/*
 * db_common.h
 */

#ifndef _DB_COMMON_H_
#define _DB_COMMON_H_

#ifndef int32
#define int32 unsigned int
#endif

#ifndef bcopy
#define bcopy(a,b,c) memcpy(b,a,c)
#endif

#define TRUE (1==1)
#define FALSE (0==1)

#ifndef min
#define min(a,b) (((a) < (b)) ? (a) : (b))
#endif

#define string_record 0x00

/*
 * -- start and end of number of characters field
 */

#define sr_ncr_1 2
#define sr_ncr_2 3
#define sr_char_start 4

/*
 * -- string pieces for record occurence strings
 * -- the layout of this record type is: 1 lead byte number of occs; remaining bytes 4-byte record identifiers
 * -- (30 of these) total 122 bytes
 */

#define wdoccs_string_record 0x01

/*
 * -- start and end of number of occurences field
 */

#define wo_nr_1 3
#define wo_nr_2 3
#define wo_occs_start 4

#define wos_low_lim 4
#define wos_hi_lim  (2*wos_low_lim)

/*
 * -- bigstring nodes. These have character count as their sole cumulator
 */

#define bigstr_node_record 0x82
#define bigstr_node_ncr    0x02

/*
 * -- min and max number of allowed children
 */

#define bnr_low_lim 7
#define bnr_hi_lim (2 * bnr_low_lim - 1)

#define bnr_ch_start 3
#define bnr_cum_start 59
#define bnr_cum_end 128

/*
 * -- layout is: 14 children (4 bytes each);14 cumulants children (5 bytes each); total 128 bytes.
 */

/*
 * -- record_occurences bigstring nodes.
 * -- These have item count and rightmost record key as cumulators
 */

#define wdoccs_str_node_record 0x83

/*
 * -- non-compound record_occurences bigstring nodes.
 */

#define wdoccs_str_node_ncr 0x03

/*
 * -- min a nd max number of allowed children
 */

#define wo_low_lim 4
#define wo_hi_lim  (2 * wo_low_lim)

#define wo_ch_start 3
#define wo_cum_start 39
#define wo_cum2_start 84
#define wo_cum2_end 119

/*
 * -- layout is: 9 children (4 bytes each), 9 cumulated number of occurences (5 bytes each),
 * -- 9 rightmost occuring id in child (4 bytes each); total 119 bytes.
 */

/*
 * -- word index B_tree nodes.
 * -- These have item count and rightmost word as cumulators
 */

#define wd_index_node_record 0x84

/*
 * -- non-compound word index B_tree nodes.
 */

#define wd_index_node_ncr 0x04

/*
 * -- min and max number of allowed children
 */

#define wix_low_lim 3
#define wix_hi_lim (2 * wix_low_lim - 1)

/*
 * -- layout is: cum_occs (5 bytes each, 6 of these, 30 bytes), word_length and start word_start (12 bytes each,
 * -- 6 of these, 72 bytes); children (4 bytes each, 6 of these, 24 bytes); total 128 bytes.
 */

#define wix_ch_start 3
#define wix_cum_start 27
#define wix_cum2_start 57
#define wix_cum2_end 128

/*
 * -- min and max number of allowed children
 */

#define wixnc_low_lim 3
#define wixnc_hi_lim (2 * wixnc_low_lim)

/*
 * -- layout is: cum_occs (5 bytes each, 7 of these, 35 bytes), word_length and start word_start (12 bytes each,
 * -- 7 of these, 84 bytes) total 121 bytes.
 */

#define wixnc_ch_start 3
#define wixnc_cum_start 3
#define wixnc_cum2_start 38
#define wixnc_cum2_end 121

/*
 * -- database cumulative record-start index B_tree nodes.
 */

#define db_index_node_record 0x85

/*
 * -- These have item count and rightmost word as cumulators
 * -- non-compound database record-start index B_tree nodes.
 */

#define db_index_node_ncr 0x05

/*
 * -- min and max number of allowed children
 */

#define dbix_low_lim 4
#define dbix_hi_lim (2 * dbix_low_lim)

/*
 * -- layout is: cum_length (5 bytes each, 9 of these, 45 bytes), last key  (4 bytes each, 9 of these, 36 bytes)
 * -- children (4 bytes each, 9 of these, 36 bytes); total 119 bytes.
 */

#define dbix_ch_start 3
#define dbix_cum_start 39
#define dbix_cum2_start 84
#define dbix_cum2_end 119

/*
 * -- min and max number of allowed children
 */

#define dbnc_low_lim 7
#define dbnc_hi_lim (2 * dbnc_low_lim - 1)

/*
 * -- layout is: cum_length (5 bytes each, 14 of these, 70 bytes), last key  (4 bytes each, 14 of these, 56 bytes)
 * -- total 128 bytes.
 */

#define dbnc_ch_start 3
#define dbnc_cum_start 3
#define dbnc_cum2_start 73
#define dbnc_cum2_end 128

/*
 * -- record byte containing its type
 */

#define type_byte 1

/*
 * -- record byte containing its number of children
 */

#define nch_byte 2

#define NUM_CH(t) (t[nch_byte-1])
#define SET_NUM_CH(t,x) t[nch_byte-1]=x
#define GET_TYPE(t) (t[type_byte-1])

#define REC_SIZE 128
#define MAX_BUFF_NO 64
#define db_default_file_name "disk_record_file"
#define MAX_FILE_SIZE (2<<15)
/* was 2000 */

#endif
