#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "str_list.h"

StrListPtr create_str_list()
{
	StrListPtr theList = (StrListPtr)malloc(sizeof(StrList));
	if (!theList)
		return NULL;

	theList->head = NULL;
	
	return theList;
}

void empty_str_list(StrListPtr theList)
{
	StrListElemPtr theListIt;
	
	if (theList) {
		theListIt = theList->head;
	
		while (theListIt) {
			StrListElemPtr theListNext = theListIt->next;
			free(theListIt);
			theListIt = theListNext;
		}
	}
}

void destroy_str_list(StrListPtr *theList)
{
	if (theList) {
		if (*theList) {
			empty_str_list(*theList);
			free(*theList);
		}
		*theList = NULL;
	}
}

StrListElemPtr first_element_str_list(StrListPtr theList)
{
	if (theList)
		return theList->head;
	else
		return NULL;
}

StrListElemPtr next_element_str_list(StrListElemPtr theListIt)
{
	if (theListIt)
		return theListIt->next;
	else
		return NULL;
}

int add_element_str_list(StrListPtr theList, char *str, int strLength)
{
	StrListElemPtr listElem;
	
	if (!theList)
		return -2;
	
	listElem = (StrListElemPtr)malloc(sizeof(StrListElem) + strLength);
	if (!listElem)
		return -1;
		
	listElem->str = ((char *)listElem) + sizeof(StrListElem);
	listElem->next = theList->head;
	
	memcpy(listElem->str, str, strLength);
	
	theList->head = listElem;

	return 0;
}

int delete_element_str_list(StrListPtr theList, char *str, int (*seeker)(StrListElem *, char *str))
{
	StrListElemPtr theListIt;
	StrListElemPtr theListPrevIt = NULL;
		
	if (theList) {
		theListIt = theList->head;
	
		while (theListIt) {
			if (seeker(theListIt, str)) {
				if (!theListPrevIt) 
					theList->head = theListIt->next;
				else 
					theListPrevIt->next = theListIt->next;

				free(theListIt);
				
				return 1;
			}
			
			theListPrevIt = theListIt;
			theListIt = theListIt->next;
		}
	}
	
	return 0;
}