#include "stubs_utilities.h"
#include "macros.h"

#include <ctype.h>
#include <stdarg.h>

#ifdef macintosh
#include <TextUtils.h>

	#include "stdarg.h"
	int DebugPrintf(char *format, ...)
	{
		int len;
		va_list ap;
		static char buffer[256];
		
		va_start(ap, format);
		len = vsprintf(buffer, format, ap);
		va_end(ap);
		
		DebugStr(c2pstr(buffer));
		
		return len;
	}
#endif

void check_type_arg(SETL_SYSTEM_PROTO specifier *argv, int param, char *routine, int32 type)
{
	if ((argv[param].sp_form != ft_opaque) ||
		(((argv[param].sp_val.sp_opaque_ptr->type) & 65535 ) != type))
		abend(SETL_SYSTEM msg_bad_arg, "event", param + 1,
			routine, abend_opnd_str(SETL_SYSTEM argv+param));
}

void check_arg(
  SETL_SYSTEM_PROTO
  specifier *argv,                  
  int param,
  int type,
  char *typestr,
  char *routine)
{
	if (argv[param].sp_form != type)
		abend(SETL_SYSTEM msg_bad_arg,typestr,param+1,routine,
			abend_opnd_str(SETL_SYSTEM argv+param));
}

void check_arg_for_two_types(
  SETL_SYSTEM_PROTO
  specifier *argv,                  
  int param,
  int type1,
  int type2,
  char *typestr,
  char *routine)
{
	if (!(argv[param].sp_form == type1 || argv[param].sp_form == type2))
		abend(SETL_SYSTEM msg_bad_arg,typestr,param+1,routine,
			abend_opnd_str(SETL_SYSTEM argv+param));
}

void check_arg_for_three_types(
  SETL_SYSTEM_PROTO
  specifier *argv,                  
  int param,
  int type1,
  int type2,
  int type3,
  char *typestr,
  char *routine)
{
	if (!(argv[param].sp_form == type1 || argv[param].sp_form == type2 || argv[param].sp_form == type3))
		abend(SETL_SYSTEM msg_bad_arg,typestr,param+1,routine,
			abend_opnd_str(SETL_SYSTEM argv+param));
}

void check_arg_or_om(
  SETL_SYSTEM_PROTO
  specifier *argv,                  
  int param,
  int type,
  char *typestr,
  char *routine)
{
	if (!(argv[param].sp_form == type || argv[param].sp_form == ft_omega) )
		abend(SETL_SYSTEM msg_bad_arg,typestr,param+1,routine,
			abend_opnd_str(SETL_SYSTEM argv+param));
}

void setl2_string_to_cstring(string_h_ptr_type string_hdr, char *p, int buffer_len)
{
	string_c_ptr_type string_cell;         /* string cell pointer               */
	char *string_char_ptr, *string_char_end;
	char *t;
	char *s;
	int32 aa;

	assert(string_hdr->s_length<=buffer_len);

	t = p;
	for (string_cell = string_hdr->s_head;
	    string_cell != NULL;
	    string_cell = string_cell->s_next) {

		for (s = string_cell->s_cell_value;
		    t < p + string_hdr->s_length &&
		    s < (char *)(string_cell->s_cell_value + STR_CELL_WIDTH);
		    *t++ = *s++);

	}
	*(p+string_hdr->s_length) = 0;
}

string_h_ptr_type setl2_string(SETL_SYSTEM_PROTO char *s, int slen)
{
	string_h_ptr_type string_hdr;          /* string root                       */
	string_c_ptr_type string_cell;         /* string cell pointer               */
	char *string_char_ptr, *string_char_end;

	get_string_header(string_hdr);
	string_hdr->s_use_count = 1;
	string_hdr->s_hash_code = -1;
	string_hdr->s_length = 0;
	string_hdr->s_head = string_hdr->s_tail = NULL;
	string_char_ptr = string_char_end = NULL;

	/* copy the source string */

	while (slen-->0) {

		if (string_char_ptr == string_char_end) {

			get_string_cell(string_cell);
			if (string_hdr->s_tail != NULL)
				(string_hdr->s_tail)->s_next = string_cell;
			string_cell->s_prev = string_hdr->s_tail;
			string_cell->s_next = NULL;
			string_hdr->s_tail = string_cell;
			if (string_hdr->s_head == NULL)
				string_hdr->s_head = string_cell;
			string_char_ptr = string_cell->s_cell_value;
			string_char_end = string_char_ptr + STR_CELL_WIDTH;

		}

		*string_char_ptr++ = *s++;
		string_hdr->s_length++;

	}
	return string_hdr;
}

result_type callback_caller(
	SETL_SYSTEM_PROTO
	char *type_returned,	/* return a character representation of the returned value */
	specifier *callback,
	char *fmt,
	...)                                /* any other arguments               */
{
	va_list argp;                          /* current argument pointer          */
	i_real_ptr_type real_ptr;              /* real pointer                      */

	/* used to build tuple               */
	specifier spare;                       /* spare specifier                   */
	specifier save_callback;               /* saved callback handler            */

	result_type result;
	
	int		p_int;
	int32	p_long;
	double	p_double;
	char	*p_string;

	long count;

	/* make sure our callback is a procedure */

	if (callback->sp_form != ft_proc)
		abend(SETL_SYSTEM "Expected procedure in callout, but found:\n %s",
		    abend_opnd_str(SETL_SYSTEM callback));

	va_start(argp, fmt);
	count = 0;
	while (*fmt) {
		count++;
		switch(toupper(*fmt++)) {

			case OMEGA_TYPE:

				spare.sp_form = ft_omega;
				push_pstack(&spare);
				break;				

			case STRING_TYPE:			/* string */
				p_string = va_arg(argp, char *);
				
				spare.sp_form = ft_string;
				spare.sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM p_string, strlen(p_string));
				push_pstack(&spare);
				break;

			case SHORT_TYPE:           /* int */
				p_int = va_arg(argp, int);
				spare.sp_form = ft_short;
				spare.sp_val.sp_short_value = p_int;
				push_pstack(&spare);
				break;

			case LONG_TYPE:           /* long */
				p_long = va_arg(argp, int);
				spare.sp_form = ft_long;
				short_to_long(SETL_SYSTEM &spare, p_long);
				push_pstack(&spare);
				break;

			case DOUBLE_TYPE:           /* double */
				p_double = va_arg(argp, double);
				i_get_real(real_ptr);
				spare.sp_form = ft_real;
				spare.sp_val.sp_real_ptr = real_ptr;
				real_ptr->r_use_count = 1;
				real_ptr->r_value = p_double;
				push_pstack(&spare);
				break;

		}
	}
	va_end(argp);

	/* call the callback handler */

	save_callback.sp_form = callback->sp_form;
	save_callback.sp_val.sp_biggest = callback->sp_val.sp_biggest;
	spare.sp_form = ft_omega;
	call_procedure(SETL_SYSTEM &spare,
	    &save_callback,
	    NULL,
	    count,YES,NO,0);
	callback->sp_form = save_callback.sp_form;
	callback->sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

	switch (spare.sp_form) {

		case ft_omega: 

			*type_returned = OMEGA_TYPE;
			break;

		case ft_string: {
			
			int buffer_len;
			string_h_ptr_type string_hdr = spare.sp_val.sp_string_ptr;
			
			if (!(result.string_value = malloc(buffer_len = string_hdr->s_length + 1)))
				abend(SETL_SYSTEM "Out of memory");

			setl2_string_to_cstring(string_hdr, result.string_value, buffer_len);
			*type_returned = STRING_TYPE;

			break;
		}

		case ft_short:
		
			result.short_value = spare.sp_val.sp_short_value;
			*type_returned = SHORT_TYPE;
			
			break;

		case ft_long: 

			result.long_value = long_to_short(SETL_SYSTEM spare.sp_val.sp_long_ptr);
			*type_returned = LONG_TYPE;
			break;

		default:

			abend(SETL_SYSTEM "Unexpected type from callback, found:\n %s",
			    abend_opnd_str(SETL_SYSTEM &spare));
			break;
		}

	unmark_specifier(&spare);

	return result;
}

