#ifndef __DENSE_BITPLNS_H__
#define __DENSE_BITPLNS_H__

#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

mimage_ptr		clone_mimage_dense(mimage_ptr mimg);
int				write_jpeg_mimage_dense(char *fname, mimage_ptr mimg);
#ifndef TIFF_DISABLED
int				write_tiff_mimage_dense(char *fname, mimage_ptr mimg);
#endif

mimage_ptr		extract_planes_dmimage(mimage_ptr mimg, int from, int to);

int				convert_dmimage_to_float(mimage_ptr mimg);
int				convert_dmimage_to_float(mimage_ptr mimg);

mimage_ptr		unimath_dmimage(void *user_ptr, void *user_ptr2, mimage_ptr mimg, float (*floating_op)(void *user_ptr, void *user_ptr2, float, int));

mimage_ptr		flip_h_dense(mimage_ptr mimg);
mimage_ptr		flip_v_dense(mimage_ptr mimg);

void			*create_dense_byteplane(int width, int height, char kind);
void			destroy_dense_byteplane(void *byteplane, char kind);

mimage_ptr		unary_op_dmimage(mimage_ptr mimg, unsigned char (*gray_op)(unsigned char), float (*float_op)(float));
mimage_ptr		binary_op_dmimage(mimage_ptr mimg_a, mimage_ptr mimg_b, unsigned char (*gray_op)(unsigned char, unsigned char), float (*float_op)(float, float));
mimage_ptr		binary_op_constant_dmimage(mimage_ptr mimg, void *values_array, unsigned char (*gray_op)(unsigned char, unsigned char), float (*float_op)(float, float));

mimage_ptr		rotate_90_dense(mimage_ptr mimg);
mimage_ptr		rotate_180_dense(mimage_ptr mimg);
mimage_ptr		rotate_270_dense(mimage_ptr mimg);

float			maxof_mimage_dense(mimage_ptr mimg);
float			minof_mimage_dense(mimage_ptr mimg);
double			*sumall_mimage_dense(mimage_ptr mimg, int power);
void			*sort_mimage_dense(mimage_ptr mimg, int *elements) ;

size_t			*histogram_mimage_dense(mimage_ptr mimg, float *fvalues, size_t fvalues_size);
mimage_ptr		threshold_mimage_dense(mimage_ptr mimg, float *fvalues, size_t fvalues_size);

void			*get_pixel_mimage_dense(mimage_ptr mimg, int x, int y);
int				set_pixel_mimage_dense(mimage_ptr mimg, int x, int y, void *pixel_value_array);

mimage_ptr		set_planes_mimage_dense(mimage_ptr mimg_res, mimage_ptr mimg, int from, int to);

int				convert_dmimage_to_discrete(mimage_ptr mimg);

mimage_ptr		random_mimage_dense(mimage_ptr mimg, float r_min, float r_max);
int				crop_mimage_dense(mimage_ptr mimg, image_rect_ptr rect);
int				invert_mimage_dense(mimage_ptr mimg);
mimage_ptr		lut_mimage_dense(mimage_ptr mimg, mpixel *LUTs[], int number_of_planes, int target_kind);

int				lex_minof_mimage_dense(mimage_ptr mimg, gr_image_displacement *pos);
int				lex_maxof_mimage_dense(mimage_ptr mimg, gr_image_displacement *pos);
mimage_ptr		lex_sort_mimage_dense(mimage_ptr mimg);

#endif /* __DENSE_BITPLNS_H__ */

