#ifndef __PKG_STUBS_H__
#define __PKG_STUBS_H__	0x0100

#include <stdarg.h>

/*--------------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------------*/

/*
 *	Type definitions
 */

typedef union {
	void  *value_ptr;
	int32  value_int32;
	float  value_float;
	double value_double;
} callback_result;

/*
 *	Macros and definitions
 */

#ifdef FNAME_MAX_SIZE
 #undef FNAME_MAX_SIZE
#endif

#define FNAME_MAX_SIZE 256

#ifndef YES
 #define YES         1                  /* true constant                     */
#endif

#ifndef NO
 #define NO          0                  /* false constant                    */
#endif


#ifdef TUPLE_SIZE
 #undef TUPLE_SIZE
#endif

#define TUPLE_SIZE(tuple_arg) \
	tuple_arg.sp_val.sp_tuple_ptr->t_ntype.t_root.t_length


#ifndef MACROS_LOADED

#ifdef TUPLE_ITERATOR
 #undef TUPLE_ITERATOR
#endif

#define TUPLE_ITERATOR(source)                \
tuple_h_ptr_type source##_work_hdr;           \
tuple_c_ptr_type source##_cell;               \
int32 source##_number;                        \
int source##_height, source##_index;          \
specifier *source##_element; 

#ifdef ITERATE_TUPLE_BEGIN
 #undef ITERATE_TUPLE_BEGIN
#endif

#define ITERATE_TUPLE_BEGIN(source,troot) \
   source##_work_hdr = troot; \
   source##_number = -1; \
   source##_height = troot->t_ntype.t_root.t_height; \
   source##_index = 0; \
   while (source##_number < troot->t_ntype.t_root.t_length) { \
      source##_element = NULL; \
      for (;;) { \
	if (!source##_height && source##_index < TUP_HEADER_SIZE) { \
	    if (source##_work_hdr->t_child[source##_index].t_cell == NULL) { \
	       source##_number++; source##_index++; continue; \
	    } \
	    source##_cell = source##_work_hdr->t_child[source##_index].t_cell; \
            source##_element = &(source##_cell->t_spec); \
            source##_number++; source##_index++; \
            break; } \
         if ( source##_index >= TUP_HEADER_SIZE) {  \
            if ( source##_work_hdr == troot) break; \
            source##_height++; \
            source##_index = \
               source##_work_hdr->t_ntype.t_intern.t_child_index + 1; \
            source##_work_hdr = \
               source##_work_hdr->t_ntype.t_intern.t_parent; \
            continue; \
         }  \
         if (source##_work_hdr->t_child[source##_index].t_header == NULL) { \
            source##_number += 1L << (source##_height * TUP_SHIFT_DIST); \
            source##_index++; \
            continue; \
         } \
         source##_work_hdr = source##_work_hdr->t_child[source##_index].t_header; \
         source##_index = 0; source##_height--;  \
      } \
      if (source##_element == NULL) break;

#ifdef ITERATE_TUPLE_END
 #undef ITERATE_TUPLE_END
#endif

#define ITERATE_TUPLE_END(source) }

#endif /* MACROS_LOADED */

/*--------------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------------*/

/*
 *	Prototypes
 */

	/*
	 *	Imported
	 */

extern int32 register_type(SETL_SYSTEM_PROTO char *, void *);

	/*
	 *	Exported
	 */

static void check_arg(SETL_SYSTEM_PROTO specifier *argv, int param, int type, char *typestr, char *routine);
static void check_type(SETL_SYSTEM_PROTO specifier *argv, int param, int type, int expected_type, char *argstr, char *errstr, char *routine);
static void check_gr_arg(SETL_SYSTEM_PROTO specifier *argv, int param, char *routine);

void create_and_return_integers_tuple_from_array(SETL_SYSTEM_PROTO int *array, size_t array_size, specifier *target);
void create_and_return_shorts_tuple_from_array(SETL_SYSTEM_PROTO unsigned char *array, size_t array_size, specifier *target);
void create_and_return_longs_tuple_from_array(SETL_SYSTEM_PROTO unsigned long *array, size_t array_size, specifier *target);
void create_and_return_floats_tuple_from_array(SETL_SYSTEM_PROTO float *array, size_t array_size, specifier *target);
void create_and_return_doubles_tuple_from_array(SETL_SYSTEM_PROTO double *array, size_t array_size, specifier *target);
void create_and_return_mimages_tuple_from_array(SETL_SYSTEM_PROTO mimage_ptr *array, size_t array_size, specifier *target);

string_h_ptr_type setl2_string(SETL_SYSTEM_PROTO char *s, int slen);
void setl2_string_to_cstring(string_h_ptr_type string_hdr, unsigned char *p, int buffer_len);

callback_result d_callback_caller(SETL_SYSTEM_PROTO specifier *callback, char *fmt, ...);

static float gradient_callback_op(SETL_SYSTEM_PROTO void *user_ptr2, int x, int y, int c);
static float unimath_callback_op(SETL_SYSTEM_PROTO void *user_ptr2, float f, int c);

void gr_internal_destructor(mimage_ptr mimg);
SETL_API int32 GRLIB__INIT(SETL_SYSTEM_PROTO_VOID);

SETL_API void GR_CLONE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_CREATE_IMAGE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_DESTROY_IMAGE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_READ_TIFF_IMAGE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_WRITE_TIFF_IMAGE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_READ_JPEG_IMAGE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_WRITE_JPEG_IMAGE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_CONVERT_TO_FLOAT(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_CONVERT_TO_INT(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_CROP(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_STUFF(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_SHRINK(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_WIDTH(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_HEIGHT(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_PLANES_NUMBER(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_TYPE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_DENSITY(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_CONST(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_PLUS(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_MINUS(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_TIMES(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_DIVIDE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_MAXIM(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_MINIM(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_POWER(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_MAXOF(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_MINOF(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_SUMALL(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_SCALE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_SORT(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_WIDTH_AND_HEIGHT(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_CONVOLVE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_MAXVOLVE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_MINVOLVE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_SELF(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_SELF_PUT(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_SIN(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_COSIN(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_TAN(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_EXP(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_LOG(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_ABS(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_EVEN(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_ODD(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_SQRT(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_ASIN(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_ACOSIN(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_ATAN(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_FIX(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_FLOOR(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_CEILING(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_THRESHOLD(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_HISTOGRAM(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_GRADIENT(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_UNIMATH(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_PLUS_CONST(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_MINUS_CONST(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_TIMES_CONST(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_DIVIDE_CONST(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_MAXIM_CONST(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_MINIM_CONST(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_POWER_CONST(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_PERLIN(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_PERLIN2(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_TO_STRING(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_FROM_STRING(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_ANAGLYPH(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_SET_PIXEL(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_GET_PIXEL(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_CONNECTED_COMPONENTS(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_CONVERT_TO_SPARSE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_CONVERT_TO_DENSE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_GET_LEVEL_DENSE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_GET_NEAR_DENSE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_SHRINK_AND_CUT(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_VALIDATE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_FLIP_H(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_FLIP_V(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_ROTATE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_SUPERPOSE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_RANDOM(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_RECTANGLE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_ELLIPSE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_INVERT(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_OFFSET(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_SPLIT(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_MASK(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_LUT(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_LEX_MAX(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_LEX_MIN(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_LEX_SORT(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_STUFF_IN_PLACE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_FLATTEN(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_TILE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_FFT(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_FFT_INVERSE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void GR_WAVELET(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);

/*--------------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------------*/

/*
 *	External variables
 */

extern int32 gr_type;	/* Package type reference */

/*--------------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------------*/

#endif /* __PKG_STUBS_H__ */
