#ifndef __GR_SPARSE_UTILS_H__
#define __GR_SPARSE_UTILS_H__	0x0100

#include "gr_bitplns.h"

	/*
	 *	 Utilities
	 */
	 
			/* Allocations */
	 
int		allocate_sparse_buffers(mimage_ptr mimg, int data_length, int section_length, int buffer_length);

int		pre_setup_sparse_mimage_no_buffer(mimage_ptr mimg, int width, int height);
int		pre_setup_sparse_mimage_no_buffer_allocated(mimage_ptr mimg, int num_sections, int nominal_height);
int		pre_setup_sparse_mimage(mimage_ptr mimg, int width, int height, int kind, int planes_number);
int		allocate_buffers_for_sparse_mimage(mimage_ptr mimg, int kind, int buffer_length);

			/* Information */
	 
int		sections_in_row(mimage_ptr mimg, int k);
int		is_pixel_default_value(mimage_ptr mimg, void *value);

			/* Setting */
	 
int		set_default_color_smimage(mimage_ptr mimg, mpixel_ptr default_array);
int		set_default_fcolor_smimage(mimage_ptr mimg, fmpixel_ptr fdefault_array);
int		set_default_plane_color_smimage(mimage_ptr mimg, mpixel pixel_value, short plane_index);
int		set_default_plane_fcolor_smimage(mimage_ptr mimg, fmpixel pixel_value, short plane_index);

			/* Validation */

int		trim_sparse(mimage_ptr mimg);

			/* Dynamic Table Manager */
			 
int		expand_table_on_need(void **table, int index, int *length, short type_size);
int		shrink_table_to_size(void **table, int length, short type_size);

			/* Section copy */

void	write_section_in_buffer_at_offset(mimage_ptr mimg, mimage_ptr target_mimg, section_data_ptr sect, int position_in_buffer);
void	copy_section_from_mimage(mimage_ptr mimg, mimage_ptr target_mimg, section_data_ptr sect, section_data_ptr target_sect, int *data_idx_target, int expand_default);
void	copy_row_from_mimage(mimage_ptr mimg, mimage_ptr res_mimg, int row_idx, int *row_idx_target, int *sect_idx_target, int *data_idx, int expand_default);

#endif /* __GR_SPARSE_UTILS_H__ */