#ifndef __UTILS_H__
#define __UTILS_H__

#include <stdlib.h>
#include "gr_bitplns.h"

#ifdef __cplusplus
extern "C" {
#endif

int		is_valid_rect(image_rect_ptr rect_ptr);

int		float_compare(float *x, float *y);
int		unsigned_char_compare(unsigned char *x, unsigned char *y);
int		bfbsearch(float value, float *values, size_t size);
int		bibsearch(int value, int *values, size_t size);
float	threshold_pixel(float value, float *fvalues, size_t fvalues_size);

int		*get_planes_distances_for_mimage(mimage_ptr mimg);

int		lex_pixels_compare(mpixel *a, mpixel *b, int n, int *d);
int		lex_fpixels_compare(fmpixel *a, fmpixel *b, int n, int *d);
int		lex_pixels_default_compare(mpixel *a, mpixel *def, int n, int *d);
int		lex_fpixels_default_compare(fmpixel *a, fmpixel *def, int n, int *d);

int										*generate_pixel_no_array(int num_pixels);
gr_image_displacement *generate_displacements_for_sparse_mimage(mimage_ptr mimg);
gr_image_displacement	*generate_pixel_disp_array(int size);

void	sort_by_pvals(int *pixel_no_array, mimage_ptr mimg, int pixel_number);
void	sort_by_pvals_and_posns(int *pixel_no_array, mimage_ptr mimg);
void	sort_sparse_by_pvals_and_posns(int *pixel_no_array, gr_image_displacement *disp_array, mimage_ptr mimg);

#ifdef __cplusplus
}
#endif

#endif /* __UTILS_H__ */

