/*
 *
\*/


/* SETL2 system header files */


#include "macros.h"


/* constants */

#define YES         1                  /* true constant                     */
#define NO          0                  /* false constant                    */



void check_arg(
  SETL_SYSTEM_PROTO
  specifier *argv,                  
  int param,
  int type,
  char *typestr,
  char *routine)
{

   if (argv[param].sp_form != type)
      abend(SETL_SYSTEM msg_bad_arg,typestr,param+1,routine,
            abend_opnd_str(SETL_SYSTEM argv+param));

}

extern void*   (*setl_environment)(char *message);


void GET_POSITION(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int32 position = -1;
void *p;

   if (setl_environment!=NULL) {
		p=setl_environment("O"); // Insert Position
		if (p) position=*((int32*)(p));   		
   }
   
   unmark_specifier(target);
   if (position==-1) { 
      target->sp_form = ft_omega;
   } else {
      target->sp_form = ft_short;
      target->sp_val.sp_short_value = (position+1);
   }
}

void GET_LENGTH(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{

int32 len = -1;
void *p;

   if (setl_environment!=NULL) {
		p=setl_environment("L"); // Buffer Length
		if (p) len=*((int32*)(p));   		
   }
   
   unmark_specifier(target);
   if (len==-1) { 
      target->sp_form = ft_omega;
   } else {
      target->sp_form = ft_short;
      target->sp_val.sp_short_value = len;
   }
}

void GET_BUFFER(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
STRING_CONSTRUCTOR(sc)

void *p;
char *buffer;

   if (setl_environment!=NULL) {
		p=setl_environment("B"); // Buffer Length
		if (p) {
			buffer=*(char**)(p);
			if (buffer) {
				STRING_CONSTRUCTOR_BEGIN(sc);

	  			while (*buffer!=0) {
	      			STRING_CONSTRUCTOR_ADD(sc,*buffer);
	      			buffer++;
	   			}
	   			buffer=*(char**)(p);
	   			free(buffer);
	   			*((char**)(p))=NULL;
	   			
	 			unmark_specifier(target);
				target->sp_form = ft_string;
				target->sp_val.sp_string_ptr = STRING_HEADER(sc);
				return;
			}

		}		
   }
   
   unmark_specifier(target);
   target->sp_form = ft_omega;
   
}

void SET_BUFFER(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int32 d_start,d_end;
int32 *p1,*p2;
char **p3;
STRING_ITERATOR(si)
char *newtext;


   check_arg(SETL_SYSTEM argv,0,ft_short,"integer","set_buffer");
   check_arg(SETL_SYSTEM argv,1,ft_short,"integer","set_buffer");
   check_arg(SETL_SYSTEM argv,2,ft_string,"string","set_buffer");
   
   d_start = argv[0].sp_val.sp_short_value;
   d_end   = argv[1].sp_val.sp_short_value;
   
   ITERATE_STRING_BEGIN(si,argv[2]);

   newtext = (char *)malloc((size_t)(STRING_LEN(argv[2]) + 1));
   if (newtext == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   STRING_CONVERT(si,newtext);
   
   
   if (setl_environment!=NULL) {
		p1=setl_environment("D"); // Delete start
		if (p1) {
			
			p2=setl_environment("d"); // Delete end
			if (p2) {
			   p3=setl_environment("I"); // Insert String
			    if (p3) {
				*p1 = d_start-1;
				*p2 = d_end;
				*p3 = newtext;
		    	}
			
			}
   		}
   }
   
   unmark_specifier(target);
   target->sp_form = ft_omega;
   
   

}



void SET_SELECTION(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int32 d_start,d_end;
int32 *p1,*p2;


   check_arg(SETL_SYSTEM argv,0,ft_short,"integer","set_selection");
   check_arg(SETL_SYSTEM argv,1,ft_short,"integer","set_selection");
   
   d_start = argv[0].sp_val.sp_short_value;
   d_end   = argv[1].sp_val.sp_short_value;
   
   
   if (setl_environment!=NULL) {
		p1=setl_environment("S"); // Selection start
		if (p1) {
			
			p2=setl_environment("s"); // Selection end
			if (p2) {
				*p1 = d_start-1;
				*p2 = d_end;
		 	
			}
   		}
   }
   
   unmark_specifier(target);
   target->sp_form = ft_omega;
  

}

void GET_SELECTION(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int32 start = -1;
int32 end = -1;
void *p;
TUPLE_CONSTRUCTOR(tc)
specifier s;

   if (setl_environment!=NULL) {
		p=setl_environment("b"); 
		if (p) start=*((int32*)(p));   
		p=setl_environment("e"); 
		if (p) end=*((int32*)(p));   		
   }
   
   unmark_specifier(target);
   if ((start==-1)||(end==-1)) { 
      target->sp_form = ft_omega;
   } else {
	    TUPLE_CONSTRUCTOR_BEGIN(tc);

      s.sp_form = ft_short;
      s.sp_val.sp_short_value = start+1;
      TUPLE_ADD_CELL(tc,&s);

 	
  	     s.sp_form = ft_short;
  	     s.sp_val.sp_short_value = end;
  	     TUPLE_ADD_CELL(tc,&s);
	

  	 TUPLE_CONSTRUCTOR_END(tc);

      target->sp_form = ft_tuple;
      target->sp_val.sp_tuple_ptr = TUPLE_HEADER(tc);
   }

}

void GET_PARAMETER(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
STRING_CONSTRUCTOR(sc)

void *p;
char *buffer;

   if (setl_environment!=NULL) {
		p=setl_environment("p"); // Buffer Length
		if (p) {
			buffer=*(char**)(p);
			if (buffer) {
				STRING_CONSTRUCTOR_BEGIN(sc);

	  			while (*buffer!=0) {
	      			STRING_CONSTRUCTOR_ADD(sc,*buffer);
	      			buffer++;
	   			}
	   			
	 			unmark_specifier(target);
				target->sp_form = ft_string;
				target->sp_val.sp_string_ptr = STRING_HEADER(sc);
				return;
			}

		}		
   }
   
   unmark_specifier(target);
   target->sp_form = ft_omega;
   
}

void GET_PDATA(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
STRING_CONSTRUCTOR(sc)

void *p;
char *buffer;

   if (setl_environment!=NULL) {
		p=setl_environment("P");
		if (p) {
			buffer=*(char**)(p);
			if (buffer) {
				STRING_CONSTRUCTOR_BEGIN(sc);

	  			while (*buffer!=0) {
	      			STRING_CONSTRUCTOR_ADD(sc,*buffer);
	      			buffer++;
	   			}
	   			
	 			unmark_specifier(target);
				target->sp_form = ft_string;
				target->sp_val.sp_string_ptr = STRING_HEADER(sc);
				return;
			}

		}		
   }
   
   unmark_specifier(target);
   target->sp_form = ft_omega;
   
}

void SET_PDATA(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
char **p1;
STRING_ITERATOR(si)
char *newtext;


   check_arg(SETL_SYSTEM argv,0,ft_string,"string","set_pdata");
   
  
   ITERATE_STRING_BEGIN(si,argv[0]);

   newtext = (char *)malloc((size_t)(STRING_LEN(argv[0]) + 1));
   if (newtext == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   STRING_CONVERT(si,newtext);
   
   
   if (setl_environment!=NULL) {
		p1=setl_environment("P"); // Delete start
		if (p1) {
			if (*p1) {
				free(*p1);
			}
			*p1 = newtext;
			unmark_specifier(target);
   			target->sp_form = ft_omega;
   			return;
   
		}
   }
   //free(newtext);
   
   unmark_specifier(target);
   target->sp_form = ft_omega;
   
   

}


void IDE_RERUN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
char **p1;
STRING_ITERATOR(si)
char *newtext;


   check_arg(SETL_SYSTEM argv,0,ft_string,"string","ide_rerun");
   
  
   ITERATE_STRING_BEGIN(si,argv[0]);

   newtext = (char *)malloc((size_t)(STRING_LEN(argv[0]) + 1));
   if (newtext == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   STRING_CONVERT(si,newtext);
   
   
   if (setl_environment!=NULL) {
		p1=setl_environment("r"); // Rerun
		if (p1) {
			if (*p1) {
				free(*p1);
			}
			*p1 = newtext;
			unmark_specifier(target);
   			target->sp_form = ft_omega;
   			return;
   
		}
   }
   //free(newtext);
   
   unmark_specifier(target);
   target->sp_form = ft_omega;
   
   

}


void SET_LIBRARY_LIST(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
char **p1;
STRING_ITERATOR(si)
char *newtext;
char *s,*p,*q;
int i;



   check_arg(SETL_SYSTEM argv,0,ft_string,"string","ide_rerun");
   
  
   ITERATE_STRING_BEGIN(si,argv[0]);

   newtext = (char *)malloc((size_t)(STRING_LEN(argv[0]) + 1));
   if (newtext == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   STRING_CONVERT(si,newtext);
   
   DEFAULT_LIBRARY=newtext;
   
     s=p=DEFAULT_LIBRARY;

   close_lib(SETL_SYSTEM_VOID);
   open_lib();
   
   i=YES; /* Make sure we can write onto this library... */
   while (s!=NULL) {
      while ((*p!=0)&&(*p!=',')) p++;
         if ((p-s)<=0) { 
            s=NULL;
         } else {
           q=(char *)malloc((size_t)(p-s+ 1));
           if (q == NULL)
              giveup(SETL_SYSTEM msg_malloc_error);
           strncpy(q,s,(p-s));
           q[p-s]='\0';
           add_lib_file(SETL_SYSTEM q,i);
           i=NO;    
           free(q);
           if (*p==0) s=NULL; 
           else {
             s=p+1;
             p=s;
           }
	 }
   }


   add_lib_path(SETL_SYSTEM LIBRARY_PATH);

   
   
   
   //free(newtext);
   
   unmark_specifier(target);
   target->sp_form = ft_omega;
   
   

}


void GET_LIBRARY_LIST(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
STRING_CONSTRUCTOR(sc)

void *p;
char *buffer;

	buffer=DEFAULT_LIBRARY;

	STRING_CONSTRUCTOR_BEGIN(sc);

	while (*buffer!=0) {
	STRING_CONSTRUCTOR_ADD(sc,*buffer);
	buffer++;
	}


	unmark_specifier(target);
	target->sp_form = ft_string;
	target->sp_val.sp_string_ptr = STRING_HEADER(sc);
	return;
			
}

void RELOAD_LIBRARY_PACKAGE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
string_h_ptr_type string_hdr;          /* root of string value              */
string_c_ptr_type string_cell;         /* string cell                       */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
char *key;                             /* system key                        */
char *s, *t;                           /* temporary looping variables       */
unittab_ptr_type unittab_ptr;          /* loaded unit                       */
char name_buffer[MAX_TOK_LEN];         /* name buffer for slot              */

   /* convert the key to a C character string */

   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg, "string", 1, "library_package",
            abend_opnd_str(SETL_SYSTEM argv));

   string_hdr = argv[0].sp_val.sp_string_ptr;

   key = (char *)malloc((size_t)(string_hdr->s_length + 1));
   if (key == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   t = key;
   for (string_cell = string_hdr->s_head;
        string_cell != NULL;
        string_cell = string_cell->s_next) {

      for (s = string_cell->s_cell_value;
           t < key + string_hdr->s_length &&
              s < string_cell->s_cell_value + STR_CELL_WIDTH;
           *t++ = *s++);

   }
   *t = '\0';
  
   strcpy(name_buffer,key);
   unittab_ptr = get_unittab(SETL_SYSTEM name_buffer);
   if (unittab_ptr!=NULL)
   		unittab_ptr->ut_is_loaded=0;

   unittab_ptr = load_unit(SETL_SYSTEM key, NULL, NULL);
   free(key);

   /*
    *  Make sure we found a package.
    */

   if (unittab_ptr == NULL || 
       ((unittab_ptr->ut_type != PACKAGE_UNIT)&&
       (unittab_ptr->ut_type != NATIVE_UNIT))) {
      unmark_specifier(target);
      target->sp_form = ft_omega;
      return;
   }

   /*
    *  Return the symbol map.
    */

   unmark_specifier(target);
   target->sp_form = ft_map;
   target->sp_val.sp_map_ptr = unittab_ptr->ut_symbol_map;
   mark_specifier(target);

   return;
}