/**************************************************************************
 *                                                                        *
 *                        P L O T I C U S   P A K                         *
 *                                                                        *
 **************************************************************************/

/* SETL2 system header files */
                     
#include "macros.h"

#define YES 1
#define NO  0


int ploticus_init(const char *device,const char *outfilename);
int ploticus_arg(const char *s,const char *t);
int ploticus_setvar(const char *s,const char *t);
int ploticus_execline(const char *s);
int ploticus_begin();
int ploticus_end();
int ploticus_execscript(const char *device,int type);


void check_arg(
  SETL_SYSTEM_PROTO
  specifier *argv,                  
  int param,
  int type,
  char *typestr,
  char *routine)
{

   if (argv[param].sp_form != type)
      abend(SETL_SYSTEM msg_bad_arg,typestr,param+1,routine,
            abend_opnd_str(SETL_SYSTEM argv+param));

}

int check_int(
  SETL_SYSTEM_PROTO
  specifier *argv,                  
  int param,
  int type,
  char *typestr,
  char *routine)
{

 if (argv[param].sp_form == ft_short) 
      return (int)(argv[param].sp_val.sp_short_value);
   else if (argv[param].sp_form == ft_long) 
      return (int)long_to_short(SETL_SYSTEM argv[param].sp_val.sp_long_ptr);
   else 
      abend(SETL_SYSTEM msg_bad_arg,"integer",param+1,routine,
            abend_opnd_str(SETL_SYSTEM argv+param));
       
}


SETL_API  void PLOTICUS_INIT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
STRING_ITERATOR(sc)
int i,len;
char *str,*filename,*p;

   check_arg(SETL_SYSTEM argv,0,ft_string,"string","ploticus_init");
   check_arg(SETL_SYSTEM argv,1,ft_string,"string","ploticus_init");
 
   len = STRING_LEN(argv[0]);
   
   str = (char*)(malloc(len+1));
   if (str == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   ITERATE_STRING_BEGIN(sc,argv[0]);
	
   p=str;
   for (i=0;i<len;i++) {
      *p++=(char)ITERATE_STRING_CHAR(sc);
      ITERATE_STRING_NEXT(sc);
   }
   *p=0;

   len = STRING_LEN(argv[1]);
   
   filename = (char*)(malloc(len+1));
   if (filename == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   ITERATE_STRING_BEGIN(sc,argv[1]);
	
   p=filename;
   for (i=0;i<len;i++) {
      *p++=(char)ITERATE_STRING_CHAR(sc);
      ITERATE_STRING_NEXT(sc);
   }
   *p=0;
   

   unmark_specifier(target);
   target->sp_form = ft_short;
   target->sp_val.sp_short_value = ploticus_init(str,filename);

}

SETL_API  void PLOTICUS_ARG(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
STRING_ITERATOR(sc)
int i,len;
char *str,*filename,*p;

   check_arg(SETL_SYSTEM argv,0,ft_string,"string","ploticus_arg");
   check_arg(SETL_SYSTEM argv,1,ft_string,"string","ploticus_arg");
 
   len = STRING_LEN(argv[0]);
   
   str = (char*)(malloc(len+1));
   if (str == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   ITERATE_STRING_BEGIN(sc,argv[0]);
	
   p=str;
   for (i=0;i<len;i++) {
      *p++=(char)ITERATE_STRING_CHAR(sc);
      ITERATE_STRING_NEXT(sc);
   }
   *p=0;

   len = STRING_LEN(argv[1]);
   
   filename = (char*)(malloc(len+1));
   if (filename == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   ITERATE_STRING_BEGIN(sc,argv[1]);
	
   p=filename;
   for (i=0;i<len;i++) {
      *p++=(char)ITERATE_STRING_CHAR(sc);
      ITERATE_STRING_NEXT(sc);
   }
   *p=0;
   

   unmark_specifier(target);
   target->sp_form = ft_short;
   target->sp_val.sp_short_value = ploticus_arg(str,filename);

}

SETL_API  void PLOTICUS_EXECSCRIPT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
STRING_ITERATOR(sc)
int i,len,type;
char *str,*p;

   check_arg(SETL_SYSTEM argv,0,ft_string,"string","ploticus_execscript");
   type = check_int(SETL_SYSTEM argv,1,ft_short,"integer","ploticus_execscript");

 
   len = STRING_LEN(argv[0]);
   
   str = (char*)(malloc(len+1));
   if (str == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   ITERATE_STRING_BEGIN(sc,argv[0]);
	
   p=str;
   for (i=0;i<len;i++) {
      *p++=(char)ITERATE_STRING_CHAR(sc);
      ITERATE_STRING_NEXT(sc);
   }
   *p=0;

 

   unmark_specifier(target);
   target->sp_form = ft_short;
   target->sp_val.sp_short_value = ploticus_execscript(str,type);

}
SETL_API  void PLOTICUS_SETVAR(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
STRING_ITERATOR(sc)
int i,len;
char *str,*filename,*p;

   check_arg(SETL_SYSTEM argv,0,ft_string,"string","ploticus_setvar");
   check_arg(SETL_SYSTEM argv,1,ft_string,"string","ploticus_setvar");
 
   len = STRING_LEN(argv[0]);
   
   str = (char*)(malloc(len+1));
   if (str == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   ITERATE_STRING_BEGIN(sc,argv[0]);
	
   p=str;
   for (i=0;i<len;i++) {
      *p++=(char)ITERATE_STRING_CHAR(sc);
      ITERATE_STRING_NEXT(sc);
   }
   *p=0;

   len = STRING_LEN(argv[1]);
   
   filename = (char*)(malloc(len+1));
   if (filename == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   ITERATE_STRING_BEGIN(sc,argv[1]);
	
   p=filename;
   for (i=0;i<len;i++) {
      *p++=(char)ITERATE_STRING_CHAR(sc);
      ITERATE_STRING_NEXT(sc);
   }
   *p=0;
   

   unmark_specifier(target);
   target->sp_form = ft_short;
   target->sp_val.sp_short_value = ploticus_setvar(str,filename);

}

SETL_API  void PLOTICUS_EXECLINE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
STRING_ITERATOR(sc)
int i,len;
char *str,*p;

   check_arg(SETL_SYSTEM argv,0,ft_string,"string","ploticus_execline");
 
   len = STRING_LEN(argv[0]);
   
   str = (char*)(malloc(len+1));
   if (str == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   ITERATE_STRING_BEGIN(sc,argv[0]);
	
   p=str;
   for (i=0;i<len;i++) {
      *p++=(char)ITERATE_STRING_CHAR(sc);
      ITERATE_STRING_NEXT(sc);
   }
   *p=0;

   
 
   unmark_specifier(target);
   target->sp_form = ft_short;
   target->sp_val.sp_short_value = ploticus_execline(str);

}

SETL_API  void PLOTICUS_BEGIN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{


 

 
   unmark_specifier(target);
   target->sp_form = ft_short;
   target->sp_val.sp_short_value = ploticus_begin();

}

SETL_API  void PLOTICUS_END(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{


  
 
   unmark_specifier(target);
   target->sp_form = ft_short;
   target->sp_val.sp_short_value = ploticus_end();

}

#ifdef CODEWARRIOR
int strncasecmp(const char *s1, const char *s2, unsigned int n)
{
     if (n == 0)
         return 0;
 
     while ((n-- != 0)
            && (tolower(*(unsigned char *) s1) ==
                tolower(*(unsigned char *) s2))) {
         if (n == 0 || *s1 == '\0' || *s2 == '\0')
             return 0;
         s1++;
         s2++;
     }
 
     return tolower(*(unsigned char *) s1) - tolower(*(unsigned char *) s2);
 }
 
int strcasecmp(const char *s1, const char *s2)
{
	 while ((*s1 != 0)
            && (tolower(*(unsigned char *) s1) ==
                tolower(*(unsigned char *) s2))) {
         s1++;
         s2++;
     }
 
     return tolower(*(unsigned char *) s1) - tolower(*(unsigned char *) s2);
 }
 
#endif
