#include "nrutil.h"

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

#include "lpkit.h"
#include "poly_zeroes.h"

void comb_coeff_test();
void test_get_coeffs();
void test_hull_excludes_0();
void test_hull_excludes_0_bis();
void test_hull_excludes_0_tris();
void test_find_root_list(double *Q_coefficients, int nQ, double *a, double *b, int *degrees, int dim);
void test1();
void test2();
void test3();
void test4();
void test5();
void test6();
void test7();
void test8();
void test9();
void test10();
void test11();
void test12();
void test13();
void test14();
void test_big();
void simplex_test1();
void simplex_test2();
void simplex_test3();
void simplex_test4();
void test_three_d();
void test_three_d_bis();
void plsolve_test0();
void plsolve_test1();

#ifdef MEM_LEAK_CHECK
static char *file_name = "poly_tests.c";
#include "debug_mem.h"
#endif

void comb_coeff_test()
{
	int j;
	printf("[");
	for (j=0;j<=2;j++)
		printf("%f ",comb(2,j));
	printf("], ");
	printf("[");
	for (j=0;j<=1;j++)
		printf("%f ",comb(1,j));
	printf("], ");
	printf("%f ",comb(0,0));
}

void test_get_coeffs() 
{

	double test_array[] = {-1.0000000000, 0.0000000000, -1.0000000000, 0.0000000000, 0.0000000000, 
	1.0000000000, -1.0000000000, -1.0000000000, -1.0000000000, -1.0000000000, 0.0000000000, 0.0000000000, 0.0000000000,
	 -1.0000000000, 0.0000000000, -1.0000000000, 1.0000000000, 0.0000000000};
	int degs_array[] = {2, 2};
	double *res_array;
	int i;
	
	res_array = get_left_coeffs_gen(test_array, 18, 0, degs_array, 2);
	if (res_array) {
		printf("[POLY ZEROES] res_array = ");
		for (i=0; i<18; i++)
			printf("%3.11g ", res_array[i]);
		printf("\n");
		
		free(res_array);
	}

	res_array = get_right_coeffs_gen(test_array, 18, 0, degs_array, 2);
	if (res_array) {
		printf("[POLY ZEROES] res_array = ");
		for (i=0; i<18; i++)
			printf("%3.11g ", res_array[i]);
		printf("\n");
		
		free(res_array);
	}
}

void test_hull_excludes_0()
{
	double delt = 0.0001; 		/* test 2D convex-hull-includes origin routine */

	double test_array[6];
	
	poly_zeroes_initialize(1.0e-20, 1.0e-10, 50, 10 /*only for this routine*/, 100); 

	test_array[0] = cos(delt);
	test_array[1] = sin(delt);
	test_array[2] = -cos(delt);
	test_array[3] = -sin(delt);
printf("1 - [POLY ZEROES] %d\n", hull_excludes_0(test_array, 4, 2));
	test_array[0] = cos(2.0 * delt);
	test_array[1] = sin(2.0 * delt);
	test_array[2] = -cos(2.0 * delt);
	test_array[3] = -sin(2.0 * delt);
printf("2 - [POLY ZEROES] %d\n", hull_excludes_0(test_array, 4, 2));
	test_array[0] = cos(pio2);
	test_array[1] = sin(pio2);
	test_array[2] = cos(-pio2 + delt);
	test_array[3] = sin(-pio2 + delt);
printf("3 - [POLY ZEROES] %d\n", hull_excludes_0(test_array, 4, 2));
	test_array[0] = cos(pio2);
	test_array[1] = sin(pio2);
	test_array[2] = cos(-pio2 - delt);
	test_array[3] = sin(-pio2 - delt);
printf("4 - [POLY ZEROES] %d\n", hull_excludes_0(test_array, 4, 2));
	test_array[0] = cos(pio2);
	test_array[1] = sin(pio2);
	test_array[2] = cos(-pio2 + delt);
	test_array[3] = sin(-pio2 + delt);
	test_array[4] = 1.0;
	test_array[5] = 0.0;
printf("5 - [POLY ZEROES] %d\n", hull_excludes_0(test_array, 6, 2));
	test_array[0] = cos(pio2);
	test_array[1] = sin(pio2);
	test_array[2] = cos(-pio2 - delt);
	test_array[3] = sin(-pio2 - delt);
	test_array[4] = -1.0;
	test_array[5] = 0.0;
printf("6 - [POLY ZEROES] %d\n", hull_excludes_0(test_array, 6, 2));
	test_array[0] = cos(pio2);
	test_array[1] = sin(pio2);
	test_array[2] = cos(-pio2 + delt);
	test_array[3] = sin(-pio2 + delt);
	test_array[4] = -1.0;
	test_array[5] = 0.0;
printf("7 - [POLY ZEROES] %d\n", hull_excludes_0(test_array, 6, 2));
	test_array[0] = cos(pio2);
	test_array[1] = sin(pio2);
	test_array[2] = cos(-pio2 - delt);
	test_array[3] = sin(-pio2 - delt);
	test_array[4] = 1.0;
	test_array[5] = 0.0;
printf("8 - [POLY ZEROES] %d\n", hull_excludes_0(test_array, 6, 2));
	test_array[0] = cos(pio2);
	test_array[1] = sin(pio2);
	test_array[2] = cos(pi - delt);
	test_array[3] = sin(pi - delt);
	test_array[4] = 1.0;
	test_array[5] = 0.0;
printf("9 - [POLY ZEROES] %d\n", hull_excludes_0(test_array, 6, 2));
	test_array[0] = cos(-pio2);
	test_array[1] = sin(-pio2);
	test_array[2] = cos(pi + delt);
	test_array[3] = sin(pi + delt);
	test_array[4] = 1.0;
	test_array[5] = 0.0;
printf("10 - [POLY ZEROES] %d\n", hull_excludes_0(test_array, 6, 2));
	test_array[0] = cos(-pio2);
	test_array[1] = sin(-pio2);
	test_array[2] = cos(pi + delt);
	test_array[3] = sin(pi + delt);
	test_array[4] = cos(pio2 + delt);
	test_array[5] = sin(pio2 + delt);
printf("11 - [POLY ZEROES] %d\n", hull_excludes_0(test_array, 6, 2));
	test_array[0] = cos(-pio2);
	test_array[1] = sin(-pio2);
	test_array[2] = cos(pi + delt);
	test_array[3] = sin(pi + delt);
	test_array[4] = cos(pio2 - delt);
	test_array[5] = sin(pio2 - delt);
printf("12 - [POLY ZEROES] %d\n", hull_excludes_0(test_array, 6, 2));
	test_array[0] = 1.0;
	test_array[1] = -1.0;
	test_array[2] = cos(0.75 * pi + delt);
	test_array[3] = sin(0.75 * pi + delt);
	test_array[4] = -1.0;
	test_array[5] = -1.0;
printf("13 - [POLY ZEROES] %d\n", hull_excludes_0(test_array, 6, 2));
}		

void test_find_root_list(double *Q_coeffs, int nQ, double *a, double *b, int *degrees, int dim)
{
	int j;
	int i;

	int root_list_back_size;
	double **root_list_back;

	root_list_back = find_root_list(Q_coeffs, nQ, a, b, degrees, dim, &root_list_back_size);

	if (root_list_back) {
		for (i=0; i<root_list_back_size; i++) {
			double *this_row = root_list_back[i];

			for (j=0; j<dim; j++) {
				printf("%3.11g ", this_row[j]);
			}
			printf("\n");

			free(this_row);
		}
		free(root_list_back);
	}
	printf("\n");
}

void test1()
{
	double Q_coeffs[] = {	-1.0000000000, -1.0000000000, 
							-1.0000000000, 1.0000000000, 
							 2.0000000000, -1.0000000000, 
							 2.0000000000, 1.0000000000};
	double a[] = {0.0,0.0};
	double b[] = {1.0,1.0};
	int degrees[] = {1,1};
	int dim = 2;
	int nQ = 8;

	test_find_root_list(Q_coeffs, nQ, a, b, degrees, dim);
}


void test2()
{
	double Q_coeffs[] = {	-1.0000000000, 0.0000000000, 
							-1.0000000000, 0.0000000000, 
							 0.0000000000, 1.0000000000,
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							 0.0000000000, 0.0000000000, 
							 0.0000000000, -1.0000000000, 
							 0.0000000000, -1.0000000000, 
							 1.0000000000, 0.0000000000};
	double a[] = {0.0,0.0};
	double b[] = {1.0,1.0};
	int degrees[] = {2,2};
	int dim = 2;
	int nQ = 18;

	test_find_root_list(Q_coeffs, nQ, a, b, degrees, dim);
}

void test3()
{
	double Q_coeffs[] = {	-1.0000000000, 0.0000000000, 
							-1.0000000000, 0.0000000000, 
							-1.0000000000, 0.0000000000, 
							-1.0000000000, 0.0000000000, 
							 0.0000000000, 1.0000000000, 
							-1.0000000000, 0.0000000000, 
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000, 
							-1.0000000000, 0.0000000000, 
							 0.0000000000, 1.0000000000,
							-1.0000000000, -0.33333333333, 
							-1.0000000000, -0.33333333333, 
							-1.0000000000, -0.33333333333, 
							-1.0000000000, -0.33333333333, 
							 0.0000000000, 0.66666666667, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							 0.0000000000, 0.0000000000, 
							 0.0000000000, -1.0000000000, 
							 0.0000000000, -1.0000000000, 
							 0.0000000000, -1.0000000000, 
							 0.0000000000, -1.0000000000, 
							 1.0000000000, 0.0000000000};
	double a[] = {0.0,0.0};
	double b[] = {1.0,1.0};
	int degrees[] = {4,4};
	int dim = 2;
	int nQ = 50;

	test_find_root_list(Q_coeffs, nQ, a, b, degrees, dim);
}

void test4()
{
	double Q_coeffs[] = {	-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							 0.0000000000, 1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							 0.0000000000, 1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							 0.0000000000, 1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000, 
							 0.0000000000, 1.0000000000, 
							-1.0000000000, -1.0285714286, 
							-1.0000000000, -1.0285714286, 
							-1.0000000000, -1.0285714286, 
							-1.0000000000, -1.0285714286, 
							-1.0000000000, -1.0285714286, 
							-1.0000000000, -1.0285714286, 
							-1.0000000000, -1.0285714286, 
							-1.0000000000, -1.0285714286, 
							 0.0000000000, 0.97142857143, 
							-1.0000000000, -1.1428571429, 
							-1.0000000000, -1.1428571429,
							-1.0000000000, -1.1428571429, 
							-1.0000000000, -1.1428571429, 
							-1.0000000000, -1.1428571429, 
							-1.0000000000, -1.1428571429, 
							-1.0000000000, -1.1428571429, 
							-1.0000000000, -1.1428571429, 
							 0.0000000000, 0.85714285714, 
							-1.0000000000, -1.4285714286, 
							-1.0000000000, -1.4285714286, 
							-1.0000000000, -1.4285714286, 
							-1.0000000000, -1.4285714286, 
							-1.0000000000, -1.4285714286, 
							-1.0000000000, -1.4285714286, 
							-1.0000000000, -1.4285714286, 
							-1.0000000000, -1.4285714286, 
							 0.0000000000, 0.57142857143, 
							-1.0000000000, -2.0000000000,
							-1.0000000000, -2.0000000000, 
							-1.0000000000, -2.0000000000, 
							-1.0000000000, -2.0000000000, 
							-1.0000000000, -2.0000000000,
							-1.0000000000, -2.0000000000, 
							-1.0000000000, -2.0000000000, 
							-1.0000000000, -2.0000000000, 
							 0.0000000000, 0.0000000000, 
							 0.0000000000, -1.0000000000, 
							 0.0000000000, -1.0000000000, 
							 0.0000000000, -1.0000000000, 
							 0.0000000000, -1.0000000000, 
							 0.0000000000, -1.0000000000, 
							 0.0000000000, -1.0000000000, 
							 0.0000000000, -1.0000000000, 
							 0.0000000000, -1.0000000000, 
							 1.0000000000, 1.0000000000};
	double a[] = {0.0,0.0};
	double b[] = {1.0,1.0};
	int degrees[] = {8,8};
	int dim = 2;
	int nQ = 162;

	test_find_root_list(Q_coeffs, nQ, a, b, degrees, dim);
}

void test5()
{
	double Q_coeffs[] = {	-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							 0.0000000000, 1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							 0.0000000000, 1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							 0.0000000000, 1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,
							 0.0000000000, 1.0000000000,
							-1.0000000000, -1.0285714286,
							-1.0000000000, -1.0285714286,
							-1.0000000000, -1.0285714286,
							-1.0000000000, -1.0285714286,
							-1.0000000000, -1.0285714286,
							-1.0000000000, -1.0285714286,
							-1.0000000000, -1.0285714286,
							-1.0000000000, -1.0285714286,
							 0.0000000000, 0.97142857143,
							-1.0000000000, -1.1428571429,
							-1.0000000000, -1.1428571429,
							-1.0000000000, -1.1428571429,
							-1.0000000000, -1.1428571429,
							-1.0000000000, -1.1428571429,
							-1.0000000000, -1.1428571429,
							-1.0000000000, -1.1428571429,
							-1.0000000000, -1.1428571429,
							 0.0000000000, 0.85714285714,
							-1.0000000000, -1.4285714286,
							-1.0000000000, -1.4285714286,
							-1.0000000000, -1.4285714286,
							-1.0000000000, -1.4285714286,
							-1.0000000000, -1.4285714286,
							-1.0000000000, -1.4285714286,
							-1.0000000000, -1.4285714286,
							-1.0000000000, -1.4285714286,
							 0.0000000000, 0.57142857143,
							-1.0000000000, -2.0000000000,
							-1.0000000000, -2.0000000000,
							-1.0000000000, -2.0000000000,
							-1.0000000000, -2.0000000000,
							-1.0000000000, -2.0000000000,
							-1.0000000000, -2.0000000000,
							-1.0000000000, -2.0000000000,
							-1.0000000000, -2.0000000000,
							 0.0000000000, 0.0000000000,
							 0.0000000000, -1.0000000000,
							 0.0000000000, -1.0000000000,
							 0.0000000000, -1.0000000000,
							 0.0000000000, -1.0000000000,
							 0.0000000000, -1.0000000000,
							 0.0000000000, -1.0000000000,
							 0.0000000000, -1.0000000000,
							 0.0000000000, -1.0000000000,
							 1.0000000000, 1.0000000000};
	double a[] = {0.0,0.0};
	double b[] = {1.0,1.0};
	int degrees[] = {8,8};
	int dim = 2;
	int nQ = 162;

	test_find_root_list(Q_coeffs, nQ, a, b, degrees, dim);
}

void test6()
{
	double Q_coeffs[] = {
	0.58833600000, 0.0000000000
	, 0.58833600000, 0.56980666667
	, 0.22740266667, 1.1396133333
	, -0.49446400000, 1.0654200000
	, 0.18273600000, -0.29677333333
	, 5.7790026667, -2.1909666667
	, -14.425664000, -1.0611600000
	, 1.2151233333, 0.0000000000
	, 1.2151233333, 0.90066222222
	, 0.38192333333, 1.8013244444
	, -1.2844766667, 1.0899866667
	, -1.5107433333, -2.8453511111
	, 4.2497900000, -3.6166888889
	, -13.182876667, 21.163973333
	, 2.2786400000, 0.0000000000
	, 2.2786400000, 1.7510111111
	, 0.12133333333, 3.5020222222
	, -4.1932800000, 2.3342333333
	, -4.9745333333, -4.6711555556
	, 9.1589066667, -5.8329444444
	, 19.279040000, 39.730066667
	, 4.6360500000, 0.0000000000
	, 4.6360500000, 4.2921333333
	, -0.069883333333, 8.5842666667
	, -9.4817500000, 5.9162000000
	, -11.587550000, -10.672266667
	, 17.636716667, -26.941333333
	, 78.227050000, 13.748800000
	, 11.721333333, 0.0000000000
	, 11.721333333, 10.378555556
	, -0.64426666667, 20.757111111
	, -25.375466667, 15.003666667
	, -41.234933333, -23.013777778
	, -5.7480000000, -81.627222222
	, 108.79733333, -93.568666667
	, 31.800000000, 0.0000000000
	, 31.800000000, 32.211111111
	, -0.73666666667, 64.422222222
	, -65.810000000, 63.803333333
	, -130.05333333, -2.4755555556
	, -126.73333333, -132.84444444
	, 8.2500000000, -256.93333333
	, 144.00000000, 0.0000000000
	, 144.00000000, 102.00000000
	, 67.866666667, 204.00000000
	, -84.400000000, 246.55000000
	, -264.40000000, 170.20000000
	, -375.33333333, -43.500000000
	, -308.00000000, -331.00000000};
	
	double a[] = {-0.1,0.0};
	double b[] = {1.0,1.0};
	int degrees[] = {6,6};
	int dim = 2;
	int nQ = 98;

	test_find_root_list(Q_coeffs, nQ, a, b, degrees, dim);
}

void test7()
{
	double Q_coeffs[] = {	1.4344000000, 0.76851200000
							, 2.1639493333, -0.48610400000
							, 1.4669893333, -2.7426000000
							, -2.1099320000, -3.4747380000
							, -5.0423266667, 2.3619720000
							, 6.9700693333, 8.4798860000
							, 1.0249360000, -16.591160000
							, 0.17978400000, 0.038962666667
							, 0.074433333333, -0.026895555556
							, 0.22673200000, -0.12566577778
							, 0.44235400000, -0.22008000000
							, 0.88811800000, 0.31276977778
							, 7.8898233333, -0.53958844444
							, -24.046110000, -10.646026667
							, 0.35167733333, 0.31129333333
							, 0.38039466667, -0.24996577778
							, 0.35974400000, -0.88246968889
							, 0.19495813333, -1.2678432000
							, -0.21263440000, -2.4346831111
							, 4.8322266667, 0.64978777778
							, -31.159626667, 26.488066667
							, -0.57615800000, 0.13205200000
							, -0.70353066667, -0.11979666667
							, -0.40838746667, -0.32895653333
							, -0.84550400000, -0.31467780000
							, 0.71313733333, -3.1757946667
							, 16.676183333, 2.7469866667
							, 11.154550000, 61.908800000
							, -0.15202000000, 0.56603866667
							, -0.052154666667, -0.69941355556
							, 0.23934240000, -0.49640977778
							, -2.6518800000, -2.3893680000
							, -0.078936000000, -15.154902222
							, 34.424133333, -24.114744444
							, 87.164000000, 37.531333333
							, -4.7966526667, -0.60153066667
							, -1.4801233333, -0.31885511111
							, -4.6390300000, 5.3294444444
							, -21.026866667, 2.2374300000
							, -32.985700000, -30.845644444
							, 7.3516666667, -83.018888889
							, 120.08333333, -71.933333333
							, 20.122564000, -14.662860000
							, 34.183893333, 10.256356667
							, 18.681373333, 48.069333333
							, -37.677200000, 64.143450000
							, -105.13066667, 14.768666667
							, -107.06666667, -102.91666667
							, 22.000000000, -201.00000000
							};
	double a[] = {-0.1,-0.1};
	double b[] = {1.0,1.0};
	int degrees[] = {6,6};
	int dim = 2;
	int nQ = 98;

	test_find_root_list(Q_coeffs,nQ, a, b, degrees, dim);
}

void test8()
{
	double Q_coeffs[] = {	1.0000000000, 0.0000000000,
							1.0000000000, 0.0000000000,
							0.16666666667, 0.0000000000,
							-1.5000000000, 0.0000000000,
							2.0000000000, 0.0000000000,
							1.0000000000, 0.0000000000,
							1.0000000000, 0.62500000000,
							0.16666666667, 1.2500000000,
							-1.5000000000, 0.37500000000,
							2.0000000000, -3.5000000000,
							1.8333333333, 0.0000000000,
							1.8333333333, 1.2500000000,
							0.0000000000, 2.5000000000,
							-3.6666666667, 0.75000000000,
							-3.1666666667, -7.0000000000,
							3.5000000000, 0.0000000000,
							3.5000000000, 3.3750000000,
							-0.33333333333, 6.7500000000,
							-8.0000000000, 5.6250000000,
							-13.500000000, -4.5000000000,
							12.000000000, 0.0000000000,
							12.000000000, 8.5000000000,
							5.1666666667, 17.000000000,
							-8.5000000000, 19.500000000,
							-23.000000000, 10.000000000};
	double a[] = {0.0,0.0};
	double b[] = {1.0,1.0};
	int degrees[] = {4,4};
	int dim = 2;
	int nQ = 50;

	test_find_root_list(Q_coeffs, nQ, a, b, degrees, dim);
}

void test9()
{
	double Q_coeffs[] = {	1.0000000000, 0.0000000000,
							1.0000000000, 2.5000000000,
							-5.0000000000, 5.0000000000,
							3.5000000000, 0.0000000000,
							3.5000000000, 5.5000000000,
							-2.5000000000, 11.000000000,
							12.000000000, 0.0000000000,
							12.000000000, 8.5000000000,
							6.0000000000, 17.000000000};
	double a[] = {0.0,0.0};
	double b[] = {1.0,1.0};
	int degrees[] = {2,2};
	int dim = 2;
	int nQ = 18;

	test_find_root_list(Q_coeffs, nQ, a, b, degrees, dim);
}

void test10()
{
	double Q_coeffs[] = {	0.58833600000, 0.0000000000
							, 0.58833600000, 0.56980666667
							, 0.22740266667, 1.1396133333
							, -0.49446400000, 1.0654200000
							, 0.18273600000, -0.29677333333
							, 5.7790026667, -2.1909666667
							, -14.425664000, -1.0611600000
							, 1.2151233333, 0.0000000000
							, 1.2151233333, 0.90066222222
							, 0.38192333333, 1.8013244444
							, -1.2844766667, 1.0899866667
							, -1.5107433333, -2.8453511111
							, 4.2497900000, -3.6166888889
							, -13.182876667, 21.163973333
							, 2.2786400000, 0.0000000000
							, 2.2786400000, 1.7510111111
							, 0.12133333333, 3.5020222222
							, -4.1932800000, 2.3342333333
							, -4.9745333333, -4.6711555556
							, 9.1589066667, -5.8329444444
							, 19.279040000, 39.730066667
							, 4.6360500000, 0.0000000000
							, 4.6360500000, 4.2921333333
							, -0.069883333333, 8.5842666667
							, -9.4817500000, 5.9162000000
							, -11.587550000, -10.672266667
							, 17.636716667, -26.941333333
							, 78.227050000, 13.748800000
							, 11.721333333, 0.0000000000
							, 11.721333333, 10.378555556
							, -0.64426666667, 20.757111111
							, -25.375466667, 15.003666667
							, -41.234933333, -23.013777778
							, -5.7480000000, -81.627222222
							, 108.79733333, -93.568666667
							, 31.800000000, 0.0000000000
							, 31.800000000, 32.211111111
							, -0.73666666667, 64.422222222
							, -65.810000000, 63.803333333
							, -130.05333333, -2.4755555556
							, -126.73333333, -132.84444444
							, 8.2500000000, -256.93333333
							, 144.00000000, 0.0000000000
							, 144.00000000, 102.00000000
							, 67.866666667, 204.00000000
							, -84.400000000, 246.55000000
							, -264.40000000, 170.20000000
							, -375.33333333, -43.500000000
							, -308.00000000, -331.00000000};
	double a[] = {-0.1,0.0};
	double b[] = {1.0,1.0};
	int degrees[] = {6,6};
	int dim = 2;
	int nQ = 98;

	test_find_root_list(Q_coeffs, nQ, a, b, degrees, dim);
}

void test11()
{
	double Q_coeffs[] = {	0.73542000000, 0.0000000000
							, 0.73542000000, 0.48700000000
							, 0.66742000000, 0.97400000000
							, 0.53142000000, 0.021000000000
							, -0.27258000000, -3.8120000000
							, -2.9445800000, 6.0350000000
							, 1.2711200000, 0.0000000000
							, 1.2711200000, 0.54684000000
							, 0.25272000000, 1.0936800000
							, -1.7840800000, 0.46452000000
							, -1.4792800000, -2.5166400000
							, 7.8871200000, 8.9742000000
							, 1.8891000000, 0.0000000000
							, 1.8891000000, 1.6521200000
							, 0.13810000000, 3.3042400000
							, -3.3639000000, 1.8663600000
							, -1.2969000000, -5.7515200000
							, 20.979100000, -4.6394000000
							, 4.5060000000, 0.0000000000
							, 4.5060000000, 3.4834000000
							, -0.15560000000, 6.9668000000
							, -9.4788000000, 3.2682000000
							, -12.183600000, -14.794400000
							, 14.290000000, -36.403000000
							, 10.160000000, 0.0000000000
							, 10.160000000, 10.992000000
							, -1.9860000000, 21.984000000
							, -26.278000000, 19.524000000
							, -47.476000000, -9.8400000000
							, -35.100000000, -61.560000000
							, 48.000000000, 0.0000000000
							, 48.000000000, 34.400000000
							, 21.400000000, 68.800000000
							, -31.800000000, 81.300000000
							, -92.400000000, 50.000000000
							, -122.00000000, -29.000000000};
	double a[] = {-0.1,0.0};
	double b[] = {1.0,1.0};
	int degrees[] = {5,5};
	int dim = 2;
	int nQ = 72;

	test_find_root_list(Q_coeffs, nQ, a, b, degrees, dim);
}

void test12()
{
	double Q_coeffs[] = {	0.71400000000, 0.0000000000
							, 0.71400000000, 0.92666666667
							, 0.64733333333, 1.8533333333
							, 0.51400000000, -3.2200000000
							, 1.7333333333, 0.0000000000
							, 1.7333333333, 0.97555555556
							, -0.53333333333, 1.9511111111
							, -5.0666666667, -3.0733333333
							, 2.8333333333, 0.0000000000
							, 2.8333333333, 3.4444444444
							, -1.6333333333, 6.8888888889
							, -10.566666667, 4.3333333333
							, 12.000000000, 0.0000000000
							, 12.000000000, 8.3333333333
							, 5.3333333333, 16.666666667
							, -8.0000000000, 19.000000000};
	double a[] = {-0.1,0.0};
	double b[] = {1.0,1.0};
	int degrees[] = {3,3};
	int dim = 2;
	int nQ = 32;

	test_find_root_list(Q_coeffs, nQ, a, b, degrees, dim);
}

void test13()
{
	double Q_coeffs[] = {	1.0000000000, 0.0000000000,
							1.0000000000, 0.0000000000,
							1.0000000000, 0.0000000000,
							1.0000000000, 0.0000000000,
							5.0000000000, 0.0000000000,
							1.0000000000, 0.0000000000,
							1.0000000000, 0.0000000000,
							1.0000000000, 0.0000000000,
							1.0000000000, -1.0000000000,
							5.0000000000, -4.0000000000,
							1.0000000000, 0.0000000000,
							1.0000000000, 0.0000000000,
							0.33333333333, 0.0000000000,
							-1.0000000000, -2.0000000000,
							1.0000000000, -8.0000000000,
							1.0000000000, 0.0000000000,
							1.0000000000, 1.0000000000,
							-1.0000000000, 2.0000000000,
							-5.0000000000, 0.0000000000,
							-7.0000000000, -8.0000000000,
							5.0000000000, 0.0000000000,
							5.0000000000, 4.0000000000,
							1.0000000000, 8.0000000000,
							-7.0000000000, 8.0000000000,
							-15.000000000, 0.0000000000};
	double a[] = {0.0,0.0};
	double b[] = {1.0,1.0};
	int degrees[] = {4,4};
	int dim = 2;
	int nQ = 50;

	test_find_root_list(Q_coeffs, nQ, a, b, degrees, dim);
}

void test14()
{
	double Q_coeffs[] = {	-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							15.000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, -2.0000000000,
							15.000000000, -16.000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.5714285714, 0.0000000000,
							-5.0000000000, -4.0000000000,
							-1.0000000000, -32.000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.28571428571,
							-2.7142857143, 1.7142857143,
							-13.000000000, 0.0000000000,
							-33.000000000, -32.000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-0.77142857143, 0.0000000000,
							0.14285714286, 1.1428571429,
							-1.0000000000, 6.8571428571,
							-17.000000000, 16.000000000,
							-65.000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, -0.28571428571,
							0.14285714286, -1.1428571429,
							4.7142857143, -4.4408920985e-16,
							10.428571429, 11.428571429,
							-1.0000000000, 40.000000000,
							-65.000000000, 64.000000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 0.0000000000,
							-1.5714285714, 0.0000000000,
							-2.7142857143, -1.7142857143,
							-1.0000000000, -6.8571428571,
							10.428571429, -11.428571429,
							33.285714286, 0.0000000000,
							47.000000000, 48.000000000,
							-1.0000000000, 128.00000000,
							-1.0000000000, 0.0000000000,
							-1.0000000000, 2.0000000000,
							-5.0000000000, 4.0000000000,
							-13.000000000, 0.0000000000,
							-17.000000000, -16.000000000,
							-1.0000000000, -40.000000000,
							47.000000000, -48.000000000,
							111.00000000, 0.0000000000,
							127.00000000, 128.00000000,
							15.000000000, 0.0000000000,
							15.000000000, 16.000000000,
							-1.0000000000, 32.000000000,
							-33.000000000, 32.000000000,
							-65.000000000, 0.0000000000,
							-65.000000000, -64.000000000,
							-1.0000000000, -128.00000000,
							127.00000000, -128.00000000,
							255.00000000, 0.0000000000};
	double a[] = {0.0,0.0};
	double b[] = {1.0,1.0};
	int degrees[] = {8,8};
	int dim = 2;
	int nQ = 162;

	test_find_root_list(Q_coeffs, nQ, a, b, degrees, dim);
}

void test_hull_excludes_0_bis()
{
	double c[] = {  1,   0,   1, 0.41666666667, 0.81666666667, 0.83333333334, 0.45, 1.09375, 0.050000000001, 1.0416666667, -0.083333333331, 0.67708333334, -0.062499999996, 0.3125, 1.4166666666,   0, 1.4166666666, 0.56944444443, 1.1291666667, 1.1388888889, 0.55416666666, 1.4770833333, -0.10625000001, 1.3527777778, -0.44791666667, 0.78472222222, -0.42708333334, 0.29166666667, 2.0166666666,   0, 2.0166666666, 0.82638888888, 1.565, 1.6527777778, 0.66166666666, 2.1416666667, -0.40166666668, 1.9555555556, -1.0416666667, 1.1006944444, -0.94583333333, 0.27083333333, 2.95625,   0, 2.95625, 1.2625, 2.2491666667, 2.525, 0.83499999999, 3.284375, -0.86750000001, 3.0375, -2.0208333333, 1.71875, -1.93125, 0.13749999999, 4.5416666666,   0, 4.5416666666, 2.0048611111, 3.4191666666, 4.0097222222, 1.1741666666, 5.2583333333, -1.61, 4.9944444444, -3.7666666667, 2.9930555555, -4.1083333333, 0.091666666649, 7.3854166666,   0, 7.3854166666, 3.3263888889, 5.58125, 6.6527777777, 1.9729166666, 8.8541666666, -2.6541666667, 8.8055555555, -6.7291666667, 6.0069444444, -8.4583333334, 1.2083333333, 13.125,   0, 13.125, 5.7395833333, 10.229166667, 11.479166667, 4.4375, 15.58125, -3.2250000001, 16.408333333, -10.708333333, 13.041666667, -15.5,   6 };
	int nc = 98;

	printf("hull_excludes_0 = %d\n", hull_excludes_0(c, nc, 2));
}

void test_hull_excludes_0_tris()
{
	double c[] = { -9.5367431641e-07, -9.5367431641e-07, -9.5367431641e-07, 0.0, 4.768371582e-07,  -9.5367431641e-07, 4.768371582e-07,  0.0 };
	double c1[] = { -9.5367431641, -9.5367431641, -9.5367431641, 0.0, 4.768371582,  -9.5367431641, 4.768371582,  0.0 };
	int nc = 8;
	int n_vars =  2;

	poly_zeroes_initialize(1.0e-14, 1.0e-7, 50, 10 /*only for this routine*/, 100); 

	printf("1. hull_excludes_0 = %d\n", hull_excludes_0(c, nc, n_vars));
	printf("2. hull_excludes_0 = %d\n", hull_excludes_0(c1, nc, n_vars));
}

void simplex_test1()
{
	int res;
	int i, j;
	int res_case;
	int *irowv, *iposv;
	double **a;	/* this is a pointer to a numerical recipes array */
	extern double smallish;

		/*
		 *	prepare data for simplex algorithm call
		 */

	a = dmatrix(1, 6, 1, 5);
	if (!a)
		return;

	a[1][1] =  0;	a[1][2] =  1;	a[1][3] =  0;	a[1][4] = -1;	a[1][5] =  0;
	a[2][1] =  2;	a[2][2] = -1;	a[2][3] =  0;	a[2][4] = +1;	a[2][5] =  0;
	a[3][1] =  2;	a[3][2] =  0;	a[3][3] = -1;	a[3][4] =  0;	a[3][5] = +1;
	a[4][1] =  1;	a[4][2] = -1;	a[4][3] =  0;	a[4][4] = +1;	a[4][5] =  0;
	a[5][1] =  1;	a[5][2] =  0;	a[5][3] = -1;	a[5][4] =  0;	a[5][5] = +1;

	irowv = ivector(1,4);
	if (!irowv)
		return;
	iposv = ivector(1,4);
	if (!iposv)
		return;

/*
 */
printf("a BEFORE = \n");
for (i=1; i<6; i++) {
	printf("[");
	for (j=1; j<5; j++) {
		printf("%g, ", a[i][j]);
	}
	printf("%g],\n",a[i][5]);
}
printf("[");
for (j=1; j<5; j++) {
	printf("%g, ", a[6][j]);
}
printf("%g]\n",a[6][5]);
/*
 */
	simplex(a, 4, 2, 2, 0, &res_case, irowv, iposv);
/*
 */
printf("a AFTER = \n");
for (i=1; i<6; i++) {
	printf("[");
	for (j=1; j<5; j++) {
		printf("%g, ", a[i][j]);
	}
	printf("%g],\n",a[i][5]);
}
printf("[");
for (j=1; j<5; j++) {
	printf("%g, ", a[6][j]);
}
printf("%g]\n",a[6][5]);

printf("irowv AFTER = \n[");
for (i=1;i<4;i++)
	printf("%d ,",irowv[i]);
printf("%d]\n",irowv[4]);

printf("iposv AFTER = \n[");
for (i=1;i<4;i++)
	printf("%d ,",iposv[i]);
printf("%d]\n",iposv[4]);
/*
 */
	res = (a[1][1] >= smallish);

	free_dmatrix(a, 1, 6, 1, 5);
	free_ivector(irowv, 1, 4);
	free_ivector(iposv, 1, 4);
	
}

void simplex_test2()
{
	int res;
	int i, j;
	int res_case;
	int *irowv, *iposv;
	double **a;	/* this is a pointer to a numerical recipes array */
	extern double smallish;

		/*
		 *	prepare data for simplex algorithm call
		 */

	a = dmatrix(1, 4, 1, 3);
	if (!a)
		return;

	a[1][1] =  0;	a[1][2] =  1;	a[1][3] = -1;
	a[2][1] =  2;	a[2][2] = -1;	a[2][3] =  1;
	a[3][1] =  1;	a[3][2] = -1;	a[3][3] =  1;

	irowv = ivector(1,1);
	if (!irowv)
		return;
	iposv = ivector(1,2);
	if (!iposv)
		return;

/*
 */
printf("a BEFORE = \n");
for (i=1; i<4; i++) {
	printf("[");
	for (j=1; j<3; j++) {
		printf("%g, ", a[i][j]);
	}
	printf("%g],\n",a[i][3]);
}
printf("[");
for (j=1; j<3; j++) {
	printf("%g, ", a[4][j]);
}
printf("%g]\n",a[4][3]);
/*
 */
	simplex(a, 1, 1, 1, 0, &res_case, irowv, iposv);
/*
 */
printf("a AFTER = \n");
for (i=1; i<4; i++) {
	printf("[");
	for (j=1; j<3; j++) {
		printf("%g, ", a[i][j]);
	}
	printf("%g],\n",a[i][3]);
}
printf("[");
for (j=1; j<3; j++) {
	printf("%g, ", a[4][j]);
}
printf("%g]\n",a[4][3]);

printf("irowv AFTER = \n[");
for (i=1;i<1;i++)
	printf("%d ,",irowv[i]);
printf("%d]\n",irowv[1]);

printf("iposv AFTER = \n[");
for (i=1;i<2;i++)
	printf("%d ,",iposv[i]);
printf("%d]\n",iposv[2]);
/*
 */
	res = (a[1][1] >= smallish);

	free_dmatrix(a, 1, 6, 1, 5);
	free_ivector(irowv, 1, 4);
	free_ivector(iposv, 1, 4);
	
}

void simplex_test3()
{
	int res;
	int i, j;
	int res_case;
	int *irowv, *iposv;
	double **a;	/* this is a pointer to a numerical recipes array */
	extern double smallish;

		/*
		 *	prepare data for simplex algorithm call
		 */

	a = dmatrix(1, 6, 1, 5);
	if (!a)
		return;

	a[1][1] =   0;	a[1][2] =  1;	a[1][3] =  1;	a[1][4] =  3;	a[1][5] = -0.5;
	a[2][1] = 740;	a[2][2] = -1;	a[2][3] =  0;	a[2][4] = -2;	a[2][5] =    0;
	a[3][1] =   0;	a[3][2] =  0;	a[3][3] = -2;	a[3][4] =  0;	a[3][5] =   +7;
	a[4][1] = 0.5;	a[4][2] =  0;	a[4][3] = -1;	a[4][4] = +1;	a[4][5] =   -2;
	a[5][1] =   9;	a[5][2] = -1;	a[5][3] = -1;	a[5][4] = -1;	a[5][5] =   -1;

	irowv = ivector(1,4);
	if (!irowv)
		return;
	iposv = ivector(1,4);
	if (!iposv)
		return;

/*
 */
printf("a BEFORE = \n");
for (i=1; i<6; i++) {
	printf("[");
	for (j=1; j<5; j++) {
		printf("%g, ", a[i][j]);
	}
	printf("%g],\n",a[i][5]);
}
printf("[");
for (j=1; j<5; j++) {
	printf("%g, ", a[6][j]);
}
printf("%g]\n",a[6][5]);
/*
 */
	simplex(a, 4, 2, 1, 1, &res_case, irowv, iposv);
/*
 */
printf("a AFTER = \n");
for (i=1; i<6; i++) {
	printf("[");
	for (j=1; j<5; j++) {
		printf("%g, ", a[i][j]);
	}
	printf("%g],\n",a[i][5]);
}
printf("[");
for (j=1; j<5; j++) {
	printf("%g, ", a[6][j]);
}
printf("%g]\n",a[6][5]);

printf("irowv AFTER = \n[");
for (i=1;i<4;i++)
	printf("%d ,",irowv[i]);
printf("%d]\n",irowv[4]);

printf("iposv AFTER = \n[");
for (i=1;i<4;i++)
	printf("%d ,",iposv[i]);
printf("%d]\n",iposv[4]);
/*
 */
	res = (a[1][1] >= smallish);

	free_dmatrix(a, 1, 6, 1, 5);
	free_ivector(irowv, 1, 4);
	free_ivector(iposv, 1, 4);
	
}

void simplex_test4()
{
	int res;
	int i, j;
	int res_case;
	int *irowv, *iposv;
	double **a;	/* this is a pointer to a numerical recipes array */
	extern double smallish;

	static	double mat[] = {
		0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
		0, 9.63258713978425419E-06, 0.0026272546798032890558, -0.17920312446487479674, -0.037929915124945541571, -9.63258713978425419E-06, -0.0026272546798032890558, 0.17920312446487479674, 0.037929915124945541571, -1,
		0, 9.6325871397842558841E-06, 0.0026272546798032890558, -0.1792031231540308911, 0.22155252905585606782, -9.6325871397842558841E-06, -0.0026272546798032890558, 0.1792031231540308911, -0.22155252905585606782, -1,
		0, 9.63258713978425419E-06, 0.0026272546798032890558, -0.17920313381414904041, 0.48103497323665772578, -9.63258713978425419E-06, -0.0026272546798032890558, 0.17920313381414904041, -0.48103497323665772578, -1,
		0, 9.6325871397842558841E-06, 0.0026272546798032890558, -0.17920315644522916143, 0.74051741741745902292, -9.6325871397842558841E-06, -0.0026272546798032890558, 0.17920315644522916143, -0.74051741741745902292, -1,
		0, 9.63258713978425419E-06, 0.0026272546798032890558, -0.17920319104727125414, 0.99999986159825993148, -9.63258713978425419E-06, -0.0026272546798032890558, 0.17920319104727125414, -0.99999986159825993148, -1,
		0, 9.63258713978425419E-06, 0.0026272546798032890558, 0.080279319715873376229, -0.037929916437397251383, -9.63258713978425419E-06, -0.0026272546798032890558, -0.080279319715873376229, 0.037929916437397251383, -1,
		0, 9.6325871397842558841E-06, 0.0026272546798032890558, 0.080279321026717281873, 0.22155253672162586454, -9.6325871397842558841E-06, -0.0026272546798032890558, -0.080279321026717281873, -0.22155253672162586454, -1,
		0, 9.63258713978425419E-06, 0.0026272546798032890558, 0.080279310366599063165, 0.48103498988064902209, -9.63258713978425419E-06, -0.0026272546798032890558, -0.080279310366599063165, -0.48103498988064902209, -1,
		0, 9.6325871397842558841E-06, 0.0026272546798032890558, 0.080279287735518706226, 0.74051744303967181882, -9.6325871397842558841E-06, -0.0026272546798032890558, -0.080279287735518706226, -0.74051744303967181882, -1,
		0, 9.63258713978425419E-06, 0.0026272546798032890558, 0.080279253133476224935, 0.99999989619869433799, -9.63258713978425419E-06, -0.0026272546798032890558, -0.080279253133476224935, -0.99999989619869433799, -1,
		0, 9.63258713978425419E-06, 0.0026272546798032890558, 0.33976177586758360416, -0.037929917749849009767, -9.63258713978425419E-06, -0.0026272546798032890558, -0.33976177586758360416, 0.037929917749849009767, -1,
		0, 9.6325871397842558841E-06, 0.0026272546798032890558, 0.33976177717842748205, 0.22155254438739574452, -9.6325871397842558841E-06, -0.0026272546798032890558, -0.33976177717842748205, -0.22155254438739574452, -1,
		0, 9.63258713978425419E-06, 0.0026272546798032890558, 0.33976176651830913844, 0.48103500652464048493, -9.63258713978425419E-06, -0.0026272546798032890558, -0.33976176651830913844, -0.48103500652464048493, -1,
		0, 9.6325871397842558841E-06, 0.0026272546798032890558, 0.33976174388722857334, 0.74051746866188494778, -9.6325871397842558841E-06, -0.0026272546798032890558, -0.33976174388722857334, -0.74051746866188494778, -1,
		0, 9.63258713978425419E-06, 0.0026272546798032890558, 0.33976170928518578673, 0.99999993079912896654, -9.63258713978425419E-06, -0.0026272546798032890558, -0.33976170928518578673, -0.99999993079912896654, -1,
		0, 9.63258713978425419E-06, 0.0026272546798032890558, 0.59924424399025599808, -0.037929919062300754273, -9.63258713978425419E-06, -0.0026272546798032890558, -0.59924424399025599808, 0.037929919062300754273, -1,
		0, 9.6325871397842558841E-06, 0.0026272546798032890558, 0.59924424530109998699, 0.22155255205316573552, -9.6325871397842558841E-06, -0.0026272546798032890558, -0.59924424530109998699, -0.22155255205316573552, -1,
		0, 9.63258713978425419E-06, 0.0026272546798032890558, 0.59924423464098153236, 0.48103502316863222532, -9.63258713978425419E-06, -0.0026272546798032890558, -0.59924423464098153236, -0.48103502316863222532, -1,
		0, 9.6325871397842558841E-06, 0.0026272546798032890558, 0.59924421200990063419, 0.74051749428409852083, -9.6325871397842558841E-06, -0.0026272546798032890558, -0.59924421200990063419, -0.74051749428409852083, -1,
		0, 9.63258713978425419E-06, 0.0026272546798032890558, 0.59924417740785740349, 0.99999996539956426123, -9.63258713978425419E-06, -0.0026272546798032890558, -0.59924417740785740349, -0.99999996539956426123, -1,
		0, 9.6325871397842558841E-06, 0.0026272546798032890558, 0.85872672408389083554, -0.037929920374752491841, -9.6325871397842558841E-06, -0.0026272546798032890558, -0.85872672408389083554, 0.037929920374752491841, -1,
		0, 9.6325871397842575782E-06, 0.0026272546798032890558, 0.85872672539473493547, 0.22155255971893586531, -9.6325871397842575782E-06, -0.0026272546798032890558, -0.85872672539473493547, -0.22155255971893586531, -1,
		0, 9.6325871397842558841E-06, 0.0026272546798032890558, 0.8587267147346162588, 0.48103503981262424327, -9.6325871397842558841E-06, -0.0026272546798032890558, -0.8587267147346162588, -0.48103503981262424327, -1,
		0, 9.6325871397842558841E-06, 0.0026272546798032890558, 0.85872669210353536062, 0.74051751990631231592, -9.6325871397842558841E-06, -0.0026272546798032890558, -0.85872669210353536062, -0.74051751990631231592, -1,
		0, 9.63258713978425419E-06, 0.0026272546798032890558, 0.85872665750149179686, 1, -9.63258713978425419E-06, -0.0026272546798032890558, -0.85872665750149179686, -1, -1,
		0, 9.6325873159554096939E-06, 0.0019704410101000855576, -0.17920312446487479674, -0.037929915124945527694, -9.6325873159554096939E-06, -0.0019704410101000855576, 0.17920312446487479674, 0.037929915124945527694, -1,
		0, 9.6325873159554079999E-06, 0.0019704410101000855576, -0.1792031231540308911, 0.22155252905585606782, -9.6325873159554079999E-06, -0.0019704410101000855576, 0.1792031231540308911, -0.22155252905585606782, -1,
		0, 9.6325873159554079999E-06, 0.0019704410101000855576, -0.17920313381414904041, 0.48103497323665767027, -9.6325873159554079999E-06, -0.0019704410101000855576, 0.17920313381414904041, -0.48103497323665767027, -1,
		0, 9.6325873159554096939E-06, 0.0019704410101000855576, -0.17920315644522916143, 0.74051741741745902292, -9.6325873159554096939E-06, -0.0019704410101000855576, 0.17920315644522916143, -0.74051741741745902292, -1,
		0, 9.6325873159554079999E-06, 0.0019704410101000855576, -0.17920319104727125414, 0.99999986159825993148, -9.6325873159554079999E-06, -0.0019704410101000855576, 0.17920319104727125414, -0.99999986159825993148, -1,
		0, 9.6325873159554096939E-06, 0.0019704410101000855576, 0.080279319715873376229, -0.037929916437397251383, -9.6325873159554096939E-06, -0.0019704410101000855576, -0.080279319715873376229, 0.037929916437397251383, -1,
		0, 9.6325873159554079999E-06, 0.0019704410101000855576, 0.080279321026717281873, 0.22155253672162589229, -9.6325873159554079999E-06, -0.0019704410101000855576, -0.080279321026717281873, -0.22155253672162589229, -1,
		0, 9.6325873159554079999E-06, 0.0019704410101000855576, 0.080279310366599063165, 0.48103498988064902209, -9.6325873159554079999E-06, -0.0019704410101000855576, -0.080279310366599063165, -0.48103498988064902209, -1,
		0, 9.6325873159554096939E-06, 0.0019704410101000855576, 0.080279287735518706226, 0.74051744303967181882, -9.6325873159554096939E-06, -0.0019704410101000855576, -0.080279287735518706226, -0.74051744303967181882, -1,
		0, 9.6325873159554079999E-06, 0.0019704410101000855576, 0.080279253133476224935, 0.99999989619869433799, -9.6325873159554079999E-06, -0.0019704410101000855576, -0.080279253133476224935, -0.99999989619869433799, -1,
		0, 9.6325873159554096939E-06, 0.0019704410101000855576, 0.33976177586758365967, -0.037929917749848982012, -9.6325873159554096939E-06, -0.0019704410101000855576, -0.33976177586758365967, 0.037929917749848982012, -1,
		0, 9.6325873159554079999E-06, 0.0019704410101000855576, 0.33976177717842748205, 0.22155254438739574452, -9.6325873159554079999E-06, -0.0019704410101000855576, -0.33976177717842748205, -0.22155254438739574452, -1,
		0, 9.6325873159554079999E-06, 0.0019704410101000855576, 0.33976176651830919395, 0.48103500652464048493, -9.6325873159554079999E-06, -0.0019704410101000855576, -0.33976176651830919395, -0.48103500652464048493, -1,
		0, 9.6325873159554096939E-06, 0.0019704410101000855576, 0.33976174388722857334, 0.74051746866188494778, -9.6325873159554096939E-06, -0.0019704410101000855576, -0.33976174388722857334, -0.74051746866188494778, -1,
		0, 9.6325873159554079999E-06, 0.0019704410101000855576, 0.33976170928518578673, 0.99999993079912896654, -9.6325873159554079999E-06, -0.0019704410101000855576, -0.33976170928518578673, -0.99999993079912896654, -1,
		0, 9.6325873159554096939E-06, 0.0019704410101000855576, 0.59924424399025599808, -0.037929919062300754273, -9.6325873159554096939E-06, -0.0019704410101000855576, -0.59924424399025599808, 0.037929919062300754273, -1,
		0, 9.6325873159554079999E-06, 0.0019704410101000855576, 0.59924424530109998699, 0.22155255205316573552, -9.6325873159554079999E-06, -0.0019704410101000855576, -0.59924424530109998699, -0.22155255205316573552, -1,
		0, 9.6325873159554079999E-06, 0.0019704410101000855576, 0.59924423464098153236, 0.48103502316863222532, -9.6325873159554079999E-06, -0.0019704410101000855576, -0.59924423464098153236, -0.48103502316863222532, -1,
		0, 9.6325873159554096939E-06, 0.0019704410101000855576, 0.59924421200990063419, 0.74051749428409852083, -9.6325873159554096939E-06, -0.0019704410101000855576, -0.59924421200990063419, -0.74051749428409852083, -1,
		0, 9.6325873159554079999E-06, 0.0019704410101000855576, 0.59924417740785740349, 0.99999996539956426123, -9.6325873159554079999E-06, -0.0019704410101000855576, -0.59924417740785740349, -0.99999996539956426123, -1,
		0, 9.6325873159554096939E-06, 0.0019704410101000855576, 0.85872672408389083554, -0.037929920374752491841, -9.6325873159554096939E-06, -0.0019704410101000855576, -0.85872672408389083554, 0.037929920374752491841, -1,
		0, 9.6325873159554096939E-06, 0.0019704410101000855576, 0.85872672539473504649, 0.22155255971893586531, -9.6325873159554096939E-06, -0.0019704410101000855576, -0.85872672539473504649, -0.22155255971893586531, -1,
		0, 9.6325873159554096939E-06, 0.0019704410101000855576, 0.8587267147346162588, 0.48103503981262424327, -9.6325873159554096939E-06, -0.0019704410101000855576, -0.8587267147346162588, -0.48103503981262424327, -1,
		0, 9.6325873159554096939E-06, 0.0019704410101000855576, 0.85872669210353536062, 0.74051751990631231592, -9.6325873159554096939E-06, -0.0019704410101000855576, -0.85872669210353536062, -0.74051751990631231592, -1,
		0, 9.6325873159554079999E-06, 0.0019704410101000855576, 0.85872665750149179686, 1, -9.6325873159554079999E-06, -0.0019704410101000855576, -0.85872665750149179686, -1, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968820594, -0.17920312446487479674, -0.037929915124945527694, -9.6325874334028450025E-06, -0.0013136273403968820594, 0.17920312446487479674, 0.037929915124945527694, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968818426, -0.1792031231540308911, 0.22155252905585606782, -9.6325874334028450025E-06, -0.0013136273403968818426, 0.1792031231540308911, -0.22155252905585606782, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968818426, -0.17920313381414904041, 0.48103497323665767027, -9.6325874334028450025E-06, -0.0013136273403968818426, 0.17920313381414904041, -0.48103497323665767027, -1,
		0, 9.6325874334028466965E-06, 0.0013136273403968818426, -0.17920315644522916143, 0.74051741741745902292, -9.6325874334028466965E-06, -0.0013136273403968818426, 0.17920315644522916143, -0.74051741741745902292, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968818426, -0.17920319104727125414, 0.99999986159825993148, -9.6325874334028450025E-06, -0.0013136273403968818426, 0.17920319104727125414, -0.99999986159825993148, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968820594, 0.080279319715873376229, -0.037929916437397251383, -9.6325874334028450025E-06, -0.0013136273403968820594, -0.080279319715873376229, 0.037929916437397251383, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968818426, 0.080279321026717281873, 0.22155253672162589229, -9.6325874334028450025E-06, -0.0013136273403968818426, -0.080279321026717281873, -0.22155253672162589229, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968818426, 0.080279310366599063165, 0.48103498988064902209, -9.6325874334028450025E-06, -0.0013136273403968818426, -0.080279310366599063165, -0.48103498988064902209, -1,
		0, 9.6325874334028466965E-06, 0.0013136273403968818426, 0.080279287735518706226, 0.74051744303967181882, -9.6325874334028466965E-06, -0.0013136273403968818426, -0.080279287735518706226, -0.74051744303967181882, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968818426, 0.080279253133476224935, 0.99999989619869433799, -9.6325874334028450025E-06, -0.0013136273403968818426, -0.080279253133476224935, -0.99999989619869433799, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968820594, 0.33976177586758365967, -0.037929917749848982012, -9.6325874334028450025E-06, -0.0013136273403968820594, -0.33976177586758365967, 0.037929917749848982012, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968818426, 0.33976177717842748205, 0.22155254438739574452, -9.6325874334028450025E-06, -0.0013136273403968818426, -0.33976177717842748205, -0.22155254438739574452, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968818426, 0.33976176651830919395, 0.48103500652464048493, -9.6325874334028450025E-06, -0.0013136273403968818426, -0.33976176651830919395, -0.48103500652464048493, -1,
		0, 9.6325874334028466965E-06, 0.0013136273403968818426, 0.33976174388722857334, 0.74051746866188494778, -9.6325874334028466965E-06, -0.0013136273403968818426, -0.33976174388722857334, -0.74051746866188494778, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968818426, 0.33976170928518578673, 0.99999993079912896654, -9.6325874334028450025E-06, -0.0013136273403968818426, -0.33976170928518578673, -0.99999993079912896654, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968820594, 0.59924424399025599808, -0.037929919062300754273, -9.6325874334028450025E-06, -0.0013136273403968820594, -0.59924424399025599808, 0.037929919062300754273, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968818426, 0.59924424530109998699, 0.22155255205316573552, -9.6325874334028450025E-06, -0.0013136273403968818426, -0.59924424530109998699, -0.22155255205316573552, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968818426, 0.59924423464098153236, 0.48103502316863222532, -9.6325874334028450025E-06, -0.0013136273403968818426, -0.59924423464098153236, -0.48103502316863222532, -1,
		0, 9.6325874334028466965E-06, 0.0013136273403968818426, 0.59924421200990063419, 0.74051749428409852083, -9.6325874334028466965E-06, -0.0013136273403968818426, -0.59924421200990063419, -0.74051749428409852083, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968818426, 0.59924417740785740349, 0.99999996539956426123, -9.6325874334028450025E-06, -0.0013136273403968818426, -0.59924417740785740349, -0.99999996539956426123, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968820594, 0.85872672408389083554, -0.037929920374752491841, -9.6325874334028450025E-06, -0.0013136273403968820594, -0.85872672408389083554, 0.037929920374752491841, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968818426, 0.85872672539473504649, 0.22155255971893586531, -9.6325874334028450025E-06, -0.0013136273403968818426, -0.85872672539473504649, -0.22155255971893586531, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968818426, 0.8587267147346162588, 0.48103503981262424327, -9.6325874334028450025E-06, -0.0013136273403968818426, -0.8587267147346162588, -0.48103503981262424327, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968818426, 0.85872669210353536062, 0.74051751990631231592, -9.6325874334028450025E-06, -0.0013136273403968818426, -0.85872669210353536062, -0.74051751990631231592, -1,
		0, 9.6325874334028450025E-06, 0.0013136273403968818426, 0.85872665750149179686, 1, -9.6325874334028450025E-06, -0.0013136273403968818426, -0.85872665750149179686, -1, -1,
		0, 9.6325874921265618097E-06, 0.00065681367069367845284, -0.17920312446487479674, -0.037929915124945527694, -9.6325874921265618097E-06, -0.00065681367069367845284, 0.17920312446487479674, 0.037929915124945527694, -1,
		0, 9.6325874921265635038E-06, 0.00065681367069367845284, -0.1792031231540308911, 0.22155252905585606782, -9.6325874921265635038E-06, -0.00065681367069367845284, 0.1792031231540308911, -0.22155252905585606782, -1,
		0, 9.6325874921265618097E-06, 0.00065681367069367845284, -0.17920313381414904041, 0.48103497323665767027, -9.6325874921265618097E-06, -0.00065681367069367845284, 0.17920313381414904041, -0.48103497323665767027, -1,
		0, 9.6325874921265635038E-06, 0.00065681367069367845284, -0.17920315644522916143, 0.74051741741745902292, -9.6325874921265635038E-06, -0.00065681367069367845284, 0.17920315644522916143, -0.74051741741745902292, -1,
		0, 9.6325874921265618097E-06, 0.00065681367069367845284, -0.17920319104727125414, 0.99999986159825993148, -9.6325874921265618097E-06, -0.00065681367069367845284, 0.17920319104727125414, -0.99999986159825993148, -1,
		0, 9.6325874921265618097E-06, 0.00065681367069367845284, 0.080279319715873376229, -0.037929916437397251383, -9.6325874921265618097E-06, -0.00065681367069367845284, -0.080279319715873376229, 0.037929916437397251383, -1,
		0, 9.6325874921265635038E-06, 0.00065681367069367845284, 0.080279321026717281873, 0.22155253672162589229, -9.6325874921265635038E-06, -0.00065681367069367845284, -0.080279321026717281873, -0.22155253672162589229, -1,
		0, 9.6325874921265618097E-06, 0.00065681367069367845284, 0.080279310366599063165, 0.48103498988064902209, -9.6325874921265618097E-06, -0.00065681367069367845284, -0.080279310366599063165, -0.48103498988064902209, -1,
		0, 9.6325874921265635038E-06, 0.00065681367069367845284, 0.080279287735518706226, 0.74051744303967181882, -9.6325874921265635038E-06, -0.00065681367069367845284, -0.080279287735518706226, -0.74051744303967181882, -1,
		0, 9.6325874921265618097E-06, 0.00065681367069367845284, 0.080279253133476224935, 0.99999989619869433799, -9.6325874921265618097E-06, -0.00065681367069367845284, -0.080279253133476224935, -0.99999989619869433799, -1,
		0, 9.6325874921265618097E-06, 0.00065681367069367845284, 0.33976177586758365967, -0.037929917749848982012, -9.6325874921265618097E-06, -0.00065681367069367845284, -0.33976177586758365967, 0.037929917749848982012, -1,
		0, 9.6325874921265635038E-06, 0.00065681367069367845284, 0.33976177717842748205, 0.22155254438739574452, -9.6325874921265635038E-06, -0.00065681367069367845284, -0.33976177717842748205, -0.22155254438739574452, -1,
		0, 9.6325874921265618097E-06, 0.00065681367069367845284, 0.33976176651830919395, 0.48103500652464048493, -9.6325874921265618097E-06, -0.00065681367069367845284, -0.33976176651830919395, -0.48103500652464048493, -1,
		0, 9.6325874921265635038E-06, 0.00065681367069367845284, 0.33976174388722857334, 0.74051746866188494778, -9.6325874921265635038E-06, -0.00065681367069367845284, -0.33976174388722857334, -0.74051746866188494778, -1,
		0, 9.6325874921265618097E-06, 0.00065681367069367845284, 0.33976170928518578673, 0.99999993079912896654, -9.6325874921265618097E-06, -0.00065681367069367845284, -0.33976170928518578673, -0.99999993079912896654, -1,
		0, 9.6325874921265618097E-06, 0.00065681367069367845284, 0.59924424399025599808, -0.037929919062300754273, -9.6325874921265618097E-06, -0.00065681367069367845284, -0.59924424399025599808, 0.037929919062300754273, -1,
		0, 9.6325874921265635038E-06, 0.00065681367069367845284, 0.59924424530109998699, 0.22155255205316573552, -9.6325874921265635038E-06, -0.00065681367069367845284, -0.59924424530109998699, -0.22155255205316573552, -1,
		0, 9.6325874921265618097E-06, 0.00065681367069367845284, 0.59924423464098153236, 0.48103502316863222532, -9.6325874921265618097E-06, -0.00065681367069367845284, -0.59924423464098153236, -0.48103502316863222532, -1,
		0, 9.6325874921265635038E-06, 0.00065681367069367845284, 0.59924421200990063419, 0.74051749428409852083, -9.6325874921265635038E-06, -0.00065681367069367845284, -0.59924421200990063419, -0.74051749428409852083, -1,
		0, 9.6325874921265618097E-06, 0.00065681367069367845284, 0.59924417740785740349, 0.99999996539956426123, -9.6325874921265618097E-06, -0.00065681367069367845284, -0.59924417740785740349, -0.99999996539956426123, -1,
		0, 9.6325874921265618097E-06, 0.00065681367069367845284, 0.85872672408389083554, -0.037929920374752491841, -9.6325874921265618097E-06, -0.00065681367069367845284, -0.85872672408389083554, 0.037929920374752491841, -1,
		0, 9.6325874921265635038E-06, 0.00065681367069367845284, 0.85872672539473504649, 0.22155255971893586531, -9.6325874921265635038E-06, -0.00065681367069367845284, -0.85872672539473504649, -0.22155255971893586531, -1,
		0, 9.6325874921265618097E-06, 0.00065681367069367845284, 0.8587267147346162588, 0.48103503981262424327, -9.6325874921265618097E-06, -0.00065681367069367845284, -0.8587267147346162588, -0.48103503981262424327, -1,
		0, 9.6325874921265635038E-06, 0.00065681367069367845284, 0.85872669210353536062, 0.74051751990631231592, -9.6325874921265635038E-06, -0.00065681367069367845284, -0.85872669210353536062, -0.74051751990631231592, -1,
		0, 9.6325874921265618097E-06, 0.00065681367069367845284, 0.85872665750149179686, 1, -9.6325874921265618097E-06, -0.00065681367069367845284, -0.85872665750149179686, -1, -1,
		0, 9.6325874921265618097E-06, 9.9047507009538666534E-13, -0.17920312446487479674, -0.037929915124945527694, -9.6325874921265618097E-06, -9.9047507009538666534E-13, 0.17920312446487479674, 0.037929915124945527694, -1,
		0, 9.6325874921265635038E-06, 9.9047507009538666534E-13, -0.1792031231540308911, 0.22155252905585606782, -9.6325874921265635038E-06, -9.9047507009538666534E-13, 0.1792031231540308911, -0.22155252905585606782, -1,
		0, 9.6325874921265618097E-06, 9.9047507009538666534E-13, -0.17920313381414904041, 0.48103497323665767027, -9.6325874921265618097E-06, -9.9047507009538666534E-13, 0.17920313381414904041, -0.48103497323665767027, -1,
		0, 9.6325874921265635038E-06, 9.9047507009538666534E-13, -0.17920315644522916143, 0.74051741741745902292, -9.6325874921265635038E-06, -9.9047507009538666534E-13, 0.17920315644522916143, -0.74051741741745902292, -1,
		0, 9.6325874921265618097E-06, 9.9047507009538666534E-13, -0.17920319104727125414, 0.99999986159825993148, -9.6325874921265618097E-06, -9.9047507009538666534E-13, 0.17920319104727125414, -0.99999986159825993148, -1,
		0, 9.6325874921265618097E-06, 9.9047507009538666534E-13, 0.080279319715873376229, -0.037929916437397251383, -9.6325874921265618097E-06, -9.9047507009538666534E-13, -0.080279319715873376229, 0.037929916437397251383, -1,
		0, 9.6325874921265635038E-06, 9.9047507009538666534E-13, 0.080279321026717281873, 0.22155253672162589229, -9.6325874921265635038E-06, -9.9047507009538666534E-13, -0.080279321026717281873, -0.22155253672162589229, -1,
		0, 9.6325874921265618097E-06, 9.9047507009538666534E-13, 0.080279310366599063165, 0.48103498988064902209, -9.6325874921265618097E-06, -9.9047507009538666534E-13, -0.080279310366599063165, -0.48103498988064902209, -1,
		0, 9.6325874921265635038E-06, 9.9047507009538666534E-13, 0.080279287735518706226, 0.74051744303967181882, -9.6325874921265635038E-06, -9.9047507009538666534E-13, -0.080279287735518706226, -0.74051744303967181882, -1,
		0, 9.6325874921265618097E-06, 9.9047507009538666534E-13, 0.080279253133476224935, 0.99999989619869433799, -9.6325874921265618097E-06, -9.9047507009538666534E-13, -0.080279253133476224935, -0.99999989619869433799, -1,
		0, 9.6325874921265618097E-06, 9.9047507009538666534E-13, 0.33976177586758365967, -0.037929917749848982012, -9.6325874921265618097E-06, -9.9047507009538666534E-13, -0.33976177586758365967, 0.037929917749848982012, -1,
		0, 9.6325874921265635038E-06, 9.9047507009538666534E-13, 0.33976177717842748205, 0.22155254438739574452, -9.6325874921265635038E-06, -9.9047507009538666534E-13, -0.33976177717842748205, -0.22155254438739574452, -1,
		0, 9.6325874921265618097E-06, 9.9047507009538666534E-13, 0.33976176651830919395, 0.48103500652464048493, -9.6325874921265618097E-06, -9.9047507009538666534E-13, -0.33976176651830919395, -0.48103500652464048493, -1,
		0, 9.6325874921265635038E-06, 9.9047507009538666534E-13, 0.33976174388722857334, 0.74051746866188494778, -9.6325874921265635038E-06, -9.9047507009538666534E-13, -0.33976174388722857334, -0.74051746866188494778, -1,
		0, 9.6325874921265618097E-06, 9.9047507009538666534E-13, 0.33976170928518578673, 0.99999993079912896654, -9.6325874921265618097E-06, -9.9047507009538666534E-13, -0.33976170928518578673, -0.99999993079912896654, -1,
		0, 9.6325874921265618097E-06, 9.9047507009538666534E-13, 0.59924424399025599808, -0.037929919062300754273, -9.6325874921265618097E-06, -9.9047507009538666534E-13, -0.59924424399025599808, 0.037929919062300754273, -1,
		0, 9.6325874921265635038E-06, 9.9047507009538666534E-13, 0.59924424530109998699, 0.22155255205316573552, -9.6325874921265635038E-06, -9.9047507009538666534E-13, -0.59924424530109998699, -0.22155255205316573552, -1,
		0, 9.6325874921265618097E-06, 9.9047507009538666534E-13, 0.59924423464098153236, 0.48103502316863222532, -9.6325874921265618097E-06, -9.9047507009538666534E-13, -0.59924423464098153236, -0.48103502316863222532, -1,
		0, 9.6325874921265635038E-06, 9.9047507009538666534E-13, 0.59924421200990063419, 0.74051749428409852083, -9.6325874921265635038E-06, -9.9047507009538666534E-13, -0.59924421200990063419, -0.74051749428409852083, -1,
		0, 9.6325874921265618097E-06, 9.9047507009538666534E-13, 0.59924417740785740349, 0.99999996539956426123, -9.6325874921265618097E-06, -9.9047507009538666534E-13, -0.59924417740785740349, -0.99999996539956426123, -1,
		0, 9.6325874921265618097E-06, 9.9047507009538666534E-13, 0.85872672408389083554, -0.037929920374752491841, -9.6325874921265618097E-06, -9.9047507009538666534E-13, -0.85872672408389083554, 0.037929920374752491841, -1,
		0, 9.6325874921265635038E-06, 9.9047507009538666534E-13, 0.85872672539473504649, 0.22155255971893586531, -9.6325874921265635038E-06, -9.9047507009538666534E-13, -0.85872672539473504649, -0.22155255971893586531, -1,
		0, 9.6325874921265618097E-06, 9.9047507009538666534E-13, 0.8587267147346162588, 0.48103503981262424327, -9.6325874921265618097E-06, -9.9047507009538666534E-13, -0.8587267147346162588, -0.48103503981262424327, -1,
		0, 9.6325874921265635038E-06, 9.9047507009538666534E-13, 0.85872669210353536062, 0.74051751990631231592, -9.6325874921265635038E-06, -9.9047507009538666534E-13, -0.85872669210353536062, -0.74051751990631231592, -1,
		0, 9.6325874921265618097E-06, 9.9047507009538666534E-13, 0.85872665750149179686, 1, -9.6325874921265618097E-06, -9.9047507009538666534E-13, -0.85872665750149179686, -1, -1,
		0, 6.6769256261683503087E-06, 0.0026272546798024962872, -0.17920312446487479674, -0.037929915124945541571, -6.6769256261683503087E-06, -0.0026272546798024962872, 0.17920312446487479674, 0.037929915124945541571, -1,
		0, 6.6769256261683494617E-06, 0.0026272546798024962872, -0.17920312315403094661, 0.22155252905585606782, -6.6769256261683494617E-06, -0.0026272546798024962872, 0.17920312315403094661, -0.22155252905585606782, -1,
		0, 6.6769256261683503087E-06, 0.0026272546798024962872, -0.17920313381414906817, 0.48103497323665772578, -6.6769256261683503087E-06, -0.0026272546798024962872, 0.17920313381414906817, -0.48103497323665772578, -1,
		0, 6.6769256261683503087E-06, 0.0026272546798024962872, -0.17920315644522918919, 0.74051741741745902292, -6.6769256261683503087E-06, -0.0026272546798024962872, 0.17920315644522918919, -0.74051741741745902292, -1,
		0, 6.6769256261683494617E-06, 0.0026272546798024962872, -0.1792031910472712819, 0.99999986159825993148, -6.6769256261683494617E-06, -0.0026272546798024962872, 0.1792031910472712819, -0.99999986159825993148, -1,
		0, 6.6769256261683503087E-06, 0.0026272546798024962872, 0.080279319715873362351, -0.037929916437397251383, -6.6769256261683503087E-06, -0.0026272546798024962872, -0.080279319715873362351, 0.037929916437397251383, -1,
		0, 6.6769256261683494617E-06, 0.0026272546798024962872, 0.080279321026717254117, 0.22155253672162586454, -6.6769256261683494617E-06, -0.0026272546798024962872, -0.080279321026717254117, -0.22155253672162586454, -1,
		0, 6.6769256261683503087E-06, 0.0026272546798024962872, 0.080279310366599021531, 0.48103498988064902209, -6.6769256261683503087E-06, -0.0026272546798024962872, -0.080279310366599021531, -0.48103498988064902209, -1,
		0, 6.6769256261683503087E-06, 0.0026272546798024962872, 0.08027928773551867847, 0.74051744303967181882, -6.6769256261683503087E-06, -0.0026272546798024962872, -0.08027928773551867847, -0.74051744303967181882, -1,
		0, 6.6769256261683494617E-06, 0.0026272546798024962872, 0.080279253133476211057, 0.99999989619869433799, -6.6769256261683494617E-06, -0.0026272546798024962872, -0.080279253133476211057, -0.99999989619869433799, -1,
		0, 6.6769256261683503087E-06, 0.0026272546798024962872, 0.33976177586758354865, -0.037929917749849009767, -6.6769256261683503087E-06, -0.0026272546798024962872, -0.33976177586758354865, 0.037929917749849009767, -1,
		0, 6.6769256261683494617E-06, 0.0026272546798024962872, 0.33976177717842742654, 0.22155254438739574452, -6.6769256261683494617E-06, -0.0026272546798024962872, -0.33976177717842742654, -0.22155254438739574452, -1,
		0, 6.6769256261683503087E-06, 0.0026272546798024962872, 0.33976176651830913844, 0.48103500652464048493, -6.6769256261683503087E-06, -0.0026272546798024962872, -0.33976176651830913844, -0.48103500652464048493, -1,
		0, 6.6769256261683503087E-06, 0.0026272546798024962872, 0.33976174388722851782, 0.74051746866188494778, -6.6769256261683503087E-06, -0.0026272546798024962872, -0.33976174388722851782, -0.74051746866188494778, -1,
		0, 6.6769256261683494617E-06, 0.0026272546798024962872, 0.33976170928518573122, 0.99999993079912896654, -6.6769256261683494617E-06, -0.0026272546798024962872, -0.33976170928518573122, -0.99999993079912896654, -1,
		0, 6.6769256261683503087E-06, 0.0026272546798024962872, 0.59924424399025599808, -0.037929919062300754273, -6.6769256261683503087E-06, -0.0026272546798024962872, -0.59924424399025599808, 0.037929919062300754273, -1,
		0, 6.6769256261683503087E-06, 0.0026272546798024962872, 0.59924424530109998699, 0.22155255205316573552, -6.6769256261683503087E-06, -0.0026272546798024962872, -0.59924424530109998699, -0.22155255205316573552, -1,
		0, 6.6769256261683503087E-06, 0.0026272546798024962872, 0.59924423464098153236, 0.48103502316863222532, -6.6769256261683503087E-06, -0.0026272546798024962872, -0.59924423464098153236, -0.48103502316863222532, -1,
		0, 6.6769256261683503087E-06, 0.0026272546798024962872, 0.59924421200990063419, 0.74051749428409852083, -6.6769256261683503087E-06, -0.0026272546798024962872, -0.59924421200990063419, -0.74051749428409852083, -1,
		0, 6.6769256261683503087E-06, 0.0026272546798024962872, 0.59924417740785740349, 0.99999996539956426123, -6.6769256261683503087E-06, -0.0026272546798024962872, -0.59924417740785740349, -0.99999996539956426123, -1,
		0, 6.6769256261683511557E-06, 0.0026272546798024962872, 0.85872672408389083554, -0.037929920374752491841, -6.6769256261683511557E-06, -0.0026272546798024962872, -0.85872672408389083554, 0.037929920374752491841, -1,
		0, 6.6769256261683503087E-06, 0.0026272546798024962872, 0.85872672539473482445, 0.22155255971893586531, -6.6769256261683503087E-06, -0.0026272546798024962872, -0.85872672539473482445, -0.22155255971893586531, -1,
		0, 6.6769256261683511557E-06, 0.0026272546798024962872, 0.8587267147346162588, 0.48103503981262424327, -6.6769256261683511557E-06, -0.0026272546798024962872, -0.8587267147346162588, -0.48103503981262424327, -1,
		0, 6.6769256261683503087E-06, 0.0026272546798024962872, 0.85872669210353513858, 0.74051751990631231592, -6.6769256261683503087E-06, -0.0026272546798024962872, -0.85872669210353513858, -0.74051751990631231592, -1,
		0, 6.6769256261683503087E-06, 0.0026272546798024962872, 0.85872665750149157482, 1, -6.6769256261683503087E-06, -0.0026272546798024962872, -0.85872665750149157482, -1, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, -0.1792031244648748245, -0.037929915124945527694, -6.6769258023395041185E-06, -0.0019704410100994909812, 0.1792031244648748245, 0.037929915124945527694, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, -0.17920312315403097436, 0.22155252905585606782, -6.6769258023395041185E-06, -0.0019704410100994909812, 0.17920312315403097436, -0.22155252905585606782, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, -0.17920313381414909593, 0.48103497323665767027, -6.6769258023395041185E-06, -0.0019704410100994909812, 0.17920313381414909593, -0.48103497323665767027, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, -0.17920315644522921694, 0.74051741741745902292, -6.6769258023395041185E-06, -0.0019704410100994909812, 0.17920315644522921694, -0.74051741741745902292, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, -0.17920319104727130965, 0.99999986159825993148, -6.6769258023395041185E-06, -0.0019704410100994909812, 0.17920319104727130965, -0.99999986159825993148, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, 0.080279319715873348473, -0.037929916437397251383, -6.6769258023395041185E-06, -0.0019704410100994909812, -0.080279319715873348473, 0.037929916437397251383, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, 0.080279321026717254117, 0.22155253672162589229, -6.6769258023395041185E-06, -0.0019704410100994909812, -0.080279321026717254117, -0.22155253672162589229, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, 0.080279310366599007653, 0.48103498988064902209, -6.6769258023395041185E-06, -0.0019704410100994909812, -0.080279310366599007653, -0.48103498988064902209, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, 0.080279287735518664593, 0.74051744303967181882, -6.6769258023395041185E-06, -0.0019704410100994909812, -0.080279287735518664593, -0.74051744303967181882, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, 0.08027925313347619718, 0.99999989619869433799, -6.6769258023395041185E-06, -0.0019704410100994909812, -0.08027925313347619718, -0.99999989619869433799, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, 0.33976177586758360416, -0.037929917749848982012, -6.6769258023395041185E-06, -0.0019704410100994909812, -0.33976177586758360416, 0.037929917749848982012, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, 0.33976177717842742654, 0.22155254438739574452, -6.6769258023395041185E-06, -0.0019704410100994909812, -0.33976177717842742654, -0.22155254438739574452, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, 0.33976176651830913844, 0.48103500652464048493, -6.6769258023395041185E-06, -0.0019704410100994909812, -0.33976176651830913844, -0.48103500652464048493, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, 0.33976174388722851782, 0.74051746866188494778, -6.6769258023395041185E-06, -0.0019704410100994909812, -0.33976174388722851782, -0.74051746866188494778, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, 0.33976170928518567571, 0.99999993079912896654, -6.6769258023395041185E-06, -0.0019704410100994909812, -0.33976170928518567571, -0.99999993079912896654, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, 0.59924424399025599808, -0.037929919062300754273, -6.6769258023395041185E-06, -0.0019704410100994909812, -0.59924424399025599808, 0.037929919062300754273, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, 0.59924424530109998699, 0.22155255205316573552, -6.6769258023395041185E-06, -0.0019704410100994909812, -0.59924424530109998699, -0.22155255205316573552, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, 0.59924423464098153236, 0.48103502316863222532, -6.6769258023395041185E-06, -0.0019704410100994909812, -0.59924423464098153236, -0.48103502316863222532, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, 0.59924421200990063419, 0.74051749428409852083, -6.6769258023395041185E-06, -0.0019704410100994909812, -0.59924421200990063419, -0.74051749428409852083, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, 0.59924417740785740349, 0.99999996539956426123, -6.6769258023395041185E-06, -0.0019704410100994909812, -0.59924417740785740349, -0.99999996539956426123, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, 0.85872672408389083554, -0.037929920374752491841, -6.6769258023395041185E-06, -0.0019704410100994909812, -0.85872672408389083554, 0.037929920374752491841, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, 0.85872672539473482445, 0.22155255971893586531, -6.6769258023395041185E-06, -0.0019704410100994909812, -0.85872672539473482445, -0.22155255971893586531, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, 0.8587267147346162588, 0.48103503981262424327, -6.6769258023395041185E-06, -0.0019704410100994909812, -0.8587267147346162588, -0.48103503981262424327, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, 0.85872669210353513858, 0.74051751990631231592, -6.6769258023395041185E-06, -0.0019704410100994909812, -0.85872669210353513858, -0.74051751990631231592, -1,
		0, 6.6769258023395041185E-06, 0.0019704410100994909812, 0.85872665750149157482, 1, -6.6769258023395041185E-06, -0.0019704410100994909812, -0.85872665750149157482, -1, -1,
		0, 6.676925919786939427E-06, 0.0013136273403964854583, -0.1792031244648748245, -0.037929915124945527694, -6.676925919786939427E-06, -0.0013136273403964854583, 0.1792031244648748245, 0.037929915124945527694, -1,
		0, 6.6769259197869402741E-06, 0.0013136273403964854583, -0.17920312315403097436, 0.22155252905585606782, -6.6769259197869402741E-06, -0.0013136273403964854583, 0.17920312315403097436, -0.22155252905585606782, -1,
		0, 6.6769259197869402741E-06, 0.0013136273403964854583, -0.17920313381414909593, 0.48103497323665767027, -6.6769259197869402741E-06, -0.0013136273403964854583, 0.17920313381414909593, -0.48103497323665767027, -1,
		0, 6.6769259197869402741E-06, 0.0013136273403964854583, -0.17920315644522921694, 0.74051741741745902292, -6.6769259197869402741E-06, -0.0013136273403964854583, 0.17920315644522921694, -0.74051741741745902292, -1,
		0, 6.6769259197869402741E-06, 0.0013136273403964854583, -0.17920319104727130965, 0.99999986159825993148, -6.6769259197869402741E-06, -0.0013136273403964854583, 0.17920319104727130965, -0.99999986159825993148, -1,
		0, 6.676925919786939427E-06, 0.0013136273403964854583, 0.080279319715873348473, -0.037929916437397251383, -6.676925919786939427E-06, -0.0013136273403964854583, -0.080279319715873348473, 0.037929916437397251383, -1,
		0, 6.6769259197869402741E-06, 0.0013136273403964854583, 0.080279321026717254117, 0.22155253672162589229, -6.6769259197869402741E-06, -0.0013136273403964854583, -0.080279321026717254117, -0.22155253672162589229, -1,
		0, 6.6769259197869402741E-06, 0.0013136273403964854583, 0.080279310366599007653, 0.48103498988064902209, -6.6769259197869402741E-06, -0.0013136273403964854583, -0.080279310366599007653, -0.48103498988064902209, -1,
		0, 6.6769259197869402741E-06, 0.0013136273403964854583, 0.080279287735518664593, 0.74051744303967181882, -6.6769259197869402741E-06, -0.0013136273403964854583, -0.080279287735518664593, -0.74051744303967181882, -1,
		0, 6.6769259197869402741E-06, 0.0013136273403964854583, 0.08027925313347619718, 0.99999989619869433799, -6.6769259197869402741E-06, -0.0013136273403964854583, -0.08027925313347619718, -0.99999989619869433799, -1,
		0, 6.676925919786939427E-06, 0.0013136273403964854583, 0.33976177586758360416, -0.037929917749848982012, -6.676925919786939427E-06, -0.0013136273403964854583, -0.33976177586758360416, 0.037929917749848982012, -1,
		0, 6.6769259197869402741E-06, 0.0013136273403964854583, 0.33976177717842742654, 0.22155254438739574452, -6.6769259197869402741E-06, -0.0013136273403964854583, -0.33976177717842742654, -0.22155254438739574452, -1,
		0, 6.6769259197869402741E-06, 0.0013136273403964854583, 0.33976176651830913844, 0.48103500652464048493, -6.6769259197869402741E-06, -0.0013136273403964854583, -0.33976176651830913844, -0.48103500652464048493, -1,
		0, 6.6769259197869402741E-06, 0.0013136273403964854583, 0.33976174388722851782, 0.74051746866188494778, -6.6769259197869402741E-06, -0.0013136273403964854583, -0.33976174388722851782, -0.74051746866188494778, -1,
		0, 6.6769259197869402741E-06, 0.0013136273403964854583, 0.33976170928518567571, 0.99999993079912896654, -6.6769259197869402741E-06, -0.0013136273403964854583, -0.33976170928518567571, -0.99999993079912896654, -1,
		0, 6.676925919786939427E-06, 0.0013136273403964854583, 0.59924424399025599808, -0.037929919062300754273, -6.676925919786939427E-06, -0.0013136273403964854583, -0.59924424399025599808, 0.037929919062300754273, -1,
		0, 6.6769259197869402741E-06, 0.0013136273403964854583, 0.59924424530109998699, 0.22155255205316573552, -6.6769259197869402741E-06, -0.0013136273403964854583, -0.59924424530109998699, -0.22155255205316573552, -1,
		0, 6.6769259197869402741E-06, 0.0013136273403964854583, 0.59924423464098153236, 0.48103502316863222532, -6.6769259197869402741E-06, -0.0013136273403964854583, -0.59924423464098153236, -0.48103502316863222532, -1,
		0, 6.6769259197869402741E-06, 0.0013136273403964854583, 0.59924421200990063419, 0.74051749428409852083, -6.6769259197869402741E-06, -0.0013136273403964854583, -0.59924421200990063419, -0.74051749428409852083, -1,
		0, 6.6769259197869402741E-06, 0.0013136273403964854583, 0.59924417740785740349, 0.99999996539956426123, -6.6769259197869402741E-06, -0.0013136273403964854583, -0.59924417740785740349, -0.99999996539956426123, -1,
		0, 6.676925919786939427E-06, 0.0013136273403964854583, 0.85872672408389083554, -0.037929920374752491841, -6.676925919786939427E-06, -0.0013136273403964854583, -0.85872672408389083554, 0.037929920374752491841, -1,
		0, 6.676925919786939427E-06, 0.0013136273403964854583, 0.85872672539473482445, 0.22155255971893586531, -6.676925919786939427E-06, -0.0013136273403964854583, -0.85872672539473482445, -0.22155255971893586531, -1,
		0, 6.676925919786939427E-06, 0.0013136273403964854583, 0.8587267147346162588, 0.48103503981262424327, -6.676925919786939427E-06, -0.0013136273403964854583, -0.8587267147346162588, -0.48103503981262424327, -1,
		0, 6.676925919786939427E-06, 0.0013136273403964854583, 0.85872669210353513858, 0.74051751990631231592, -6.676925919786939427E-06, -0.0013136273403964854583, -0.85872669210353513858, -0.74051751990631231592, -1,
		0, 6.676925919786939427E-06, 0.0013136273403964854583, 0.85872665750149157482, 1, -6.676925919786939427E-06, -0.0013136273403964854583, -0.85872665750149157482, -1, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348015227, -0.1792031244648748245, -0.037929915124945527694, -6.6769259785106587754E-06, -0.00065681367069348015227, 0.1792031244648748245, 0.037929915124945527694, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348026069, -0.17920312315403097436, 0.22155252905585606782, -6.6769259785106587754E-06, -0.00065681367069348026069, 0.17920312315403097436, -0.22155252905585606782, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348026069, -0.17920313381414909593, 0.48103497323665767027, -6.6769259785106587754E-06, -0.00065681367069348026069, 0.17920313381414909593, -0.48103497323665767027, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348026069, -0.17920315644522921694, 0.74051741741745902292, -6.6769259785106587754E-06, -0.00065681367069348026069, 0.17920315644522921694, -0.74051741741745902292, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348026069, -0.17920319104727130965, 0.99999986159825993148, -6.6769259785106587754E-06, -0.00065681367069348026069, 0.17920319104727130965, -0.99999986159825993148, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348015227, 0.080279319715873348473, -0.037929916437397251383, -6.6769259785106587754E-06, -0.00065681367069348015227, -0.080279319715873348473, 0.037929916437397251383, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348026069, 0.080279321026717254117, 0.22155253672162589229, -6.6769259785106587754E-06, -0.00065681367069348026069, -0.080279321026717254117, -0.22155253672162589229, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348026069, 0.080279310366599007653, 0.48103498988064902209, -6.6769259785106587754E-06, -0.00065681367069348026069, -0.080279310366599007653, -0.48103498988064902209, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348026069, 0.080279287735518664593, 0.74051744303967181882, -6.6769259785106587754E-06, -0.00065681367069348026069, -0.080279287735518664593, -0.74051744303967181882, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348026069, 0.08027925313347619718, 0.99999989619869433799, -6.6769259785106587754E-06, -0.00065681367069348026069, -0.08027925313347619718, -0.99999989619869433799, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348015227, 0.33976177586758360416, -0.037929917749848982012, -6.6769259785106587754E-06, -0.00065681367069348015227, -0.33976177586758360416, 0.037929917749848982012, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348026069, 0.33976177717842742654, 0.22155254438739574452, -6.6769259785106587754E-06, -0.00065681367069348026069, -0.33976177717842742654, -0.22155254438739574452, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348026069, 0.33976176651830913844, 0.48103500652464048493, -6.6769259785106587754E-06, -0.00065681367069348026069, -0.33976176651830913844, -0.48103500652464048493, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348026069, 0.33976174388722851782, 0.74051746866188494778, -6.6769259785106587754E-06, -0.00065681367069348026069, -0.33976174388722851782, -0.74051746866188494778, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348026069, 0.33976170928518567571, 0.99999993079912896654, -6.6769259785106587754E-06, -0.00065681367069348026069, -0.33976170928518567571, -0.99999993079912896654, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348015227, 0.59924424399025599808, -0.037929919062300754273, -6.6769259785106587754E-06, -0.00065681367069348015227, -0.59924424399025599808, 0.037929919062300754273, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348026069, 0.59924424530109998699, 0.22155255205316573552, -6.6769259785106587754E-06, -0.00065681367069348026069, -0.59924424530109998699, -0.22155255205316573552, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348026069, 0.59924423464098153236, 0.48103502316863222532, -6.6769259785106587754E-06, -0.00065681367069348026069, -0.59924423464098153236, -0.48103502316863222532, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348026069, 0.59924421200990063419, 0.74051749428409852083, -6.6769259785106587754E-06, -0.00065681367069348026069, -0.59924421200990063419, -0.74051749428409852083, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348026069, 0.59924417740785740349, 0.99999996539956426123, -6.6769259785106587754E-06, -0.00065681367069348026069, -0.59924417740785740349, -0.99999996539956426123, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348015227, 0.85872672408389083554, -0.037929920374752491841, -6.6769259785106587754E-06, -0.00065681367069348015227, -0.85872672408389083554, 0.037929920374752491841, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348015227, 0.85872672539473482445, 0.22155255971893586531, -6.6769259785106587754E-06, -0.00065681367069348015227, -0.85872672539473482445, -0.22155255971893586531, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348015227, 0.8587267147346162588, 0.48103503981262424327, -6.6769259785106587754E-06, -0.00065681367069348015227, -0.8587267147346162588, -0.48103503981262424327, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348015227, 0.85872669210353513858, 0.74051751990631231592, -6.6769259785106587754E-06, -0.00065681367069348015227, -0.85872669210353513858, -0.74051751990631231592, -1,
		0, 6.6769259785106587754E-06, 0.00065681367069348015227, 0.85872665750149157482, 1, -6.6769259785106587754E-06, -0.00065681367069348015227, -0.85872665750149157482, -1, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342296292E-13, -0.1792031244648748245, -0.037929915124945527694, -6.6769259785106587754E-06, -9.9047507253342296292E-13, 0.1792031244648748245, 0.037929915124945527694, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342276097E-13, -0.17920312315403097436, 0.22155252905585606782, -6.6769259785106587754E-06, -9.9047507253342276097E-13, 0.17920312315403097436, -0.22155252905585606782, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342276097E-13, -0.17920313381414909593, 0.48103497323665767027, -6.6769259785106587754E-06, -9.9047507253342276097E-13, 0.17920313381414909593, -0.48103497323665767027, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342276097E-13, -0.17920315644522921694, 0.74051741741745902292, -6.6769259785106587754E-06, -9.9047507253342276097E-13, 0.17920315644522921694, -0.74051741741745902292, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342255902E-13, -0.17920319104727130965, 0.99999986159825993148, -6.6769259785106587754E-06, -9.9047507253342255902E-13, 0.17920319104727130965, -0.99999986159825993148, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342296292E-13, 0.080279319715873348473, -0.037929916437397251383, -6.6769259785106587754E-06, -9.9047507253342296292E-13, -0.080279319715873348473, 0.037929916437397251383, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342276097E-13, 0.080279321026717254117, 0.22155253672162589229, -6.6769259785106587754E-06, -9.9047507253342276097E-13, -0.080279321026717254117, -0.22155253672162589229, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342276097E-13, 0.080279310366599007653, 0.48103498988064902209, -6.6769259785106587754E-06, -9.9047507253342276097E-13, -0.080279310366599007653, -0.48103498988064902209, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342276097E-13, 0.080279287735518664593, 0.74051744303967181882, -6.6769259785106587754E-06, -9.9047507253342276097E-13, -0.080279287735518664593, -0.74051744303967181882, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342255902E-13, 0.08027925313347619718, 0.99999989619869433799, -6.6769259785106587754E-06, -9.9047507253342255902E-13, -0.08027925313347619718, -0.99999989619869433799, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342296292E-13, 0.33976177586758360416, -0.037929917749848982012, -6.6769259785106587754E-06, -9.9047507253342296292E-13, -0.33976177586758360416, 0.037929917749848982012, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342276097E-13, 0.33976177717842742654, 0.22155254438739574452, -6.6769259785106587754E-06, -9.9047507253342276097E-13, -0.33976177717842742654, -0.22155254438739574452, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342276097E-13, 0.33976176651830913844, 0.48103500652464048493, -6.6769259785106587754E-06, -9.9047507253342276097E-13, -0.33976176651830913844, -0.48103500652464048493, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342276097E-13, 0.33976174388722851782, 0.74051746866188494778, -6.6769259785106587754E-06, -9.9047507253342276097E-13, -0.33976174388722851782, -0.74051746866188494778, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342255902E-13, 0.33976170928518567571, 0.99999993079912896654, -6.6769259785106587754E-06, -9.9047507253342255902E-13, -0.33976170928518567571, -0.99999993079912896654, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342296292E-13, 0.59924424399025599808, -0.037929919062300754273, -6.6769259785106587754E-06, -9.9047507253342296292E-13, -0.59924424399025599808, 0.037929919062300754273, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342276097E-13, 0.59924424530109998699, 0.22155255205316573552, -6.6769259785106587754E-06, -9.9047507253342276097E-13, -0.59924424530109998699, -0.22155255205316573552, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342276097E-13, 0.59924423464098153236, 0.48103502316863222532, -6.6769259785106587754E-06, -9.9047507253342276097E-13, -0.59924423464098153236, -0.48103502316863222532, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342276097E-13, 0.59924421200990063419, 0.74051749428409852083, -6.6769259785106587754E-06, -9.9047507253342276097E-13, -0.59924421200990063419, -0.74051749428409852083, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342255902E-13, 0.59924417740785740349, 0.99999996539956426123, -6.6769259785106587754E-06, -9.9047507253342255902E-13, -0.59924417740785740349, -0.99999996539956426123, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342296292E-13, 0.85872672408389083554, -0.037929920374752491841, -6.6769259785106587754E-06, -9.9047507253342296292E-13, -0.85872672408389083554, 0.037929920374752491841, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342296292E-13, 0.85872672539473482445, 0.22155255971893586531, -6.6769259785106587754E-06, -9.9047507253342296292E-13, -0.85872672539473482445, -0.22155255971893586531, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342276097E-13, 0.8587267147346162588, 0.48103503981262424327, -6.6769259785106587754E-06, -9.9047507253342276097E-13, -0.8587267147346162588, -0.48103503981262424327, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342276097E-13, 0.85872669210353513858, 0.74051751990631231592, -6.6769259785106587754E-06, -9.9047507253342276097E-13, -0.85872669210353513858, -0.74051751990631231592, -1,
		0, 6.6769259785106587754E-06, 9.9047507253342255902E-13, 0.85872665750149157482, 1, -6.6769259785106587754E-06, -9.9047507253342255902E-13, -0.85872665750149157482, -1, -1,
		0, 3.721264112553633544E-06, 0.0026272546798017043859, -0.1792031244648748245, -0.037929915124945541571, -3.721264112553633544E-06, -0.0026272546798017043859, 0.1792031244648748245, 0.037929915124945541571, -1,
		0, 3.7212641125536331205E-06, 0.0026272546798017043859, -0.17920312315403097436, 0.22155252905585606782, -3.7212641125536331205E-06, -0.0026272546798017043859, 0.17920312315403097436, -0.22155252905585606782, -1,
		0, 3.721264112553633544E-06, 0.0026272546798017043859, -0.17920313381414906817, 0.48103497323665772578, -3.721264112553633544E-06, -0.0026272546798017043859, 0.17920313381414906817, -0.48103497323665772578, -1,
		0, 3.721264112553633544E-06, 0.0026272546798017043859, -0.17920315644522918919, 0.74051741741745902292, -3.721264112553633544E-06, -0.0026272546798017043859, 0.17920315644522918919, -0.74051741741745902292, -1,
		0, 3.721264112553633544E-06, 0.0026272546798017043859, -0.1792031910472712819, 0.99999986159825993148, -3.721264112553633544E-06, -0.0026272546798017043859, 0.1792031910472712819, -0.99999986159825993148, -1,
		0, 3.7212641125536339675E-06, 0.0026272546798017043859, 0.080279319715873334595, -0.037929916437397251383, -3.7212641125536339675E-06, -0.0026272546798017043859, -0.080279319715873334595, 0.037929916437397251383, -1,
		0, 3.721264112553633544E-06, 0.0026272546798017043859, 0.080279321026717226362, 0.22155253672162586454, -3.721264112553633544E-06, -0.0026272546798017043859, -0.080279321026717226362, -0.22155253672162586454, -1,
		0, 3.721264112553633544E-06, 0.0026272546798017043859, 0.080279310366598993776, 0.48103498988064902209, -3.721264112553633544E-06, -0.0026272546798017043859, -0.080279310366598993776, -0.48103498988064902209, -1,
		0, 3.721264112553633544E-06, 0.0026272546798017043859, 0.080279287735518650715, 0.74051744303967181882, -3.721264112553633544E-06, -0.0026272546798017043859, -0.080279287735518650715, -0.74051744303967181882, -1,
		0, 3.721264112553633544E-06, 0.0026272546798017043859, 0.080279253133476183302, 0.99999989619869433799, -3.721264112553633544E-06, -0.0026272546798017043859, -0.080279253133476183302, -0.99999989619869433799, -1,
		0, 3.7212641125536339675E-06, 0.0026272546798017043859, 0.33976177586758354865, -0.037929917749849009767, -3.7212641125536339675E-06, -0.0026272546798017043859, -0.33976177586758354865, 0.037929917749849009767, -1,
		0, 3.721264112553633544E-06, 0.0026272546798017043859, 0.33976177717842742654, 0.22155254438739574452, -3.721264112553633544E-06, -0.0026272546798017043859, -0.33976177717842742654, -0.22155254438739574452, -1,
		0, 3.7212641125536339675E-06, 0.0026272546798017043859, 0.33976176651830902742, 0.48103500652464048493, -3.7212641125536339675E-06, -0.0026272546798017043859, -0.33976176651830902742, -0.48103500652464048493, -1,
		0, 3.7212641125536339675E-06, 0.0026272546798017043859, 0.33976174388722851782, 0.74051746866188494778, -3.7212641125536339675E-06, -0.0026272546798017043859, -0.33976174388722851782, -0.74051746866188494778, -1,
		0, 3.7212641125536339675E-06, 0.0026272546798017043859, 0.33976170928518567571, 0.99999993079912896654, -3.7212641125536339675E-06, -0.0026272546798017043859, -0.33976170928518567571, -0.99999993079912896654, -1,
		0, 3.7212641125536339675E-06, 0.0026272546798017043859, 0.59924424399025599808, -0.037929919062300754273, -3.7212641125536339675E-06, -0.0026272546798017043859, -0.59924424399025599808, 0.037929919062300754273, -1,
		0, 3.7212641125536339675E-06, 0.0026272546798017043859, 0.59924424530109987597, 0.22155255205316573552, -3.7212641125536339675E-06, -0.0026272546798017043859, -0.59924424530109987597, -0.22155255205316573552, -1,
		0, 3.721264112553633544E-06, 0.0026272546798017043859, 0.59924423464098142134, 0.48103502316863222532, -3.721264112553633544E-06, -0.0026272546798017043859, -0.59924423464098142134, -0.48103502316863222532, -1,
		0, 3.7212641125536339675E-06, 0.0026272546798017043859, 0.59924421200990052316, 0.74051749428409852083, -3.7212641125536339675E-06, -0.0026272546798017043859, -0.59924421200990052316, -0.74051749428409852083, -1,
		0, 3.721264112553633544E-06, 0.0026272546798017043859, 0.59924417740785729247, 0.99999996539956426123, -3.721264112553633544E-06, -0.0026272546798017043859, -0.59924417740785729247, -0.99999996539956426123, -1,
		0, 3.7212641125536343911E-06, 0.0026272546798017043859, 0.85872672408389083554, -0.037929920374752491841, -3.7212641125536343911E-06, -0.0026272546798017043859, -0.85872672408389083554, 0.037929920374752491841, -1,
		0, 3.7212641125536339675E-06, 0.0026272546798017043859, 0.85872672539473482445, 0.22155255971893586531, -3.7212641125536339675E-06, -0.0026272546798017043859, -0.85872672539473482445, -0.22155255971893586531, -1,
		0, 3.7212641125536343911E-06, 0.0026272546798017043859, 0.8587267147346162588, 0.48103503981262424327, -3.7212641125536343911E-06, -0.0026272546798017043859, -0.8587267147346162588, -0.48103503981262424327, -1,
		0, 3.7212641125536343911E-06, 0.0026272546798017043859, 0.85872669210353513858, 0.74051751990631231592, -3.7212641125536343911E-06, -0.0026272546798017043859, -0.85872669210353513858, -0.74051751990631231592, -1,
		0, 3.7212641125536339675E-06, 0.0026272546798017043859, 0.85872665750149157482, 1, -3.7212641125536339675E-06, -0.0026272546798017043859, -0.85872665750149157482, -1, -1,
		0, 3.7212642887247877774E-06, 0.0019704410100988964047, -0.17920312446487488001, -0.037929915124945527694, -3.7212642887247877774E-06, -0.0019704410100988964047, 0.17920312446487488001, 0.037929915124945527694, -1,
		0, 3.7212642887247877774E-06, 0.0019704410100988964047, -0.17920312315403097436, 0.22155252905585606782, -3.7212642887247877774E-06, -0.0019704410100988964047, 0.17920312315403097436, -0.22155252905585606782, -1,
		0, 3.7212642887247873539E-06, 0.0019704410100988964047, -0.17920313381414909593, 0.48103497323665767027, -3.7212642887247873539E-06, -0.0019704410100988964047, 0.17920313381414909593, -0.48103497323665767027, -1,
		0, 3.7212642887247877774E-06, 0.0019704410100988964047, -0.17920315644522921694, 0.74051741741745902292, -3.7212642887247877774E-06, -0.0019704410100988964047, 0.17920315644522921694, -0.74051741741745902292, -1,
		0, 3.7212642887247873539E-06, 0.0019704410100988964047, -0.17920319104727130965, 0.99999986159825993148, -3.7212642887247873539E-06, -0.0019704410100988964047, 0.17920319104727130965, -0.99999986159825993148, -1,
		0, 3.7212642887247877774E-06, 0.0019704410100988964047, 0.080279319715873320717, -0.037929916437397251383, -3.7212642887247877774E-06, -0.0019704410100988964047, -0.080279319715873320717, 0.037929916437397251383, -1,
		0, 3.7212642887247877774E-06, 0.0019704410100988964047, 0.080279321026717198606, 0.22155253672162589229, -3.7212642887247877774E-06, -0.0019704410100988964047, -0.080279321026717198606, -0.22155253672162589229, -1,
		0, 3.7212642887247873539E-06, 0.0019704410100988964047, 0.080279310366598979898, 0.48103498988064902209, -3.7212642887247873539E-06, -0.0019704410100988964047, -0.080279310366598979898, -0.48103498988064902209, -1,
		0, 3.7212642887247877774E-06, 0.0019704410100988964047, 0.080279287735518636837, 0.74051744303967181882, -3.7212642887247877774E-06, -0.0019704410100988964047, -0.080279287735518636837, -0.74051744303967181882, -1,
		0, 3.7212642887247873539E-06, 0.0019704410100988964047, 0.080279253133476169424, 0.99999989619869433799, -3.7212642887247873539E-06, -0.0019704410100988964047, -0.080279253133476169424, -0.99999989619869433799, -1,
		0, 3.7212642887247882009E-06, 0.0019704410100988964047, 0.33976177586758354865, -0.037929917749848982012, -3.7212642887247882009E-06, -0.0019704410100988964047, -0.33976177586758354865, 0.037929917749848982012, -1,
		0, 3.7212642887247877774E-06, 0.0019704410100988964047, 0.33976177717842742654, 0.22155254438739574452, -3.7212642887247877774E-06, -0.0019704410100988964047, -0.33976177717842742654, -0.22155254438739574452, -1,
		0, 3.7212642887247882009E-06, 0.0019704410100988964047, 0.33976176651830902742, 0.48103500652464048493, -3.7212642887247882009E-06, -0.0019704410100988964047, -0.33976176651830902742, -0.48103500652464048493, -1,
		0, 3.7212642887247882009E-06, 0.0019704410100988964047, 0.33976174388722851782, 0.74051746866188494778, -3.7212642887247882009E-06, -0.0019704410100988964047, -0.33976174388722851782, -0.74051746866188494778, -1,
		0, 3.7212642887247877774E-06, 0.0019704410100988964047, 0.33976170928518567571, 0.99999993079912896654, -3.7212642887247877774E-06, -0.0019704410100988964047, -0.33976170928518567571, -0.99999993079912896654, -1,
		0, 3.7212642887247882009E-06, 0.0019704410100988964047, 0.59924424399025599808, -0.037929919062300754273, -3.7212642887247882009E-06, -0.0019704410100988964047, -0.59924424399025599808, 0.037929919062300754273, -1,
		0, 3.7212642887247882009E-06, 0.0019704410100988964047, 0.59924424530109987597, 0.22155255205316573552, -3.7212642887247882009E-06, -0.0019704410100988964047, -0.59924424530109987597, -0.22155255205316573552, -1,
		0, 3.7212642887247886244E-06, 0.0019704410100988964047, 0.59924423464098142134, 0.48103502316863222532, -3.7212642887247886244E-06, -0.0019704410100988964047, -0.59924423464098142134, -0.48103502316863222532, -1,
		0, 3.7212642887247882009E-06, 0.0019704410100988964047, 0.59924421200990052316, 0.74051749428409852083, -3.7212642887247882009E-06, -0.0019704410100988964047, -0.59924421200990052316, -0.74051749428409852083, -1,
		0, 3.7212642887247882009E-06, 0.0019704410100988964047, 0.59924417740785729247, 0.99999996539956426123, -3.7212642887247882009E-06, -0.0019704410100988964047, -0.59924417740785729247, -0.99999996539956426123, -1,
		0, 3.7212642887247882009E-06, 0.0019704410100988964047, 0.85872672408389083554, -0.037929920374752491841, -3.7212642887247882009E-06, -0.0019704410100988964047, -0.85872672408389083554, 0.037929920374752491841, -1,
		0, 3.7212642887247882009E-06, 0.0019704410100988964047, 0.85872672539473482445, 0.22155255971893586531, -3.7212642887247882009E-06, -0.0019704410100988964047, -0.85872672539473482445, -0.22155255971893586531, -1,
		0, 3.7212642887247886244E-06, 0.0019704410100988964047, 0.8587267147346162588, 0.48103503981262424327, -3.7212642887247886244E-06, -0.0019704410100988964047, -0.8587267147346162588, -0.48103503981262424327, -1,
		0, 3.7212642887247882009E-06, 0.0019704410100988964047, 0.85872669210353513858, 0.74051751990631231592, -3.7212642887247882009E-06, -0.0019704410100988964047, -0.85872669210353513858, -0.74051751990631231592, -1,
		0, 3.7212642887247882009E-06, 0.0019704410100988964047, 0.85872665750149157482, 1, -3.7212642887247882009E-06, -0.0019704410100988964047, -0.85872665750149157482, -1, -1,
		0, 3.72126440617222478E-06, 0.001313627340396089074, -0.17920312446487488001, -0.037929915124945527694, -3.72126440617222478E-06, -0.001313627340396089074, 0.17920312446487488001, 0.037929915124945527694, -1,
		0, 3.7212644061722243564E-06, 0.001313627340396089074, -0.17920312315403097436, 0.22155252905585606782, -3.7212644061722243564E-06, -0.001313627340396089074, 0.17920312315403097436, -0.22155252905585606782, -1,
		0, 3.72126440617222478E-06, 0.001313627340396089074, -0.17920313381414909593, 0.48103497323665767027, -3.72126440617222478E-06, -0.001313627340396089074, 0.17920313381414909593, -0.48103497323665767027, -1,
		0, 3.7212644061722243564E-06, 0.001313627340396089074, -0.17920315644522921694, 0.74051741741745902292, -3.7212644061722243564E-06, -0.001313627340396089074, 0.17920315644522921694, -0.74051741741745902292, -1,
		0, 3.7212644061722239329E-06, 0.001313627340396089074, -0.17920319104727130965, 0.99999986159825993148, -3.7212644061722239329E-06, -0.001313627340396089074, 0.17920319104727130965, -0.99999986159825993148, -1,
		0, 3.72126440617222478E-06, 0.001313627340396089074, 0.080279319715873320717, -0.037929916437397251383, -3.72126440617222478E-06, -0.001313627340396089074, -0.080279319715873320717, 0.037929916437397251383, -1,
		0, 3.7212644061722243564E-06, 0.001313627340396089074, 0.080279321026717198606, 0.22155253672162589229, -3.7212644061722243564E-06, -0.001313627340396089074, -0.080279321026717198606, -0.22155253672162589229, -1,
		0, 3.72126440617222478E-06, 0.001313627340396089074, 0.080279310366598979898, 0.48103498988064902209, -3.72126440617222478E-06, -0.001313627340396089074, -0.080279310366598979898, -0.48103498988064902209, -1,
		0, 3.7212644061722243564E-06, 0.001313627340396089074, 0.080279287735518636837, 0.74051744303967181882, -3.7212644061722243564E-06, -0.001313627340396089074, -0.080279287735518636837, -0.74051744303967181882, -1,
		0, 3.7212644061722239329E-06, 0.001313627340396089074, 0.080279253133476169424, 0.99999989619869433799, -3.7212644061722239329E-06, -0.001313627340396089074, -0.080279253133476169424, -0.99999989619869433799, -1,
		0, 3.72126440617222478E-06, 0.001313627340396089074, 0.33976177586758354865, -0.037929917749848982012, -3.72126440617222478E-06, -0.001313627340396089074, -0.33976177586758354865, 0.037929917749848982012, -1,
		0, 3.7212644061722243564E-06, 0.001313627340396089074, 0.33976177717842742654, 0.22155254438739574452, -3.7212644061722243564E-06, -0.001313627340396089074, -0.33976177717842742654, -0.22155254438739574452, -1,
		0, 3.72126440617222478E-06, 0.001313627340396089074, 0.33976176651830902742, 0.48103500652464048493, -3.72126440617222478E-06, -0.001313627340396089074, -0.33976176651830902742, -0.48103500652464048493, -1,
		0, 3.7212644061722243564E-06, 0.001313627340396089074, 0.33976174388722851782, 0.74051746866188494778, -3.7212644061722243564E-06, -0.001313627340396089074, -0.33976174388722851782, -0.74051746866188494778, -1,
		0, 3.7212644061722239329E-06, 0.001313627340396089074, 0.33976170928518567571, 0.99999993079912896654, -3.7212644061722239329E-06, -0.001313627340396089074, -0.33976170928518567571, -0.99999993079912896654, -1,
		0, 3.72126440617222478E-06, 0.001313627340396089074, 0.59924424399025599808, -0.037929919062300754273, -3.72126440617222478E-06, -0.001313627340396089074, -0.59924424399025599808, 0.037929919062300754273, -1,
		0, 3.7212644061722243564E-06, 0.001313627340396089074, 0.59924424530109987597, 0.22155255205316573552, -3.7212644061722243564E-06, -0.001313627340396089074, -0.59924424530109987597, -0.22155255205316573552, -1,
		0, 3.72126440617222478E-06, 0.001313627340396089074, 0.59924423464098142134, 0.48103502316863222532, -3.72126440617222478E-06, -0.001313627340396089074, -0.59924423464098142134, -0.48103502316863222532, -1,
		0, 3.72126440617222478E-06, 0.001313627340396089074, 0.59924421200990052316, 0.74051749428409852083, -3.72126440617222478E-06, -0.001313627340396089074, -0.59924421200990052316, -0.74051749428409852083, -1,
		0, 3.7212644061722243564E-06, 0.001313627340396089074, 0.59924417740785729247, 0.99999996539956426123, -3.7212644061722243564E-06, -0.001313627340396089074, -0.59924417740785729247, -0.99999996539956426123, -1,
		0, 3.7212644061722252035E-06, 0.001313627340396089074, 0.85872672408389083554, -0.037929920374752491841, -3.7212644061722252035E-06, -0.001313627340396089074, -0.85872672408389083554, 0.037929920374752491841, -1,
		0, 3.7212644061722252035E-06, 0.001313627340396089074, 0.85872672539473482445, 0.22155255971893586531, -3.7212644061722252035E-06, -0.001313627340396089074, -0.85872672539473482445, -0.22155255971893586531, -1,
		0, 3.72126440617222478E-06, 0.001313627340396089074, 0.8587267147346162588, 0.48103503981262424327, -3.72126440617222478E-06, -0.001313627340396089074, -0.8587267147346162588, -0.48103503981262424327, -1,
		0, 3.7212644061722252035E-06, 0.001313627340396089074, 0.85872669210353513858, 0.74051751990631231592, -3.7212644061722252035E-06, -0.001313627340396089074, -0.85872669210353513858, -0.74051751990631231592, -1,
		0, 3.7212644061722243564E-06, 0.001313627340396089074, 0.85872665750149157482, 1, -3.7212644061722243564E-06, -0.001313627340396089074, -0.85872665750149157482, -1, -1,
		0, 3.7212644648959432813E-06, 0.00065681367069328217695, -0.17920312446487488001, -0.037929915124945527694, -3.7212644648959432813E-06, -0.00065681367069328217695, 0.17920312446487488001, 0.037929915124945527694, -1,
		0, 3.7212644648959424342E-06, 0.00065681367069328206853, -0.17920312315403097436, 0.22155252905585606782, -3.7212644648959424342E-06, -0.00065681367069328206853, 0.17920312315403097436, -0.22155252905585606782, -1,
		0, 3.7212644648959428577E-06, 0.00065681367069328206853, -0.17920313381414909593, 0.48103497323665767027, -3.7212644648959428577E-06, -0.00065681367069328206853, 0.17920313381414909593, -0.48103497323665767027, -1,
		0, 3.7212644648959428577E-06, 0.00065681367069328206853, -0.17920315644522921694, 0.74051741741745902292, -3.7212644648959428577E-06, -0.00065681367069328206853, 0.17920315644522921694, -0.74051741741745902292, -1,
		0, 3.7212644648959424342E-06, 0.00065681367069328206853, -0.17920319104727130965, 0.99999986159825993148, -3.7212644648959424342E-06, -0.00065681367069328206853, 0.17920319104727130965, -0.99999986159825993148, -1,
		0, 3.7212644648959432813E-06, 0.00065681367069328217695, 0.080279319715873320717, -0.037929916437397251383, -3.7212644648959432813E-06, -0.00065681367069328217695, -0.080279319715873320717, 0.037929916437397251383, -1,
		0, 3.7212644648959424342E-06, 0.00065681367069328206853, 0.080279321026717198606, 0.22155253672162589229, -3.7212644648959424342E-06, -0.00065681367069328206853, -0.080279321026717198606, -0.22155253672162589229, -1,
		0, 3.7212644648959428577E-06, 0.00065681367069328206853, 0.080279310366598979898, 0.48103498988064902209, -3.7212644648959428577E-06, -0.00065681367069328206853, -0.080279310366598979898, -0.48103498988064902209, -1,
		0, 3.7212644648959428577E-06, 0.00065681367069328206853, 0.080279287735518636837, 0.74051744303967181882, -3.7212644648959428577E-06, -0.00065681367069328206853, -0.080279287735518636837, -0.74051744303967181882, -1,
		0, 3.7212644648959424342E-06, 0.00065681367069328206853, 0.080279253133476169424, 0.99999989619869433799, -3.7212644648959424342E-06, -0.00065681367069328206853, -0.080279253133476169424, -0.99999989619869433799, -1,
		0, 3.7212644648959432813E-06, 0.00065681367069328217695, 0.33976177586758354865, -0.037929917749848982012, -3.7212644648959432813E-06, -0.00065681367069328217695, -0.33976177586758354865, 0.037929917749848982012, -1,
		0, 3.7212644648959424342E-06, 0.00065681367069328206853, 0.33976177717842742654, 0.22155254438739574452, -3.7212644648959424342E-06, -0.00065681367069328206853, -0.33976177717842742654, -0.22155254438739574452, -1,
		0, 3.7212644648959428577E-06, 0.00065681367069328206853, 0.33976176651830902742, 0.48103500652464048493, -3.7212644648959428577E-06, -0.00065681367069328206853, -0.33976176651830902742, -0.48103500652464048493, -1,
		0, 3.7212644648959428577E-06, 0.00065681367069328206853, 0.33976174388722851782, 0.74051746866188494778, -3.7212644648959428577E-06, -0.00065681367069328206853, -0.33976174388722851782, -0.74051746866188494778, -1,
		0, 3.7212644648959424342E-06, 0.00065681367069328206853, 0.33976170928518567571, 0.99999993079912896654, -3.7212644648959424342E-06, -0.00065681367069328206853, -0.33976170928518567571, -0.99999993079912896654, -1,
		0, 3.7212644648959432813E-06, 0.00065681367069328217695, 0.59924424399025599808, -0.037929919062300754273, -3.7212644648959432813E-06, -0.00065681367069328217695, -0.59924424399025599808, 0.037929919062300754273, -1,
		0, 3.7212644648959424342E-06, 0.00065681367069328206853, 0.59924424530109987597, 0.22155255205316573552, -3.7212644648959424342E-06, -0.00065681367069328206853, -0.59924424530109987597, -0.22155255205316573552, -1,
		0, 3.7212644648959428577E-06, 0.00065681367069328206853, 0.59924423464098142134, 0.48103502316863222532, -3.7212644648959428577E-06, -0.00065681367069328206853, -0.59924423464098142134, -0.48103502316863222532, -1,
		0, 3.7212644648959428577E-06, 0.00065681367069328206853, 0.59924421200990052316, 0.74051749428409852083, -3.7212644648959428577E-06, -0.00065681367069328206853, -0.59924421200990052316, -0.74051749428409852083, -1,
		0, 3.7212644648959424342E-06, 0.00065681367069328206853, 0.59924417740785729247, 0.99999996539956426123, -3.7212644648959424342E-06, -0.00065681367069328206853, -0.59924417740785729247, -0.99999996539956426123, -1,
		0, 3.7212644648959432813E-06, 0.00065681367069328206853, 0.85872672408389083554, -0.037929920374752491841, -3.7212644648959432813E-06, -0.00065681367069328206853, -0.85872672408389083554, 0.037929920374752491841, -1,
		0, 3.7212644648959432813E-06, 0.00065681367069328206853, 0.85872672539473482445, 0.22155255971893586531, -3.7212644648959432813E-06, -0.00065681367069328206853, -0.85872672539473482445, -0.22155255971893586531, -1,
		0, 3.7212644648959428577E-06, 0.00065681367069328196011, 0.8587267147346162588, 0.48103503981262424327, -3.7212644648959428577E-06, -0.00065681367069328196011, -0.8587267147346162588, -0.48103503981262424327, -1,
		0, 3.7212644648959432813E-06, 0.00065681367069328196011, 0.85872669210353513858, 0.74051751990631231592, -3.7212644648959432813E-06, -0.00065681367069328196011, -0.85872669210353513858, -0.74051751990631231592, -1,
		0, 3.7212644648959428577E-06, 0.00065681367069328196011, 0.85872665750149157482, 1, -3.7212644648959428577E-06, -0.00065681367069328196011, -0.85872665750149157482, -1, -1,
		0, 3.7212644648959432813E-06, 9.9047507497145926049E-13, -0.17920312446487488001, -0.037929915124945527694, -3.7212644648959432813E-06, -9.9047507497145926049E-13, 0.17920312446487488001, 0.037929915124945527694, -1,
		0, 3.7212644648959424342E-06, 9.9047507497145946244E-13, -0.17920312315403097436, 0.22155252905585606782, -3.7212644648959424342E-06, -9.9047507497145946244E-13, 0.17920312315403097436, -0.22155252905585606782, -1,
		0, 3.7212644648959428577E-06, 9.9047507497145946244E-13, -0.17920313381414909593, 0.48103497323665767027, -3.7212644648959428577E-06, -9.9047507497145946244E-13, 0.17920313381414909593, -0.48103497323665767027, -1,
		0, 3.7212644648959428577E-06, 9.9047507497145946244E-13, -0.17920315644522921694, 0.74051741741745902292, -3.7212644648959428577E-06, -9.9047507497145946244E-13, 0.17920315644522921694, -0.74051741741745902292, -1,
		0, 3.7212644648959424342E-06, 9.9047507497145946244E-13, -0.17920319104727130965, 0.99999986159825993148, -3.7212644648959424342E-06, -9.9047507497145946244E-13, 0.17920319104727130965, -0.99999986159825993148, -1,
		0, 3.7212644648959432813E-06, 9.9047507497145926049E-13, 0.080279319715873320717, -0.037929916437397251383, -3.7212644648959432813E-06, -9.9047507497145926049E-13, -0.080279319715873320717, 0.037929916437397251383, -1,
		0, 3.7212644648959424342E-06, 9.9047507497145946244E-13, 0.080279321026717198606, 0.22155253672162589229, -3.7212644648959424342E-06, -9.9047507497145946244E-13, -0.080279321026717198606, -0.22155253672162589229, -1,
		0, 3.7212644648959428577E-06, 9.9047507497145946244E-13, 0.080279310366598979898, 0.48103498988064902209, -3.7212644648959428577E-06, -9.9047507497145946244E-13, -0.080279310366598979898, -0.48103498988064902209, -1,
		0, 3.7212644648959428577E-06, 9.9047507497145946244E-13, 0.080279287735518636837, 0.74051744303967181882, -3.7212644648959428577E-06, -9.9047507497145946244E-13, -0.080279287735518636837, -0.74051744303967181882, -1,
		0, 3.7212644648959424342E-06, 9.9047507497145946244E-13, 0.080279253133476169424, 0.99999989619869433799, -3.7212644648959424342E-06, -9.9047507497145946244E-13, -0.080279253133476169424, -0.99999989619869433799, -1,
		0, 3.7212644648959432813E-06, 9.9047507497145926049E-13, 0.33976177586758354865, -0.037929917749848982012, -3.7212644648959432813E-06, -9.9047507497145926049E-13, -0.33976177586758354865, 0.037929917749848982012, -1,
		0, 3.7212644648959424342E-06, 9.9047507497145946244E-13, 0.33976177717842742654, 0.22155254438739574452, -3.7212644648959424342E-06, -9.9047507497145946244E-13, -0.33976177717842742654, -0.22155254438739574452, -1,
		0, 3.7212644648959428577E-06, 9.9047507497145946244E-13, 0.33976176651830902742, 0.48103500652464048493, -3.7212644648959428577E-06, -9.9047507497145946244E-13, -0.33976176651830902742, -0.48103500652464048493, -1,
		0, 3.7212644648959428577E-06, 9.9047507497145946244E-13, 0.33976174388722851782, 0.74051746866188494778, -3.7212644648959428577E-06, -9.9047507497145946244E-13, -0.33976174388722851782, -0.74051746866188494778, -1,
		0, 3.7212644648959424342E-06, 9.9047507497145946244E-13, 0.33976170928518567571, 0.99999993079912896654, -3.7212644648959424342E-06, -9.9047507497145946244E-13, -0.33976170928518567571, -0.99999993079912896654, -1,
		0, 3.7212644648959432813E-06, 9.9047507497145926049E-13, 0.59924424399025599808, -0.037929919062300754273, -3.7212644648959432813E-06, -9.9047507497145926049E-13, -0.59924424399025599808, 0.037929919062300754273, -1,
		0, 3.7212644648959424342E-06, 9.9047507497145946244E-13, 0.59924424530109987597, 0.22155255205316573552, -3.7212644648959424342E-06, -9.9047507497145946244E-13, -0.59924424530109987597, -0.22155255205316573552, -1,
		0, 3.7212644648959428577E-06, 9.9047507497145946244E-13, 0.59924423464098142134, 0.48103502316863222532, -3.7212644648959428577E-06, -9.9047507497145946244E-13, -0.59924423464098142134, -0.48103502316863222532, -1,
		0, 3.7212644648959428577E-06, 9.9047507497145946244E-13, 0.59924421200990052316, 0.74051749428409852083, -3.7212644648959428577E-06, -9.9047507497145946244E-13, -0.59924421200990052316, -0.74051749428409852083, -1,
		0, 3.7212644648959424342E-06, 9.9047507497145946244E-13, 0.59924417740785729247, 0.99999996539956426123, -3.7212644648959424342E-06, -9.9047507497145946244E-13, -0.59924417740785729247, -0.99999996539956426123, -1,
		0, 3.7212644648959432813E-06, 9.9047507497145926049E-13, 0.85872672408389083554, -0.037929920374752491841, -3.7212644648959432813E-06, -9.9047507497145926049E-13, -0.85872672408389083554, 0.037929920374752491841, -1,
		0, 3.7212644648959432813E-06, 9.9047507497145926049E-13, 0.85872672539473482445, 0.22155255971893586531, -3.7212644648959432813E-06, -9.9047507497145926049E-13, -0.85872672539473482445, -0.22155255971893586531, -1,
		0, 3.7212644648959428577E-06, 9.9047507497145926049E-13, 0.8587267147346162588, 0.48103503981262424327, -3.7212644648959428577E-06, -9.9047507497145926049E-13, -0.8587267147346162588, -0.48103503981262424327, -1,
		0, 3.7212644648959432813E-06, 9.9047507497145926049E-13, 0.85872669210353513858, 0.74051751990631231592, -3.7212644648959432813E-06, -9.9047507497145926049E-13, -0.85872669210353513858, -0.74051751990631231592, -1,
		0, 3.7212644648959428577E-06, 9.9047507497145926049E-13, 0.85872665750149157482, 1, -3.7212644648959428577E-06, -9.9047507497145926049E-13, -0.85872665750149157482, -1, -1,
		0, 7.6560259894010675477E-07, 0.0026272546798009107499, -0.17920312446487490776, -0.037929915124945541571, -7.6560259894010675477E-07, -0.0026272546798009107499, 0.17920312446487490776, 0.037929915124945541571, -1,
		0, 7.6560259894010675477E-07, 0.0026272546798009107499, -0.17920312315403102987, 0.22155252905585606782, -7.6560259894010675477E-07, -0.0026272546798009107499, 0.17920312315403102987, -0.22155252905585606782, -1,
		0, 7.6560259894010675477E-07, 0.0026272546798009107499, -0.17920313381414915144, 0.48103497323665772578, -7.6560259894010675477E-07, -0.0026272546798009107499, 0.17920313381414915144, -0.48103497323665772578, -1,
		0, 7.6560259894010675477E-07, 0.0026272546798009107499, -0.17920315644522927245, 0.74051741741745902292, -7.6560259894010675477E-07, -0.0026272546798009107499, 0.17920315644522927245, -0.74051741741745902292, -1,
		0, 7.6560259894010675477E-07, 0.0026272546798009107499, -0.17920319104727136517, 0.99999986159825993148, -7.6560259894010675477E-07, -0.0026272546798009107499, 0.17920319104727136517, -0.99999986159825993148, -1,
		0, 7.6560259894010675477E-07, 0.0026272546798009107499, 0.080279319715873292962, -0.037929916437397251383, -7.6560259894010675477E-07, -0.0026272546798009107499, -0.080279319715873292962, 0.037929916437397251383, -1,
		0, 7.6560259894010675477E-07, 0.0026272546798009107499, 0.080279321026717170851, 0.22155253672162586454, -7.6560259894010675477E-07, -0.0026272546798009107499, -0.080279321026717170851, -0.22155253672162586454, -1,
		0, 7.6560259894010675477E-07, 0.0026272546798009107499, 0.080279310366598952142, 0.48103498988064902209, -7.6560259894010675477E-07, -0.0026272546798009107499, -0.080279310366598952142, -0.48103498988064902209, -1,
		0, 7.6560259894010675477E-07, 0.0026272546798009107499, 0.080279287735518595204, 0.74051744303967181882, -7.6560259894010675477E-07, -0.0026272546798009107499, -0.080279287735518595204, -0.74051744303967181882, -1,
		0, 7.6560259894010675477E-07, 0.0026272546798009107499, 0.080279253133476113913, 0.99999989619869433799, -7.6560259894010675477E-07, -0.0026272546798009107499, -0.080279253133476113913, -0.99999989619869433799, -1,
		0, 7.6560259894010675477E-07, 0.0026272546798009107499, 0.33976177586758349314, -0.037929917749849009767, -7.6560259894010675477E-07, -0.0026272546798009107499, -0.33976177586758349314, 0.037929917749849009767, -1,
		0, 7.6560259894010675477E-07, 0.0026272546798009107499, 0.33976177717842731552, 0.22155254438739574452, -7.6560259894010675477E-07, -0.0026272546798009107499, -0.33976177717842731552, -0.22155254438739574452, -1,
		0, 7.6560259894010675477E-07, 0.0026272546798009107499, 0.33976176651830902742, 0.48103500652464048493, -7.6560259894010675477E-07, -0.0026272546798009107499, -0.33976176651830902742, -0.48103500652464048493, -1,
		0, 7.6560259894010686065E-07, 0.0026272546798009107499, 0.3397617438872284068, 0.74051746866188494778, -7.6560259894010686065E-07, -0.0026272546798009107499, -0.3397617438872284068, -0.74051746866188494778, -1,
		0, 7.6560259894010686065E-07, 0.0026272546798009107499, 0.3397617092851856202, 0.99999993079912896654, -7.6560259894010686065E-07, -0.0026272546798009107499, -0.3397617092851856202, -0.99999993079912896654, -1,
		0, 7.6560259894010675477E-07, 0.0026272546798009107499, 0.59924424399025599808, -0.037929919062300754273, -7.6560259894010675477E-07, -0.0026272546798009107499, -0.59924424399025599808, 0.037929919062300754273, -1,
		0, 7.6560259894010686065E-07, 0.0026272546798009107499, 0.59924424530109987597, 0.22155255205316573552, -7.6560259894010686065E-07, -0.0026272546798009107499, -0.59924424530109987597, -0.22155255205316573552, -1,
		0, 7.6560259894010686065E-07, 0.0026272546798009107499, 0.59924423464098142134, 0.48103502316863222532, -7.6560259894010686065E-07, -0.0026272546798009107499, -0.59924423464098142134, -0.48103502316863222532, -1,
		0, 7.6560259894010696653E-07, 0.0026272546798009107499, 0.59924421200990052316, 0.74051749428409852083, -7.6560259894010696653E-07, -0.0026272546798009107499, -0.59924421200990052316, -0.74051749428409852083, -1,
		0, 7.6560259894010686065E-07, 0.0026272546798009107499, 0.59924417740785729247, 0.99999996539956426123, -7.6560259894010686065E-07, -0.0026272546798009107499, -0.59924417740785729247, -0.99999996539956426123, -1,
		0, 7.6560259894010675477E-07, 0.0026272546798009107499, 0.85872672408389083554, -0.037929920374752491841, -7.6560259894010675477E-07, -0.0026272546798009107499, -0.85872672408389083554, 0.037929920374752491841, -1,
		0, 7.6560259894010686065E-07, 0.0026272546798009107499, 0.85872672539473482445, 0.22155255971893586531, -7.6560259894010686065E-07, -0.0026272546798009107499, -0.85872672539473482445, -0.22155255971893586531, -1,
		0, 7.6560259894010696653E-07, 0.0026272546798009107499, 0.85872671473461614777, 0.48103503981262424327, -7.6560259894010696653E-07, -0.0026272546798009107499, -0.85872671473461614777, -0.48103503981262424327, -1,
		0, 7.6560259894010696653E-07, 0.0026272546798009107499, 0.85872669210353513858, 0.74051751990631231592, -7.6560259894010696653E-07, -0.0026272546798009107499, -0.85872669210353513858, -0.74051751990631231592, -1,
		0, 7.6560259894010696653E-07, 0.0026272546798009107499, 0.85872665750149157482, 1, -7.6560259894010696653E-07, -0.0026272546798009107499, -0.85872665750149157482, -1, -1,
		0, 7.6560277511126119987E-07, 0.0019704410100983018282, -0.17920312446487490776, -0.037929915124945527694, -7.6560277511126119987E-07, -0.0019704410100983018282, 0.17920312446487490776, 0.037929915124945527694, -1,
		0, 7.6560277511126119987E-07, 0.0019704410100983018282, -0.17920312315403102987, 0.22155252905585606782, -7.6560277511126119987E-07, -0.0019704410100983018282, 0.17920312315403102987, -0.22155252905585606782, -1,
		0, 7.6560277511126130575E-07, 0.0019704410100983018282, -0.17920313381414915144, 0.48103497323665767027, -7.6560277511126130575E-07, -0.0019704410100983018282, 0.17920313381414915144, -0.48103497323665767027, -1,
		0, 7.6560277511126130575E-07, 0.0019704410100983018282, -0.17920315644522927245, 0.74051741741745902292, -7.6560277511126130575E-07, -0.0019704410100983018282, 0.17920315644522927245, -0.74051741741745902292, -1,
		0, 7.6560277511126119987E-07, 0.0019704410100983018282, -0.17920319104727136517, 0.99999986159825993148, -7.6560277511126119987E-07, -0.0019704410100983018282, 0.17920319104727136517, -0.99999986159825993148, -1,
		0, 7.6560277511126130575E-07, 0.0019704410100983018282, 0.080279319715873279084, -0.037929916437397251383, -7.6560277511126130575E-07, -0.0019704410100983018282, -0.080279319715873279084, 0.037929916437397251383, -1,
		0, 7.6560277511126119987E-07, 0.0019704410100983018282, 0.080279321026717170851, 0.22155253672162589229, -7.6560277511126119987E-07, -0.0019704410100983018282, -0.080279321026717170851, -0.22155253672162589229, -1,
		0, 7.6560277511126141163E-07, 0.0019704410100983018282, 0.080279310366598938264, 0.48103498988064902209, -7.6560277511126141163E-07, -0.0019704410100983018282, -0.080279310366598938264, -0.48103498988064902209, -1,
		0, 7.6560277511126130575E-07, 0.0019704410100983018282, 0.080279287735518595204, 0.74051744303967181882, -7.6560277511126130575E-07, -0.0019704410100983018282, -0.080279287735518595204, -0.74051744303967181882, -1,
		0, 7.6560277511126119987E-07, 0.0019704410100983018282, 0.080279253133476113913, 0.99999989619869433799, -7.6560277511126119987E-07, -0.0019704410100983018282, -0.080279253133476113913, -0.99999989619869433799, -1,
		0, 7.6560277511126130575E-07, 0.0019704410100983018282, 0.33976177586758349314, -0.037929917749848982012, -7.6560277511126130575E-07, -0.0019704410100983018282, -0.33976177586758349314, 0.037929917749848982012, -1,
		0, 7.6560277511126130575E-07, 0.0019704410100983018282, 0.33976177717842731552, 0.22155254438739574452, -7.6560277511126130575E-07, -0.0019704410100983018282, -0.33976177717842731552, -0.22155254438739574452, -1,
		0, 7.6560277511126141163E-07, 0.0019704410100983018282, 0.33976176651830902742, 0.48103500652464048493, -7.6560277511126141163E-07, -0.0019704410100983018282, -0.33976176651830902742, -0.48103500652464048493, -1,
		0, 7.6560277511126141163E-07, 0.0019704410100983018282, 0.3397617438872284068, 0.74051746866188494778, -7.6560277511126141163E-07, -0.0019704410100983018282, -0.3397617438872284068, -0.74051746866188494778, -1,
		0, 7.6560277511126130575E-07, 0.0019704410100983018282, 0.33976170928518556469, 0.99999993079912896654, -7.6560277511126130575E-07, -0.0019704410100983018282, -0.33976170928518556469, -0.99999993079912896654, -1,
		0, 7.6560277511126130575E-07, 0.0019704410100983018282, 0.59924424399025588706, -0.037929919062300754273, -7.6560277511126130575E-07, -0.0019704410100983018282, -0.59924424399025588706, 0.037929919062300754273, -1,
		0, 7.6560277511126141163E-07, 0.0019704410100983018282, 0.59924424530109987597, 0.22155255205316573552, -7.6560277511126141163E-07, -0.0019704410100983018282, -0.59924424530109987597, -0.22155255205316573552, -1,
		0, 7.6560277511126141163E-07, 0.0019704410100983018282, 0.59924423464098142134, 0.48103502316863222532, -7.6560277511126141163E-07, -0.0019704410100983018282, -0.59924423464098142134, -0.48103502316863222532, -1,
		0, 7.6560277511126151751E-07, 0.0019704410100983018282, 0.59924421200990052316, 0.74051749428409852083, -7.6560277511126151751E-07, -0.0019704410100983018282, -0.59924421200990052316, -0.74051749428409852083, -1,
		0, 7.6560277511126141163E-07, 0.0019704410100983018282, 0.59924417740785729247, 0.99999996539956426123, -7.6560277511126141163E-07, -0.0019704410100983018282, -0.59924417740785729247, -0.99999996539956426123, -1,
		0, 7.6560277511126141163E-07, 0.0019704410100983018282, 0.85872672408389072451, -0.037929920374752491841, -7.6560277511126141163E-07, -0.0019704410100983018282, -0.85872672408389072451, 0.037929920374752491841, -1,
		0, 7.6560277511126151751E-07, 0.0019704410100983018282, 0.85872672539473471343, 0.22155255971893586531, -7.6560277511126151751E-07, -0.0019704410100983018282, -0.85872672539473471343, -0.22155255971893586531, -1,
		0, 7.6560277511126151751E-07, 0.0019704410100983018282, 0.85872671473461614777, 0.48103503981262424327, -7.6560277511126151751E-07, -0.0019704410100983018282, -0.85872671473461614777, -0.48103503981262424327, -1,
		0, 7.6560277511126162339E-07, 0.0019704410100983018282, 0.85872669210353513858, 0.74051751990631231592, -7.6560277511126162339E-07, -0.0019704410100983018282, -0.85872669210353513858, -0.74051751990631231592, -1,
		0, 7.6560277511126151751E-07, 0.0019704410100983018282, 0.8587266575014914638, 1, -7.6560277511126151751E-07, -0.0019704410100983018282, -0.8587266575014914638, -1, -1,
		0, 7.6560289255869746132E-07, 0.0013136273403956924728, -0.17920312446487490776, -0.037929915124945527694, -7.6560289255869746132E-07, -0.0013136273403956924728, 0.17920312446487490776, 0.037929915124945527694, -1,
		0, 7.6560289255869756719E-07, 0.0013136273403956924728, -0.17920312315403102987, 0.22155252905585606782, -7.6560289255869756719E-07, -0.0013136273403956924728, 0.17920312315403102987, -0.22155252905585606782, -1,
		0, 7.6560289255869756719E-07, 0.0013136273403956924728, -0.17920313381414915144, 0.48103497323665767027, -7.6560289255869756719E-07, -0.0013136273403956924728, 0.17920313381414915144, -0.48103497323665767027, -1,
		0, 7.6560289255869756719E-07, 0.0013136273403956924728, -0.17920315644522927245, 0.74051741741745902292, -7.6560289255869756719E-07, -0.0013136273403956924728, 0.17920315644522927245, -0.74051741741745902292, -1,
		0, 7.6560289255869756719E-07, 0.0013136273403956924728, -0.17920319104727136517, 0.99999986159825993148, -7.6560289255869756719E-07, -0.0013136273403956924728, 0.17920319104727136517, -0.99999986159825993148, -1,
		0, 7.6560289255869746132E-07, 0.0013136273403956924728, 0.080279319715873279084, -0.037929916437397251383, -7.6560289255869746132E-07, -0.0013136273403956924728, -0.080279319715873279084, 0.037929916437397251383, -1,
		0, 7.6560289255869756719E-07, 0.0013136273403956924728, 0.080279321026717170851, 0.22155253672162589229, -7.6560289255869756719E-07, -0.0013136273403956924728, -0.080279321026717170851, -0.22155253672162589229, -1,
		0, 7.6560289255869756719E-07, 0.0013136273403956924728, 0.080279310366598938264, 0.48103498988064902209, -7.6560289255869756719E-07, -0.0013136273403956924728, -0.080279310366598938264, -0.48103498988064902209, -1,
		0, 7.6560289255869767307E-07, 0.0013136273403956924728, 0.080279287735518595204, 0.74051744303967181882, -7.6560289255869767307E-07, -0.0013136273403956924728, -0.080279287735518595204, -0.74051744303967181882, -1,
		0, 7.6560289255869756719E-07, 0.0013136273403956924728, 0.080279253133476113913, 0.99999989619869433799, -7.6560289255869756719E-07, -0.0013136273403956924728, -0.080279253133476113913, -0.99999989619869433799, -1,
		0, 7.6560289255869756719E-07, 0.0013136273403956924728, 0.33976177586758349314, -0.037929917749848982012, -7.6560289255869756719E-07, -0.0013136273403956924728, -0.33976177586758349314, 0.037929917749848982012, -1,
		0, 7.6560289255869767307E-07, 0.0013136273403956924728, 0.33976177717842731552, 0.22155254438739574452, -7.6560289255869767307E-07, -0.0013136273403956924728, -0.33976177717842731552, -0.22155254438739574452, -1,
		0, 7.6560289255869777895E-07, 0.0013136273403956924728, 0.33976176651830902742, 0.48103500652464048493, -7.6560289255869777895E-07, -0.0013136273403956924728, -0.33976176651830902742, -0.48103500652464048493, -1,
		0, 7.6560289255869777895E-07, 0.0013136273403956924728, 0.3397617438872284068, 0.74051746866188494778, -7.6560289255869777895E-07, -0.0013136273403956924728, -0.3397617438872284068, -0.74051746866188494778, -1,
		0, 7.6560289255869767307E-07, 0.0013136273403956924728, 0.33976170928518556469, 0.99999993079912896654, -7.6560289255869767307E-07, -0.0013136273403956924728, -0.33976170928518556469, -0.99999993079912896654, -1,
		0, 7.6560289255869756719E-07, 0.0013136273403956924728, 0.59924424399025588706, -0.037929919062300754273, -7.6560289255869756719E-07, -0.0013136273403956924728, -0.59924424399025588706, 0.037929919062300754273, -1,
		0, 7.6560289255869767307E-07, 0.0013136273403956924728, 0.59924424530109987597, 0.22155255205316573552, -7.6560289255869767307E-07, -0.0013136273403956924728, -0.59924424530109987597, -0.22155255205316573552, -1,
		0, 7.6560289255869777895E-07, 0.0013136273403956924728, 0.59924423464098142134, 0.48103502316863222532, -7.6560289255869777895E-07, -0.0013136273403956924728, -0.59924423464098142134, -0.48103502316863222532, -1,
		0, 7.6560289255869777895E-07, 0.0013136273403956924728, 0.59924421200990052316, 0.74051749428409852083, -7.6560289255869777895E-07, -0.0013136273403956924728, -0.59924421200990052316, -0.74051749428409852083, -1,
		0, 7.6560289255869777895E-07, 0.0013136273403956924728, 0.59924417740785729247, 0.99999996539956426123, -7.6560289255869777895E-07, -0.0013136273403956924728, -0.59924417740785729247, -0.99999996539956426123, -1,
		0, 7.6560289255869777895E-07, 0.0013136273403956924728, 0.85872672408389072451, -0.037929920374752491841, -7.6560289255869777895E-07, -0.0013136273403956924728, -0.85872672408389072451, 0.037929920374752491841, -1,
		0, 7.6560289255869777895E-07, 0.0013136273403956924728, 0.85872672539473471343, 0.22155255971893586531, -7.6560289255869777895E-07, -0.0013136273403956924728, -0.85872672539473471343, -0.22155255971893586531, -1,
		0, 7.6560289255869777895E-07, 0.0013136273403956924728, 0.85872671473461614777, 0.48103503981262424327, -7.6560289255869777895E-07, -0.0013136273403956924728, -0.85872671473461614777, -0.48103503981262424327, -1,
		0, 7.6560289255869799071E-07, 0.0013136273403956924728, 0.85872669210353513858, 0.74051751990631231592, -7.6560289255869799071E-07, -0.0013136273403956924728, -0.85872669210353513858, -0.74051751990631231592, -1,
		0, 7.6560289255869799071E-07, 0.0013136273403956924728, 0.8587266575014914638, 1, -7.6560289255869799071E-07, -0.0013136273403956924728, -0.8587266575014914638, -1, -1,
		0, 7.6560295128241564498E-07, 0.00065681367069308387637, -0.17920312446487490776, -0.037929915124945527694, -7.6560295128241564498E-07, -0.00065681367069308387637, 0.17920312446487490776, 0.037929915124945527694, -1,
		0, 7.6560295128241575085E-07, 0.00065681367069308387637, -0.17920312315403102987, 0.22155252905585606782, -7.6560295128241575085E-07, -0.00065681367069308387637, 0.17920312315403102987, -0.22155252905585606782, -1,
		0, 7.6560295128241564498E-07, 0.00065681367069308387637, -0.17920313381414915144, 0.48103497323665767027, -7.6560295128241564498E-07, -0.00065681367069308387637, 0.17920313381414915144, -0.48103497323665767027, -1,
		0, 7.6560295128241575085E-07, 0.00065681367069308387637, -0.17920315644522927245, 0.74051741741745902292, -7.6560295128241575085E-07, -0.00065681367069308387637, 0.17920315644522927245, -0.74051741741745902292, -1,
		0, 7.6560295128241564498E-07, 0.00065681367069308387637, -0.17920319104727136517, 0.99999986159825993148, -7.6560295128241564498E-07, -0.00065681367069308387637, 0.17920319104727136517, -0.99999986159825993148, -1,
		0, 7.6560295128241564498E-07, 0.00065681367069308387637, 0.080279319715873279084, -0.037929916437397251383, -7.6560295128241564498E-07, -0.00065681367069308387637, -0.080279319715873279084, 0.037929916437397251383, -1,
		0, 7.6560295128241575085E-07, 0.00065681367069308387637, 0.080279321026717170851, 0.22155253672162589229, -7.6560295128241575085E-07, -0.00065681367069308387637, -0.080279321026717170851, -0.22155253672162589229, -1,
		0, 7.6560295128241585673E-07, 0.00065681367069308387637, 0.080279310366598938264, 0.48103498988064902209, -7.6560295128241585673E-07, -0.00065681367069308387637, -0.080279310366598938264, -0.48103498988064902209, -1,
		0, 7.6560295128241585673E-07, 0.00065681367069308387637, 0.080279287735518595204, 0.74051744303967181882, -7.6560295128241585673E-07, -0.00065681367069308387637, -0.080279287735518595204, -0.74051744303967181882, -1,
		0, 7.6560295128241564498E-07, 0.00065681367069308387637, 0.080279253133476113913, 0.99999989619869433799, -7.6560295128241564498E-07, -0.00065681367069308387637, -0.080279253133476113913, -0.99999989619869433799, -1,
		0, 7.6560295128241564498E-07, 0.00065681367069308387637, 0.33976177586758349314, -0.037929917749848982012, -7.6560295128241564498E-07, -0.00065681367069308387637, -0.33976177586758349314, 0.037929917749848982012, -1,
		0, 7.6560295128241575085E-07, 0.00065681367069308387637, 0.33976177717842731552, 0.22155254438739574452, -7.6560295128241575085E-07, -0.00065681367069308387637, -0.33976177717842731552, -0.22155254438739574452, -1,
		0, 7.6560295128241585673E-07, 0.00065681367069308387637, 0.33976176651830902742, 0.48103500652464048493, -7.6560295128241585673E-07, -0.00065681367069308387637, -0.33976176651830902742, -0.48103500652464048493, -1,
		0, 7.6560295128241585673E-07, 0.00065681367069308387637, 0.3397617438872284068, 0.74051746866188494778, -7.6560295128241585673E-07, -0.00065681367069308387637, -0.3397617438872284068, -0.74051746866188494778, -1,
		0, 7.6560295128241575085E-07, 0.00065681367069308387637, 0.33976170928518556469, 0.99999993079912896654, -7.6560295128241575085E-07, -0.00065681367069308387637, -0.33976170928518556469, -0.99999993079912896654, -1,
		0, 7.6560295128241585673E-07, 0.00065681367069308387637, 0.59924424399025588706, -0.037929919062300754273, -7.6560295128241585673E-07, -0.00065681367069308387637, -0.59924424399025588706, 0.037929919062300754273, -1,
		0, 7.6560295128241596261E-07, 0.00065681367069308387637, 0.59924424530109987597, 0.22155255205316573552, -7.6560295128241596261E-07, -0.00065681367069308387637, -0.59924424530109987597, -0.22155255205316573552, -1,
		0, 7.6560295128241606849E-07, 0.00065681367069308387637, 0.59924423464098142134, 0.48103502316863222532, -7.6560295128241606849E-07, -0.00065681367069308387637, -0.59924423464098142134, -0.48103502316863222532, -1,
		0, 7.6560295128241617437E-07, 0.00065681367069308387637, 0.59924421200990052316, 0.74051749428409852083, -7.6560295128241617437E-07, -0.00065681367069308387637, -0.59924421200990052316, -0.74051749428409852083, -1,
		0, 7.6560295128241606849E-07, 0.00065681367069308387637, 0.59924417740785729247, 0.99999996539956426123, -7.6560295128241606849E-07, -0.00065681367069308387637, -0.59924417740785729247, -0.99999996539956426123, -1,
		0, 7.6560295128241585673E-07, 0.00065681367069308387637, 0.85872672408389072451, -0.037929920374752491841, -7.6560295128241585673E-07, -0.00065681367069308387637, -0.85872672408389072451, 0.037929920374752491841, -1,
		0, 7.6560295128241585673E-07, 0.00065681367069308387637, 0.85872672539473471343, 0.22155255971893586531, -7.6560295128241585673E-07, -0.00065681367069308387637, -0.85872672539473471343, -0.22155255971893586531, -1,
		0, 7.6560295128241606849E-07, 0.00065681367069308387637, 0.85872671473461614777, 0.48103503981262424327, -7.6560295128241606849E-07, -0.00065681367069308387637, -0.85872671473461614777, -0.48103503981262424327, -1,
		0, 7.6560295128241617437E-07, 0.00065681367069308387637, 0.85872669210353513858, 0.74051751990631231592, -7.6560295128241617437E-07, -0.00065681367069308387637, -0.85872669210353513858, -0.74051751990631231592, -1,
		0, 7.6560295128241606849E-07, 0.00065681367069308387637, 0.8587266575014914638, 1, -7.6560295128241606849E-07, -0.00065681367069308387637, -0.8587266575014914638, -1, -1,
		0, 7.6560295128241564498E-07, 9.9047507740949737561E-13, -0.17920312446487490776, -0.037929915124945527694, -7.6560295128241564498E-07, -9.9047507740949737561E-13, 0.17920312446487490776, 0.037929915124945527694, -1,
		0, 7.6560295128241575085E-07, 9.9047507740949737561E-13, -0.17920312315403102987, 0.22155252905585606782, -7.6560295128241575085E-07, -9.9047507740949737561E-13, 0.17920312315403102987, -0.22155252905585606782, -1,
		0, 7.6560295128241564498E-07, 9.9047507740949737561E-13, -0.17920313381414915144, 0.48103497323665767027, -7.6560295128241564498E-07, -9.9047507740949737561E-13, 0.17920313381414915144, -0.48103497323665767027, -1,
		0, 7.6560295128241575085E-07, 9.9047507740949737561E-13, -0.17920315644522927245, 0.74051741741745902292, -7.6560295128241575085E-07, -9.9047507740949737561E-13, 0.17920315644522927245, -0.74051741741745902292, -1,
		0, 7.6560295128241564498E-07, 9.9047507740949737561E-13, -0.17920319104727136517, 0.99999986159825993148, -7.6560295128241564498E-07, -9.9047507740949737561E-13, 0.17920319104727136517, -0.99999986159825993148, -1,
		0, 7.6560295128241564498E-07, 9.9047507740949737561E-13, 0.080279319715873279084, -0.037929916437397251383, -7.6560295128241564498E-07, -9.9047507740949737561E-13, -0.080279319715873279084, 0.037929916437397251383, -1,
		0, 7.6560295128241575085E-07, 9.9047507740949737561E-13, 0.080279321026717170851, 0.22155253672162589229, -7.6560295128241575085E-07, -9.9047507740949737561E-13, -0.080279321026717170851, -0.22155253672162589229, -1,
		0, 7.6560295128241585673E-07, 9.9047507740949737561E-13, 0.080279310366598938264, 0.48103498988064902209, -7.6560295128241585673E-07, -9.9047507740949737561E-13, -0.080279310366598938264, -0.48103498988064902209, -1,
		0, 7.6560295128241585673E-07, 9.9047507740949737561E-13, 0.080279287735518595204, 0.74051744303967181882, -7.6560295128241585673E-07, -9.9047507740949737561E-13, -0.080279287735518595204, -0.74051744303967181882, -1,
		0, 7.6560295128241564498E-07, 9.9047507740949737561E-13, 0.080279253133476113913, 0.99999989619869433799, -7.6560295128241564498E-07, -9.9047507740949737561E-13, -0.080279253133476113913, -0.99999989619869433799, -1,
		0, 7.6560295128241564498E-07, 9.9047507740949737561E-13, 0.33976177586758349314, -0.037929917749848982012, -7.6560295128241564498E-07, -9.9047507740949737561E-13, -0.33976177586758349314, 0.037929917749848982012, -1,
		0, 7.6560295128241575085E-07, 9.9047507740949737561E-13, 0.33976177717842731552, 0.22155254438739574452, -7.6560295128241575085E-07, -9.9047507740949737561E-13, -0.33976177717842731552, -0.22155254438739574452, -1,
		0, 7.6560295128241585673E-07, 9.9047507740949737561E-13, 0.33976176651830902742, 0.48103500652464048493, -7.6560295128241585673E-07, -9.9047507740949737561E-13, -0.33976176651830902742, -0.48103500652464048493, -1,
		0, 7.6560295128241585673E-07, 9.9047507740949737561E-13, 0.3397617438872284068, 0.74051746866188494778, -7.6560295128241585673E-07, -9.9047507740949737561E-13, -0.3397617438872284068, -0.74051746866188494778, -1,
		0, 7.6560295128241575085E-07, 9.9047507740949737561E-13, 0.33976170928518556469, 0.99999993079912896654, -7.6560295128241575085E-07, -9.9047507740949737561E-13, -0.33976170928518556469, -0.99999993079912896654, -1,
		0, 7.6560295128241585673E-07, 9.9047507740949737561E-13, 0.59924424399025588706, -0.037929919062300754273, -7.6560295128241585673E-07, -9.9047507740949737561E-13, -0.59924424399025588706, 0.037929919062300754273, -1,
		0, 7.6560295128241596261E-07, 9.9047507740949737561E-13, 0.59924424530109987597, 0.22155255205316573552, -7.6560295128241596261E-07, -9.9047507740949737561E-13, -0.59924424530109987597, -0.22155255205316573552, -1,
		0, 7.6560295128241606849E-07, 9.9047507740949737561E-13, 0.59924423464098142134, 0.48103502316863222532, -7.6560295128241606849E-07, -9.9047507740949737561E-13, -0.59924423464098142134, -0.48103502316863222532, -1,
		0, 7.6560295128241617437E-07, 9.9047507740949737561E-13, 0.59924421200990052316, 0.74051749428409852083, -7.6560295128241617437E-07, -9.9047507740949737561E-13, -0.59924421200990052316, -0.74051749428409852083, -1,
		0, 7.6560295128241606849E-07, 9.9047507740949737561E-13, 0.59924417740785729247, 0.99999996539956426123, -7.6560295128241606849E-07, -9.9047507740949737561E-13, -0.59924417740785729247, -0.99999996539956426123, -1,
		0, 7.6560295128241585673E-07, 9.9047507740949737561E-13, 0.85872672408389072451, -0.037929920374752491841, -7.6560295128241585673E-07, -9.9047507740949737561E-13, -0.85872672408389072451, 0.037929920374752491841, -1,
		0, 7.6560295128241585673E-07, 9.9047507740949737561E-13, 0.85872672539473471343, 0.22155255971893586531, -7.6560295128241585673E-07, -9.9047507740949737561E-13, -0.85872672539473471343, -0.22155255971893586531, -1,
		0, 7.6560295128241606849E-07, 9.9047507740949737561E-13, 0.85872671473461614777, 0.48103503981262424327, -7.6560295128241606849E-07, -9.9047507740949737561E-13, -0.85872671473461614777, -0.48103503981262424327, -1,
		0, 7.6560295128241617437E-07, 9.9047507740949737561E-13, 0.85872669210353513858, 0.74051751990631231592, -7.6560295128241617437E-07, -9.9047507740949737561E-13, -0.85872669210353513858, -0.74051751990631231592, -1,
		0, 7.6560295128241606849E-07, 9.9047507740949737561E-13, 0.8587266575014914638, 1, -7.6560295128241606849E-07, -9.9047507740949737561E-13, -0.8587266575014914638, -1, -1,
		0, -2.1900589146722305885E-06, 0.0026272546798001179813, -0.17920312446487493552, -0.037929915124945541571, 2.1900589146722305885E-06, -0.0026272546798001179813, 0.17920312446487493552, 0.037929915124945541571, -1,
		0, -2.1900589146722305885E-06, 0.0026272546798001179813, -0.17920312315403105763, 0.22155252905585606782, 2.1900589146722305885E-06, -0.0026272546798001179813, 0.17920312315403105763, -0.22155252905585606782, -1,
		0, -2.1900589146722305885E-06, 0.0026272546798001179813, -0.17920313381414917919, 0.48103497323665772578, 2.1900589146722305885E-06, -0.0026272546798001179813, 0.17920313381414917919, -0.48103497323665772578, -1,
		0, -2.1900589146722305885E-06, 0.0026272546798001179813, -0.17920315644522930021, 0.74051741741745902292, 2.1900589146722305885E-06, -0.0026272546798001179813, 0.17920315644522930021, -0.74051741741745902292, -1,
		0, -2.190058914672231012E-06, 0.0026272546798001179813, -0.17920319104727139292, 0.99999986159825993148, 2.190058914672231012E-06, -0.0026272546798001179813, 0.17920319104727139292, -0.99999986159825993148, -1,
		0, -2.1900589146722305885E-06, 0.0026272546798001179813, 0.080279319715873223573, -0.037929916437397251383, 2.1900589146722305885E-06, -0.0026272546798001179813, -0.080279319715873223573, 0.037929916437397251383, -1,
		0, -2.1900589146722305885E-06, 0.0026272546798001179813, 0.080279321026717115339, 0.22155253672162586454, 2.1900589146722305885E-06, -0.0026272546798001179813, -0.080279321026717115339, -0.22155253672162586454, -1,
		0, -2.1900589146722305885E-06, 0.0026272546798001179813, 0.080279310366598896631, 0.48103498988064902209, 2.1900589146722305885E-06, -0.0026272546798001179813, -0.080279310366598896631, -0.48103498988064902209, -1,
		0, -2.1900589146722305885E-06, 0.0026272546798001179813, 0.08027928773551855357, 0.74051744303967181882, 2.1900589146722305885E-06, -0.0026272546798001179813, -0.08027928773551855357, -0.74051744303967181882, -1,
		0, -2.1900589146722305885E-06, 0.0026272546798001179813, 0.080279253133476113913, 0.99999989619869433799, 2.1900589146722305885E-06, -0.0026272546798001179813, -0.080279253133476113913, -0.99999989619869433799, -1,
		0, -2.1900589146722305885E-06, 0.0026272546798001179813, 0.33976177586758349314, -0.037929917749849009767, 2.1900589146722305885E-06, -0.0026272546798001179813, -0.33976177586758349314, 0.037929917749849009767, -1,
		0, -2.1900589146722305885E-06, 0.0026272546798001179813, 0.33976177717842731552, 0.22155254438739574452, 2.1900589146722305885E-06, -0.0026272546798001179813, -0.33976177717842731552, -0.22155254438739574452, -1,
		0, -2.1900589146722305885E-06, 0.0026272546798001179813, 0.33976176651830902742, 0.48103500652464048493, 2.1900589146722305885E-06, -0.0026272546798001179813, -0.33976176651830902742, -0.48103500652464048493, -1,
		0, -2.1900589146722305885E-06, 0.0026272546798001179813, 0.3397617438872284068, 0.74051746866188494778, 2.1900589146722305885E-06, -0.0026272546798001179813, -0.3397617438872284068, -0.74051746866188494778, -1,
		0, -2.1900589146722305885E-06, 0.0026272546798001179813, 0.33976170928518567571, 0.99999993079912896654, 2.1900589146722305885E-06, -0.0026272546798001179813, -0.33976170928518567571, -0.99999993079912896654, -1,
		0, -2.1900589146722305885E-06, 0.0026272546798001179813, 0.59924424399025577603, -0.037929919062300754273, 2.1900589146722305885E-06, -0.0026272546798001179813, -0.59924424399025577603, 0.037929919062300754273, -1,
		0, -2.1900589146722305885E-06, 0.0026272546798001179813, 0.59924424530109987597, 0.22155255205316573552, 2.1900589146722305885E-06, -0.0026272546798001179813, -0.59924424530109987597, -0.22155255205316573552, -1,
		0, -2.1900589146722305885E-06, 0.0026272546798001179813, 0.59924423464098142134, 0.48103502316863222532, 2.1900589146722305885E-06, -0.0026272546798001179813, -0.59924423464098142134, -0.48103502316863222532, -1,
		0, -2.1900589146722305885E-06, 0.0026272546798001179813, 0.59924421200990052316, 0.74051749428409852083, 2.1900589146722305885E-06, -0.0026272546798001179813, -0.59924421200990052316, -0.74051749428409852083, -1,
		0, -2.1900589146722305885E-06, 0.0026272546798001179813, 0.59924417740785729247, 0.99999996539956426123, 2.1900589146722305885E-06, -0.0026272546798001179813, -0.59924417740785729247, -0.99999996539956426123, -1,
		0, -2.1900589146722301649E-06, 0.0026272546798001179813, 0.85872672408389083554, -0.037929920374752491841, 2.1900589146722301649E-06, -0.0026272546798001179813, -0.85872672408389083554, 0.037929920374752491841, -1,
		0, -2.1900589146722301649E-06, 0.0026272546798001179813, 0.85872672539473482445, 0.22155255971893586531, 2.1900589146722301649E-06, -0.0026272546798001179813, -0.85872672539473482445, -0.22155255971893586531, -1,
		0, -2.1900589146722301649E-06, 0.0026272546798001179813, 0.8587267147346162588, 0.48103503981262424327, 2.1900589146722301649E-06, -0.0026272546798001179813, -0.8587267147346162588, -0.48103503981262424327, -1,
		0, -2.1900589146722301649E-06, 0.0026272546798001179813, 0.85872669210353513858, 0.74051751990631231592, 2.1900589146722301649E-06, -0.0026272546798001179813, -0.85872669210353513858, -0.74051751990631231592, -1,
		0, -2.1900589146722301649E-06, 0.0026272546798001179813, 0.85872665750149157482, 1, 2.1900589146722301649E-06, -0.0026272546798001179813, -0.85872665750149157482, -1, -1,
		0, -2.1900587385010767786E-06, 0.0019704410100977076854, -0.17920312446487493552, -0.037929915124945541571, 2.1900587385010767786E-06, -0.0019704410100977076854, 0.17920312446487493552, 0.037929915124945541571, -1,
		0, -2.1900587385010767786E-06, 0.0019704410100977076854, -0.17920312315403105763, 0.22155252905585606782, 2.1900587385010767786E-06, -0.0019704410100977076854, 0.17920312315403105763, -0.22155252905585606782, -1,
		0, -2.1900587385010767786E-06, 0.0019704410100977076854, -0.17920313381414917919, 0.48103497323665772578, 2.1900587385010767786E-06, -0.0019704410100977076854, 0.17920313381414917919, -0.48103497323665772578, -1,
		0, -2.1900587385010767786E-06, 0.0019704410100977076854, -0.17920315644522930021, 0.74051741741745902292, 2.1900587385010767786E-06, -0.0019704410100977076854, 0.17920315644522930021, -0.74051741741745902292, -1,
		0, -2.1900587385010767786E-06, 0.0019704410100977076854, -0.17920319104727139292, 0.99999986159825993148, 2.1900587385010767786E-06, -0.0019704410100977076854, 0.17920319104727139292, -0.99999986159825993148, -1,
		0, -2.1900587385010767786E-06, 0.0019704410100977076854, 0.080279319715873223573, -0.037929916437397251383, 2.1900587385010767786E-06, -0.0019704410100977076854, -0.080279319715873223573, 0.037929916437397251383, -1,
		0, -2.1900587385010767786E-06, 0.0019704410100977076854, 0.080279321026717115339, 0.22155253672162586454, 2.1900587385010767786E-06, -0.0019704410100977076854, -0.080279321026717115339, -0.22155253672162586454, -1,
		0, -2.1900587385010767786E-06, 0.0019704410100977076854, 0.080279310366598896631, 0.48103498988064902209, 2.1900587385010767786E-06, -0.0019704410100977076854, -0.080279310366598896631, -0.48103498988064902209, -1,
		0, -2.1900587385010767786E-06, 0.0019704410100977076854, 0.08027928773551855357, 0.74051744303967181882, 2.1900587385010767786E-06, -0.0019704410100977076854, -0.08027928773551855357, -0.74051744303967181882, -1,
		0, -2.1900587385010767786E-06, 0.0019704410100977076854, 0.080279253133476113913, 0.99999989619869433799, 2.1900587385010767786E-06, -0.0019704410100977076854, -0.080279253133476113913, -0.99999989619869433799, -1,
		0, -2.1900587385010767786E-06, 0.0019704410100977076854, 0.33976177586758343763, -0.037929917749849009767, 2.1900587385010767786E-06, -0.0019704410100977076854, -0.33976177586758343763, 0.037929917749849009767, -1,
		0, -2.1900587385010767786E-06, 0.0019704410100977076854, 0.33976177717842731552, 0.22155254438739574452, 2.1900587385010767786E-06, -0.0019704410100977076854, -0.33976177717842731552, -0.22155254438739574452, -1,
		0, -2.1900587385010767786E-06, 0.0019704410100977076854, 0.3397617665183089164, 0.48103500652464048493, 2.1900587385010767786E-06, -0.0019704410100977076854, -0.3397617665183089164, -0.48103500652464048493, -1,
		0, -2.1900587385010767786E-06, 0.0019704410100977076854, 0.3397617438872284068, 0.74051746866188494778, 2.1900587385010767786E-06, -0.0019704410100977076854, -0.3397617438872284068, -0.74051746866188494778, -1,
		0, -2.1900587385010767786E-06, 0.0019704410100977076854, 0.3397617092851856202, 0.99999993079912896654, 2.1900587385010767786E-06, -0.0019704410100977076854, -0.3397617092851856202, -0.99999993079912896654, -1,
		0, -2.1900587385010763551E-06, 0.0019704410100977076854, 0.59924424399025577603, -0.037929919062300754273, 2.1900587385010763551E-06, -0.0019704410100977076854, -0.59924424399025577603, 0.037929919062300754273, -1,
		0, -2.1900587385010767786E-06, 0.0019704410100977076854, 0.59924424530109987597, 0.22155255205316573552, 2.1900587385010767786E-06, -0.0019704410100977076854, -0.59924424530109987597, -0.22155255205316573552, -1,
		0, -2.1900587385010763551E-06, 0.0019704410100977076854, 0.59924423464098142134, 0.48103502316863222532, 2.1900587385010763551E-06, -0.0019704410100977076854, -0.59924423464098142134, -0.48103502316863222532, -1,
		0, -2.1900587385010763551E-06, 0.0019704410100977076854, 0.59924421200990052316, 0.74051749428409852083, 2.1900587385010763551E-06, -0.0019704410100977076854, -0.59924421200990052316, -0.74051749428409852083, -1,
		0, -2.1900587385010763551E-06, 0.0019704410100977076854, 0.59924417740785729247, 0.99999996539956426123, 2.1900587385010763551E-06, -0.0019704410100977076854, -0.59924417740785729247, -0.99999996539956426123, -1,
		0, -2.1900587385010759316E-06, 0.0019704410100977076854, 0.85872672408389072451, -0.037929920374752491841, 2.1900587385010759316E-06, -0.0019704410100977076854, -0.85872672408389072451, 0.037929920374752491841, -1,
		0, -2.1900587385010763551E-06, 0.0019704410100977076854, 0.85872672539473471343, 0.22155255971893586531, 2.1900587385010763551E-06, -0.0019704410100977076854, -0.85872672539473471343, -0.22155255971893586531, -1,
		0, -2.1900587385010759316E-06, 0.0019704410100977076854, 0.85872671473461614777, 0.48103503981262424327, 2.1900587385010759316E-06, -0.0019704410100977076854, -0.85872671473461614777, -0.48103503981262424327, -1,
		0, -2.1900587385010759316E-06, 0.0019704410100977076854, 0.85872669210353513858, 0.74051751990631231592, 2.1900587385010759316E-06, -0.0019704410100977076854, -0.85872669210353513858, -0.74051751990631231592, -1,
		0, -2.1900587385010759316E-06, 0.0019704410100977076854, 0.85872665750149157482, 1, 2.1900587385010759316E-06, -0.0019704410100977076854, -0.85872665750149157482, -1, -1,
		0, -2.1900586210536401996E-06, 0.0013136273403952963054, -0.17920312446487493552, -0.037929915124945541571, 2.1900586210536401996E-06, -0.0013136273403952963054, 0.17920312446487493552, 0.037929915124945541571, -1,
		0, -2.1900586210536401996E-06, 0.0013136273403952963054, -0.17920312315403105763, 0.22155252905585606782, 2.1900586210536401996E-06, -0.0013136273403952963054, 0.17920312315403105763, -0.22155252905585606782, -1,
		0, -2.190058621053639776E-06, 0.0013136273403952963054, -0.17920313381414917919, 0.48103497323665772578, 2.190058621053639776E-06, -0.0013136273403952963054, 0.17920313381414917919, -0.48103497323665772578, -1,
		0, -2.190058621053639776E-06, 0.0013136273403952963054, -0.17920315644522930021, 0.74051741741745902292, 2.190058621053639776E-06, -0.0013136273403952963054, 0.17920315644522930021, -0.74051741741745902292, -1,
		0, -2.190058621053639776E-06, 0.0013136273403952963054, -0.17920319104727139292, 0.99999986159825993148, 2.190058621053639776E-06, -0.0013136273403952963054, 0.17920319104727139292, -0.99999986159825993148, -1,
		0, -2.190058621053639776E-06, 0.0013136273403952963054, 0.080279319715873223573, -0.037929916437397251383, 2.190058621053639776E-06, -0.0013136273403952963054, -0.080279319715873223573, 0.037929916437397251383, -1,
		0, -2.1900586210536401996E-06, 0.0013136273403952963054, 0.080279321026717115339, 0.22155253672162586454, 2.1900586210536401996E-06, -0.0013136273403952963054, -0.080279321026717115339, -0.22155253672162586454, -1,
		0, -2.190058621053639776E-06, 0.0013136273403952963054, 0.080279310366598896631, 0.48103498988064902209, 2.190058621053639776E-06, -0.0013136273403952963054, -0.080279310366598896631, -0.48103498988064902209, -1,
		0, -2.190058621053639776E-06, 0.0013136273403952963054, 0.08027928773551855357, 0.74051744303967181882, 2.190058621053639776E-06, -0.0013136273403952963054, -0.08027928773551855357, -0.74051744303967181882, -1,
		0, -2.190058621053639776E-06, 0.0013136273403952963054, 0.080279253133476113913, 0.99999989619869433799, 2.190058621053639776E-06, -0.0013136273403952963054, -0.080279253133476113913, -0.99999989619869433799, -1,
		0, -2.190058621053639776E-06, 0.0013136273403952963054, 0.33976177586758343763, -0.037929917749849009767, 2.190058621053639776E-06, -0.0013136273403952963054, -0.33976177586758343763, 0.037929917749849009767, -1,
		0, -2.190058621053639776E-06, 0.0013136273403952963054, 0.33976177717842731552, 0.22155254438739574452, 2.190058621053639776E-06, -0.0013136273403952963054, -0.33976177717842731552, -0.22155254438739574452, -1,
		0, -2.190058621053639776E-06, 0.0013136273403952963054, 0.3397617665183089164, 0.48103500652464048493, 2.190058621053639776E-06, -0.0013136273403952963054, -0.3397617665183089164, -0.48103500652464048493, -1,
		0, -2.190058621053639776E-06, 0.0013136273403952963054, 0.3397617438872284068, 0.74051746866188494778, 2.190058621053639776E-06, -0.0013136273403952963054, -0.3397617438872284068, -0.74051746866188494778, -1,
		0, -2.190058621053639776E-06, 0.0013136273403952963054, 0.3397617092851856202, 0.99999993079912896654, 2.190058621053639776E-06, -0.0013136273403952963054, -0.3397617092851856202, -0.99999993079912896654, -1,
		0, -2.190058621053639776E-06, 0.0013136273403952963054, 0.59924424399025577603, -0.037929919062300754273, 2.190058621053639776E-06, -0.0013136273403952963054, -0.59924424399025577603, 0.037929919062300754273, -1,
		0, -2.1900586210536401996E-06, 0.0013136273403952963054, 0.59924424530109987597, 0.22155255205316573552, 2.1900586210536401996E-06, -0.0013136273403952963054, -0.59924424530109987597, -0.22155255205316573552, -1,
		0, -2.190058621053639776E-06, 0.0013136273403952963054, 0.59924423464098142134, 0.48103502316863222532, 2.190058621053639776E-06, -0.0013136273403952963054, -0.59924423464098142134, -0.48103502316863222532, -1,
		0, -2.190058621053639776E-06, 0.0013136273403952963054, 0.59924421200990052316, 0.74051749428409852083, 2.190058621053639776E-06, -0.0013136273403952963054, -0.59924421200990052316, -0.74051749428409852083, -1,
		0, -2.190058621053639776E-06, 0.0013136273403952963054, 0.59924417740785729247, 0.99999996539956426123, 2.190058621053639776E-06, -0.0013136273403952963054, -0.59924417740785729247, -0.99999996539956426123, -1,
		0, -2.1900586210536393525E-06, 0.0013136273403952963054, 0.85872672408389072451, -0.037929920374752491841, 2.1900586210536393525E-06, -0.0013136273403952963054, -0.85872672408389072451, 0.037929920374752491841, -1,
		0, -2.190058621053639776E-06, 0.0013136273403952963054, 0.85872672539473471343, 0.22155255971893586531, 2.190058621053639776E-06, -0.0013136273403952963054, -0.85872672539473471343, -0.22155255971893586531, -1,
		0, -2.1900586210536393525E-06, 0.0013136273403952963054, 0.85872671473461614777, 0.48103503981262424327, 2.1900586210536393525E-06, -0.0013136273403952963054, -0.85872671473461614777, -0.48103503981262424327, -1,
		0, -2.1900586210536393525E-06, 0.0013136273403952963054, 0.85872669210353513858, 0.74051751990631231592, 2.1900586210536393525E-06, -0.0013136273403952963054, -0.85872669210353513858, -0.74051751990631231592, -1,
		0, -2.1900586210536393525E-06, 0.0013136273403952963054, 0.85872665750149157482, 1, 2.1900586210536393525E-06, -0.0013136273403952963054, -0.85872665750149157482, -1, -1,
		0, -2.1900585623299221218E-06, 0.00065681367069288579263, -0.17920312446487493552, -0.037929915124945541571, 2.1900585623299221218E-06, -0.00065681367069288579263, 0.17920312446487493552, 0.037929915124945541571, -1,
		0, -2.1900585623299221218E-06, 0.00065681367069288579263, -0.17920312315403105763, 0.22155252905585606782, 2.1900585623299221218E-06, -0.00065681367069288579263, 0.17920312315403105763, -0.22155252905585606782, -1,
		0, -2.1900585623299216983E-06, 0.00065681367069288579263, -0.17920313381414917919, 0.48103497323665772578, 2.1900585623299216983E-06, -0.00065681367069288579263, 0.17920313381414917919, -0.48103497323665772578, -1,
		0, -2.1900585623299216983E-06, 0.00065681367069288579263, -0.17920315644522930021, 0.74051741741745902292, 2.1900585623299216983E-06, -0.00065681367069288579263, 0.17920315644522930021, -0.74051741741745902292, -1,
		0, -2.1900585623299216983E-06, 0.00065681367069288579263, -0.17920319104727139292, 0.99999986159825993148, 2.1900585623299216983E-06, -0.00065681367069288579263, 0.17920319104727139292, -0.99999986159825993148, -1,
		0, -2.1900585623299221218E-06, 0.00065681367069288579263, 0.080279319715873223573, -0.037929916437397251383, 2.1900585623299221218E-06, -0.00065681367069288579263, -0.080279319715873223573, 0.037929916437397251383, -1,
		0, -2.1900585623299221218E-06, 0.00065681367069288579263, 0.080279321026717115339, 0.22155253672162586454, 2.1900585623299221218E-06, -0.00065681367069288579263, -0.080279321026717115339, -0.22155253672162586454, -1,
		0, -2.1900585623299216983E-06, 0.00065681367069288579263, 0.080279310366598896631, 0.48103498988064902209, 2.1900585623299216983E-06, -0.00065681367069288579263, -0.080279310366598896631, -0.48103498988064902209, -1,
		0, -2.1900585623299216983E-06, 0.00065681367069288579263, 0.08027928773551855357, 0.74051744303967181882, 2.1900585623299216983E-06, -0.00065681367069288579263, -0.08027928773551855357, -0.74051744303967181882, -1,
		0, -2.1900585623299216983E-06, 0.00065681367069288579263, 0.080279253133476113913, 0.99999989619869433799, 2.1900585623299216983E-06, -0.00065681367069288579263, -0.080279253133476113913, -0.99999989619869433799, -1,
		0, -2.1900585623299212747E-06, 0.00065681367069288579263, 0.33976177586758343763, -0.037929917749849009767, 2.1900585623299212747E-06, -0.00065681367069288579263, -0.33976177586758343763, 0.037929917749849009767, -1,
		0, -2.1900585623299216983E-06, 0.00065681367069288579263, 0.33976177717842731552, 0.22155254438739574452, 2.1900585623299216983E-06, -0.00065681367069288579263, -0.33976177717842731552, -0.22155254438739574452, -1,
		0, -2.1900585623299216983E-06, 0.00065681367069288579263, 0.3397617665183089164, 0.48103500652464048493, 2.1900585623299216983E-06, -0.00065681367069288579263, -0.3397617665183089164, -0.48103500652464048493, -1,
		0, -2.1900585623299216983E-06, 0.00065681367069288579263, 0.3397617438872284068, 0.74051746866188494778, 2.1900585623299216983E-06, -0.00065681367069288579263, -0.3397617438872284068, -0.74051746866188494778, -1,
		0, -2.1900585623299216983E-06, 0.00065681367069288579263, 0.3397617092851856202, 0.99999993079912896654, 2.1900585623299216983E-06, -0.00065681367069288579263, -0.3397617092851856202, -0.99999993079912896654, -1,
		0, -2.1900585623299221218E-06, 0.00065681367069288579263, 0.59924424399025577603, -0.037929919062300754273, 2.1900585623299221218E-06, -0.00065681367069288579263, -0.59924424399025577603, 0.037929919062300754273, -1,
		0, -2.1900585623299221218E-06, 0.00065681367069288579263, 0.59924424530109987597, 0.22155255205316573552, 2.1900585623299221218E-06, -0.00065681367069288579263, -0.59924424530109987597, -0.22155255205316573552, -1,
		0, -2.1900585623299216983E-06, 0.00065681367069288579263, 0.59924423464098142134, 0.48103502316863222532, 2.1900585623299216983E-06, -0.00065681367069288579263, -0.59924423464098142134, -0.48103502316863222532, -1,
		0, -2.1900585623299216983E-06, 0.00065681367069288579263, 0.59924421200990052316, 0.74051749428409852083, 2.1900585623299216983E-06, -0.00065681367069288579263, -0.59924421200990052316, -0.74051749428409852083, -1,
		0, -2.1900585623299216983E-06, 0.00065681367069288579263, 0.59924417740785729247, 0.99999996539956426123, 2.1900585623299216983E-06, -0.00065681367069288579263, -0.59924417740785729247, -0.99999996539956426123, -1,
		0, -2.1900585623299212747E-06, 0.00065681367069288579263, 0.85872672408389072451, -0.037929920374752491841, 2.1900585623299212747E-06, -0.00065681367069288579263, -0.85872672408389072451, 0.037929920374752491841, -1,
		0, -2.1900585623299216983E-06, 0.00065681367069288579263, 0.85872672539473471343, 0.22155255971893586531, 2.1900585623299216983E-06, -0.00065681367069288579263, -0.85872672539473471343, -0.22155255971893586531, -1,
		0, -2.1900585623299212747E-06, 0.00065681367069288579263, 0.85872671473461614777, 0.48103503981262424327, 2.1900585623299212747E-06, -0.00065681367069288579263, -0.85872671473461614777, -0.48103503981262424327, -1,
		0, -2.1900585623299212747E-06, 0.00065681367069288579263, 0.85872669210353513858, 0.74051751990631231592, 2.1900585623299212747E-06, -0.00065681367069288579263, -0.85872669210353513858, -0.74051751990631231592, -1,
		0, -2.1900585623299212747E-06, 0.00065681367069288579263, 0.85872665750149157482, 1, 2.1900585623299212747E-06, -0.00065681367069288579263, -0.85872665750149157482, -1, -1,
		0, -2.1900585623299221218E-06, 9.9047507984753609656E-13, -0.17920312446487493552, -0.037929915124945541571, 2.1900585623299221218E-06, -9.9047507984753609656E-13, 0.17920312446487493552, 0.037929915124945541571, -1,
		0, -2.1900585623299221218E-06, 9.9047507984753609656E-13, -0.17920312315403105763, 0.22155252905585606782, 2.1900585623299221218E-06, -9.9047507984753609656E-13, 0.17920312315403105763, -0.22155252905585606782, -1,
		0, -2.1900585623299216983E-06, 9.9047507984753609656E-13, -0.17920313381414917919, 0.48103497323665772578, 2.1900585623299216983E-06, -9.9047507984753609656E-13, 0.17920313381414917919, -0.48103497323665772578, -1,
		0, -2.1900585623299216983E-06, 9.9047507984753609656E-13, -0.17920315644522930021, 0.74051741741745902292, 2.1900585623299216983E-06, -9.9047507984753609656E-13, 0.17920315644522930021, -0.74051741741745902292, -1,
		0, -2.1900585623299216983E-06, 9.9047507984753609656E-13, -0.17920319104727139292, 0.99999986159825993148, 2.1900585623299216983E-06, -9.9047507984753609656E-13, 0.17920319104727139292, -0.99999986159825993148, -1,
		0, -2.1900585623299221218E-06, 9.9047507984753609656E-13, 0.080279319715873223573, -0.037929916437397251383, 2.1900585623299221218E-06, -9.9047507984753609656E-13, -0.080279319715873223573, 0.037929916437397251383, -1,
		0, -2.1900585623299221218E-06, 9.9047507984753609656E-13, 0.080279321026717115339, 0.22155253672162586454, 2.1900585623299221218E-06, -9.9047507984753609656E-13, -0.080279321026717115339, -0.22155253672162586454, -1,
		0, -2.1900585623299216983E-06, 9.9047507984753609656E-13, 0.080279310366598896631, 0.48103498988064902209, 2.1900585623299216983E-06, -9.9047507984753609656E-13, -0.080279310366598896631, -0.48103498988064902209, -1,
		0, -2.1900585623299216983E-06, 9.9047507984753609656E-13, 0.08027928773551855357, 0.74051744303967181882, 2.1900585623299216983E-06, -9.9047507984753609656E-13, -0.08027928773551855357, -0.74051744303967181882, -1,
		0, -2.1900585623299216983E-06, 9.9047507984753609656E-13, 0.080279253133476113913, 0.99999989619869433799, 2.1900585623299216983E-06, -9.9047507984753609656E-13, -0.080279253133476113913, -0.99999989619869433799, -1,
		0, -2.1900585623299212747E-06, 9.9047507984753609656E-13, 0.33976177586758343763, -0.037929917749849009767, 2.1900585623299212747E-06, -9.9047507984753609656E-13, -0.33976177586758343763, 0.037929917749849009767, -1,
		0, -2.1900585623299216983E-06, 9.9047507984753609656E-13, 0.33976177717842731552, 0.22155254438739574452, 2.1900585623299216983E-06, -9.9047507984753609656E-13, -0.33976177717842731552, -0.22155254438739574452, -1,
		0, -2.1900585623299216983E-06, 9.9047507984753609656E-13, 0.3397617665183089164, 0.48103500652464048493, 2.1900585623299216983E-06, -9.9047507984753609656E-13, -0.3397617665183089164, -0.48103500652464048493, -1,
		0, -2.1900585623299216983E-06, 9.9047507984753609656E-13, 0.3397617438872284068, 0.74051746866188494778, 2.1900585623299216983E-06, -9.9047507984753609656E-13, -0.3397617438872284068, -0.74051746866188494778, -1,
		0, -2.1900585623299216983E-06, 9.9047507984753609656E-13, 0.3397617092851856202, 0.99999993079912896654, 2.1900585623299216983E-06, -9.9047507984753609656E-13, -0.3397617092851856202, -0.99999993079912896654, -1,
		0, -2.1900585623299221218E-06, 9.9047507984753609656E-13, 0.59924424399025577603, -0.037929919062300754273, 2.1900585623299221218E-06, -9.9047507984753609656E-13, -0.59924424399025577603, 0.037929919062300754273, -1,
		0, -2.1900585623299221218E-06, 9.9047507984753609656E-13, 0.59924424530109987597, 0.22155255205316573552, 2.1900585623299221218E-06, -9.9047507984753609656E-13, -0.59924424530109987597, -0.22155255205316573552, -1,
		0, -2.1900585623299216983E-06, 9.9047507984753609656E-13, 0.59924423464098142134, 0.48103502316863222532, 2.1900585623299216983E-06, -9.9047507984753609656E-13, -0.59924423464098142134, -0.48103502316863222532, -1,
		0, -2.1900585623299216983E-06, 9.9047507984753609656E-13, 0.59924421200990052316, 0.74051749428409852083, 2.1900585623299216983E-06, -9.9047507984753609656E-13, -0.59924421200990052316, -0.74051749428409852083, -1,
		0, -2.1900585623299216983E-06, 9.9047507984753609656E-13, 0.59924417740785729247, 0.99999996539956426123, 2.1900585623299216983E-06, -9.9047507984753609656E-13, -0.59924417740785729247, -0.99999996539956426123, -1,
		0, -2.1900585623299212747E-06, 9.9047507984753609656E-13, 0.85872672408389072451, -0.037929920374752491841, 2.1900585623299212747E-06, -9.9047507984753609656E-13, -0.85872672408389072451, 0.037929920374752491841, -1,
		0, -2.1900585623299216983E-06, 9.9047507984753609656E-13, 0.85872672539473471343, 0.22155255971893586531, 2.1900585623299216983E-06, -9.9047507984753609656E-13, -0.85872672539473471343, -0.22155255971893586531, -1,
		0, -2.1900585623299212747E-06, 9.9047507984753609656E-13, 0.85872671473461614777, 0.48103503981262424327, 2.1900585623299212747E-06, -9.9047507984753609656E-13, -0.85872671473461614777, -0.48103503981262424327, -1,
		0, -2.1900585623299212747E-06, 9.9047507984753609656E-13, 0.85872669210353513858, 0.74051751990631231592, 2.1900585623299212747E-06, -9.9047507984753609656E-13, -0.85872669210353513858, -0.74051751990631231592, -1,
		0, -2.1900585623299212747E-06, 9.9047507984753609656E-13, 0.85872665750149157482, 1, 2.1900585623299212747E-06, -9.9047507984753609656E-13, -0.85872665750149157482, -1, -1,
		1, -1, -1, -1, -1, -1, -1, -1, -1, 0,
		-0, -0, -0, -0, -0, -0, -0, -0, -0, -0
	};


	
	double *mat_ptr = mat;
		

		/*
		 *	prepare data for simplex algorithm call
		 */

	a = dmatrix(1, 628, 1, 10);
	if (!a)
		return;

	for (i=1;i<=628;i++)
		for (j=1;j<=10;j++)
			a[i][j] = (float)*mat_ptr++;


	irowv = ivector(1,9);
	if (!irowv)
		return;
	iposv = ivector(1,626);
	if (!iposv)
		return;

	simplex(a, 9, 625, 0, 1, &res_case, irowv, iposv);

	res = (a[1][1] >= smallish);

	free_dmatrix(a, 1, 628, 1, 10);
	free_ivector(irowv, 1, 9);
	free_ivector(iposv, 1, 626);
	
}

void test_three_d()
{
	double Q_coeffs[] = {	-1.0000000000, -1.0000000000, -1.0000000000, 
							-1.0000000000, -1.0000000000,  2.0000000000, 
							-1.0000000000,  2.0000000000, -1.0000000000, 
							-1.0000000000,  2.0000000000,  2.0000000000, 
							 2.0000000000, -1.0000000000, -1.0000000000, 
							 2.0000000000, -1.0000000000,  2.0000000000, 
							 2.0000000000,  2.0000000000, -1.0000000000, 
							 2.0000000000,  2.0000000000,  2.0000000000};

	double a[] = {0.0,0.0,0.0};
	double b[] = {1.0,1.0,1.0};
	int degrees[] = {1,1,1};
	int dim = 3;
	int nQ = 24;

	test_find_root_list(Q_coeffs, nQ, a, b, degrees, dim);
}

void test_three_d_bis()
{
	double Q_coeffs[] = {	-1.0000000000, -1.0000000000, -1.0000000000,
							-1.0000000000, -1.0000000000,  3.0000000000, 
							-1.0000000000,  2.0000000000, -1.0000000000, 
							-1.0000000000,  2.0000000000,  3.0000000000, 
							 1.0000000000, -1.0000000000, -1.0000000000, 
							 1.0000000000, -1.0000000000,  3.0000000000, 
							 1.0000000000,  2.0000000000, -1.0000000000, 
							 1.0000000000,  2.0000000000,  3.0000000000};
							 
	double a[] = {0.0,0.0,0.0};
	double b[] = {1.0,1.0,1.0};
	int degrees[] = {1,1,1};
	int dim = 3;
	int nQ = 24;

	test_find_root_list(Q_coeffs, nQ, a, b, degrees, dim);
}

/*void plsolve_test0()
{
	int ret;
	int nvars = 1;
	lprec *lp1;

	REAL mat[2][2] = { 
		{ 1.0, 0.0},
		{ 1.0, 2.0}};

	lp1 = make_lp(0, nvars);

	set_obj_fn(lp1, mat[0]);	

	add_constraint(lp1, mat[1], LE, mat[1][nvars]);

	set_lowbo(lp1, 1, 0);
	set_upbo(lp1, 1, 20);

	ret = solve(lp1);

	printf("ret = %d\n", ret);

	print_solution(lp1);
}*/

void plsolve_test0()
{
	int ret;
	int nvars = 4;
	lprec *lp1;

	REAL mat[2][5] = { 
		{ -2, -3, 2, -3, 0},
		{ 3, 2, 2, 4, 4}};

	REAL *ob_fn = (double *)(&mat[0])-1;
	REAL *const_mat = (double *)(&mat[1])-1;

/*	REAL ob_fn[] = { 0, -2, -3, 2, -3};
	REAL const_mat[] = { 0, 3, 2, 2, 4};
*/
	lp1 = make_lp(0, nvars);

	set_obj_fn(lp1, ob_fn);	

	add_constraint(lp1, const_mat, LE, 4.0);

	set_lowbo(lp1, 1, 0);
	set_upbo(lp1, 1, 20);

	print_lp(lp1);

	ret = solve(lp1);

	printf("ret = %d\n", ret);

	print_solution(lp1);
}


void plsolve_test1()
{
	int ret;
	int nvars = 4;
	lprec *lp1;

	REAL mat[5][5] = { 
		{-1.0, 0.0, 1.0, 0.0, /**/ 0.0},
		/**/
		{ 1.0, 0.0,-1.0, 0.0, /**/ 2.0},
		{ 0.0, 1.0, 0.0,-1.0, /**/ 2.0},
		{ 1.0, 0.0,-1.0, 0.0, /**/ 1.0},
		{ 0.0, 1.0, 0.0,-1.0, /**/ 1.0}};

	lp1 = make_lp(0, nvars);

	set_obj_fn(lp1, (double *)&mat[0] - 1);	

	add_constraint(lp1, (double *)&mat[1] - 1, LE, mat[1][nvars]);
	add_constraint(lp1, (double *)&mat[2] - 1, LE, mat[2][nvars]);
	add_constraint(lp1, (double *)&mat[3] - 1, GE, mat[3][nvars]);
	add_constraint(lp1, (double *)&mat[4] - 1, GE, mat[4][nvars]);

	print_lp(lp1);

	ret = solve(lp1);

	printf("ret = %d\n", ret);

	print_solution(lp1);
}

int main()
{
	clock_t begin, end;
	int test_times = 1;	

	int k;
	
	begin = clock();
	for (k=0 ; k<test_times ; k++) {

//		plsolve_test0();
//		plsolve_test1();
//		simplex_test1();
//		simplex_test2();
//		simplex_test3();
//		simplex_test4();
		
/*		printf("3d 1\n");
		test_three_d();
		printf("3d 2\n");
		test_three_d_bis();

		printf("hull excludes 1\n");
		test_hull_excludes_0_tris(); 

*/		printf("1\n");
		test1();
/*		printf("2\n");
		test2();	
		printf("3\n");
		test3();
		printf("4\n");
		test4();	
		printf("5\n");
		test5();	
		printf("6\n");
		test6();
		printf("7\n");
		test7();	
		printf("8\n");
		test8();	
		printf("9\n");
		test9();
		printf("10\n");
		test10();	
		printf("11\n");
		test11();
		printf("12\n");
		test12();	
		printf("13\n");
		test13();
		printf("14\n");
		test14();
		test_big();
*/

	}
	end = clock();
	printf("Time ellapsed: %f secs\n", ((double)end-begin)/CLOCKS_PER_SEC);
		
	return 0;
}
