/*
 *
 * Package: Poly Zeros
 * File: poly_zeroes.h
 *
 * (c) 1999 Jack Schwartz
 * part of translation from the Setl Language by G. Di Mauro
 *
 */

#ifndef __POLY_ZEROES_H__
#define __POLY_ZEROES_H__	0x0100

#ifdef __cplusplus
extern "C"
{
#endif


	/*
	 * preprocessor definition
	 */

#ifndef max
#	define max(a,b) (((a) > (b))?(a):(b))
#endif

#ifndef min
#	define min(a,b) (((a) < (b))?(a):(b))
#endif

#ifndef PI
#	define PI		((double)3.141592653589793238462643383)
#	define PIO2		(PI/2.0)
#	define pi		PI
#	define pio2		PIO2
#endif

#define small_angle ((double)1.0e-6)

	/*
	 * prototypes
	 */

double	**find_root_list(double *Q_coefficients, int nQ, double *a, double *b, int *degrees, int dim, int *root_list_size);
void	poly_zeroes_initialize(double the_small_enough, double the_small_enough2, int the_refused_enough, int the_max_roots, int the_split_enough);
short	hull_excludes_0(double *vect, int vec_len, int dim);
double	*get_left_coeffs_gen(double *c, int nc, int axis, int *degs, int n_vars);
double	*get_right_coeffs_gen(double *c, int nc, int axis, int *degs, int n_vars);
short	find_root_list_Q(double *c, int nc, double *a, double *b, int dim, int axis, int *degs, int n_vars);
void simplex(double **a, int n, int m1, int m2, int m3, int *icase, int izrov[], int iposv[]);
double	comb(int i, int j);
	/* numerical recipes functions */
double	factrl(int n);
double	gammln(double xx);
	/* numerical recipes functions */
void simplx(double **a, int m, int n, int m1, int m2, int m3, int *icase,	int izrov[], int iposv[]);


#ifdef __cplusplus
}
#endif

#endif	/* __POLY_ZEROES_H__ */