/*
\*/




/* SETL2 system header files */





#include "Python.h"
#ifdef macintosh
#include "macglue.h"
//#include <SIOUX.h>
#endif /* macintosh */

#include "macros.h"

extern int hard_stop;

#ifdef PLUGIN
#define fprintf plugin_fprintf
#define printf plugin_printf
#endif

static char *python_result=NULL;
static result_len=1024;

struct setl_tcl {
   int32 use_count;
   int32 type;
   void *interp;
};

struct setl_tcl_interpreters {
   void *interp;
   struct setl_tcl_interpreters *next;
};

struct setl_callback {
   SETL_SYSTEM_PROTO_VOID;
   specifier s;
};

/* constants */

#define YES         1                  /* true constant                     */
#define NO          0                  /* false constant                    */

int32 tcl_type;
static int quitMainLoop = 0;
static int errorInCmd = 0;
static struct setl_tcl_interpreters *interp_list;

static void internal_destructor(struct setl_tcl *spec)
{

/*
   if ((spec!=NULL)&&((spec->type&65535)==tcl_type))
      regfree(&spec->r);
*/

}

string_h_ptr_type setl2_string(SETL_SYSTEM_PROTO char *s)
{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char *string_char_ptr, *string_char_end;
int slen;

   slen = strlen(s);
   get_string_header(string_hdr);
   string_hdr->s_use_count = 1;
   string_hdr->s_hash_code = -1;
   string_hdr->s_length = 0;
   string_hdr->s_head = string_hdr->s_tail = NULL;
   string_char_ptr = string_char_end = NULL;

   /* copy the source string */

   while (slen-->0) {

      if (string_char_ptr == string_char_end) {

         get_string_cell(string_cell);
         if (string_hdr->s_tail != NULL)
            (string_hdr->s_tail)->s_next = string_cell;
         string_cell->s_prev = string_hdr->s_tail;
         string_cell->s_next = NULL;
         string_hdr->s_tail = string_cell;
         if (string_hdr->s_head == NULL)
            string_hdr->s_head = string_cell;
         string_char_ptr = string_cell->s_cell_value;
         string_char_end = string_char_ptr + STR_CELL_WIDTH;

      }

      *string_char_ptr++ = *s++;
      string_hdr->s_length++;

   }
   return string_hdr;
}


static PyObject *
setl_pass(self, args)
        PyObject *self; /* Not used */
        PyObject *args;
{
char *command;
int rlen;

	if (!PyArg_ParseTuple(args, "s", &command))
	   return NULL;
	   
	if ((rlen=strlen(command))>=result_len) {
		free(python_result);
		python_result=(char *)malloc(rlen+1);
		if (python_result==NULL) return Py_BuildValue("i",1);
		result_len=rlen;
	}
	strcpy(python_result,command);
		

	return Py_BuildValue("i", 0);
	           

}

static PyMethodDef setl_methods[] = {
        {"pass_string",         setl_pass,      METH_VARARGS},
        {NULL,          NULL}           /* sentinel */
};



SETL_API int32 PYTHON__INIT(
   SETL_SYSTEM_PROTO_VOID)
{
   interp_list=NULL;
   
   tcl_type=register_type(SETL_SYSTEM "python",internal_destructor);
   if (tcl_type==0) return 1;
  
   python_result=(char *)malloc(result_len+1);
   if (python_result==NULL) return 1;
   strcpy(python_result,"empty");
	
#ifdef macintosh
	PyMac_Initialize();
#else
	Py_Initialize();
#endif

   PyImport_AddModule("setl");
   Py_InitModule("setl", setl_methods);

   return 0;

}

SETL_API int32 PYTHON__END(
   SETL_SYSTEM_PROTO_VOID)
{
struct setl_tcl_interpreters *p;
int count;
  p=interp_list;
	while (p) {
		//     printf("Ready to destroy...\n");

    // Tcl_Eval(p->interp,"destroy .");
  
      // printf("Ready to delete...\n");

	//	 Tcl_DeleteInterp(p->interp);	

 		//  printf("Removed 1 interpreter\n");

			p=p->next;
			free(p);
	}
	interp_list=NULL;
	//Py_Exit(0);
}


SETL_API void PYTHON_CREATE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct setl_tcl *A; /* w */ 
/*
 */
static int done=0;
/*
 */
struct setl_tcl_interpreters *temp;

   A = (struct setl_tcl *)(malloc(sizeof(struct setl_tcl)));

   A->use_count = 0;
   A->type = tcl_type;

   A->interp = 0; //Tcl_CreateInterp();
   // Add the interpreter to the active list...
	 temp=(struct setl_tcl_interpreters*)malloc(sizeof(struct setl_tcl_interpreters));
	 temp->interp=A->interp;
	 temp->next= interp_list;
	 interp_list=temp;
  
   //if (Tcl_AppInit(A->interp) != TCL_OK) {
//	
//	    unmark_specifier(target);
  //    target->sp_form = ft_omega;
    //  return;

   //}



   unmark_specifier(target);
   target->sp_form = ft_opaque;
   target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)A;

}



SETL_API void PYTHON_EXEC(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct setl_tcl *A;
string_h_ptr_type string_hdr;          /* root of string value              */
string_c_ptr_type string_cell;         /* string cell                       */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
char *key;                             /* system key                        */
char *s, *t;                           /* temporary looping variables       */
int result;

   /* convert the key to a C character string */

   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"exec",
            abend_opnd_str(SETL_SYSTEM argv));

   string_hdr = argv[0].sp_val.sp_string_ptr;

   key = (char *)malloc((size_t)(string_hdr->s_length + 2));
   if (key == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   t = key;
   for (string_cell = string_hdr->s_head;
        string_cell != NULL;
        string_cell = string_cell->s_next) {

      for (s = string_cell->s_cell_value;
           t < key + string_hdr->s_length &&
              s < string_cell->s_cell_value + STR_CELL_WIDTH;
           *t++ = *s++);

   }
   *t++ = '\n';
   *t = '\0';


	PyRun_SimpleString(key);


   
  // result=Tcl_Eval(A->interp,key);
   free(key);
  // if (result==TCL_ERROR) {
      unmark_specifier(target);
      target->sp_form = ft_omega;
  // } 

   //unmark_specifier(target);
   //target->sp_form = ft_string;
   //target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM A->interp->result);

}


SETL_API void PYTHON_GETSTRING(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct setl_tcl *A;
string_h_ptr_type string_hdr;          /* root of string value              */
string_c_ptr_type string_cell;         /* string cell                       */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
char *key;                             /* system key                        */
char *s, *t;                           /* temporary looping variables       */
int result;

  
  
   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM python_result);

}
