/*
\*/


/* SETL2 system header files */

#include "macros.h"

#include "regex.h"

struct setlrx {
   int32 use_count;
   int32 type;
   regex_t r;
};


/* constants */

#define YES         1                  /* true constant                     */
#define NO          0                  /* false constant                    */

static int32 rx_type;

static void internal_destructor(struct setlrx *spec)
{

   if ((spec!=NULL)&&((spec->type&65535)==rx_type))
      rx_regfree(&spec->r);

}

#ifdef MACINTOSH
int bcmp(char *s1, char *s2, int n)	{
		return memcmp (s1,s2,n);
}
#endif

SETL_API int32 RX__INIT(
   SETL_SYSTEM_PROTO_VOID)
{
   rx_type=register_type(SETL_SYSTEM "regular expressions",internal_destructor);
   if (rx_type==0) return 1;
   return 0;

}


SETL_API void REGCOMP(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct setlrx *A; /* w */ 
int flags;
string_h_ptr_type string_hdr;          /* root of string value              */
string_c_ptr_type string_cell;         /* string cell                       */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
char *key;                             /* system key                        */
char *s, *t;                           /* temporary looping variables       */

specifier return1;
int result;



   if (argv[1].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",2,"regcomp",
            abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"regcomp",
         abend_opnd_str(SETL_SYSTEM argv+2));

   flags = (argv[2].sp_val.sp_short_value);

   string_hdr = argv[1].sp_val.sp_string_ptr;

   key = (char *)malloc((size_t)(string_hdr->s_length + 1));
   if (key == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   t = key;
   for (string_cell = string_hdr->s_head;
        string_cell != NULL;
        string_cell = string_cell->s_next) {

      for (s = string_cell->s_cell_value;
           t < key + string_hdr->s_length &&
              s < string_cell->s_cell_value + STR_CELL_WIDTH;
           *t++ = *s++);

   }
   *t = '\0';

   A = (struct setlrx *)(malloc(sizeof(struct setlrx)));

   A->use_count = 0;
   A->type = rx_type;

   result = rx_regcomp(&A->r,key,flags);

   free(key);

   unmark_specifier(target);
   target->sp_form = ft_short;
   target->sp_val.sp_short_value = result;

   return1.sp_form = ft_opaque;
   return1.sp_val.sp_opaque_ptr = (opaque_item_ptr_type)A;
   push_pstack(&return1);

}

SETL_API void REGEXEC(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct setlrx *A; /* w */ 
int flags;
string_h_ptr_type string_hdr;          /* root of string value              */
string_c_ptr_type string_cell;         /* string cell                       */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
char *key;                             /* system key                        */
char *r, *t;                           /* temporary looping variables       */
TUPLE_CONSTRUCTOR(ca)
TUPLE_CONSTRUCTOR(cb)
specifier s;
specifier return1;
int result;
regmatch_t regs[128];
int i;


   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=rx_type))
      abend(SETL_SYSTEM msg_bad_arg,"regular expression",1,"regexec",
         abend_opnd_str(SETL_SYSTEM argv+0));

   A = (struct setlrx *)(argv[0].sp_val.sp_opaque_ptr);


   if (argv[1].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",2,"regcomp",
            abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",3,"regcomp",
         abend_opnd_str(SETL_SYSTEM argv+2));

   flags = (argv[2].sp_val.sp_short_value);

   string_hdr = argv[1].sp_val.sp_string_ptr;

   key = (char *)malloc((size_t)(string_hdr->s_length + 1));
   if (key == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   t = key;
   for (string_cell = string_hdr->s_head;
        string_cell != NULL;
        string_cell = string_cell->s_next) {

      for (r = string_cell->s_cell_value;
           t < key + string_hdr->s_length &&
              r < string_cell->s_cell_value + STR_CELL_WIDTH;
           *t++ = *r++);

   }
   *t = '\0';
  
   result = rx_regexec(&(A->r),key,128,regs,flags);

   free(key);

   TUPLE_CONSTRUCTOR_BEGIN(ca);
   
   if (result==0) {
      i=0;
      while ((i<128)&&(regs[i].rm_so!=-1)) {

        TUPLE_CONSTRUCTOR_BEGIN(cb);

           s.sp_form = ft_short;
           s.sp_val.sp_short_value = regs[i].rm_so+1;
           TUPLE_ADD_CELL(cb,&s);

           s.sp_form = ft_short;
           s.sp_val.sp_short_value = regs[i].rm_eo+1;
           TUPLE_ADD_CELL(cb,&s);

        TUPLE_CONSTRUCTOR_END(cb);

        s.sp_form = ft_tuple;
        s.sp_val.sp_tuple_ptr = TUPLE_HEADER(cb);
        TUPLE_ADD_CELL(ca,&s);

        i++;
      }
  
  }
  TUPLE_CONSTRUCTOR_END(ca);

   return1.sp_form = ft_tuple;
   return1.sp_val.sp_tuple_ptr = TUPLE_HEADER(ca);
   push_pstack(&return1);

   unmark_specifier(target);
   target->sp_form = ft_short;
   target->sp_val.sp_short_value = result;

}

string_h_ptr_type setl2_string(SETL_SYSTEM_PROTO char *s)
{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char *string_char_ptr, *string_char_end;
int slen;

   slen = strlen(s);
   get_string_header(string_hdr);
   string_hdr->s_use_count = 1;
   string_hdr->s_hash_code = -1;
   string_hdr->s_length = 0;
   string_hdr->s_head = string_hdr->s_tail = NULL;
   string_char_ptr = string_char_end = NULL;

   /* copy the source string */

   while (slen-->0) {

      if (string_char_ptr == string_char_end) {

         get_string_cell(string_cell);
         if (string_hdr->s_tail != NULL)
            (string_hdr->s_tail)->s_next = string_cell;
         string_cell->s_prev = string_hdr->s_tail;
         string_cell->s_next = NULL;
         string_hdr->s_tail = string_cell;
         if (string_hdr->s_head == NULL)
            string_hdr->s_head = string_cell;
         string_char_ptr = string_cell->s_cell_value;
         string_char_end = string_char_ptr + STR_CELL_WIDTH;

      }

      *string_char_ptr++ = *s++;
      string_hdr->s_length++;

   }
   return string_hdr;
}

SETL_API void REGERROR(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct setlrx *A; /* w */ 
int rx_error;
int result;
char *e;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"regerror",
         abend_opnd_str(SETL_SYSTEM argv+0));

   rx_error = (argv[0].sp_val.sp_short_value);

   if ((argv[1].sp_form != ft_opaque)||
       (((argv[1].sp_val.sp_opaque_ptr->type)&65535)!=rx_type))
      abend(SETL_SYSTEM msg_bad_arg,"regular expression",2,"regerror",
         abend_opnd_str(SETL_SYSTEM argv+1));

   A = (struct setlrx *)(argv[0].sp_val.sp_opaque_ptr);


   result = rx_regerror(rx_error,&(A->r),NULL,0);
   e = (char *)malloc(result);
   if (e == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   rx_regerror(rx_error,&(A->r),e,result);

   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM e);

   free(e);

}
