#include <tk.h>
#include <tcl.h>

typedef struct {
	Tk_Window tkwin;
	Display *display;
	Tcl_Interp *interp;
	int x, y;
	int size;
	int borderWidth;
	Tk_3DBorder bgBorder;
	Tk_3DBorder fgBorder;
	int relief;
	GC gc;
	int updatePending;
} Rastport;

static int RastportCmd(ClientData clientData,
		Tcl_Interp *interp, int argc, char *argv[]) 
{
	Tk_Window main = (Tk_Window) clientData;
	Rastport *rastportPtr;
	Tk_Window tkwin;
	
	if (argc < 2) {
		Tcl_AppendResult(interp, "wrong # args: should be \"",
			argv[0], " pathname ?options?\"", (char *) NULL);
		return TCL_ERROR;
	}

	tkwin = Tk_CreateWindowFromPath(interp, main, argv[1], (char *) NULL);
	if (tkwin == NULL) {
		return TCL_ERROR;
	}
	Tk_SetClass(tkwin, "Rastport");
	
	rastportPtr = (Rastport *) malloc(sizeof(Rastport));
	rastportPtr->tkwin = tkwin;
	rastportPtr->display = Tk_Display(tkwin);
	rastportPtr->interp = interp;
	rastportPtr->x = rastportPtr->y = 0;
	rastportPtr->size = 20;
	rastportPtr->borderWidth = 0;
	rastportPtr->bgBorder = rastportPtr->fgBorder = NULL;
	rastportPtr->relief = TK_RELIEF_FLAT;
	rastportPtr->gc = None;
	rastportPtr->updatePending = 0;
	
	Tk_CreateEventHandler(tkwin,
			ExposureMask|StructureNotifyMask, RastportEventProc,
			(ClientData) rastportPtr);
	Tcl_CreateCommnd(interp, Tk_PathName(tkwin),
		RastportWidgetCmd, (ClientData) rastportPtr,
		(Tcl_CmdDeleteProc *) NULL);
	if (RastportConfigure(interp, rastportPtr, argc-2, argv+2, 0)
			!= TCL_OK) {
		Tk_DestroyWindow(rastportPtr->tkwin);
		return TCL_ERROR;
	}
	interp->result = Tk_PathName(tkwin);
	return TCL_OK;
}

int Rastport_Init(Tcl_Interp *interp) 
{
	Tcl_CreateCommand(interp, "Rastport", RastportCmd,
		(ClientData) Tk_MainWindow(interp),
		(Tcl_CmdDeleteProc *) NULL);
		
	return TCL_OK;
}

static int RastportConfigure(Tcl_Interp *interp,
		Rastport *rastportPtr, int argc, char *argv[], int flags)
{
	if (Tk_ConfigureWidget(interp, rastportPtr->tkwin, configSpecs, 
			argc, argv, (char *) rastportPtr, flags) != TCL_OK) {
		return TCL_ERROR;
	}
	Tk_SetWindowBackground(rastportPtr->tkwin,
			Tk_3DBorderColor(rastportPtr->bgBorder)->pixel);
	if (rastportPtr->gc == None) {
		XGCValues gcValues;
		gcValues.function = GXcopy;
		GCValues.graphics_exposures = False;
		rastportPtr->gc = Tk_GetGC(squarePtr->tkwin,
			GCFunction|GCGraphicsExposures, &gcValues);
	}	
	Tk_GeometryRequest(rastportPtr->tkwin, 200, 150);
	Tk_SetInternalBorder(rastportPtr->tkwin,
			rastportPtr->borderWidth);
	if (!rastportPtr->updatePending) {
		Tk_DoWhenIdle(RastportDisplay, (ClientData) rastportPtr);
		rastportPtr->updatePending = 1;
	}
	return TCL_OK;
}

static int RastportWidgetCmd(ClientData clientData,
		Tcl_Interp *interp, int argc, char *argv[]) 
{
	Rastport *rastportPtr = (Rastport *) clientData;
	int result = TCL_OK;
	
	if (argc < 2) {
		Tcl_AppendResult(interp, "wrong # args: should be \"",
				argv[0], " option ?arg arg ...?\"",
				(char *) NULL);
		return TCL_ERROR;
	}

	Tk_Preserve((ClientData) rastportPtr);
	if (strcmp(argv[1], "configure") == 0) {
		if (argc == 2) {
			result = Tk_ConfigureInfo(interp, rastportPtr->tkwin,
				configSpecs, (char *) rastportPtr,
				(char *) NULL, 0);
		} else if (argc == 3) {
			result = Tk_ConfigureInfo(interp, rastportPtr->tkwin,
				configSpecs, (char *) rastportPtr,
				(argv[2], 0);
		} else {
			result = RastportConfigure(interp, rastportPtr,
				argc - 2, argv+2, TK_CONFIG_ARGV_ONLY);
		}
	} else if (strcmp(argv[1], "position") == 0) {
		if ((argc != 2) && (argc != 4)) {
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					argv[0], " position ?x y?\"", (char *) NULL);
			goto error;
		}
		if (argc == 4) {
			if ((Tk_GetPixels(interp, rastportPtr->tkwin, argv[2],
					&rastportPtr->x) != TCL_OK) ||
					(Tk_GetPixels(interp, rastportPtr->tkwin, 
					argv[3], &rastportPtr->y) != TCL_OK)) {
				goto error;
			}
			KeepInWindow(rastportPtr);
		}
		sprintf(interp->result, "%d %d", rastportPtr->x,
				rastportPtr->y);
	} else if (strcmp(argv[1], "size") == 0) {
		if ((argc != 2) && (argc != 3)) {
			Tcl_AppendResult(interp, "wrong # args: should be \"",
				argv[0], " size ?amount?\"", (char *) NULL);
			goto error;
		}
		if (argc == 3) {
			int i;
			if (Tk_GetPixels(interp, squarePtr->tkwin, argv[2], &i) != TCL_OK) {
				goto error;
			}
			if ((i <= 0) || (i > 100)) {
				Tcl_AppendResult(interp, "bad size \"", argv[2], "\"", (char *) NULL);
				goto error;
			}
			rastportPtr->size = i;
			KeepInWindow(rastportPtr);
		}
		sprintf(interp->result, "%d", rastportPtr->size);
	} else {
		Tcl_AppendResult(interp, "bad option \"", argv[1], 
				"\": must be configure, position or size",
				(char *) NULL);
		goto error;
	}
	if (!squarePtr->updatePending) {
		Tk_DoWhenIdle(RastportDisplay, (ClientData) rastportPtr);
		rastportPtr->updatePending = 1;
	}
	Tk_Release((ClientData) squarePtr);
	return result;

error:
	Tk_Release((ClientData) rastportPtr);
	return TCL_ERROR;
}

static void KeepInWindow(Rastport *rastportPtr)
{
	int gap, bd;
	bd = 0;
	if (rastportPtr->relief != TK_RELIEF_FLAT) {
		bd = rastportPtr->borderWidth;
	}
}