/*
\*/


/* SETL2 system header files */



#include "macros.h"

EXTERNAL  int hard_stop;

#ifdef PLUGIN
#define fprintf plugin_fprintf
#define printf plugin_printf
#endif

#include <tcl.h>
#include <tk.h>

/* 
 * Tk extensions by GDM 
 */
#include "tkMimage.h" 
#include "tkCanvasSave.h"
/*
 */
 
#define TKMAJORMINOR (TK_MAJOR_VERSION*1000 + TK_MINOR_VERSION)

#ifdef macintosh

#include "tkMacInt.h"
#include "tclMac.h"

/*
** Additional cruft needed by Tcl/Tk on the Mac.
** This is for Tcl 7.5 and Tk 4.1 (patch release 1).
*/

/* ckfree() expects a char* */
#define FREECAST (char *)

#include <Events.h> /* For EventRecord */

typedef int (*TclMacConvertEventPtr)(EventRecord *eventPtr);
/* They changed the name... */
#if TKMAJORMINOR < 8000
#define Tcl_MacSetEventProc TclMacSetEventProc
#endif
void Tcl_MacSetEventProc (TclMacConvertEventPtr procPtr);
int TkMacConvertEvent (EventRecord *eventPtr);

static int PyMacConvertEvent (EventRecord *eventPtr);

#include <SIOUX.h>
extern int SIOUXIsAppWindow(WindowPtr);

#endif

struct setl_tcl {
   int32 use_count;
   int32 type;
   Tcl_Interp *interp;
};

struct setl_tcl_interpreters {
   Tcl_Interp *interp;
   struct setl_tcl_interpreters *next;
};

struct setl_callback {
   char *setl_instance;
   specifier s;
};

/* constants */

#define YES         1                  /* true constant                     */
#define NO          0                  /* false constant                    */

int32 tcl_type;
static int quitMainLoop = 0;
static int errorInCmd = 0;
static struct setl_tcl_interpreters *interp_list;

static void internal_destructor(struct setl_tcl *spec)
{

/*
   if ((spec!=NULL)&&((spec->type&65535)==tcl_type))
      regfree(&spec->r);
*/

}

string_h_ptr_type setl2_string(SETL_SYSTEM_PROTO char *s)
{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char *string_char_ptr, *string_char_end;
int slen;

   slen = strlen(s);
   get_string_header(string_hdr);
   string_hdr->s_use_count = 1;
   string_hdr->s_hash_code = -1;
   string_hdr->s_length = 0;
   string_hdr->s_head = string_hdr->s_tail = NULL;
   string_char_ptr = string_char_end = NULL;

   /* copy the source string */

   while (slen-->0) {

      if (string_char_ptr == string_char_end) {

         get_string_cell(string_cell);
         if (string_hdr->s_tail != NULL)
            (string_hdr->s_tail)->s_next = string_cell;
         string_cell->s_prev = string_hdr->s_tail;
         string_cell->s_next = NULL;
         string_hdr->s_tail = string_cell;
         if (string_hdr->s_head == NULL)
            string_hdr->s_head = string_cell;
         string_char_ptr = string_cell->s_cell_value;
         string_char_end = string_char_ptr + STR_CELL_WIDTH;

      }

      *string_char_ptr++ = *s++;
      string_hdr->s_length++;

   }
   return string_hdr;
}


static void
SetlTimer(clientData)
        ClientData clientData;               /* Is (self, func) */
{
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */

#ifdef TSAFE
plugin_item_ptr_type plugin_instance;

   plugin_instance = ((struct setl_callback *)clientData)->setl_instance;
#endif

   save_callback.sp_form = ((struct setl_callback *)clientData)->s.sp_form;
   save_callback.sp_val.sp_biggest = ((struct setl_callback *)clientData)->s.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  0,YES,NO,0);

   ((struct setl_callback *)clientData)->s.sp_form = save_callback.sp_form;
   ((struct setl_callback *)clientData)->s.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;

}

static int
SetlCommand(clientData, interp, argc, argv)
        ClientData clientData;               /* Is (self, func) */
        Tcl_Interp *interp;
        int argc;
        char *argv[];
{
specifier save_callback;               /* saved callback handler            */
specifier spare;                       /* spare specifier                   */
int i,np;
#ifdef TSAFE
plugin_item_ptr_type plugin_instance;
#endif
TUPLE_CONSTRUCTOR(ca)
specifier param;                       /* spare specifier                   */
specifier s;

#ifdef TSAFE
   plugin_instance = ((struct setl_callback *)clientData)->setl_instance;
#endif
	/*
	 printf("Argc = %d\n",argc);
	 for (i=0;i<argc;i++) {
	  	printf("Argv[%d]=%s\n",i,argv[i]);
	 
	 }
	*/
	 np=0;
	 if (argc>1) {
	    np=1;
	    TUPLE_CONSTRUCTOR_BEGIN(ca);
      for (i=1;i<argc;i++) {
    
		
   	      s.sp_form = ft_string;
   	      s.sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM argv[i]);
   	      TUPLE_ADD_CELL(ca,&s);
   	      
      }
      TUPLE_CONSTRUCTOR_END(ca);
      
      param.sp_form = ft_tuple;
      param.sp_val.sp_tuple_ptr = TUPLE_HEADER(ca);
      
   		push_pstack(&param);

      
	 }
   save_callback.sp_form = ((struct setl_callback *)clientData)->s.sp_form;
   save_callback.sp_val.sp_biggest = ((struct setl_callback *)clientData)->s.sp_val.sp_biggest;
   spare.sp_form = ft_omega;
   call_procedure(SETL_SYSTEM &spare,
                  &save_callback,
                  NULL,
                  np,YES,NO,0);

   ((struct setl_callback *)clientData)->s.sp_form = save_callback.sp_form;
   ((struct setl_callback *)clientData)->s.sp_val.sp_biggest = save_callback.sp_val.sp_biggest;
  // printf("Return from command!!\n");
   return TCL_OK;
}


SETL_API int32 TK__INIT(
   SETL_SYSTEM_PROTO_VOID)
{
   interp_list=NULL;
   
   tcl_type=register_type(SETL_SYSTEM "tcltk",internal_destructor);
   if (tcl_type==0) return 1;

  
#ifdef macintosh
	/*
	** Part of this code is stolen from MacintoshInit in tkMacAppInit.
	** Most of the initializations in that routine (toolbox init calls and
	** such) have already been done for us, so we only need these.
	*/
	
	InitGraf(&qd.thePort);
	InitFonts();
	InitWindows();
	InitMenus();
	TEInit();
	InitDialogs(nil);
	InitCursor();

	
#if TKMAJORMINOR >= 8000
	tcl_macQdPtr = &qd;
#endif

	Tcl_MacSetEventProc(PyMacConvertEvent);

#if GENERATINGCFM
	mac_addlibresources();
#endif /* GENERATINGCFM */
#endif /* macintosh */
   
   return 0;

}

SETL_API int32 TK__END(
   SETL_SYSTEM_PROTO_VOID)
{
struct setl_tcl_interpreters *p;
int count;

  p=interp_list;
	while (p) {
     	 //printf("Ready to destroy...\n");
     	 //Tcl_Eval(p->interp,"destroy .");
         //printf("Ready to delete...\n");
	 Tcl_DeleteInterp(p->interp);	
 	 //	  printf("Removed 1 interpreter\n");
	 p=p->next;
	 free(p);
	}
	interp_list=NULL;
}


SETL_API void TK_CREATE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct setl_tcl *A; /* w */ 
int status;
/*
 */
static int done=0;
/*
 */
struct setl_tcl_interpreters *temp;

   A = (struct setl_tcl *)(malloc(sizeof(struct setl_tcl)));

   A->use_count = 0;
   A->type = tcl_type;

   A->interp = Tcl_CreateInterp();
   
   Tcl_FindExecutable(NULL); /* Needed for TCL 8.4.1 */

   // Add the interpreter to the active list...
	 temp=(struct setl_tcl_interpreters*)malloc(sizeof(struct setl_tcl_interpreters));
	 temp->interp=A->interp;
	 temp->next= interp_list;
	 interp_list=temp;
  
#if defined(macintosh) && TKMAJORMINOR >= 8000
	/* This seems to be needed since Tk 8.0 */
	
	ClearMenuBar();

/*
 */
if (done==0) TkMacInitMenus(A->interp);
/*
 */

#endif
/*
 */
done=1;
/*
 */

   Tcl_DeleteCommand(A->interp, "exit");
   Tcl_DeleteCommand(A->interp, "tkerror");
  
   Tcl_SetVar(A->interp, "tcl_interactive", "1", TCL_GLOBAL_ONLY);


   if ((status=Tcl_AppInit(A->interp)) != TCL_OK) {
      printf("error : status = %d (%s)\n",status,Tcl_GetStringResult(A->interp));
	   
	  unmark_specifier(target);
      target->sp_form = ft_omega;
      return;

   }

/* 
 * Tk extensions by GDM 
 */
	Rastport_Init(A->interp);			// rastport widget
	//registerMimageType(A->interp);		// mimage type

#ifdef MACINTOSH
	
	registerCanvasSave(A->interp);
	registerCanvasISave(A->interp);
#endif
	
/*
 */

   unmark_specifier(target);
   target->sp_form = ft_opaque;
   target->sp_val.sp_opaque_ptr = (opaque_item_ptr_type)A;

}

SETL_API int32 tk_event_source_function(SETL_SYSTEM_PROTO specifier *callback)
{
	int err = -1;

	quitMainLoop = 0;
	if (Tk_GetNumMainWindows() > 0 && !hard_stop && !quitMainLoop && !errorInCmd) {

		err = Tcl_DoOneEvent(TCL_DONT_WAIT);
	}
	
	quitMainLoop = 0;

	if (errorInCmd) {
		errorInCmd = 0;
		err = -1;
	}
	
	return err;
}

SETL_API void TK_GET_EVENT_SOURCE_FUNCTION(  
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
	unsigned long event_source_function_value;

	event_source_function_value = (unsigned long)tk_event_source_function;

	unmark_specifier(target);
	
	target->sp_form = ft_short;
	target->sp_val.sp_short_value = event_source_function_value;
}

SETL_API void TK_HANDLE_EVENT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
	int result;
	
	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"regular expression",1,"mainloop",
				abend_opnd_str(SETL_SYSTEM argv+0));


	result = tk_event_source_function(SETL_SYSTEM NULL);

	if (result < 0)
		goto end;

	unmark_specifier(target);
	target->sp_form = ft_short;
	target->sp_val.sp_short_value = result;
	
	return;
		
end:
   unmark_specifier(target);
   target->sp_form = ft_omega;

}
SETL_API void TK_MAINLOOP(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct setl_tcl *A;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
      abend(SETL_SYSTEM msg_bad_arg,"regular expression",1,"mainloop",
         abend_opnd_str(SETL_SYSTEM argv+0));

   A = (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);

   quitMainLoop = 0;

	while (Tk_GetNumMainWindows() > 0 &&
		   !hard_stop &&
	       !quitMainLoop &&
	       !errorInCmd)
	{
		int result;

		result = Tcl_DoOneEvent(0);

		if (result < 0)
			break;
	}
	
	quitMainLoop = 0;

	if (errorInCmd) {
		errorInCmd = 0;
		goto end;
	}
	
end:
   unmark_specifier(target);
   target->sp_form = ft_omega;

}

SETL_API void TK_DOONEEVENT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
	int result = -1;
	struct setl_tcl *A;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"regular expression",1,"dooneevent",
				abend_opnd_str(SETL_SYSTEM argv+0));

	A = (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);

	if (Tk_GetNumMainWindows() > 0 && !hard_stop && !quitMainLoop && !errorInCmd) 
		result = Tcl_DoOneEvent(0);

	unmark_specifier(target);
	target->sp_form = ft_short;
	target->sp_val.sp_short_value = result;
}

SETL_API void TK_DESTROY(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct setl_tcl *A;
struct setl_tcl_interpreters *p,*q;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
      abend(SETL_SYSTEM msg_bad_arg,"regular expression",1,"destroy",
         abend_opnd_str(SETL_SYSTEM argv+0));

   A = (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);

	 // Remove it from the active list...
	 if (interp_list) {
	 q=NULL;
	 p=interp_list;
	   while (p) {
	 	  	if (p->interp==A->interp) {
	 			    if (q==NULL) {
	 			    	 interp_list=p->next;
               free(p);
	 			    } else {
	 			    	 q->next=p->next;
	 			    	 free(p);
	 			    }
	 	  		  break;
	 	  	}
	      q=p;
	 		  p=p->next;
	   }
   }
   Tcl_DeleteInterp(A->interp);
 
   unmark_specifier(target);
   target->sp_form = ft_omega;
}

SETL_API void TK_CALL(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct setl_tcl *A;
string_h_ptr_type string_hdr;          /* root of string value              */
string_c_ptr_type string_cell;         /* string cell                       */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
char *key;                             /* system key                        */
char *s, *t;                           /* temporary looping variables       */
int result;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
      abend(SETL_SYSTEM msg_bad_arg,"regular expression",1,"tk_call",
         abend_opnd_str(SETL_SYSTEM argv+0));

   A = (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);

   /* convert the key to a C character string */

   if (argv[1].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",2,"eval",
            abend_opnd_str(SETL_SYSTEM argv+1));

   string_hdr = argv[1].sp_val.sp_string_ptr;

   key = (char *)malloc((size_t)(string_hdr->s_length + 1));
   if (key == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   t = key;
   for (string_cell = string_hdr->s_head;
        string_cell != NULL;
        string_cell = string_cell->s_next) {

      for (s = string_cell->s_cell_value;
           t < key + string_hdr->s_length &&
              s < string_cell->s_cell_value + STR_CELL_WIDTH;
           *t++ = *s++);

   }
   *t = '\0';

   
   result=Tcl_Eval(A->interp,key);
   free(key);
   if (result==TCL_ERROR) {
      unmark_specifier(target);
      target->sp_form = ft_omega;
   } 

   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM A->interp->result);

}

SETL_API void TK_QUIT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{

   quitMainLoop = 1;

}






SETL_API void TK_CREATECOMMAND(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
struct setl_tcl *A;
string_h_ptr_type string_hdr;          /* root of string value              */
string_c_ptr_type string_cell;         /* string cell                       */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
char *key;                             /* system key                        */
char *s, *t;                           /* temporary looping variables       */
void *result;
struct setl_callback *clientdata;

   if ((argv[0].sp_form != ft_opaque)||
       (((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
      abend(SETL_SYSTEM msg_bad_arg,"tk object",1,"createcommand",
         abend_opnd_str(SETL_SYSTEM argv+0));

   A = (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);

   /* convert the key to a C character string */

   if (argv[1].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",2,"createcommand",
            abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_proc)
      abend(SETL_SYSTEM msg_bad_arg,"procedure",3,"createcommand",
         abend_opnd_str(SETL_SYSTEM argv+2));

   clientdata = (struct setl_callback *)malloc((size_t)(sizeof(struct setl_callback)));
   if (clientdata == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   clientdata->s.sp_form = ft_proc;
   clientdata->s.sp_val.sp_proc_ptr = argv[2].sp_val.sp_proc_ptr;
#ifdef TSAFE
   clientdata->setl_instance = SETL_SYSTEM_VOID;
#endif

   string_hdr = argv[1].sp_val.sp_string_ptr;

   key = (char *)malloc((size_t)(string_hdr->s_length + 1));
   if (key == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   t = key;
   for (string_cell = string_hdr->s_head;
        string_cell != NULL;
        string_cell = string_cell->s_next) {

      for (s = string_cell->s_cell_value;
           t < key + string_hdr->s_length &&
              s < string_cell->s_cell_value + STR_CELL_WIDTH;
           *t++ = *s++);

   }
   *t = '\0';

   
   result=Tcl_CreateCommand(A->interp,key,SetlCommand,(ClientData)clientdata,
	                    (Tcl_CmdDeleteProc *)NULL);
   free(key);
   if (result==NULL) {
      unmark_specifier(target);
      target->sp_form = ft_omega;
   } 

   unmark_specifier(target);
   target->sp_form = ft_short;
   target->sp_val.sp_short_value = 0;

}

SETL_API void TK_CREATETIMER(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int interval;
void *result;
struct setl_callback *clientdata;
Tcl_TimerToken token;

   if (argv[0].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"createcommand",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form != ft_proc)
      abend(SETL_SYSTEM msg_bad_arg,"procedure",2,"createcommand",
         abend_opnd_str(SETL_SYSTEM argv+1));

   clientdata = (struct setl_callback *)malloc((size_t)(sizeof(struct setl_callback)));
   if (clientdata == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   clientdata->s.sp_form = ft_proc;
   clientdata->s.sp_val.sp_proc_ptr = argv[1].sp_val.sp_proc_ptr;
#ifdef TSAFE
   clientdata->setl_instance = SETL_SYSTEM_VOID;
#endif

   interval = argv[0].sp_val.sp_short_value;

   token = Tcl_CreateTimerHandler(interval,SetlTimer,(ClientData)clientdata);

   unmark_specifier(target);
   target->sp_form = ft_omega;

}

SETL_API void TK_IDLECALLBACK(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
int interval;
void *result;
struct setl_callback *clientdata;
Tcl_TimerToken token;

   if (argv[0].sp_form != ft_proc)
      abend(SETL_SYSTEM msg_bad_arg,"procedure",1,"createcommand",
         abend_opnd_str(SETL_SYSTEM argv));

   clientdata = (struct setl_callback *)malloc((size_t)(sizeof(struct setl_callback)));
   if (clientdata == NULL)
      giveup(SETL_SYSTEM msg_malloc_error);

   clientdata->s.sp_form = ft_proc;
   clientdata->s.sp_val.sp_proc_ptr = argv[0].sp_val.sp_proc_ptr;
#ifdef TSAFE
   clientdata->setl_instance = SETL_SYSTEM_VOID;
#endif


   Tk_DoWhenIdle(SetlTimer,(ClientData)clientdata);

   unmark_specifier(target);
   target->sp_form = ft_omega;

}






#ifdef macintosh

/*
** Anyone who embeds Tcl/Tk on the Mac must define panic().
*/

/*
void
panic(char * format, ...)
{
	va_list varg;
	
	va_start(varg, format);
	
	vfprintf(stderr, format, varg);
	(void) fflush(stderr);
	
	va_end(varg);

	Py_FatalError("Tcl/Tk panic");
}
*/

/*
** Pass events to SIOUX before passing them to Tk.
*/

static int
PyMacConvertEvent(eventPtr)
	EventRecord *eventPtr;
{
	WindowPtr frontwin;
	/*
	** Sioux eats too many events, so we don't pass it everything.
	** We always pass update events to Sioux, and we only pass other events if
	** the Sioux window is frontmost. This means that Tk menus don't work
	** in that case, but at least we can scroll the sioux window.
	** Note that the SIOUXIsAppWindow() routine we use here is not really
	** part of the external interface of Sioux...
	*/
  
  if ( eventPtr->what == updateEvt) {
  	plugin_event_hook();
	}
	//frontwin = FrontWindow();
	//if ( eventPtr->what == updateEvt || SIOUXIsAppWindow(frontwin) ) {
//		if (SIOUXHandleOneEvent(eventPtr))
//			return 0; /* Nothing happened to the Tcl event queue */
//	}
   return TkMacConvertEvent(eventPtr);
}

#if defined(FUSE_GUSI) && TKMAJORMINOR < 8000
/*
 * For Python we have to override this routine (from TclMacNotify),
 * since we use GUSI for our sockets, not Tcl streams. Hence, we have
 * to use GUSI select to see whether our socket is ready. Note that
 * createfilehandler (above) sets the type to TCL_UNIX_FD for our
 * files and sockets.
 *
 * NOTE: this code was lifted from Tcl 7.6, it may need to be modified
 * for other versions.  */

int
Tcl_FileReady(file, mask)
    Tcl_File file;		/* File handle for a stream. */
    int mask;			/* OR'ed combination of TCL_READABLE,
				 * TCL_WRITABLE, and TCL_EXCEPTION:
				 * indicates conditions caller cares about. */
{
    int type;
    int fd;

    fd = (int) Tcl_GetFileInfo(file, &type);

    if (type == TCL_MAC_SOCKET) {
	return TclMacSocketReady(file, mask);
    } else if (type == TCL_MAC_FILE) {
	/*
	 * Under the Macintosh, files are always ready, so we just 
	 * return the mask that was passed in.
	 */

	return mask;
    } else if (type == TCL_UNIX_FD) {
	fd_set readset, writeset, excset;
	struct timeval tv;
	
	FD_ZERO(&readset);
	FD_ZERO(&writeset);
	FD_ZERO(&excset);
	
	if ( mask & TCL_READABLE ) FD_SET(fd, &readset);
	if ( mask & TCL_WRITABLE ) FD_SET(fd, &writeset);
	if ( mask & TCL_EXCEPTION ) FD_SET(fd, &excset);
	
	tv.tv_sec = tv.tv_usec = 0;
	if ( select(fd+1, &readset, &writeset, &excset, &tv) <= 0 )
		return 0;
	
	mask = 0;
	if ( FD_ISSET(fd, &readset) ) mask |= TCL_READABLE;
	if ( FD_ISSET(fd, &writeset) ) mask |= TCL_WRITABLE;
	if ( FD_ISSET(fd, &excset) ) mask |= TCL_EXCEPTION;

	return mask;
    }
    
    return 0;
}
#endif /* USE_GUSI */


#if GENERATINGCFM

/*
** Additional Mac specific code for dealing with shared libraries.
*/

#include <Resources.h>
#include <CodeFragments.h>

static int loaded_from_shlib = 0;
static FSSpec library_fss;

/*
** If this module is dynamically loaded the following routine should
** be the init routine. It takes care of adding the shared library to
** the resource-file chain, so that the tk routines can find their
** resources.
*/
OSErr pascal
init_tk_shlib(CFragInitBlockPtr data)
{
	__initialize();
	if ( data == nil ) return noErr;
	if ( data->fragLocator.where == kDataForkCFragLocator ) {
		library_fss = *data->fragLocator.u.onDisk.fileSpec;
		loaded_from_shlib = 1;
	} else if ( data->fragLocator.where == kResourceCFragLocator ) {
		library_fss = *data->fragLocator.u.inSegs.fileSpec;
		loaded_from_shlib = 1;
	}
	return noErr;
}

/*
** Insert the library resources into the search path. Put them after
** the resources from the application. Again, we ignore errors.
*/
static
mac_addlibresources()
{
	if ( !loaded_from_shlib ) 
		return;
	(void)FSpOpenResFile(&library_fss, fsRdPerm);
}

#endif /* GENERATINGCFM */

#endif /* macintosh */

#ifdef SPAM
/** Tcl to Python **/

static PyObject *
Tkapp_GetInt(self, args)
	PyObject *self;
	PyObject *args;
{
	char *s;
	int v;

	if (!PyArg_ParseTuple(args, "s", &s))
		return NULL;
	if (Tcl_GetInt(Tkapp_Interp(self), s, &v) == TCL_ERROR)
		return Tkinter_Error(self);
	return Py_BuildValue("i", v);
}

static PyObject *
Tkapp_GetDouble(self, args)
	PyObject *self;
	PyObject *args;
{
	char *s;
	double v;

	if (!PyArg_ParseTuple(args, "s", &s))
		return NULL;
	if (Tcl_GetDouble(Tkapp_Interp(self), s, &v) == TCL_ERROR)
		return Tkinter_Error(self);
	return Py_BuildValue("d", v);
}

static PyObject *
Tkapp_GetBoolean(self, args)
	PyObject *self;
	PyObject *args;
{
	char *s;
	int v;

	if (!PyArg_ParseTuple(args, "s", &s))
		return NULL;
	if (Tcl_GetBoolean(Tkapp_Interp(self), s, &v) == TCL_ERROR)
		return Tkinter_Error(self);
	return Py_BuildValue("i", v);
}

static PyObject *
Tkapp_ExprString(self, args)
	PyObject *self;
	PyObject *args;
{
	char *s;

	if (!PyArg_ParseTuple(args, "s", &s))
		return NULL;
	if (Tcl_ExprString(Tkapp_Interp(self), s) == TCL_ERROR)
		return Tkinter_Error(self);
	return Py_BuildValue("s", Tkapp_Result(self));
}

static PyObject *
Tkapp_ExprLong(self, args)
	PyObject *self;
	PyObject *args;
{
	char *s;
	long v;

	if (!PyArg_ParseTuple(args, "s", &s))
		return NULL;
	if (Tcl_ExprLong(Tkapp_Interp(self), s, &v) == TCL_ERROR)
		return Tkinter_Error(self);
	return Py_BuildValue("l", v);
}

static PyObject *
Tkapp_ExprDouble(self, args)
	PyObject *self;
	PyObject *args;
{
	char *s;
	double v;
	int retval;

	if (!PyArg_ParseTuple(args, "s", &s))
		return NULL;
	PyFPE_START_PROTECT("Tkapp_ExprDouble", return 0)
	retval = Tcl_ExprDouble(Tkapp_Interp(self), s, &v);
	PyFPE_END_PROTECT(retval)
	if (retval == TCL_ERROR)
		return Tkinter_Error(self);
	return Py_BuildValue("d", v);
}

static PyObject *
Tkapp_ExprBoolean(self, args)
	PyObject *self;
	PyObject *args;
{
	char *s;
	int v;

	if (!PyArg_ParseTuple(args, "s", &s))
		return NULL;
	if (Tcl_ExprBoolean(Tkapp_Interp(self), s, &v) == TCL_ERROR)
		return Tkinter_Error(self);
	return Py_BuildValue("i", v);
}



static PyObject *
Tkapp_SplitList(self, args)
	PyObject *self;
	PyObject *args;
{
	char *list;
	int argc;
	char **argv;
	PyObject *v;
	int i;

	if (!PyArg_ParseTuple(args, "s", &list))
		return NULL;

	if (Tcl_SplitList(Tkapp_Interp(self), list, &argc, &argv) == TCL_ERROR)
		return Tkinter_Error(self);

	if (!(v = PyTuple_New(argc)))
		return NULL;
	
	for (i = 0; i < argc; i++) {
		PyObject *s = PyString_FromString(argv[i]);
		if (!s || PyTuple_SetItem(v, i, s)) {
			Py_DECREF(v);
			v = NULL;
			goto finally;
		}
	}

  finally:
	ckfree(FREECAST argv);
	return v;
}

static PyObject *
Tkapp_Split(self, args)
	PyObject *self;
	PyObject *args;
{
	char *list;

	if (!PyArg_ParseTuple(args, "s", &list))
		return NULL;
	return Split(self, list);
}

static PyObject *
Tkapp_Merge(self, args)
	PyObject *self;
	PyObject *args;
{
	char *s = Merge(args);
	PyObject *res = NULL;

	if (s) {
		res = PyString_FromString(s);
		ckfree(s);
	}
	else
		PyErr_SetString(Tkinter_TclError, "merge failed");

	return res;
}


#endif
