/*
\*/


/* SETL2 system header files */


#include "macros.h"

#include <tcl.h>
#include <tk.h>
#include <math.h>

#include "tkrasterport.h"

extern int hard_stop;

#ifdef PLUGIN
#define fprintf plugin_fprintf
#define printf plugin_printf
#endif



/*
 *	Types defined
 */

struct setl_tcl {
   int32 use_count;
   int32 type;
   Tcl_Interp *interp;
};

struct setl_tcl_interpreters {
   Tcl_Interp *interp;
   struct setl_tcl_interpreters *next;
};

/*
 *	Global variables
 */

extern int32 tcl_type;

/*
 *	Prototypes
 */

SETL_API void check_arg(SETL_SYSTEM_PROTO specifier *argv, int param, int type, char *typestr, char *routine);
SETL_API void setl2_string_to_cstring(string_h_ptr_type string_hdr, unsigned char *p, int buffer_len);
SETL_API void TK_GR_PUT(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_PUT_BLEND(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_PUT_ADD(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_PUT_DIF(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_PUT_MUL(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_PUT_DIV(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_PUT_MAX(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_PUT_MIN(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_PUT_POW(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_PUT_AND_ROTATE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_PUT_BLEND_AND_ROTATE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_PUT_ADD_AND_ROTATE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_PUT_DIF_AND_ROTATE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_PUT_MUL_AND_ROTATE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_PUT_DIV_AND_ROTATE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_PUT_MAX_AND_ROTATE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_PUT_MIN_AND_ROTATE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_PUT_POW_AND_ROTATE(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_GET(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_GET_BLEND(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_GET_ADD(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_GET_DIF(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_GET_MUL(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_GET_DIV(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_GET_MAX(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_GET_MIN(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_GR_GET_POW(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
SETL_API void TK_TESTRASTPORT(SETL_SYSTEM_PROTO int argc, specifier *argv, specifier *target);
static float op_sum(float a, float b);
static float op_dif(float a, float b);
static float op_mul(float a, float b);
static float op_div(float a, float b);
static float op_max(float a, float b);
static float op_min(float a, float b);
static float op_pow(float a, float b);

/*
 *	Utilities implementation
 */

void check_arg(SETL_SYSTEM_PROTO specifier *argv, int param, int type, char *typestr, char *routine)
{

   if (argv[param].sp_form != type)
	  abend(SETL_SYSTEM msg_bad_arg, typestr, param+1, 
	  		routine, abend_opnd_str(SETL_SYSTEM argv+param));

}

void setl2_string_to_cstring(string_h_ptr_type string_hdr, 
	unsigned char *p, int buffer_len)
{
	string_c_ptr_type string_cell;	  /* string cell pointer		 */
	unsigned char *t;
	unsigned char *s;

	assert(string_hdr->s_length<=buffer_len);

	t = p;
	for (string_cell = string_hdr->s_head;
		string_cell != NULL;
		string_cell = string_cell->s_next) {

		for (s = string_cell->s_cell_value; t < p + string_hdr->s_length &&
				s < (unsigned char *)(string_cell->s_cell_value + STR_CELL_WIDTH);) { 
			*t++ = *s++; }
	}
	*(p+string_hdr->s_length) = 0;
}

/*
 *	Implementation
 */

void TK_GR_PUT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_put",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_put");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_put");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_put");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_put");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffMimageInRastport_ex(A->interp, mimg, pathname, x, y, 0.0f, 1.0f, op_sum, GR_NO_ROTATE);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_PUT_BLEND(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;
	float c1, c2;
	
	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_put_blend",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_put_blend");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_put_blend");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_put_blend");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_put_blend");
	check_arg(SETL_SYSTEM argv, 5, ft_real, "integer", "tk_gr_put_blend");
	check_arg(SETL_SYSTEM argv, 6, ft_real, "integer", "tk_gr_put_blend");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	c1		= (float)argv[5].sp_val.sp_real_ptr->r_value;
	c2		= (float)argv[6].sp_val.sp_real_ptr->r_value;
	
	StuffMimageInRastport_ex(A->interp, mimg, pathname, x, y, c1, c2, op_sum, GR_NO_ROTATE);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_PUT_ADD(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_put_sum",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_put_sum");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_put_sum");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_put_sum");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_put_sum");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffMimageInRastport_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_sum, GR_NO_ROTATE);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_PUT_DIF(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_put_dif",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_put_dif");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_put_dif");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_put_dif");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_put_dif");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffMimageInRastport_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_dif, GR_NO_ROTATE);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_PUT_MUL(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_put_mul",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_put_mul");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_put_mul");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_put_mul");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_put_mul");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffMimageInRastport_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_mul, GR_NO_ROTATE);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_PUT_DIV(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_put_div",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_put_div");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_put_div");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_put_div");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_put_div");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffMimageInRastport_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_div, GR_NO_ROTATE);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_PUT_MAX(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_put_max",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_put_max");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_put_max");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_put_max");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_put_max");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffMimageInRastport_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_max, GR_NO_ROTATE);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_PUT_MIN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_put_min",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_put_min");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_put_min");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_put_min");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_put_min");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffMimageInRastport_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_min, GR_NO_ROTATE);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_PUT_POW(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_put_pow",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_put_pow");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_put_pow");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_put_pow");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_put_pow");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffMimageInRastport_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_pow, GR_NO_ROTATE);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_PUT_AND_ROTATE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_put_and_rotate",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_put_and_rotate");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_put_and_rotate");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_put_and_rotate");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_put_and_rotate");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffMimageInRastport_ex(A->interp, mimg, pathname, x, y, 0.0f, 1.0f, op_sum, GR_ROTATE_90);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_PUT_BLEND_AND_ROTATE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;
	float c1, c2;
	
	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_put_blend_and_rotate",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_put_blend_and_rotate");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_put_blend_and_rotate");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_put_blend_and_rotate");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_put_blend_and_rotate");
	check_arg(SETL_SYSTEM argv, 5, ft_real, "integer", "tk_gr_put_blend_and_rotate");
	check_arg(SETL_SYSTEM argv, 6, ft_real, "integer", "tk_gr_put_blend_and_rotate");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	c1		= (float)argv[5].sp_val.sp_real_ptr->r_value;
	c2		= (float)argv[6].sp_val.sp_real_ptr->r_value;
	
	StuffMimageInRastport_ex(A->interp, mimg, pathname, x, y, c1, c2, op_sum, GR_ROTATE_90);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_PUT_ADD_AND_ROTATE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_put_sum_and_rotate",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_put_sum_and_rotate");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_put_sum_and_rotate");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_put_sum_and_rotate");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_put_sum_and_rotate");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffMimageInRastport_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_sum, GR_ROTATE_90);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_PUT_DIF_AND_ROTATE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_put_dif_and_rotate",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_put_dif_and_rotate");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_put_dif_and_rotate");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_put_dif_and_rotate");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_put_dif_and_rotate");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffMimageInRastport_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_dif, GR_ROTATE_90);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_PUT_MUL_AND_ROTATE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_put_mul_and_rotate",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_put_mul_and_rotate");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_put_mul_and_rotate");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_put_mul_and_rotate");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_put_mul_and_rotate");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffMimageInRastport_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_mul, GR_ROTATE_90);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_PUT_DIV_AND_ROTATE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_put_div_and_rotate",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_put_div_and_rotate");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_put_div_and_rotate");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_put_div_and_rotate");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_put_div_and_rotate");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffMimageInRastport_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_div, GR_ROTATE_90);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_PUT_MAX_AND_ROTATE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_put_max_and_rotate",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_put_max_and_rotate");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_put_max_and_rotate");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_put_max_and_rotate");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_put_max_and_rotate");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffMimageInRastport_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_max, GR_ROTATE_90);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_PUT_MIN_AND_ROTATE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_put_min_and_rotate",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_put_min_and_rotate");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_put_min_and_rotate");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_put_min_and_rotate");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_put_mi_and_rotaten");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffMimageInRastport_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_min, GR_ROTATE_90);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_PUT_POW_AND_ROTATE(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_put_pow_and_rotate",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_put_pow_and_rotate");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_put_pow_and_rotate");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_put_pow_and_rotate");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_put_pow_and_rotate");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffMimageInRastport_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_pow, GR_ROTATE_90);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_GET(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_put",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_put");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_put");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_put");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_put");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffRastportInMimage_ex(A->interp, mimg, pathname, x, y, 0.0f, 1.0f, op_sum, GR_NO_ROTATE);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_GET_BLEND(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;
	float c1, c2;
	
	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_get_blend",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_get_blend");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_get_blend");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_get_blend");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_get_blend");
	check_arg(SETL_SYSTEM argv, 5, ft_real, "integer", "tk_gr_get_blend");
	check_arg(SETL_SYSTEM argv, 6, ft_real, "integer", "tk_gr_get_blend");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	c1		= (float)argv[5].sp_val.sp_real_ptr->r_value;
	c2		= (float)argv[6].sp_val.sp_real_ptr->r_value;
	
	StuffRastportInMimage_ex(A->interp, mimg, pathname, x, y, c1, c2, op_sum, GR_NO_ROTATE);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_GET_ADD(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_get_sum",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_get_sum");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_get_sum");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_get_sum");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_get_sum");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffRastportInMimage_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_sum, GR_NO_ROTATE);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_GET_DIF(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_get_dif",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_get_dif");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_get_dif");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_get_dif");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_get_dif");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffRastportInMimage_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_dif, GR_NO_ROTATE);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_GET_MUL(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_put_mul",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_get_mul");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_get_mul");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_get_mul");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_get_mul");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffRastportInMimage_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_mul, GR_NO_ROTATE);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_GET_DIV(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_get_div",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_get_div");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_get_div");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_get_div");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_get_div");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffRastportInMimage_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_div, GR_NO_ROTATE);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_GET_MAX(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_get_max",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_get_max");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_get_max");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_get_max");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_get_max");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffRastportInMimage_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_max, GR_NO_ROTATE);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_GET_MIN(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_get_min",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_get_min");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_get_min");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_get_min");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_get_min");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffRastportInMimage_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_min, GR_NO_ROTATE);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_GR_GET_POW(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
#define PATHNAME_SIZE 32	

	char pathname[PATHNAME_SIZE + 1];
	struct setl_tcl *A;
	void *mimg;
	int x, y;

	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_gr_get_pow",
				abend_opnd_str(SETL_SYSTEM argv+0));

	check_arg(SETL_SYSTEM argv, 1, ft_string, "string", "tk_gr_get_pow");
	check_arg(SETL_SYSTEM argv, 2, ft_opaque, "gr_image", "tk_gr_get_pow");
	check_arg(SETL_SYSTEM argv, 3, ft_short, "integer", "tk_gr_get_pow");
	check_arg(SETL_SYSTEM argv, 4, ft_short, "integer", "tk_gr_get_pow");

	A		= (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	setl2_string_to_cstring(argv[1].sp_val.sp_string_ptr, pathname, PATHNAME_SIZE);
	mimg	= argv[2].sp_val.sp_opaque_ptr;
	x		= argv[3].sp_val.sp_short_value;
	y		= argv[4].sp_val.sp_short_value;
	
	StuffRastportInMimage_ex(A->interp, mimg, pathname, x, y, 1.0f, 1.0f, op_pow, GR_NO_ROTATE);

	unmark_specifier(target);
	target->sp_form = ft_omega;

#undef PATHNAME_SIZE
}

SETL_API void TK_TESTRASTPORT(
  SETL_SYSTEM_PROTO
  int argc,                           /* number of arguments passed        */
  specifier *argv,                    /* argument vector (two here)        */
  specifier *target)                  /* return value                      */
{
	int x, y;
static	float alfa = 0.0f;
	
	struct setl_tcl *A;
	void *mimg;
	
	argc;

	if ((argv[0].sp_form != ft_opaque)||
		(((argv[0].sp_val.sp_opaque_ptr->type)&65535)!=tcl_type))
			abend(SETL_SYSTEM msg_bad_arg,"object",1,"tk_testrastport",
				abend_opnd_str(SETL_SYSTEM argv+0));

	A = (struct setl_tcl *)(argv[0].sp_val.sp_opaque_ptr);
	mimg = argv[1].sp_val.sp_opaque_ptr;
	
	x = 160 + 160 * (int)sin(alfa);	
	y = 100 + 100 * (int)cos(alfa);	
	
	StuffMimageInRastport_ex(A->interp, mimg, ".rs", x, y, 0.0f, 1.0f, op_sum, GR_NO_ROTATE);

	alfa += 0.0628;
	
	unmark_specifier(target);
	target->sp_form = ft_omega;
}

/*
 *	Auxiliary functions
 */
 
static float op_sum(float a, float b)
{
	return a+b;
}

static float op_dif(float a, float b)
{
	return a-b;
}

static float op_mul(float a, float b)
{
	return a*b;
}

static float op_div(float a, float b)
{
	return a/b;
}

static float op_max(float a, float b)
{
	return (a>b)?a:b;
}

static float op_min(float a, float b)
{
	return (a<b)?a:b;
}

static float op_pow(float a, float b)
{
	return pow(a, b);
}

