#include <stdlib.h>

#include "tkGrLib.h"

static _int32 gr_type;

mimage_ptr create_mimage(int width, int height, int planes_number, char kind, unsigned char density)
{
	mimage_ptr mimg = (mimage_ptr)malloc(sizeof(mimage));
	if (!mimg)
		return NULL;

	mimg->planes_array = create_planes_array(width, height, kind, planes_number, density);
	if (!mimg->planes_array) {
		free (mimg);
		return NULL;
	}

	mimg->type      = gr_type;
	mimg->use_count = 1;
	mimg->comp      = planes_number;
	mimg->kind      = kind;
	mimg->density	= density;


	mimg->upperleft_x = 0;
	mimg->upperleft_y = 0;

		/* 
		 *	a sparse byteplane at the very beginning 
		 *	is empty (completely sparse) 
		 */

	mimg->data_length = 0;
	mimg->section_length = 0;
	mimg->row_start = NULL;
	mimg->row_section = NULL;
	mimg->buffer_length = 0;

	return mimg;	
}

void *create_sparse_byteplane(int width, int height, char kind)
{
	sparse_byteplane_ptr plane_ptr;

	size_t type_size = GET_TYPE_SIZE(kind);

	plane_ptr = (sparse_byteplane_ptr) calloc(sizeof(sparse_byteplane), 1);
	if (!plane_ptr)
		return NULL;

	plane_ptr->height = height;
	plane_ptr->width = width;

		/* only difference with dense byteplanes */
	plane_ptr->buffer	= NULL; 

	if (kind == FLOAT_IMAGE) 
		plane_ptr->default_value = (float)0.;
	else
		plane_ptr->default_value = 0;
	

	return plane_ptr;
}

byteplane_ptr *create_planes_array(int width, int height, char kind, int planes_number, unsigned char density)
{
	int i;
	byteplane_ptr *planes_array;
	byteplane_ptr ptr;
	
	planes_array = (byteplane *) calloc(sizeof(void *) * planes_number, 1);	
	if (!planes_array)
		return NULL;
		
	for (i=0; i<planes_number; i++) {
		ptr =  create_byteplane(width, height, kind, density);
		if (ptr)
			planes_array[i] = ptr;
		else {
			destroy_planes_array(planes_array, kind, i, density);	/* in this way we actually
							                                           destroy the built arrays */
			return NULL;
		}
	}
		
	return planes_array;
}

void destroy_planes_array(void **planes_array, char kind, int planes_number, unsigned char density)
{
	int i;

	if (planes_array) {
		i = planes_number-1;
		while (i >= 0) {
			if (planes_array[i])
				destroy_byteplane(planes_array[i], kind, density);
			i--;
		}
		free(planes_array);
	}
}

void *get_plane_buffer(void *plane, int kind)
{
#ifdef __MWERKS__
 #pragma unused(kind)
#endif
	return ((byteplane_ptr)plane)->buffer;
}

void *create_byteplane(int width, int height, char kind, unsigned char density)
{
	if (density == DENSE_IMAGE)
		return create_dense_byteplane(width, height, kind);
	else
		return create_sparse_byteplane(width, height, kind);
}

void destroy_byteplane(void *byteplane, char kind, unsigned char density)
{
	if (density == DENSE_IMAGE)
		destroy_dense_byteplane(byteplane, kind);
	else
		destroy_sparse_byteplane(byteplane, kind);
	
}
void destroy_dense_byteplane(void *byteplane, char kind)
{
	void *buffer = get_plane_buffer(byteplane, kind);
	
	free(buffer);
	free(byteplane);
}

byteplane_ptr get_byteplane_from_mimage(mimage_ptr mimg, char plane_index)
{
	void *plane;
	
	plane =  mimg->planes_array[plane_index];

	return plane;
}

void destroy_sparse_byteplane(sparse_byteplane_ptr byteplane, char kind)
{
#ifdef __MWERKS__
#pragma unused(kind)
#endif

	if (byteplane) {
		if (byteplane->buffer)
			free(byteplane->buffer);
		free(byteplane);
	}

}

void *create_dense_byteplane(int width, int height, char kind)
{
	byteplane_ptr plane_ptr;
	fbyteplane_ptr fplane_ptr;
	void *ptr;
	 
	switch (kind) {

		case REG_IMAGE:

			plane_ptr = (byteplane_ptr) calloc(sizeof(byteplane), 1);
			if (!plane_ptr)
				return NULL;

			plane_ptr->height = height;
			plane_ptr->width = width;
			plane_ptr->buffer	= (unsigned char *)malloc(width * height * sizeof(unsigned char));
			if (!plane_ptr->buffer) {
				free(plane_ptr);
				return NULL;
			}
				
			ptr = plane_ptr;
			
			break;

		case FLOAT_IMAGE:

			fplane_ptr	= (fbyteplane_ptr) calloc(sizeof(fbyteplane), 1);
			if (!fplane_ptr)
				return NULL;

			fplane_ptr->height = height;
			fplane_ptr->width = width;
			fplane_ptr->buffer = (float *)malloc(width * height * sizeof(float));
			if (!fplane_ptr->buffer) {
				free(fplane_ptr);
				return NULL;
			}
			
			ptr = fplane_ptr;
			
			break;
	}

	return ptr;
}

int sections_in_row(mimage_ptr mimg, int k)		/* get number of sections in k-th row	*/
{
	size_t num_sections_for_this_row;

	if (k < mimg->data_length - 1) 
	{
		if (mimg->row_start[k+1] >= 0) 
		{
			num_sections_for_this_row = mimg->row_start[k+1] - mimg->row_start[k];
		}
		else 
		{
			if (k+2 < mimg->data_length) 
			{
				num_sections_for_this_row = mimg->row_start[k+2] - mimg->row_start[k];
			}
			else
			{
				num_sections_for_this_row = mimg->section_length - mimg->row_start[k];
			}
		}
	}
	else
	{
		num_sections_for_this_row = mimg->section_length - mimg->row_start[k];
	}
	
	return num_sections_for_this_row;
}

void get_mimage_info(mimage_ptr mimg, int *height, int *width, int *comp, int *kind, unsigned char *density)
{
	if (mimg) {
		if (height)	 *height = ((byteplane_ptr)(mimg->planes_array[0]))->height;
		if (width)	 *width = ((byteplane_ptr)(mimg->planes_array[0]))->width;
		if (comp)	 *comp = mimg->comp;
		if (kind)	 *kind = mimg->kind;	
		if (density) *density = mimg->density;
	}
}

