#include <gestalt.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
	
#include "voice.h"
#include "str_queue.h"

#define SR_FEEDBACK

#define CHECK_ERR(a)	if ((a)) return a;

#ifndef false
#define false ((Boolean)0)
#endif

#ifndef true
#define true ((Boolean)1)
#endif

	/*
	 *	Globals
	 */

void *gUserPtr1, *gUserPtr2;
void (*gCallback)(void *user_ptr1, void *user_ptr2, char *string);
 
	/*
	 *	Prototypes
	 */

static OSErr	MakeALanguageModel (SRLanguageModel *languageModel, SRRecognitionSystem gSystem, char *phraseStrings);
static pascal OSErr HandleSpeechDoneAppleEvent (AppleEvent *theAEevt, AppleEvent* reply, long refcon);

	/*
	 *	Procedures
	 */

OSErr InitVoiceSR(SRRecognizer *theRecognizer, SRRecognitionSystem *theSystem, char *vocabulary, void *userPtr1, void *userPtr2, void (*callback)(void *user_ptr1, void *user_ptr2, char *string) )
{
	OSErr				err;
	SRLanguageModel		languageModel;
	SRRecognizer		srRecognizer;
	SRRecognitionSystem	srSystem;
#ifdef SR_FEEDBACK
	short				feedbackModes;
#endif
	
	if (!HasSpeechRecognitionMgr())
		return kSRNotAvailable;
		
	gUserPtr1 = userPtr1;
	gUserPtr2 = userPtr2;
	gCallback = callback;
	
	err = AEInstallEventHandler(kAESpeechSuite, kAESpeechDone,
		NewAEEventHandlerProc (HandleSpeechDoneAppleEvent), 0, false);
	CHECK_ERR(err);

	err = SROpenRecognitionSystem (&srSystem, kSRDefaultRecognitionSystemID);
	CHECK_ERR(err);
	
#ifdef SR_FEEDBACK
	feedbackModes = kSRHasFeedbackHasListenModes; /* kSRNoFeedbackNoListenModes; */
 	err = SRSetProperty (srSystem, kSRFeedbackAndListeningModes, 
				&feedbackModes, sizeof (feedbackModes));
	CHECK_ERR(err);
#endif

	err = MakeALanguageModel (&languageModel, srSystem, vocabulary);
	CHECK_ERR(err);

	err = SRNewRecognizer (srSystem, &srRecognizer, kSRDefaultSpeechSource);
	CHECK_ERR(err);

	err = SRSetLanguageModel (srRecognizer, languageModel);
	CHECK_ERR(err);

	err = SRReleaseObject (languageModel);
	CHECK_ERR(err);

	*theRecognizer = srRecognizer;
	*theSystem = srSystem;
	
	return noErr;
}		

OSErr StartSpeechRecognition (SRRecognizer srRecognizer)
{
	return SRStartListening (srRecognizer);
}

OSErr StopSpeechRecognition (SRRecognizer srRecognizer)
{
	return SRStopListening (srRecognizer);
}

void CleanupSpeechRecognitionStuff (SRRecognizer srRecognizer, SRRecognitionSystem srSystem)
{
	OSErr status;
	status = SRStopListening (srRecognizer);	/* stop processing incoming sound */
	status = SRReleaseObject (srRecognizer);	/* balance SRNewRecognizer call */
	status = SRCloseRecognitionSystem (srSystem);	/* balance SROpenRecognitionSystem call */
}

OSErr MakeALanguageModel (SRLanguageModel *languageModel, SRRecognitionSystem srSystem, char *phraseStr)
{
	char *delims = ",";
	char *token;
	
	OSErr			status;
	SRLanguageModel	newModel;
	const char		*lmName = "<Sample LM>";

/*	
	const char		*phraseStrings = "Hi,Stop,Robot,Print,After all,Print all the statements,Wait for next loop";
 */
	
		/*	make a simple language model (LM) */
	status = SRNewLanguageModel (srSystem, &newModel, lmName, strlen (lmName));
		
		/*	add each phrase to LM */
	if (!status) {

		token = strtok(phraseStr, delims);
	
		while (!status && token) {
			status = SRAddText (newModel, token, strlen (token), 0);
			token = strtok(NULL, delims);
		}
			
			/*	release newly created LM if an error occured while adding phrases */
		if (status)
			SRReleaseObject (newModel);
	}
	
		/*	return new LM */
	if (!status)
		*languageModel = newModel;

	return status;
}

pascal OSErr HandleSpeechDoneAppleEvent (AppleEvent *theAEevt, AppleEvent* reply, long refcon)
{
#pragma unused(reply)
#pragma unused(refcon)

	long				actualSize;
	DescType			actualType;
	OSErr				status = 0, recStatus = 0;
	SRRecognitionResult	recResult;
	char				str[255];
	Size				len;

		/* Get status */
	status = AEGetParamPtr(theAEevt,keySRSpeechStatus,typeShortInteger,
					&actualType, (Ptr)&recStatus, sizeof(status), &actualSize);

		/* Get result */
	if (!status && !recStatus)
		status = AEGetParamPtr(theAEevt,keySRSpeechResult,
					typeSRSpeechResult, &actualType, (Ptr)&recResult,
					sizeof(SRRecognitionResult), &actualSize);
					
		/* Get text of words in result.
			Could also get actual phrase, path, or LM objects using other
			format property selectors. If we did that, we'd also want to
			release those objects when we were done using them here.*/
	if (!status) {
		len = 255;
		status = SRGetProperty (recResult, kSRTEXTFormat, str, &len);
		if (!status) {
			str[len] = 0;
				
				/*
				 *	Release SRRecognitionResult since we are done with it!!! 
				 *	The toolbox has given us a reference to this object, and
				 *	assumes we are still using it until we call SRReleaseObject
				 *	with it.
				 */

			SRReleaseObject (recResult);
		}
	}
	
	if (!status) {
		if (gCallback) {
			gCallback(gUserPtr1, gUserPtr2, str);
		}
		else {
			SysBeep(0);
		}
			// word found and it's in str
	} else {
			// error during recog
	}
	
	return status;
}

Boolean HasSpeechRecognitionMgr (void)
{
	OSErr myErr;
	long mySRVersion;
	Boolean myHasSRMgr = 0;

	myErr = Gestalt (gestaltSpeechRecognitionVersion, &mySRVersion);
	if (!myErr)
		if (mySRVersion >= 0x0150)
			myHasSRMgr = 1;

	return myHasSRMgr;
}