/*\
 *  %
 *  %  Copyright (c) W. Kirk Snyder
 *  %  All Rights Reserved
 *  %
 *  %  This is unpublished source code for SETL2.  There should be no
 *  %  copies which are not in the possession of the author.  If you
 *  %  somehow come across a copy, please return or destroy it.
 *  %
 *
 *  \packagespec{Integer Literal Table}
\*/

#ifndef COMPILER_INTEGERS_LOADED

#define INT_CELL_WIDTH    (sizeof(int32) * 4 - 1)
                                       /* width of integer cell in bits     */
#define MAX_INT_CELL      ((1L << INT_CELL_WIDTH) - 1)
                                       /* maximum value of a cell           */

/* integer table node structure */

struct integer_item {
   struct integer_item *i_next;        /* next cell in list                 */
   struct integer_item *i_prev;        /* previous cell in list             */
   int32 i_value;                      /* integer value                     */
   unsigned i_is_negative;             /* sign field                        */
};

typedef struct integer_item *integer_ptr_type;
                                       /* node pointer                      */

/* clear a integer table item */

#define clear_integer(i) { \
   (i)->i_next = NULL;                 (i)->i_prev = NULL; \
   (i)->i_value = 0;                   (i)->i_is_negative = 0; \
}

/* public function declarations */

void init_integers(void);              /* initialize the integer literal    */
                                       /* table                             */
integer_ptr_type get_integer(SETL_SYSTEM_PROTO_VOID);    
                                       /* allocate a new item               */
void free_compiler_integer(integer_ptr_type);   
                                       /* return an item to the free pool   */
integer_ptr_type char_to_int(SETL_SYSTEM_PROTO char *);  
                                       /* convert string to integer         */

#define COMPILER_INTEGERS_LOADED 1
#endif
