/*\
 *  %
 *  %  Copyright (c) W. Kirk Snyder
 *  %  All Rights Reserved
 *  %
 *  %  This is unpublished source code for SETL2.  There should be no
 *  %  copies which are not in the possession of the author.  If you
 *  %  somehow come across a copy, please return or destroy it.
 *  %
 *
 *  \packagespec{Real Literal Table}
\*/

#ifndef COMPILER_REALS_LOADED

/* real table node structure */

struct c_real_item {
   double r_value;                     /* real value                        */
};

typedef struct c_real_item *c_real_ptr_type;
                                       /* node pointer                      */

/* clear a real table item */

#define clear_real(r) { \
   (r)->r_value = 0.0; \
}

/* public function declarations */

void init_compiler_reals(SETL_SYSTEM_PROTO_VOID);     
                                       /* initialize the real literal table */
c_real_ptr_type get_real(SETL_SYSTEM_PROTO_VOID);
                                       /* allocate a new item               */
void free_real(c_real_ptr_type);       /* return an item to the free pool   */
c_real_ptr_type char_to_real(SETL_SYSTEM_PROTO char *, file_pos_type *);
                                       /* convert char to internal real     */

#define COMPILER_REALS_LOADED 1
#endif
