/*\
 *  %
 *  %  Copyright (c) W. Kirk Snyder
 *  %  All Rights Reserved
 *  %
 *  %  This is unpublished source code for SETL2.  There should be no
 *  %  copies which are not in the possession of the author.  If you
 *  %  somehow come across a copy, please return or destroy it.
 *  %
 *
 *  \packagespec{String Table}
\*/

#ifndef COMPILER_STRINGS_LOADED

/* name table item structure */

struct string_item {
   char *s_value;                      /* string proper                     */
   int s_length;                       /* string length                     */
};

typedef struct string_item *string_ptr_type;
                                       /* string table type definition      */

/* clear a string table item */

#define clear_string(s) { \
   (s)->s_value = NULL;                (s)->s_length = 0; \
}

/* public function declarations */

void init_strings(SETL_SYSTEM_PROTO_VOID);               
                                       /* initialize string table           */
string_ptr_type get_string(SETL_SYSTEM_PROTO char *, int);
                                       /* get string table item             */
string_ptr_type char_to_string(SETL_SYSTEM_PROTO char *);
                                       /* convert character to string       */

#define COMPILER_STRINGS_LOADED 1
#endif
