/*\
 *  %
 *  %  Copyright (c) W. Kirk Snyder
 *  %  All Rights Reserved
 *  %
 *  %  This is unpublished source code for SETL2.  There should be no
 *  %  copies which are not in the possession of the author.  If you
 *  %  somehow come across a copy, please return or destroy it.
 *  %
 *
 *  \package{Command Line}
 *
 *  This function returns a character string of options which are placed
 *  in front of the command line.  It simply finds the appropriate
 *  environment string and returns it.  It is a separate function so that
 *  it can be overridden when interpreters are built using callout which
 *  perform specific programs.
\*/

/* standard C header files */

#include "system.h"                    /* SETL2 system constants            */

#include <ctype.h>                     /* character macros                  */
#ifdef HAVE_SIGNAL_H
#include <signal.h>                    /* signal macros                     */
#endif

/* SETL2 system header files */

#include "interp.h"                    /* SETL2 interpreter constants       */
#include "giveup.h"                    /* severe error handler              */
#include "messages.h"                  /* error messages                    */
#include "cmdline.h"                   /* command line argument string      */

/*\
 *  \function{cmdline()}
 *
 *  This function just reads an environment string and returns it.  We do
 *  this in a separate function so that it can be easily overridden to
 *  create a custom interpreter for a specific program.
\*/

char *cmdline()
{
    return getenv(INTERP_OPTIONS_KEY);
}
