/*\
 *  %
 *  %  Copyright (c) W. Kirk Snyder
 *  %  All Rights Reserved
 *  %
 *  %  This is unpublished source code for SETL2.  There should be no
 *  %  copies which are not in the possession of the author.  If you
 *  %  somehow come across a copy, please return or destroy it.
 *  %
 *
 *  \package{Constant Check}
 *
 *  This package simply checks whether an expression is constant.  It is
 *  used by the case code generation routines to determine whether the
 *  expressions in a case statement are constant.
 *
 *  \texify{const.h}
 *
 *  \packagebody{Constant Check}
\*/


/* SETL2 system header files */

#include "system.h"                    /* SETL2 system constants            */
#include "compiler.h"                  /* SETL2 compiler constants          */
#include "giveup.h"                    /* severe error handler              */
#include "messages.h"                  /* error messages                    */
#include "symtab.h"                    /* symbol table                      */
#include "ast.h"                       /* abstract syntax tree              */

/*\
 *  \function{is\_constant()}
 *
 *  We return YES if the ast is a constant symbol or if it is a simple
 *  expression all of whose operands are constant.
\*/

int is_constant(
   ast_ptr_type root)                  /* AST to be checked                 */

{

   switch (root->ast_type) {

case ast_symtab :

{
symtab_ptr_type symtab_ptr;            /* symbol table pointer from ast     */

   symtab_ptr = root->ast_child.ast_symtab_ptr;

   return (symtab_ptr->st_has_rvalue && !symtab_ptr->st_has_lvalue);

}

default :

{
   return NO;
}

/* at this point we return to normal indentation */

}}
