/*\
 *  %
 *  %  Copyright (c) W. Kirk Snyder
 *  %  All Rights Reserved
 *  %
 *  %  This is unpublished source code for SETL2.  There should be no
 *  %  copies which are not in the possession of the author.  If you
 *  %  somehow come across a copy, please return or destroy it.
 *  %
 *
 *  \packagespec{Imported Package Table}
\*/

#ifndef IMPORT_LOADED

/* import table node structure */

struct import_item {
   struct import_item *im_next;        /* next item in list                 */
   struct namtab_item *im_namtab_ptr;  /* package name                      */
   int im_unit_num;                    /* unit number of imported unit      */
   char im_source_name[PATH_LENGTH + 1];
                                       /* package source file name          */
   time_t im_time_stamp;               /* compilation time                  */
   int im_inherited;                   /* YES if unit is inherited          */
   struct symtab_item *im_symtab_ptr;  /* symbol for unit                   */
};

typedef struct import_item *import_ptr_type;
                                       /* node pointer                      */

/* clear an import table item */

#define clear_import(i) { \
   (i)->im_next = NULL;                (i)->im_namtab_ptr = NULL; \
   (i)->im_unit_num = -1;              (i)->im_source_name[0] = '\0'; \
   (i)->im_time_stamp = -1;            (i)->im_inherited = 0; \
}

/* public function declarations */

void init_import(void);                /* initialize the imported package   */
                                       /* table                             */
import_ptr_type get_import(SETL_SYSTEM_PROTO_VOID);
                                       /* allocate a new item               */
void free_import(import_ptr_type);     /* return an item to the free pool   */

#define IMPORT_LOADED 1
#endif
