/*\
 *  %
 *  %  Copyright (c) W. Kirk Snyder
 *  %  All Rights Reserved
 *  %
 *  %  This is unpublished source code for SETL2.  There should be no
 *  %  copies which are not in the possession of the author.  If you
 *  %  somehow come across a copy, please return or destroy it.
 *  %
 *
 *  \packagespec{Library Free List Table}
\*/

#ifndef LIBFREE_LOADED

/* free libfree structure */

struct libfree_item {
   int lf_head;                        /* first record in free list         */
   int lf_tail;                        /* last record in free list          */
   struct libfree_item *lf_next;       /* next free list record             */
};

/* clear free list record */

#define clear_libfree(l) { \
   (l)->lf_head = -1;                  (l)->lf_tail = -1; \
   (l)->lf_next = NULL; \
}

/* public function declarations */

#ifdef LIBWRITE

struct libfree_item *get_libfree(SETL_SYSTEM_PROTO_VOID);
                                       /* allocate free list                */
void free_libfree(libfree_ptr_type);   /* return to free pool               */

#endif

#define LIBFREE_LOADED 1
#endif

