/*\
 *  %
 *  %  Copyright (c) W. Kirk Snyder
 *  %  All Rights Reserved
 *  %
 *  %  This is unpublished source code for SETL2.  There should be no
 *  %  copies which are not in the possession of the author.  If you
 *  %  somehow come across a copy, please return or destroy it.
 *  %
 *
 *  \packagespec{Library Stream Table}
\*/

#ifndef LIBSTR_LOADED

/* SETL2 system header files */

#include "libcom.h"                    /* library manager -- common         */

/* library stream table item */

struct libstr_item {
   struct libstr_item *ls_next;        /* next stream in list               */
   struct libunit_item *ls_libunit_ptr;
                                       /* unit containing stream            */
   int ls_index;                       /* stream index                      */
   int ls_record_num;                  /* current record number             */
   char ls_buffer[LIB_DATA_SIZE];      /* input/output buffer               */
   char *ls_buff_cursor;               /* next to be read/written           */
   int32 ls_bytes_left;                /* bytes left in stream              */
};

/* macro to clear one table item */

#define clear_libstr(s) { \
   (s)->ls_next = NULL;                (s)->ls_libunit_ptr = NULL; \
   (s)->ls_index = -1;                 (s)->ls_record_num = -1; \
   (s)->ls_buffer[0] = '\0';           (s)->ls_buff_cursor = NULL; \
   (s)->ls_bytes_left = 0; \
}

/* public function declarations */

struct libstr_item *get_libstr(SETL_SYSTEM_PROTO_VOID);  /* allocate a new table item         */
void free_libstr(struct libstr_item *);
                                       /* deallocate a table item           */

#define LIBSTR_LOADED 1
#endif

