/*\
 *  %
 *  %  Copyright (c) W. Kirk Snyder
 *  %  All Rights Reserved
 *  %
 *  %  This is unpublished source code for SETL2.  There should be no
 *  %  copies which are not in the possession of the author.  If you
 *  %  somehow come across a copy, please return or destroy it.
 *  %
 *
 *  \packagespec{Library Unit Table}
\*/

#ifndef LIBUNIT_LOADED

/* SETL2 system header files */

#include "libcom.h"                    /* library manager -- common         */

/* library unit table item */

struct libunit_item {
   struct libunit_item *lu_next;       /* next unit in list                 */
   struct unit_header_item lu_header;  /* unit header structure             */
   struct libfile_item *lu_libfile_ptr;
                                       /* file containing unit              */
   struct libstr_item *lu_libstr_list; /* list of open streams in unit      */
   unsigned lu_is_output : 1;          /* YES if unit opened output         */
};

/* macro to clear one table item */

#define clear_unit(u) { \
   (u)->lu_next = NULL;                (u)->lu_libfile_ptr = NULL; \
   (u)->lu_libstr_list = NULL;         (u)->lu_is_output = 0; \
}

/* public function declarations */

struct libunit_item *get_libunit(SETL_SYSTEM_PROTO_VOID);
                                       /* allocate a new table item         */
void free_libunit(struct libunit_item *);
                                       /* deallocate a table item           */

#define LIBUNIT_LOADED 1
#endif

