/*\
 *  %
 *  %  Copyright (c) W. Kirk Snyder
 *  %  All Rights Reserved
 *  %
 *  %  This is unpublished source code for SETL2.  There should be no
 *  %  copies which are not in the possession of the author.  If you
 *  %  somehow come across a copy, please return or destroy it.
 *  %
 *
 *  \packagespec{Slot Table}
\*/

#ifndef SLOTS_LOADED

/* slot table item structure */

struct slot_item {
   int sl_type;                        /* slot type                         */
   int32 sl_number;                    /* global slot number                */
   struct slot_item *sl_hash_link;     /* next slot with same hash value    */
   char *sl_name;                      /* slot lexeme                       */
};

typedef struct slot_item *slot_ptr_type;
                                       /* slot table type definition        */

/* clear a slot item */

#define clear_slot(s) { \
   (s)->sl_type = -1;                  (s)->sl_hash_link = NULL; \
   (s)->sl_name = NULL;                (s)->sl_number = 0; \
}

#ifdef TSAFE
#define TOTAL_SLOT_COUNT plugin_instance->total_slot_count 
#else
#define TOTAL_SLOT_COUNT total_slot_count 
#ifdef SHARED

int32 total_slot_count;                /* total number of allocated slots   */

#else

extern int32 total_slot_count;         /* total number of allocated slots   */

#endif
#endif

/* public function declarations */

void init_slots(SETL_SYSTEM_PROTO_VOID); 
                                       /* initialize slot table             */
slot_ptr_type get_slot(SETL_SYSTEM_PROTO char *);    
                                       /* get slot table item               */


/* performance tuning constants */

#define SLOTS__HASH_TABLE_SIZE    13       /* size of hash table                */

#define SLOTS_LOADED
#endif
