--
-- sq2+-to-C and SETL2-to-C translator functions
--
commands squb;
---------------------------------------------------------------------
-- TEST PACKAGES
--
-- test out sq2+-to-C translator on reachability problem
--
    procedure testsq2 ( ) ; 
      print 'test sq2+-to-c compiler on graph reachability example' ; 
      sq2x ( reach, reach1000 ) ; 
    end procedure ; 
--
-- test out SETL2+-to-C translator on reachability problem
--
    procedure testsetl ( ) ; 
      print 'test setl-to-c compiler on graph reachability example' ; 
      setlx ( reachbnf, reach1000 ) ; 
    end procedure ; 
-------------------------------------------------------------------------
-- TRANSLATORS
--
-- execute SETL2-to-C translator with source program in file .input and
-- input in file .output;  if the input file name has no extension, then .src
-- will be appended; if the input file name has no extension, then .in will
-- be appended.
--
    procedure setlx ( .input , .output ) ; 
      nsetlx ( .input ) ;
      database files;	--store i/o fnames to pass to foreign stl module
      dparse files(input,.output);
      dparse files(output,.output);
      commonback;
    end procedure ; 
--
-- Backend to Raytheon Translation
--
    procedure raysetlx ();
	nsetlx(raybnf);
	commonback;
	locate top;
        ccload;           -- load cc
        strip_main;
	locate top;
        unparse;
	unparse testc inf;
    end procedure;
--
-- same as setlx, but without .output translation
--
    procedure nsetlx ( .input ) ; 
      ubload ;             -- load ub
      initdb;
      parse .input;
      unparse;
      database ismap;  --not used?; remove on apr. 7, 1995
    end procedure ; 
--
-- for testing finite differencing
--
    procedure fdsetlx(.input);
      initsm;
      initdb;
      parse .input;
      unparse;
      doanf;   		-- create normal forms for set formers
      analyze type;
      database type,ismap,ref_count,disjoint;
      initsm;
      undoanf;		-- turn normal forms into simplified forms
      cleandb;
      prepfd;		-- normalize code for finite differencing
      unparse;  	-- print finite difference normal form
      fdiff;
      unparse;  	-- print result of finite differencing
    end procedure;
--
-- execute SQ2+-to-C translator with source program in file .input and
-- input in file .output;  if the program file name has no extension, then .src
-- will be appended; if the input file name has no extension, then .in will
-- be appended.
--
    procedure sq2x ( .input , .output ) ; 
      sqload ;          -- load stlstl rw, rc, fd, sr modules
      initdb;
      parse .input;
      unparse;
      database files;  -- store i/o fnames in reln to pass to stl module
      dparse files(input,.output);
      dparse files(output,.output);
      frontend;		-- dominated convergence and finite differencing
pause 'done with frontend';  -- debug
      loadrw rwub;      -- load ub
      loadrc rcub;
      loadx xub;
      commonback;	-- real-time simulation
    end procedure ; 
----------------------------------------------------------------------
-- TRANSLATOR AUXILIARY ROUTINES
--
-- common backend for SETL2 and SQ2+ translators - performs real-time
-- simulation transformation; translation from base normal form SETL2 to c
--
    procedure commonback();
	database 
	   based0, 
	   based,
	   stl_subtype0, 
	   type_assign,
	   sbdom,
	   sb_array,
	   decl,
	   data_type,
	   sbset,
	   sbelemv,
	   wbelemv,
	   empty_set,
	   new_val,
	   empty_tuple,
	   is_om,
	   is_string,
	   sbelem,
	   key_type,
--	   new_atom,  removed 5/25/97
	   wbset,
	   in_cell,
	   done,
	   field_list;
pause 'check database relations';  --debug
	stlstlub;		-- high level SETL2 to low level SETL2
	pause 'next step is c compilation';
	setlc;			-- low level SETL2 to C
	loadsn language c;
        print 'The final C program appears just below.';
	unparse testc inf;
    end procedure ;
--
-- translator from high level SETL2 to normal form SETL2
--
    procedure stlstlub() ;
	print 'First analyze for bases and strongly based sets and maps.';
	ubnorm;	-- normalize SETL2 code and calculate database relations
	        -- .b < .t => empty, stl_subtype0(.b,.t) based0(.b)
	        -- .v : .t => empty, type_assign(.v,.t)
                -- empty_set, empty_tuple, is_om, 
	cleandb;
pause 'just before initdb done';
	initdb done;
	usedb;  -- use relations created by ubnorm
	print 'perform semantic analyses';
	analyze translate;
pause 'about to analyze read_list';
	analyze read_list;        -- relation in transcript read_list
pause 'about to analyze stl_subtype';
	analyze stl_subtype;      -- transcript stl_subtype
        pause 'bases analyzed; print created, based, sbdom, sbset,wbset';
	database
	   base_elemof,
	   created,
	   sub_type,
	   domain_link,
	   is_array,
	   fbase,
	   based,
	   base_link,
	   range_link,
	   stl_keytype,
	   read_list,
	   decl,
	   decl_array,
	   field_index,   -- smrelation copied to database relation
	   is_proc,
	   array_type,
	   is_record,
	   data_type,
	   cdata_type,
	   in_cell,
	   sbset,
	   wbset,
	   ubset,
	   sbelem,
	   wbelem,
	   sb_array,
	   sbelemof,
	   self_access,
	   self_accesser,
	   sbdom,
	   sbelemv,
	   wbelemv,
	   domainv_link,
	   rangev_link,
	   basev_link,
	   done;
-- normalization
	myclean;	-- dead code elimination
	initsm;
	empty_set;
	setcopy;
	forall1;
	compare;
	strcat;          
	setup_self;
	printset;  -- where field_index is used in rewriting
-- based instructions
	setupsbe;
	setupwbe;
	initdb done;
	base_init;
	abaseanl;
	print 'sbasegen';
	sbasegen;
	unparse;
	cleandb;
pause 'based data declarations generated';
	read_convert;	-- call foreign input generator
--input instructions
	readgen;   -- read transformations
	readkeys;  -- read transformations
--implement based instructions in terms of unbased instructions
	withz;     -- based deletion
	image;     -- based map operations
	add;       -- add to based structures
	add_clean; -- cleanup based element addition
	unparse;
	unbase;   -- implement weak and strong bases in terms of unbased data
	enter_base; -- kludge for run-time base construction
	c_field;  -- silly normalization
	passel;   -- silly normalization
	cleandb;
	initdb done;
	setup_dec; -- insert initial declarations
    end procedure;
--
-- normal form for real-time simulation
--   compute relations stl_subtype0(.b,.t), based0(.b), type_assign(.v,.t)
--                     from program declarations .b < .t and .v: .t
--                     empty_set, empty_tuple, is_om
    procedure ubnorm() ;
	end_prog;       -- end program; => end;
	print_norm;     -- print(.x), printa(tty,.x) => stl_printa(.x)
	newval_norm;    -- newval(.x) =>let .t=newval!i in .t(.x) : new_val(.t)
	printgen;       -- stl_printa => printa ,stl_geta => geta
	case_norm;      -- case statements turned to if statements
	setup_print;    -- stl_printa => printa, stl_geta => geta
	sbaseanl0;      -- close=>stl_close,open=>stl_open,{},[],om=> ,.b<.t =>
                        -- empty: stl_subtype0(.b,.t) & based0(.b)
	sbaseanl1;      -- v:tau => empty : type_assign(v,tau)
	forall0;        -- single iteration in one bvar & no filter; no elseifs
	compare_norm;   -- .x .cop .y => compare(.x,.y,.cop)
    end procedure;
--
-- dead code elimination procedure
--
    procedure myclean ( ) ; 
      print 'dead code elimination' ; 
      analyze dead ; 
      database dead;  -- added 6/27/94
      initsm ; 
      pause 'help dead';
      dclean ;  -- eliminate dead statements - added 6/27/94
      delim ;   -- collapse conditional statements - added 6/27/94
      unparse; 
    end procedure ; 
--
-- translator from normal form SETL2 down to C
--
    procedure setlc ( ) ; 
	stlcload;          -- load stlc
	print 'This a demonstration of the RAPTS translator from Set Machine';
	print 'Normal Form to C.';
	unparse stlc;
	print 'Translation will proceed top down by first rewriting the top';
	print 
	  'level program, then rewriting statements, and finally expressions.';
	setlcp;  -- translate top level program
	locate top;
	setlceq; -- translate equalities
	setlcw;  -- translate loops, 
	setlcs;  -- translate loops, conditionals, assignments
	setlct;  -- translate types
	setlcti; -- translate type assignments
	print 'The program is now translated at the statement level.';
	setlcb;  -- translate based statements
	print 'The program is now translated for based structures.';
	setlce;  -- translate read, booleans, and inequality
	emptys;  -- translate sb set and tuple initialization
    end procedure ; 
--
-- SQ2+ to normal form SETL2 translator
--
    procedure frontend()  ; 
--normalize program into form: program .x; .b end;
	end_prog;
	front;
	analyze type;
	analyze mono;
        pause 'help nminfp; help type';
	database
	   ismap,
	   ref_count,
	   free,
	   type,
	   mono,
	   anti,
	   oneone,
	   onemany,
	   manyone,
--	   new_atom,  removed 5/25/97
	   disjoint;
	initsm;
	converge;
	print 'The program just below results from dominated convergence';
	unparse;
        pause 'help type; help prepfd';
	prepfd;
	cleandb;
	print 'The normal form for finite differencing appears just below.';
	unparse;
	fdiff;		-- finite differencing
	unparse;
	forall;
	cleandb;
    end procedure;

    procedure front()  ; 
      refcount ; 
      locate top ; 
      print 'The program just below should be in equational form.' ; 
      unparse ; 
      fpform ; 
      locate top ; 
      print 'The program just below should be in fixed point form.' ; 
      unparse ; 
    end procedure ; 

    procedure refcount (); 
      strip ; 
      eqnm1 ; 
      eqnm2 ; 
      eqnm3 ; 
      eqnm4 ; 
      submit eqnf * ; 
    end procedure ; 

    procedure converge ( ) ; 
      undoanf ; 
      nmaxfp ; 
      nminfp ; 
      quant ; 
      unnegate ; 
      locate top ; 
    end procedure ; 

    procedure fpform ( ) ; 
      maxfp ; 
      minfp ; 
      doanf ; 
    end procedure ; 
------------------------------------------------------------------------
-- LOAD EXECUTABLES
--
-- load executable rw, rc, sr, and x rules for SETL2 translator
--
    procedure ubload () ; 
      loadsn language setl ; 
      loadsn rhs setl ; 
      loadsn lhs setl ; 
      loadrw rwub ; 
      loadrc rcub ; 
      loadsr srub ; 
      loadx xub;
    end procedure ; 
--
-- load executable rw, rc, fd, and sr rules for sq2+ translator
--
    procedure sqload()  ; 
      loadsn language setl ; 
      loadsn rhs setl ; 
      loadsn lhs setl ; 
      loadrw rwstlstl ; 
      loadrc rcstlstl ; 
      loadfd fdstlstl ; 
      loadsr srub ; 
    end procedure ; 
--
-- load executable rw and rc rules for normal form SETL2-to-C translator
--
    procedure stlcload()  ; 
      loadsn language setl ; 
      loadsn rhs c ; 
      loadsn lhs setl ; 
      loadrw rwstlc ; 
      loadrc rcstlc ; 
    end procedure ; 
--
-- load executable rw rules for c to c translation
--
    procedure ccload();
	loadsn language c;
	loadsn rhs c;
	loadsn lhs c;
	loadrw rwcc;
    end procedure;
--------------------------------------------------------------------------
-- META-COMPILERS
--
-- compile rw and rc rules for SETL2-to-normal form SETL2 translator
--
    procedure ubgen ( ) ;
	print 'Compile and save BASED/SETL-to-UNBASED/SETL RW and RC rules.';
	loadsn language setl;
	loadsn rhs setl;
	loadsn lhs setl;
	initrc;
	initrw;
	rslc rwub;
	rslc rcub;
    end procedure;
--
-- compile sr rules shared by SQ2+ and SETL2 translators
--
    procedure srgen ( ) ; 
      	print 
        	'Compile and save semantic rules';
      	loadsn language setl ; 
      	loadsn rhs setl ; 
      	loadsn lhs setl ; 
      	initsr;
	rslc srub;
    end procedure ; 
--
-- compile rw, rc, fd rules for SQ2+-to-SETL2 translator
--
    procedure sqgen ( ) ; 
	print 'Compile and save SETL-to-SETL RW, RC, and FD rules.';
	loadsn language setl;
	loadsn rhs setl;
	loadsn lhs setl;
	initfd;
	initrc;
	initrw;
	rslc rwstlstl;
	rslc rcstlstl;
	rslc fdstlstl;
    end procedure ; 
--
-- compile rw and rc rules for normal form SETL2-to-C translator
--
    procedure stlcgen ( ) ; 
      print 'Compile and save UNBASED/SETL-to-C RW and RC rules.' ; 
      loadsn language setl ; 
      loadsn rhs c ; 
      loadsn lhs setl ; 
      initrc ; 
      initrw ; 
      rslc rwstlc ; 
      rslc rcstlc ; 
    end procedure ; 
--
-- compile rw rules for c to c translation
--
    procedure ccgen();
	loadsn language c;
	loadsn rhs c;
	loadsn lhs c;
	initrc;
	initrw;
	rslc rwcc;
    end procedure;
--
-- compile SQ2+ and SETL2 translators
--
    procedure gencomps ( ) ; 
      sqgen ; 
      print 'setl-to-setl compiled successfully' ; 
      stlcgen ; 
      print 'setl-to-c rewrite rules compiled successfully' ; 
      ubgen ; 
      print 'setl-to-c compiler compiled successfully' ; 
      srgen;
    end procedure ; 
--
-- compile syntax for C and SETL
--
    procedure gentabs ( ) ; 
      rslc snc ; 
      print 'c.syn generated' ; 
      rslc snsetl ; 
      print 'setl.syn generated' ; 
    end procedure ; 

end commands;

