transcript flow();
  comment   'control flow analysis';
--use(t,u) t has uses occurring in part u
--def(s,v) if variable v is defined in statement s
--defv(t,v) if isavar(v), t contains lexpr v, & (t=v, desc(t,v) or desc0(t,v))
--desc([x],x), desc("x1,..,xk",xi) for i=1,...,k & lexpr [x], lexplists x1...xk
--desc0(f(x),f) & desc(f{x},f) for left expressions f(x) and f{x}
--down(u,d) is control flow from u to d, where d is inside of u 
--   and u,d are blocks, statements, thenparts
--up(d,u) is control flow from d to u, where d is inside of u 
--   and u,d are blocks, statements, thenparts
--right(p1,p2) is sideways control flow from p1 to p2
--pass(z) any definition can pass through z
--kill(p,v) if variable v is defined at point p (lexpr or lexplist)
  rel use, def, defv, desc, desc0, down, up, right: [node, node];
      pass: [node];
      kill: [node, tree];
  language setl;
begin
   match(%block, .x%)
   ->  down(.x, lchild(.x)) and up(rchild(.x), .x);

   match(%statement, .x%)
   |   neq(rsyb(.x), nil)
   ->   right(.x, rsyb(.x));

   match(%statement, for .x loop .y end loop;%)
   ->  down(%statement, for .x loop .y end loop;%, .y) and
       use(%statement, for .x loop .y end loop;%, .x) and
       up(.y, %statement, for .x loop .y end loop;%) and
       pass(%statement, for .x loop .y end loop;%) and
       right(.y, .y);

   match(%statement, for .x | .z loop .y end loop;%)
   ->  right(.y, .z) and 
       use(%statement, for .x | .z loop .y end loop;%, .z);

   match(%statement,  while .x loop .y end loop;%)
   ->  down(%statement, while .x loop .y end loop;%, .y) and
       use(%statement, while .x loop .y end loop;%, .x) and
       up(.y, %statement,  while .x loop .y end loop;%) and
       pass(%statement, while .x loop .y end loop;%) and
       right(%statement, while .x loop .y end loop;%, 
                   %statement, while .x loop .y end loop;%);

   match(%statement, if .x end if;%)
   ->  down(%statement, if .x end if;%, .x);

   match(%thenpart, .x then .y%)
   |   down(.z, %thenpart, .x then .y %)
   ->  down(.z, .y) and
       use(%thenpart, .x then .y%, .x) and
       up(.y, .z) and pass(.z);

   match(%thenpart, .x then .y else .w%)
   |   down(.z, %thenpart, .x then .y else .w%)
   ->  down(.z, .y) and
       up(.y, .z) and
       down(.z, .w) and
       up(.w, .z) and
       use(%thenpart, .x then .y else .w%, .x);

   match(%thenpart, .x then .y elseif .w%)
   |   down(.z, %thenpart, .x then .y elseif .w%)
   ->  down(.z, .y) and
       up(.y, .z) and
       down(.z, .w) and
       use(%thenpart, .x then .y elseif .w%, .x);

   match(%statement, printa( .x);%)
   ->  pass(%statement, printa(.x);%) and
       use(%statement, printa(.x);%, .x);

   match(%statement, print_newline( .x);%)
   ->  pass(%statement, print_newline(.x);%);

   match(%statement, .f(.x);%)
   -> pass(%statement, .f(.x);%);

-- fix Apr. 6
   match(%statement, .x .op:= .y;%)  
   |   defv(.x, .z)
   ->  use(%statement, .x .op:= .y;%, .x) and
       use(%statement, .x .op:= .y;%, .y) and
       def(%statement, .x .op:= .y;%, .z);

-- fix Apr. 6

   match(%statement, .f(.x) := .y;%)
   ->  use(loc(), .x);

--#include flowold.spc

   match(%statement, .x := .y;%)
   |   defv(.x, .z)
   ->  use(%statement, .x := .y;%, .y) and
       def(%statement, .x := .y;%, .z);

   match(%statement, read(.x);%)
   |   defv(.x, .z)
   ->  def(%statement, read(.x);%, .z);

   match(%lexpr, .x%)
   |   isavar(.x)
   ->  defv(.x, .x) and kill(.x, .x);

   match(%lexpr, .x(.y)%)
   ->  desc0(%lexpr, .x(.y)%, .x);

   match(%lexpr, .x{.y}%)
   ->  desc0(%lexpr, .x{.y}%, .x);

   match(%lexpr, [.x]%)
   ->  desc(%lexpr, [.x]%, .x);

   match(%lexplist, .x%)
   ->  desc(%lexplist, .x%, lchild(.x));

   desc(.x, .y) and neq(rsyb(.y), nil)
   ->  desc(.x, rsyb(.y));

   desc(.z, .x) and isavar(.x)
   ->  defv(.z, .x) and kill(.z, .x);

   desc0(.y, .x) and isavar(.x)
   ->  defv(.y, .x);
end;




