transcript live();
  comment   'live code analysis';
--pre((v,y) if v is defined before execution of y begins
--reach(x,y)
--post(v,y) if v is defined after execution of y begins
--live(x) if x is an I/O statement or procedure call or encloses a live
--  subterm, or if definition x can reach a live use of x
--livepre is not defined anywhere
  rel pre, reach, post, livepre: [node, node];
      live: [node];
  external freevar: [node, tree];
           down, up, use, right, def: [node, node];
           pass: [node];
	   is_proc: [string];
           kill: [node, tree];
  key live: [1];
  language setl;
begin
   pre(.x, .y) and pass(.y)  --for circular situations
   ->  post(.x, .y);

   pre(.x, .y) and down(.y, .z)
   -> pre(.x, .z);

--variable .x is defined just before .z is entered
   post(.x, .y) and right(.y, .z)
   -> pre(.x, .z);

--variable .x is defined in statement or block .z; i.e., after z is entered
   post(.x, .y) and up(.y, .z)
   -> post(.x, .z);

--variable .y is defined immediately in statement .x; i.e., after .x is entered
   def(.x, .y)
   -> post(.y, .x);

   def(.s, .x) and pre(.z, .s) and
       not kill(.x, .z)
   ->  post(.z,.s);

--
-- rules defining live
--
--AXIOMS
--
   match(%statement, .f(.x);%)
   | is_proc(.f)
   ->  live(%statement, .f(.x);%);

   match(%expr, .f(.x)%)
   | is_proc(.f)
   ->  live(%expr, .f(.x)%);

   match(%statement, printa(.x);%)
   ->  live(%statement, printa(.x);%);

   match(%statement, read(.x);%)  -- added 6/27/94
   ->  live(%statement, read(.x);%);

   match(%statement, print_newline(.x);%)
   ->  live(%statement, print_newline(.x);%);

--
-- INFERENCE RULES
--
--z is a free variable of y that is reachable from definition z
-- find live based on data flow

   reach(.z, .y) and freevar(.y, .z)
   ->  live(.z);

--a term that encloses a live subterm is also live - live based on control
-- flow in a structured language

   live(.x) and neq(pred(.x), nil)
   ->  live(pred(.x));

-- define reach
--definition of variable z is executed before live term x is entered, and
--  y has uses occurring in part of x

   live(.x) and pre(.z, .x) and use(.x, .y)
   -> reach(.z, .y);

end;


