  transcript read_list () ; 
      comment 'constructing reading list' ; 
--read_list(op,[x,[y,[z,[]]]]) is produced for basegen routine
--field_list is defiend in rwub
--done(v,op) where v is a variable that is done wrt op
--read_list1(op, [x,[y,[z, []]]]), where op in {wb,var,base,int,read) - is
--  a stack that gets popped as x,y,and z get implemented and pushed onto
--  read_list
--next(x) if x is an undone readlist variable 
      rel read_list, field_list: [string, typexpr];
          done: [string, string];
          read_list1: [string, typexpr];
          next: [string];
      external  wbset: [typexpr, string];
                sbset, sbdom: [typexpr, string];
                data_type: [tree, typexpr];
                based : [typexpr];
                readlist: [node, typexpr];
      key read_list, read_list1, field_list: [1];
          done: [1, 2];
      incremental read_list,
                  read_list1, field_list: replace;
begin 
--initialization for var, wb, var, base, int
  null(z, read_list(var, z))
  -> read_list(wb, []) and 
     read_list(var, []) and
     read_list(base, []) and
     read_list(int, []);

  readlist(.x, .y)      -- readlist("x,y,z",[x[y[z []]]])
  -> read_list1(read, .y);

  read_list1(read, [.y, .z]) and  not done(.y, read)
  -> next(.y); -- next(y) schedules the next read variable

  read_list(var, .x) and read_list1( read, [.y, .z]) and  done(.y, read)
  -> read_list1(read,.z) and read_list(var, [str(.y), .x]);

  next(.x) and wbset(.b, .x) and read_list(wb, .y) and not done(.x, read)
  -> read_list(wb, [str(.x), .y]) and done(.x, read);

  next(.x) and data_type(.x, int) and read_list(int, .y) and not done(.x, read)
  -> read_list(int, [str(.x), .y]) and done(.x, read);

--strongly based readlist variables are done

  next(.x) and sbset(.b, .x)
  -> done(.x, read);

  next(.x) and sbdom(.b, .x)
  -> done(.x, read);

  read_list(base, .x) and based(.b) and not done(.b, read)
  -> read_list(base, [.b, .x]) and done(.b, read);

end;

