rewriting rwstlc;
      begin 
-- delete setlcb7 on Dec. 22
--DECLARATIONS
-- * .v is of type <.t>; i.e., .v is a tuple with element type .t
        setlct4 : match ( %
          declare ,
          .v : < .t > ; 
        %)  -> rewrite ( %
          tstatement ,
          .t * .v ; 
        %) ; 
--.v is of type .t inside record
        setlct6 : match ( %
          declare ,
          .v : .t ; 
        %)  -> rewrite ( %
          tstatement ,
          .t .v ; 
        %) ; 
--.v is of type .t outside record
        setlct5 : match ( %
          statement ,
          .v : .t ; 
        %)  -> rewrite ( %
          tstatement ,
          .t .v ; 
        %) ; 
--TYPES
--bool
        setlct1 : match ( %
          type ,
          bool 
        %)  -> rewrite ( %
          type ,
          int 
        %) ; 
--record(.t)
        setlct2 : match ( %
          type ,
          record ( 
            .t 
          ) 
        %)  -> rewrite ( %
          type ,
          struct { 
            .t 
          } 
        %) ;
--set(.t) is implemented as a list
        setlct3 : match ( %
          type ,
          { .t } 
        %)  -> rewrite ( %
          type ,
          cellp 
        %) ; 
--tuple(int) is implemented as a list
        setlc_tuple : match ( %
          type ,
          < int >
        %)  -> rewrite ( %
          type ,
          cellp 
        %) ; 

--BASED EXPRESSIONS
--.s:set(.b-s) = {} or .s:map(.b-s,.t) = {}
       is_emptys : match ( %
          expr,
          is_emptys(.b, .s)
        %)  -> rewrite ( %
          expr,
          .b . firsts . .s == 0
        %) ; 
--.e:.b in .s:set(.b-s)
--.e:.b in domain .s:map(.b-s,.t)
        setlcb1 : match ( %
          expr ,
          ismem ( .e , .s , .b ) 
        %)  -> rewrite ( %
          expr ,
          .b . recs [ .e ] . .s . mem 
        %) ; 


--m:map(.b-s,.t)(.e:b)
--
        setlcb5 : match ( %
          expr ,
          getmapval ( .e , .m , .b ) 
        %)  -> rewrite ( %
          expr ,
          .b . recs [ .e ] . .m . image 
        %) ; 
--BASED COMMANDS
-- initialize weakly based set
--.s:set(.b) := {}
        setlcw2 : match ( %
          statement ,
          emptyw(.s,.b) ; 
        %)  -> rewrite ( %
          block ,
            .s = alloccell ; 
        %) ; 
--.v:tuple(.b-s) := []
        emptys2 : match ( %
          statement ,
          emptysbtuple ( .v , .b ) ; 
        %) -> rewrite ( %
          statement ,
          .v = alloc_tuple(.b . size);
        %) ; 
--.s:set(.b-s) with:= .x:b
        setlcb4 : match ( %
          statement ,
          adds ( .x , .s , .b ) ; 
        %)  -> rewrite ( %
          statement ,
          { 
            int .of , .e ; 
            .e = .x ; 
            .of = .b . firsts . .s ; 
            if ( .b . recs [ .e ] . .s . mem == false ) {
              .b . recs [ .e ] . .s . mem = true ; 
              .b . recs [ .e ] . .s . prev = 0 ; 
              .b . recs [ .e ] . .s . next = .of ; 
              .b . firsts . .s = .e ; 
              if ( .of != 0 ) 
              { 
                .b . recs [ .of ] . .s . prev = .e ; 
              } else 
              { 
                .b . lasts . .s = .e ; 
              } 
            }
          } 
        %) : where genvar ( .of ) and genvar ( .e ) ; 

-- .s:map(.b-s,.t)(.x:.b) := .y:.t
        setlc_addfs : match ( %
          statement ,
          addfs ( .x , .s , .b, .y, .t ) ; 
        %) -> rewrite ( %
          statement ,
          { 
            int .of , .e ; 
            cell * tmp;
            .e = .x ; 
            .of = .b . firsts . .s ; 
            if ( .b . recs [ .e ] . .s . mem == false ) {
              tmp = alloccell;
              .b . recs [ .e ] . .s . mem = true ; 
              .b . recs [ .e ] . .s . prev = 0 ; 
              .b . recs [ .e ] . .s . next = .of ; 
              .b . recs [ .e ] . .s . image = tmp;
              .b . firsts . .s = .e ; 
              if ( .of != 0 ) 
              { 
                .b . recs [ .of ] . .s . prev = .e ; 
              } else 
              { 
                .b . lasts . .s = .e ; 
              } 
            }
            get_funcv(.b . recs [ .e ] . .s . image) -> data . .t = .y;
          } 
        %) : where genvar ( .of ) and genvar ( .e ) ; 

--.s:set(.b-s) less:= .x:.b
--.s:map(.b-s,.t)(.x:.b) := om
        setlcb6 : match ( %
          statement ,
          dels ( .x , .s , .b ) ; 
        %) -> rewrite ( %
          statement ,
          { 
            int .of , .l , .e , .p , .n ; 
            .e = .x ; 
            .of = .b . firsts . .s ; 
            .l = .b . lasts . .s ; 
            .b . recs [ .e ] . .s . mem = false ; 
            .p = .b . recs [ .e ] . .s . prev ; 
            .n = .b . recs [ .e ] . .s . next ; 
            .b . recs [ .p ] . .s . next = .n ; 
            .b . recs [ .n ] . .s . prev = .p ; 
            if ( .of == .e ) 
            .b . firsts . .s = .n ; 
            if ( .l == .e ) 
            .b . lasts . .s = .p ; 
          } 
        %) : where genvar ( .of ) and genvar ( .e ) and genvar ( .p ) 
          and genvar ( .n ) and genvar ( .l ) ; 

--
--UNBASED EXPRESSIONS
--
--comparisons  =, /==
        setlce1 : match ( %
          expr ,
          .x /= .y 
        %)  -> rewrite ( %
          expr ,
          .x != .y 
        %) ; 

        setlce6 : match ( %
          expr ,
          .x = .y 
        %)  -> rewrite ( %
          expr ,
          .x == .y 
        %) ; 

--.s:set(.t) = {}, .f:map(.t,.q) = {}
        is_emptyw : match ( %
          expr,
          is_emptyw(.s)
        %)  -> rewrite ( %
          expr,
          .s -> next == NULL
        %) ; 

--logical operations and, or, not
        setlce2 : match ( %
          expr ,
          .x and .y 
        %)  -> rewrite ( %
          expr ,
          .x && .y 
        %) ; 
        setlce3 : match ( %
          expr ,
          .x or .y 
        %)  -> rewrite ( %
          expr ,
          .x || .y 
        %) ; 
        setlce4 : match ( %
          expr ,
          not .x 
        %) -> rewrite ( %
          expr ,
          ! .x 
        %) ; 
-- dereference .x
        setlcwval : match ( %
          expr ,
          getval ( .x ) 
        %)  -> rewrite ( %
          expr ,
          .x ->data . val 
        %) ; 
-- test for empty list with side effect assignment
        setlcw5 : match ( %
          expr ,
          exists .x in .s 
        %)  -> rewrite ( %
          expr ,
          exists ( & .x , .s ) != NULL 
        %) ; 


--UNBASED COMMANDS
-- program
        setlcp : match ( %
          program ,
          program .n ; 
            .b 
          end ; 
        %)  -> rewrite ( %
          program ,
          main ( ) { 
            .b 
          } 
        %) ; 
--conditionals
        setlcs4 : match ( %
          statement ,
          if .e then 
            .b1 
          else 
            .b2 
          end if ; 
        %)  -> rewrite ( %
          statement ,
          if ( .e ) 
          { 
            .b1 
          } else 
          { 
            .b2 
          } 
        %) ; 
        setlcs5 : match ( %
          statement ,
          if .e then 
            .b 
          end if ; 
        %)  -> rewrite ( %
          statement ,
          if ( .e ) 
          { 
            .b 
          } 
        %) ; 
--while loops
        setlcs3 : match ( %
          statement ,
          while .e loop
            .b 
          end loop; 
        %)  -> rewrite ( %
          statement ,
          while ( .e ) 
          { 
            .b 
          } 
        %) ; 
--until loops
        setlcs6 : match ( %
          statement ,
          until .e loop
            .b 
          end loop; 
        %)  -> rewrite ( %
          statement ,
          do 
          { 
            .b 
          } while ( ! ( .e ) ) ; 
        %) ; 
--for loops
        setlcw1 : match ( %
          statement ,
          for .x in .s loop
            .b 
          end loop; 
        %)  -> rewrite ( %
          statement ,
          { 
            cell * .y ; 
            if (.s == NULL)
              {
              .y = NULL;
              }
            else
              {
              .y = .s -> next ; 
              }
            while ( .y != NULL ) 
            { 
              .x = .y ; 
              { 
                .b 
              } 
              .y = .y -> next ; 
            } 
          } 
        %) : where genvar ( .y ) ; 

--assignment
        setlcs2 : match ( %
          statement ,
          .x := .y ; 
        %)  -> rewrite ( %
          statement ,
          .x = .y ; 
        %) ;
--null 
        setlcs1 : match ( %
          statement ,
          null ; 
        %)  -> rewrite ( %
          statement ,
          ; 
        %) ; 
-- initialize tuple
--.s := []
        setlc_seq : match ( %
          statement ,
          .s := [ ] ; 
        %) -> rewrite ( %
          block ,
            .s = alloccell ; 
        %) ; 

--arithmetic updates
        setlcassignminus : match ( %
          statement ,
          .x - := .y ; 
        %)  -> rewrite ( %
          statement ,
          .x -= .y ; 
        %) ; 
        setlcassignplus : match ( %
          statement ,
          .x + := .y ; 
        %)  -> rewrite ( %
          statement ,
          .x += .y ; 
        %) ; 

--.s: less:= .x using linked list deletion (weakly based and unbased sets)
        setlcw4 : match ( %
          statement ,
          del(.x, .s);
        %)  -> rewrite ( %
          statement ,
          { 
            cell * .op , * .on ; 
            .op = .x -> prev ; 
            .on = .x -> next ; 
            free ( .x ) ; 
            if ( .op != NULL ) 
            { 
              .op -> next = .on ; 
            } else 
            { 
              .s -> next = .on ; 
            } 
            if ( .on != 0 ) 
            { 
              .on -> prev = .op ; 
            } else 
            { 
              .s -> prev = .op ; 
            } 
          } 
        %) : where genvar ( .op ) and genvar ( .on ) ; 
--.y with:= .x
add_ubset : match ( %
          statement ,
          addub(.x, .s, .t);
        %)  -> rewrite ( %
          statement ,
          { 
            cell * .p , * .of ; 
            if (.s == NULL)
               { .s = alloccell ; 
               }
            .p = alloccell ; 
            .of = .s -> next ; 
            .p -> next = .of ; 
            .p -> data . .t = .x ; 
            if ( .of != NULL ) 
            { 
              .of -> prev = .p ; 
            } else 
            { 
              .s -> prev = .p ; 
            } 
            .s -> next = .p ; 
          } 
        %) : where genvar ( .p ) and genvar ( .of ) ; 

--READ ROUTINES
        readwbset : match ( %
          statement ,
          readwbset ( .b ) ; 
        %)  -> rewrite ( %
          statement ,
          readwbset ( & .b ) ; 
        %) ; 
        readint : match ( %
          statement ,
          readint ( .i ) ; 
        %)  -> rewrite ( %
          statement ,
          readint ( & .i ) ; 
        %) ; 




   end ; 
end rewriting;
