--delete unused rwrules Dec. 23
rewriting rwub;
--type_assign(x,b) for variable x with type b
--in_cell
--decl
--sbelem
--data_type
--read_list
--base_link
--field_list
--type
--decl
--done
--key_type
--stl_subtype
--empty_set
--empty_tuple
--is_om(x) if variable x stands for om
--mark3
begin 

--called from ubnorm - normalize SETL2 program

--end_prog
endprog: match(%program,
		program .x;
		.b
		end .xx;%)
	 -> rewrite(%program,
		     program .x;
 		     .b
		    end;%);

--print_norm
printnorm: match(%
       statement, print(.x);
      %)
      -> rewrite(%statement,
         printa(tty, .x);
      %);
printanormal : match ( %
           statement, printa(.x);
        %)
        -> rewrite ( % statement,
            stl_printa(.x);
        %);

--newval_norm
new_val: match(%expr, newval(.x)%)
         ->   rewrite(%expr, .t(.x)%)
         :    new_val(.t) 
         where bind(.t, newatom(newval));

--printgen
printa_gen:
   match(%statement, stl_printa(.x, .y);%)
   | eq(syntype(.y), expr)
   -> rewrite (%block,
        printa(.x, .y);
        print_newline(.x);
     %);
printa_gen1:  -- bug - must generalize
   match(%statement, stl_printa(.x, .y, .z);%)
   -> rewrite (%block, 
        printa(.x, .y);
        stl_printa(.x, .z);
     %);
printa_elim:
   match(%statement, stl_printa(.x);%)
   | eq(syntype(.x), expr)
   -> rewrite (%
       statement,
       print_newline(.x);
     %);
geta_gen:
   match(%statement, stl_geta(.x, .y);%)
   | eq(syntype(.y), expr)
   -> rewrite (%statement,
        geta(.x, .y);
     %);
geta_gen1: -- bug- must generalize
   match(%statement, stl_geta(.x, .y, .z);%)
   -> rewrite (%block, 
        geta(.x, .y);
        stl_geta(.x, .z);
     %);

--case_norm
case0: match(% statement,
               case .x
                when .y => .z
               end case; %)
      -> rewrite
         (%statement,
            if .x = .y then
                  .z
            end if; %);
case1: match(%statement, 
               case .x
                .y
                .z
               end case; %)
      -> rewrite
         (%statement,
               if dum then
                  case .x
                      .y
                  end case;
               else  case .x
                          .z
                     end case;
               end if; %);
case2: match(%statement,
               if dum then
                  if .x then .y end if;
               else  .z
               end if; %)
      -> rewrite
         (%statement,
               if .x then .y
               else  .z
               end if; %);
case3: match(%statement, 
               case .x
                when .y => .z
                otherwise => .w
               end case; %)
      -> rewrite
         (%statement,
               if .x = .y then .z
               else  .w
               end if; %);
otherwise: match(%statement, 
               case .x
                otherwise => .z
               end case; %)
           -> rewrite(%block, .z %);
when: match(%whenstmt, 
                when .x, .y  => .z
            %)
      | eq(syntype(.x), explist)
      -> rewrite
         (%whenstmt,
                when .x or condlist(.y) => .z
         %);
condlist: match(%expr,
               condlist(.x, .y)
            %)
      -> rewrite
         (%expr,
               .x or condlist(.y)
         %);
condlist0: match(%expr,
               condlist(.x)
            %)
      | eq(syntype(.x), expr)
      -> rewrite
         (%expr,
               .x
         %);

--setup_print
printa_convert : match ( %
           statement, stl_printa(.x);
        %)
        -> rewrite ( % statement,
            printa(.x);
        %);
geta_convert : match ( %
           statement, stl_geta(.x);
        %)
        -> rewrite ( % statement,
            geta(.x);
        %);

--sbaseanl0
setup : match ( %
          statement ,
          .b < .t ; 
        %)  -> rewrite ( %
           emptytree
        %) : stl_subtype0 ( .b , %
            type ,
            .t 
          %) and based0 ( .b )
        ; 
emptyelim : match ( %
          expr,
          {}
        %) | bind(.x, newatom(empty_set)) -> rewrite ( %
          expr,
          .x
        %) : empty_set(%expr, .x%);
emptyelim1 : match ( %
          expr,
          []
        %) | bind(.x, newatom(empty_tuple)) -> rewrite ( %
          expr,
          .x
        %) : empty_tuple(%expr, .x%);
omelim : match ( %
          expr,
          om
        %) | bind(.x, newatom(om)) -> rewrite ( %
          expr,
          .x
        %) : is_om(%expr, .x%);
open : match ( %
           expr, open(.x)
        %) 
          -> rewrite ( %
            expr,
            stl_open(.x)
        %);
close : match ( %
           statement, close(.x);
        %)
          -> rewrite ( %
           statement,
            stl_close(.x);
        %);

-- sbaseanl1
ielim : match ( %
          statement ,
          .x : .b ; 
        %)
         -> rewrite ( %
          emptytree
        %): type_assign(%vdec, .x%, %type, .b%);

-- forall0
elseif : match ( %
          elsepart ,
            elseif
            .y 
        %) -> rewrite ( %
          elsepart,
           else if
            .y 
           end if;
        %);
 cleanc17:              -- bug - generalize to arbitrary degree of nesting
       match(%
        statement,  
         for .x in .y , .z in .w loop
             .b
         end loop ; 
       %) 
       ->
       rewrite(%
         statement,
         for .x in .y loop
            for .z in .w loop
                .b
            end loop ;
         end loop ; 
         %);
 cleanc19:
        match(%
         statement,  
          for [ .x , .y ] in .g loop
              .b
          end loop ; 
        %) 
        ->
        rewrite(%
          statement,
          for .x1 in .g loop
                 .x := .x1(1);
                 .y := .x1(2);
                 .b
          end loop ; 
       %): bind(.b1, newatom(b)) and
           bind(.b2, newatom(b)) and
           type_assign( %expr,.x1%, %type, (.b1, .b2)%)
           where genvar(.x1);
wforall1 : match ( %
          statement ,
          for .x in .y | .k loop
            .b 
          end loop ; 
        %) -> rewrite ( %
          statement,
            for .x in .y loop
              if .k then 
                .b 
              end if ; 
            end loop ; 
        %) ; 

-- compare_norm
compare_lt: match(%expr, .x < .y%)
            -> rewrite(%expr, compare(.x, .y, lt)%);
compare_gt: match(%expr, .x > .y%)
            -> rewrite(%expr, compare(.x, .y, gt)%);
compare_le: match(%expr, .x <= .y%)
            -> rewrite(%expr, compare(.x, .y, le)%);
compare_ge: match(%expr, .x >= .y%)
            -> rewrite(%expr, compare(.x, .y, ge)%);

--called from myclean

--dclean
empty_state1:match(%statement,.x%) |
               dead(.x) and not dead(pred(.x)) and ( neq(rsyb(.x),nil) or 
               neq(lsyb(.x),nil) ) ->
                 rewrite(%emptytree%);
empty_state2:match(%statement,.x%) |
               dead(.x) and eq(rsyb(.x),nil) and eq(lsyb(.x),nil) ->
                 rewrite(%statement,null;%);

--delim
delim4 : match ( %
          thenpart ,
          .x then 
            null ; 
          else 
            .z 
        %) -> rewrite ( %
          thenpart ,
          not .x then 
            .z 
        %) ; 
delim5 : match ( %
          thenpart ,
          .x then 
            null ; 
          elseif .z 
        %) -> rewrite ( %
          thenpart ,
          not .x then 
            if .z end if ; 
        %) ; 
delim6 : match ( %
          thenpart ,
          .x then 
            .y 
          elseif .z then 
            null ; 
        %) -> rewrite ( %
          thenpart ,
          .x then 
            .y 
        %) ; 
delim7 : match ( %
          thenpart ,
          .x then 
            .y 
          else 
            null ; 
        %)  -> rewrite ( %
          thenpart ,
          .x then 
            .y 
        %) ; 

--called from stlstlub - normalization

--empty_set
emptys : match ( %
          statement ,
          .s := .x ; 
        %) | empty_set(.x) and sbset ( .b , .s ) -> rewrite ( %
          statement ,
          emptys ( .s , .b ) ; 
        %) ; 
emptysmap : match ( %
          statement ,
          .s := .x ; 
        %) 
        | sbdom ( .b , .s ) and empty_set(.x)
        -> rewrite ( %
          statement ,
          emptys ( .s , .b ) ; 
        %) ; 
emptyubset : match ( %
          statement ,
          .s := .x ; 
        %) 
        | ubset ( .b , .s ) and empty_set(.x)
        -> rewrite ( %
          statement ,
          emptyub ( .s ) ; 
        %) ; 
empty_tuple : match ( %
          statement ,
          .s := .x ; 
        %) | empty_tuple(.x) -> rewrite ( %
          statement ,
          emptytuple ( .s ) ; 
        %) ; 

--setcopy
setcopy1 : match ( %
          statement ,
          .a := .b;
        %) | sbset(.b1, .a)
          -> rewrite ( %
          block ,
            emptys(.a, .b1) ; 
            for .z in .b loop
              .a with := .z ; 
            end loop ; 
        %) : base_link ( .z , .b1 ) and decl(.z, int)
        where genvar ( .z );

--forall1 This looks wrong - should be .f less:=[.x,f(.x)]
funcom : match ( %
          statement ,
          .f ( .x ) := .y ; 
        %) | is_om(.y)
        -> rewrite ( %
          statement ,
          .f less:= .x;
        %) ; 
domelim:
         match(%
          expr,
          domain .y
        %)
        -> rewrite (%
          expr,
          .y
       %);

--compare
compare_val0: match(%expr, compare(.x, .y, .t)%)
             | base_link(.x, .b) and based(.b)
             -> rewrite(%expr, compare(getkeyimage(.x, .b), .y, .t)%);

compare_val1: match(%expr, compare(.x, .y, .t)%) --fix
             | base_link(.y, .b) and based(.b)
             -> rewrite(%expr, compare(.x, getkeyimage(.y, .b), .t)%);

--strcat
str_cat: match(%expr, .x+.y%)
         | data_type(.x, [pointer, char])
         -> rewrite(% expr, strcat(.x, .y)%);

--setup_self
self_del0:
       match(% statement, .x less:= .y;%)
       | self_access(.y, .x, %statement, .x less:= .y;%)
       -> rewrite(%statement, self_access(.x, less, .y);%);

--printset
printsbset : match ( %
          statement ,
          printa ( .h, .x ) ; 
        %) | sbset ( .b , .x ) -> rewrite ( %
             block,
             print_str(.h,"{");
             .x1 := getfirst(.x, .b);
             while .x1 /=0  loop
                 print_sbelem(.h,.b, .x1);
                .x1 := getnext(.x, .b, .x1);
             end loop;
            print_str(.h,"}");
            print_newline(.h);
            print_newline(.h);
        %): sbelem(.x1) and decl(.x1, int)
             where genvar(.x1) ; 
printwbset : match ( %
          statement ,
          printa ( .h, .x ) ; 
        %) | base_link(.x, .b) and sub_type(.b, [set, .b1]) and 
             not based(.b) and not sbset(.b3, .x) and not sbdom(.b2, .x)
           -> rewrite ( %
          block ,
          print_wbset (.h, .b, .x ) ; 
          print_newline(.h);
        %) ; 
printsbmap : match ( %
          statement ,
          printa ( .h, .x ) ; 
        %) | sbdom ( .b , .x ) and range_link(.x, .b1) -> rewrite ( %
             block ,
             .x1 := getfirst(.x, .b);
             while .x1 /=0  loop
                print_sbelem (.h, .b , .x1 ) ; 
                print_str(.h, "-> ");
                print_newline(.h);
                print_wbset (.h, .b1 , getmapval(.x1, .x, .b ) ); 
                .x1 := getnext(.x, .b, .x1);
             end loop;
             print_newline(.h);
        %): sbelem(.x1) and decl(.x1, int)
            where genvar(.x1) ; 
print_array : match ( %
          statement ,
          printa ( .h, .x ) ; 
        %) | base_link(.x, .b) and array_type(.b, .b1) and 
             not based(.b) and not sb_array(.b1, .x)
           -> rewrite ( %
          block ,
          print_array (.h, .b1, .x ) ; 
          print_newline(.h);
        %) ; 
print_array0 : match ( %
          statement ,
          print_array (.h, .b, .x ) ; 
        %) | cdata_type(.b, .t)
        -> rewrite ( %
          block ,
          print_str(.h, "[");
          for .x1 in .x loop
              print_elem (.h, .b , get_field(.x1, .t)) ; 
          end loop;
          print_str(.h,"]");
          print_newline(.h);
        %): decl(.x1, cellp) and done(.x1, self)
            where genvar(.x1) ; 
printint : match ( %
          statement ,
          printa ( .h, .x ) ; 
        %) | base_link(.x, int) -> rewrite ( %
         block,
         print_int (.h, .x ) ; 
         print_newline(.h);
        %) ; 
print_wbset0 : match ( %
          statement ,
          print_wbset (.h,.b, .x ) ; 
        %) | sub_type(.b, [set, .b1]) and cdata_type(.b1, .t)
        -> rewrite ( %
          block ,
          print_str(.h,"{");
          for .x1 in .x loop
              print_elem (.h, .b1 , get_field(.x1, .t)) ; 
          end loop;
          print_str(.h,"}");
          print_newline(.h);
        %): decl(.x1, cellp) and data_type(.x1, [pointer, cell]) and
            done(.x1, self)
            where genvar(.x1) and genvar(.x2); 
print_wbset1 : match ( %
          statement ,
          print_wbset (.h,.b, .x ) ; 
        %) | sub_type(.b, [set, .b1]) and 
             sub_type(.b1, [record, .b2])
        -> rewrite ( %
          block ,
          print_str(.h,"{");
          for .x1 in .x loop
              .x1 := getfirstw(getimagew(.x1));
              print_record(.h,.b2,.x1);
          end loop;
          print_str(.h,"}");
          print_newline(.h);
        %): decl(.x1, cellp)
            where genvar(.x1) ; 
print_tuple:
         match(%
          statement,
          print_tuple(.h, .b1, .b2, .x);
         %)
         -> rewrite(%
              block,
              print_str(.h, " [");
              .x1 := getfirstw(.x);
              print_elem (.h, .b1 , .x1) ; 
              .x1 := getnextw(.x1);
              print_elem (.h, .b2 , .x1) ; 
              print_str(.h, "]");
         %): decl(.x1, cellp)
             where genvar(.x1);
print_elem0 : match ( %
          statement ,
          print_elem (.h, int, .x ) ; 
        %)  -> rewrite ( %
             statement,
              print_int (.h, .x ) ; 
        %);
print_elem1 : match ( %
          statement ,
          print_elem (.h,.b, .x ) ; 
        %) | based(.b) -> rewrite ( %
             statement,
              print_sbelem (.h, .b, .x ) ; 
        %);
print_elem2 : match ( %
          statement ,
          print_elem (.h,.b, .x ) ; 
        %) | not based(.b) and
             sub_type(.b, [record, .b1])
           -> rewrite ( %
          statement,
          print_record(.h,.b1,.x);
        %);
print_elem3 : match ( %
          statement ,
          print_elem (.h, .b, .x ) ; 
        %) | sub_type(.b, int) and not based(.b) -> rewrite ( %
             statement,
              print_int (.h, .x ) ; 
        %);
print_elem5 : match ( %
          statement ,
          print_elem (.h, str, .x ) ; 
        %)  -> rewrite ( %
             statement,
              print_str (.h, .x) ; 
        %);
print_elem4 : match ( %
          statement ,
          print_elem (.h, .b, .x ) ; 
        %) | sub_type(.b, [record, [.n, .b1]])
        -> rewrite ( % block,
           print_str(.h, "[ ");
           print_record (.h, 1, .b, .x ) ; 
           print_str(.h, "]");
        %);
print_record0 : match ( %
          statement ,
          print_record (.h, .n, .b, .x ) ; 
        %) | field_index(.b, .n, .b1) and cdata_type(.b1, .b2)
        -> rewrite ( %
           block,
           print_elem(.h, .b1, recelem(.x, .n, .b2));
           print_str(.h, " ");
           print_record (.h, .m, .b, .x ) ; 
        %): where bind(.m, add(.n, 1)) ; 
-- fix by adding "| sub_type.... 7/7/94
print_record1 : match ( %
          statement ,
          print_record (.h, .n, .b, .x ) ; 
        %) | sub_type(.b, [record, [.m, .b1]]) and eq(.n, add(.m, 1))
        -> rewrite ( % statement,
           null;
        %);
print_sbelem0 : match ( %
          statement ,
          print_sbelem (.h,.b, .x ) ; 
        %) | sub_type( .b , [set, .b1] )
          -> rewrite ( %
          statement ,
          print_wbset (.h, .b , getkeyimage(.x, .b) ) ; 
        %);
print_sbelem1 : match ( %
          statement ,
          print_sbelem (.h, .b, .x ) ; 
        %) | not sub_type( .b , [set, .b1])
           -> rewrite ( %
          statement ,
          print_int (.h, getkeyimage(.x, .b) ) ; 
        %);
printsbelem0 : match ( %
          statement ,
          printa ( .h, .x ) ; 
        %) | base_link(.x, .b) and based(.b) and data_type(.x, int)
        -> rewrite ( %
         block,
         print_sbelem (.h, .b, .x ) ; 
         print_newline(.h);
        %) ; 
printsbelem1 : match ( %
          statement ,
          printa ( .h, .x ) ; 
        %) | base_link(.x, .b) and based(.b) and data_type(.x, [pointer, cell])
        -> rewrite ( %
         block,
         print_sbelem (.h, .b, get_field(.x, intv) ) ; 
         print_newline(.h);
        %) ; 

--based instructions

--setupsbe
self_forall:
         match(%
          statement,
          for .x in .y loop
            .b
          end loop;
        %)
        | not sbset(.b1, .y) and 
          not sbdom(.b1, .y) and 
          not done(.x, self) and
          base_link(.x, .b2) and
          cdata_type(.b2, .t)
        -> rewrite (%
        statement,
        for .x1 in .y loop
           .x := get_field(.x1, .t);
          .b
        end loop;
       %): in_cell(.x, .x1) and decl(.x1, cellp) and done(.x1, self)
           where genvar(.x1);
self_while:
         match(%
          statement,
          while exists .x in .y loop
            .b
          end loop;
        %)
        | not sbset(.b1, .y) and 
          not sbdom(.b1, .y) and 
          not done(.x, self) and
          base_link(.x, .b2) and
          cdata_type(.b2, .t)
        -> rewrite (%
        statement,
        while exists .x1 in .y loop
           .x := get_field(.x1, .t);
          .b
        end loop;
       %): in_cell(.x, .x1) and decl(.x1, cellp) and done(.x1, self)
           where genvar(.x1);
self_if:
         match(%
          statement,
          if exists .x in .y then
            .b
          end if;
        %)
        | not sbset(.b1, .y) and 
          not sbdom(.b1, .y) and 
          not done(.x, self) and
          base_link(.x, .b2) and
          cdata_type(.b2, .t)
        -> rewrite (%
        statement,
        if exists .x1 in .y then
           .x := get_field(.x1, .t);
          .b
        end if;
       %): in_cell(.x, .x1) and decl(.x1, cellp) and done(.x1, self)
           where genvar(.x1);

--setupwbe
self_del1:
       match(% statement, self_access(.x, less, .y);%)
       | in_cell(.y, .y1)
       -> rewrite(%statement, .x less:= .y1;%);
self_del2:
       match(% statement, self_access(.x, less, .y);%)
       | not in_cell(.y, .y1)
       -> rewrite(%statement, .x less:= .y;%);

--base_init
baseinit : match ( %
          program ,
          program .x ; 
            .b 
          end ; 
        %) | exists(.b1, based(.b1),not done(.b1, init)) -> rewrite ( %
          program ,
          program .x ; 
             base_init(.b1);
            .b 
          end ; 
        %) : done(.b1, init);
baseinits : match ( %
        statement, base_init(.b);
        %) | exists(.v, sbset(.b, .v), not done(.v, binit)) 
        -> rewrite ( %
          block,
             base_init(.b);
             sbset_init(.b, .v);
        %) : done(.v, binit);
baseinitm : match ( %
        statement, base_init(.b);
        %) | exists(.v, sbdom(.b, .v), not done(.v, binit)) 
        -> rewrite ( %
          block,
             base_init(.b);
             sbmap_init(.b, .v);
        %) : done(.v, binit);

--abaseanl
        setup1 : match ( %
          program ,
          program .x ; 
            .y 
          end ; 
        %) | exists ( .b , based ( .b ), not done ( .b, decl ) ) and
             stl_keytype ( .b , .t )
           -> rewrite ( %
          program ,
          program .x ; 
            .b : record ( 
              size : int ; 
              recs : < record ( 
                key : .t ; 
              ) > ; 
            ) ; 
            .y 
          end ; 
        %) : done ( .b, decl ) and 
             field_list ( .b , [ ] ) and key_type(%type,.t%)
        ; 

--sbasegen
sbmap1 : match ( %
          statement ,
          .b : record ( 
            size : int ; 
            recs : < record ( 
              .d 
            ) > ; 
          ) ; 
        %) | exists ( .s , sbdom ( .b , .s ) , true) and 
             field_list ( .b , .b1 ) -> rewrite ( %
          statement ,
          .b : record ( 
            size : int ; 
            recs : < record ( 
              .d 
              .s : record ( 
                mem : bool ; 
                prev : int ; 
                next : int ; 
                image : cellp; 
              ) ; 
            ) > ; 
            lasts : record ( 
              .s : int ; 
            ) ; 
            firsts : record ( 
              .s : int ; 
            ) ; 
          ) ; 
        %) : done ( .s, decl ) and field_list ( .b , [ .s , .b1 ] ) 
        ; 
sbset1 : match ( %
          statement ,
          .b : record ( 
            size : int ; 
            recs : < record ( 
              .d 
            ) > ; 
          ) ; 
        %) 
        | exists(.s, sbset ( .b, .s ), 
           not (exists(.s1, sbdom(.b, .s1), eq(.s, %expr, domain .s1%)))) and 
         field_list(.b, .x)
        -> rewrite ( %
          statement ,
          .b : record ( 
            size : int ; 
            recs : < record ( 
              .d 
              .s : record ( 
                mem : bool ; 
                prev : int ; 
                next : int ; 
              ) ; 
            ) > ; 
            lasts : record ( 
              .s : int ; 
            ) ; 
            firsts : record ( 
              .s : int ; 
            ) ; 
          ) ; 
        %) : done ( .s, decl ) and field_list ( .b , [ .s , .x ] ) 
        ; 
sbmap2 : match ( %
          statement ,
          .b : record ( 
            size : int ; 
            recs : < record ( 
              .d 
            ) > ; 
            lasts : record ( 
              .l 
            ) ; 
            firsts : record ( 
              .f 
            ) ; 
          ) ; 
        %) | exists ( .s , sbdom ( .b , .s ) , not done ( .s, decl )) and 
             field_list ( .b , .b1 ) -> rewrite 
          ( %
          statement ,
          .b : record ( 
            size : int ; 
            recs : < record ( 
              .d 
              .s : record ( 
                mem : bool ; 
                prev : int ; 
                next : int ; 
                image : cellp ; 
              ) ; 
            ) > ; 
            lasts : record ( 
              .l 
              .s : int ; 
            ) ; 
            firsts : record ( 
              .f 
              .s : int ; 
            ) ; 
          ) ; 
        %) : done ( .s, decl ) and field_list ( .b , [ .s , .b1 ] ) 
        ; 
sbset2 : match ( %
          statement ,
          .b : record ( 
            size : int ; 
            recs : < record ( 
              .d 
            ) > ; 
            lasts : record ( 
              .l 
            ) ; 
            firsts : record ( 
              .f 
            ) ; 
          ) ; 
        %) 
        |  exists(.s, sbset ( .b, .s ), 
             not done(.s, decl) and 
             not (exists(.s1, sbdom(.b, .s1), 
                         eq(.s, %expr, domain .s1%)))) and 
          field_list(.b, .x)
       -> rewrite ( %
          statement ,
          .b : record ( 
            size : int ; 
            recs : < record ( 
              .d 
              .s : record ( 
                mem : bool ; 
                prev : int ; 
                next : int ; 
              ) ; 
            ) > ; 
            lasts : record ( 
              .l 
              .s : int ; 
            ) ; 
            firsts : record ( 
              .f 
              .s : int ; 
            ) ; 
          ) ; 
        %) : done ( .s, decl ) and field_list ( .b , [ .s , .x ] ) 
        ; 

--input instructions

--readkeys
readintkey : match ( %
          statement ,
          readkey ( .b ) ; 
        %) | stl_keytype(.b, int)
           -> rewrite ( %
          statement,
            readkey_int ( .b) ; 
        %) ; 
readptrkey: match ( %
          statement ,
          readkey ( .b ) ; 
        %) | stl_keytype(.b, cellp)
           -> rewrite ( %
          statement,
            readkey_ptr ( .b ) ; 
        %) ; 

--readgen
read_init : match ( %
          statement ,
          read ( .x ) ; 
        %)  -> rewrite ( %
            block,
            readbasegen ( dum ) ; 
            readwbsetgen ( dum ) ; 
            readintgen ( dum ) ; 
        %) ; 
readint : match ( %
          statement ,
          readintgen ( dum ) ; 
        %) | read_list ( int , [ .b , .t ] ) -> rewrite ( %
          block ,
            readint ( .b ) ; 
            readintgen ( dum ) ; 
        %) : read_list ( int , .t ) 
        ; 
readintelim : match ( %
          statement ,
          readintgen ( dum ) ; 
        %) | read_list ( int , [ ] ) -> rewrite ( %
          emptytree
        %) ; 
readwbset : match ( %
          statement ,
          readwbsetgen ( dum ) ; 
        %) | read_list ( wb , [ .b , .t ] ) -> rewrite ( %
          block ,
            readwbset ( .b ) ; 
            readwbsetgen ( dum ) ; 
        %) : read_list ( wb , .t ) 
        ; 
readsetfield : match ( %
          statement ,
          readkey ( .x ) ; 
        %) | field_list ( .x , [ .a , .b ] ) and sbset ( .x , .a ) -> 
          rewrite ( %
          block ,
            readkey ( .x ) ; 
            readsetfield ( .x , .a ) ; 
        %) : field_list ( .x , .b ) 
        ; 
readmapfield : match ( %
          statement ,
          readkey ( .x ) ; 
        %) | field_list ( .x , [ .a , .b ] ) and sbdom ( .x , .a ) -> 
          rewrite ( %
          block ,
            readkey ( .x ) ; 
            readmapfield ( .x , .a ) ; 
        %) : field_list ( .x , .b ) 
        ; 
readwbsetelim : match ( %
          statement ,
          readwbsetgen ( dum ) ; 
        %) | read_list ( wb , [ ] ) -> rewrite ( %
          emptytree
        %) ; 
readbase : match ( %
          statement ,
          readbasegen ( dum ) ; 
        %) | read_list ( base , [ .b , .t ] )
           -> rewrite ( %
          block ,
            readkey ( .b ) ; 
            readbasegen ( dum ) ; 
        %) : read_list ( base , .t ) 
        ; 
readbaseelim : match ( %
          statement ,
          readbasegen ( dum ) ; 
        %) | read_list ( base , [ ] ) -> rewrite ( %
          emptytree
        %) ; 

--implement based instructions in terms of unbased instructions

--withz
del0 : match ( %
          statement ,
          .y less := .x ; 
        %) 
        -> rewrite ( %
          statement ,
          del ( .x , .y ) ; 
        %) ; 
add0 : match ( %
          statement ,
          .y with := .x ; 
        %) | not is_array(.y)
          -> rewrite ( %
          statement ,
          add(.x, .y);
        %) ; 
mem0 : match ( %
          expr ,
          .x in .y 
        %) 
          -> rewrite ( %
          expr ,
          ismem0 ( .x , .y )
        %) ; 
mem1 : match ( %
          expr ,
          ismem0(.x, .y )
        %) | (sbset ( .b , .y ) or sbdom(.b, .y))
          -> rewrite ( %
          expr ,
          ismem1 ( .x , .y , .b ) 
        %) ; 
mems : match ( %
          expr ,
          ismem1(.x, .y, .b )
        %) | sbelem(.x)
          -> rewrite ( %
          expr ,
          ismem ( .x , .y , .b ) 
        %) ; 
memw : match ( %
          expr ,
          ismem1(.x, .y, .b )
        %) | data_type(.x, [pointer, cell])
          -> rewrite ( %
          expr ,
          ismem ( getval(.x) , .y , .b ) 
        %) : where print(MEMW); 
notmem : match ( %
          expr ,
          .x notin .y 
        %) 
          -> rewrite ( %
          expr ,
          not ismem0 ( .x, .y)
        %) ; 
add_tuple : match ( %
          statement ,
           .y with:= .x;
        %) | is_array(.y)
          -> rewrite ( %
          statement ,
          addw(.x, .y);
        %) ; 

--image
maps : match ( %
          expr ,
          image_set(.y, .f)
        %) | sbdom ( .b , .f )
          -> rewrite ( %
          expr ,
          getmapval ( .y , .f , .b ) 
        %) ; 
mapsl : match ( %
           lexpr,
           image_set(.y, .f )
        %) | sbdom ( .b , .f )
          -> rewrite ( %
          lexpr ,
          getmapval ( .y , .f , .b )
        %); 
funcs : match ( %
          expr ,
          .f ( .y ) 
        %) | sbdom ( .b , .f ) and data_type(.y, int) and
             base_link(%expr, .f( .y )%, .b1) and cdata_type(.b1, .t)
           -> rewrite ( %
          expr ,
          getfuncval ( .y , .f , .b, .t) 
        %) ; 
funcw : match ( %
          expr ,
          .f ( .y ) 
        %) | 
          sbdom ( .b , .f ) and data_type(.y, [pointer, cell])
          -> rewrite ( %
          expr ,
          getfuncval ( getval ( .y ) , .f , .b ) 
        %): where print( FUNCW ); 
funcsl : match ( %
          lexpr ,
          .f ( .y ) 
        %) | sbdom ( .b , .f ) and data_type(.y, int) and
             base_link(%lexpr, .f( .y )%, .b1) and cdata_type(.b1, .t)
        -> rewrite ( %
          lexpr ,
          getfuncval ( .y , .f , .b, .t) 
        %) ; 
funcwl : match ( %
          lexpr ,
          .f ( .y ) 
        %) | 
          sbdom ( .b , .f ) and data_type(.y, [pointer, cell])
          -> rewrite ( %
          lexpr ,
          getfuncval ( getval ( .y ) , .f , .b ) 
        %): where print( FUNCWL ); 
funci : match ( %
          statement ,
            getfuncval ( .x , .f , .b, .t ) := .y;
        %) 
          -> rewrite ( %
           statement,
           addfs(.x, .f, .b, .y, .t);
        %) ; 
map : match ( %
          expr ,
          image_set ( .y , .f ) 
        %) | data_type(.y, [pointer, cell])
          -> rewrite ( %
          expr ,
          image_set ( getval ( .y ) , .f ) 
        %): where print( MAP ) ; 
map0 : match ( %
          expr ,
          .f { .y } 
        %)
          -> rewrite ( %
          expr ,
          image_set ( .y , .f ) 
        %) ; 
mapl : match ( %
          lexpr ,
          image_set(.y, .f)
        %) | data_type(.y, [pointer, cell])
          -> rewrite ( %
          lexpr ,
          image_set ( getval ( .y ) , .f ) 
        %): where print( MAPL ) ; 
mapl0 : match ( %
          lexpr ,
          .f { .y } 
        %)
          -> rewrite ( %
          lexpr ,
          image_set ( .y , .f ) 
        %) ; 
arrayelem : match ( %
           expr,
          .h (.i)
    %) | sb_array(.b, .h)
        -> rewrite ( %
           expr,
           arrayelem(.h, .i, intv)
        %);
arrayeleml : match ( %
           lexpr,
          .h (.i)
    %) | sb_array(.b, .h)
           -> rewrite ( %
           lexpr,
           arrayelem(.h, .i, intv)
        %);
recelem : match ( %
           expr,
          .h (.i)
    %) | data_type(%expr, .h(.i) %, .b) and cdata_type(.b, .b1) and
         is_record(.h)
        -> rewrite ( %
           expr,
           recelem(.h, .i, .b1)
        %);
receleml : match ( %
           lexpr,
          .h (.i)
    %) | data_type(%expr, .h(.i) %, .b) and cdata_type(.b, .b1) and
         is_record(.h)
        -> rewrite ( %
           lexpr,
           recelem(.h, .i, .b1)
        %);


--add
addmap1 : match ( %
          statement ,
          add(.x, getmapval(.y, .f, .b));
        %) 
         -> rewrite ( %
          block,
          if not ismem(.y, .f, .b) then
                adds(.y, .f, .b);
          end if;
          addw(.x, getmapval(.y, .f, .b));
        %) ; 
adds : match ( %
          statement ,
          add(.x, .y);
        %) | sbset ( .b , .y ) or sbdom(.b, .y) -> rewrite ( %
          statement ,
          adds ( .x , .y , .b ) ; 
        %) ; 
adds1 : match ( %
          statement ,
          adds(.x, .y, .b);
        %) | data_type(.x, [pointer, cell]) -> rewrite ( %
          statement ,
          adds ( getval(.x) , .y , .b ) ; 
        %) : where print(ADDS1); 

delmap1 : match ( %
          statement ,
          del(.x, getmapval(.y, .f, .b));
        %) 
         -> rewrite ( %
          block,
          delw(.x, getmapval(.y, .f, .b));
          if is_emptyw(getmapval(.y, .f, .b)) then
                dels(.y, .f, .b);
          end if;
         %);
dels : match ( %
          statement ,
          del(.x, .y);
        %) | sbset ( .b , .y ) or sbdom(.b, .y)
        -> rewrite ( %
          statement ,
          dels ( .x, .y , .b ) ; 
        %) ; 
dels1 : match ( %
          statement ,
          dels(.x, .y, .b);
        %) | data_type(.x, [pointer, cell])
        -> rewrite ( %
          statement ,
          dels ( getval(.x), .y , .b ) ; 
        %) : where print(DELS1); 


--add_clean
add1 : match ( %
          statement ,
          add(.x, .y);
        %) | data_type(.y, [pointer, cell])
          -> rewrite ( %
          statement ,
          addw(.x, .y);
        %) ; 
addub : match ( %
          statement ,
           addw(.x, .y);
        %) | base_link(.x, .b) and cdata_type(.b, .t)
          -> rewrite ( %
          statement ,
          addub(.x, .y, .t);
        %);

--unbase
wforall : match ( %
          statement ,
          for .x in .y loop
            .b 
          end loop ; 
        %) | sbset ( .b1 , .y ) or sbdom(.b1, .y) -> rewrite ( %
          block ,
            .x := getfirst ( .y , .b1 ) ; 
            while .x /= 0 loop
              .b 
              null ; 
              .x := getnext ( .y , .b1 , .x ) ; 
            end loop ; 
        %) ; 
wexists : match ( %
          statement ,
          while exists .a in .s loop
            .b 
          end loop ; 
        %) | sbdom(.c, .s) or sbset ( .c , .s ) -> rewrite ( %
          block ,
            .a := getfirst ( .s , .c ) ; 
            while .a /= 0 loop
              .b 
              null ; 
              .a := getfirst ( .s , .c ) ; 
            end loop ; 
        %) ; 
empty_wbset : match ( %
          expr ,
          is_empty(.s)
        %) | data_type(.s, [pointer, cell])
        -> rewrite ( %
          expr ,
          is_emptyw(.s)
        %) ; 

empty_sbset : match ( %
          expr ,
          is_empty(.s)
        %) | sbset (.b, .s ) or sbdom(.b, .s)
         -> rewrite ( %
          expr ,
          is_emptys(.b, .s) 
        %) ; 
notempty : match ( %
          expr ,
          .s /= .x 
        %) | empty_set(.x)
        -> rewrite ( %
          expr ,
          not is_empty(.s)
        %) ; 
isempty : match ( %
          expr ,
          .s = .x
        %) | empty_set(.x)
        -> rewrite ( %
          expr ,
          is_empty(.s)
        %) ; 
sforall:
         match(%
          statement,
          for .x in .y loop
            .b
          end loop;
        %)
        | sbelemof(.y, .z, .b1)
        -> rewrite (%
        statement,
        for .x in getkeyimage(.y, .b1) loop
          .b
        end loop;
       %);
domainreduce1:
       match(%
        expr,
        getfirst(domain .f, .b)
       %)
       -> rewrite(%
       expr,
       getfirst(.f, .b)
       %);
domainreduce2:
      match (%
      expr,
      getnext(domain .f, .b, .x)
     %) 
     -> rewrite (%
        expr,
        getnext(.f, .b, .x)
        %);
domainreduce3: match ( %
         expr,
         ismem(.x, domain .f, .b)
       %)
       -> rewrite (%
         expr,
         ismem(.x, .f, .b)
       %);
emptysbtuple : match ( %
          statement ,
          emptytuple ( .s ) ; 
        %) | sb_array ( .b , .s ) -> rewrite ( %
          statement ,
          emptysbtuple ( .s , .b ) ; 
        %) ; 
emptyrecord : match ( %
          statement ,
          emptytuple ( .s ) ; 
        %) | base_link(.s, .b) and sub_type (.b, [record, [.n, .b1]]) 
        -> rewrite ( %
          statement ,
          emptyrecord ( .s , .n ) ; 
        %) ; 
domainreduce4 : match ( %
           expr,
           getimage(.x, .y, .b)
        %) 
        | exists(.s1, sbdom(.b, .s1), eq(.y, %expr, domain .s1%))
        -> rewrite ( %
           expr,
           getimage(.x, .s1, .b)
        %);
wnempty : match ( %
          statement ,
          while .x /= { } loop
            .b 
          end loop ; 
        %) | sbset(.b1, .x) or sbdom(.b1, .x) -> rewrite ( %
          block ,
            while getfirst(.x, .b1) /= 0 loop
              .b 
              null;
            end loop ; 
        %): where genvar(.a); 
emptywbset : match ( %
          statement ,
          .s := .x ; 
        %) 
        | wbset ( .b , .s ) and empty_set(.x)
        -> rewrite ( %
          statement ,
          emptyw ( .s , .b ) ; 
        %) ; 

--enter_base
enters: match(%statement, .x := .y;%)
        | base_elemof(.x, .b) and created(.y, .z)
        -> rewrite(%statement, enter_base(.x, .y, .b);%);

entere: match(%expr, .newval(.x)%)
        | base_link(%expr, .newval(.x)%, .b) and
          based(.b) and
          new_val(.newval)
        -> rewrite(%expr, enter_base1(.x, .b)%);

sfieldinit: match(%statement, enter_base(.x, .y, .b);%)
              | exists(.v, sbset(.b, .v), not done(.v, finit)) 
              -> rewrite ( %
                 block,
                 enter_base(.x, .y, .b);
                 sfield_init(.b, .v);  %)
              :  done(.v, finit);
mfieldinit: match(%statement, enter_base(.x, .y, .b);%)
              |  exists(.v, sbdom(.b, .v), not done(.v, finit)) 
              -> rewrite ( %
                 block,
                 enter_base(.x, .y, .b);
                 mfield_init(.b, .v);  %)
              :  done(.v, finit);

--c_field
get_field: match(%expr, getval(.x)%)
         | decl(.x, .b) and cdata_type(.b, .t)
         -> rewrite(%expr, get_field(.x, .t)%);

--passel
omgen : match ( %
          expr,
          .x
        %) | is_om(.x)
         -> rewrite ( %
          expr,
          om
        %);
-- bug - never used, because is_string is undefined
strgen : match ( %
          expr, str_const(.y)
        %) |  is_string(.y, .x)
          -> rewrite ( %
          expr,
          str_const(.x)
        %);
delnorm: match(%statement,
               delw(.x, .y);
            %)
      -> rewrite
         (%statement,
               del(.x, .y);
         %);

--setup_dec
        setupdec : match ( %
          program ,
          program .x ; 
            .y 
          end ; 
        %) | exists ( .v , decl( .v, .t ) ,  not done ( .v, decl ))
          -> rewrite ( %
          program ,
          program .x ; 
            .v : .t ; 
            .y 
          end; 
        %) : done ( .v, decl ) 
        ; 

---------------------------

int_str:  match(%expr, str(.x)%)
         | data_type(.x, int)
         -> rewrite(% expr, int_str(.x)%);

str_str:  match(%expr, str(.x)%)
         | data_type(.x, [pointer, char])
         -> rewrite(% expr, .x%);

end;
end rewriting;
