transcript sbase();
  comment    'finding strongly based variables';
--domain_accessed(f) if domain f has an assoc. access
--non_self_accessed(s) if s has an actual assoc. access
--non_self_domain_accessed(f) if f has an actual assoc. access
--domain_based(f,b) if domain f is based on base b
--set_based(s,b) if set s is based on b
--sbset(b,s) if set s is strongly based on base b
--sbdom(b,f) if domain f is strongly based on base b
--sb_struct(x,b) if strongly based map or set x is based on b
--sbsetv(v,b) if set v is strongly based on b (where v could be domain f)
--sbdomv(b,f) if domain f is strongly based on b
--sbelem(e) if the value of e is retrieved from a strongly based set
--sbelemof(z,x,b) if z is retrieved from x, which is strongly based on b
--rangev_link(f,b) if f is a variable and range_link(f,b)
--domainv_link(f,b) if f is a variable and domain_link(f,b)
--basev_link(x,b) if x is a variable and base_link
  prompt
    sbset:  [2, ' is strongly based on ', 1];
    sbdom:  [' domain of ', 2, ' is strongly based on ', 1];
  rel domain_accessed, non_self_accessed,non_self_domain_accessed: [tree];
      domain_based, set_based: [tree, typexpr];
      sbset, sbdom: [typexpr, string];
      sb_struct, sbsetv, sbdomv: [typexpr, stree];
      sbelem: [tree];
      sbelemof: [string, string, typexpr];
      rangev_link, domainv_link, basev_link: [string, typexpr];
  external self_access, access, retrieve, domain_access,
           self_domain_access: [tree, tree, node];
           input_var, self_accesser: [tree];
           sb_dom, sb_set, sb_array: [typexpr, stree];
           sub_type: [typexpr, typexpr];
           base_link, range_link, domain_link: [tree, typexpr];
           free: [tree];
           access_from_domain,retrieve_from: [tree, tree];
           based : [typexpr];
  key  domainv_link, rangev_link, basev_link: [1];
       sbdom, sbdomv, sbset, sbsetv: [2];
       sbelem, sbelemof: [1];
  incremental sbelemof: replace;
begin

   match(%expr, .f(.x)%)
   | sb_array(.b, .f)
   -> sbelem(%expr, .f(.x)%);

   match(%expr, .f(.x)%)
   | sbdomv(.b, .f) and range_link(.f, .b1) and sub_type(.b1, [set, .b2])
     and based(.b2)
   -> sbelem(%expr, .f(.x)%);

   retrieve_from(.z, .x) and (sbsetv(.b, .x) or sbdomv(.b, .x))
   -> sbelem(.z) and sbelemof(.z, .x, .b);

   match(%expr, domain .x%)
   |  retrieve_from(.z, %expr, domain .x%) and sbdomv(.b, .x)
   -> sbelem(.z) and sbelemof(.z, .x, .b);

   access(.z, .x, .t) and not self_access(.z, .x, .t)
   -> non_self_accessed(.x);

   domain_access(.z, .x, .t) and not self_domain_access(.z, .x, .t)
   -> non_self_domain_accessed(.x);

   base_link(.x, .b) and sub_type(.b, [set, .b1]) and based(.b1)
   -> set_based(.x, .b1);
   base_link(.x, .b) and isavar(.x)
   -> basev_link(.x, .b);
   domain_link(.x, .b) and isavar(.x)
   -> domainv_link(.x, .b);
   range_link(.x, .b) and isavar(.x)
   -> rangev_link(.x, .b);

   set_based(.x, .b) and non_self_accessed(.x)
   -> sbsetv(.b, .x);

   match(%expr, domain .g%)
   | sbdomv(.b, .g)
   -> sbsetv(.b, %expr, domain .g%);

   access_from_domain(.z, .x)
   -> domain_accessed(.x);

   domain_link(.x, .b) and sub_type(.b, [set, .b1]) and based(.b1)
   -> domain_based(.x, .b1);

   domain_based(.x, .b1) and non_self_domain_accessed(.x)
   -> sbdomv(.b1, .x);

   match(%expr, domain .f%)
   | sbsetv(.b, %expr, domain .f%)
   -> sbdomv(.b, .f);

   match(%expr, .x%)
   | access_from(.z, .x) and input_var(.z)
   -> sbelem(.z);

   match(%expr, .x%)
   | access_from_domain(.z, .x) and input_var(.z)
   -> sbelem(.z);
   match(%statement, .x := .y;%)
   | isavar(.x) and sbelem(.y)
   -> sbelem(.x);
   base_link(.x, .b) and based(.b)
   -> sbelem(.x);

   sb_set(.x, .y) and not sb_array(.x, .y)
   -> sbsetv(.x, .y);

   sb_dom(.x, .y)
   -> sbdomv(.x, .y);

   sbdomv(.x, .y) or sbsetv(.x, .y)
   -> sb_struct(.x, .y);

-- conclude .x: set(.b-sb)

   sbsetv(.b, .x) and isleaf(.x)
   -> sbset(.b, .x);

-- conclude .x: map(.b-s,?)

   sbdomv(.b, .x) and isleaf(.x)
   -> sbdom(.b, .x);
end;


