syntax c;

prec :
')',']','.','->'> '.','->','[','(';
'*','&','!','++','--','/','%'> '*','/','%';
'+','-'>'+','-';
'<','<=','>','>='> '<','<=','>','>=';
'!=','=='> '!=','==';
'&&'>'&&';
'||'> '||','=', '+=', '-=' ;
'(','[','=', '+=', '-=' > ')',']','$';

runops :
'*', '&', '!', '++', '--', '-', '(', '[';

lunops :
')', ']' ;

binops :
'+', '-', '*', '/', '%', '&&', 
'||', '<', '>', '<=', '>=', '==', '!=',
'(', '[', '.', '->', '=', '+=', '-=' ;

bracks :
'(' > ')','[' > ']';

disterms :
program,block,tblock,statement,explist, expr, type,
texpr, texplist, tstatement;

crterms :
statement, tstatement;

indentterms :
block,tblock;

groupsyn :
block, explist, tblock;

btop : 
'(' > explist, '[' > explist;

convertsyn :
explist > expr, texplist > texpr;

lexterms :
real, string, patvar;

grammar :
--
-- lexical productions
--
lexeme = filler . (id | real | int | string | specop | patvar | any );
string = '\"'  break '\"\\' ( '\\' { '\"' }  break '\"\\' ) * '\"' ;
patvar = '.' id ;
real = int '.' {int} | '.' int ;
filler = span ' \t\n' ;
--
-- syntactic productions
--
program = 'main' '(' ')' '{' block '}';
block = tstatement * statement +;
statement = 'if' '(' expr ')' statement { 'else' statement } |
  'while' '(' expr')' statement |
  'do' statement 'while' '(' expr')' ';' |
  'goto' id ';' |  --fix by Allen Leung Nov 11
  ';' |
  'for' '(' expr ';' expr ';' expr ')' statement |
  '{' block '}' |
  id (':' statement | - expr ';' ) |
   expr ';' ;
explist = expr ( ',' expr) * ^;
tblock = tstatement+;
type = 'int' | 'char' | 'struct' ({id} '{' tblock '}' | id) | id;
texpr = '*' texpr | id ( '[' int ']' %)* ! ;
texplist = texpr ( ',' texpr)* ^;
tstatement = { 'typedef' } type texplist ';' ;
end syntax;
