syntax setl;

prec :
')','.','}',']' > 
  '~','.','{','[','(','?' ;
'^', '#','range','domain','arb'> 
  '**';
'**','*','/'> 
  '*','/';
'+','-','with','less','incs','subset','\\','?'>
  '+','-','with','less','incs','subset','\\';
'max','min'> 
  'max','min','in','notin','/=', '=','<','<=','>','>=';
'in','notin','/=','=','<','<=','>','>=','not','&','and'> 
  '&','and';
'or','impl'> 
  'or','impl';
'lfp','gfp','clfp','cgfp','the','exists','some','forall','(','[','{'>
   ')','}',']','$';

runops :
 '#', '+', '-', '(', '{', '[', 'exists', '^',
'arb','forall', 'not','domain','range',
'the', 'some', 'lfp', 'gfp','clfp','cgfp';

lunops :
 ')', '}', ']', '~';

binops :
'+', '-', '*', '/', '**', 'max', 'min', '&', 
'and','.',
'or', '<', '>', '<=', '>=', '=', '/=',
'in', 'notin', '(', '{', '[','?', 'impl',
'with','less','incs','subset', '\\';

specsymbs : ':=','..', '=>','->';

bracks : '(' > ')','[' > ']','{' > '}';

disterms :
program,block,lexpr,statement,declarelist,vdec,vlist,
 elsepart,sbinop,btype,para,paralist,header,pexplist,
iterator,iter,iters,explist,lexplist, thenpart, whenlist,
whenstmt, otherwise, varlist, sexpr,varl,selector,sleft,
expr,bexpr,bexplist,declare,type,typelist;

crterms : statement, declare;

indentterms : block;

utop :
'exists' > iterator,'forall' > iterator,
'the' >inside,'some'>inside,'{'>inside,
'['>inside, 'gfp'> fpargs, 'lfp'> fpargs,
'clfp'> cfpargs, 'cgfp'> cfpargs;

btop :
'('>pexplist,'['>explist,'{'>explist,'.'>selector;

convertsyn :
pexplist>expr,
explist> expr,
whenlst>whenstmt,
bexplist>bexpr,
lexplist>lexpr,
varlist>varl,
paralist>para,
typelist>type,
vlist > vdec,
declare>declarelist;

groupsyn :
block,declarelist;

lexterms :
real, string, unop, patvar;

grammar :
--
-- lexical productions
--
lexeme = filler . ( comment . filler . ) * (id | specop | real | int | 
     string | unop | patvar | any );
unop = binop span ' ' . '/' ;
string = '\"'  break '\"\\' ( '\\' { '\"' | '\\'}  break '\"\\' ) * '\"' ;
patvar = '.' id ;
real = int '.' {int} | '.' int ;
comment = '--' break '\n' ;
filler = span ' \t\n' ;
--
-- syntactic productions
--
program = header block pender;
header = 'program' id ';' ;
block = statement +;
statement = ( 'while' | 'until' )  expr 'loop' block loopender |
  'case' expr ( ( whenlist { otherwise } ) | otherwise ) caseender |
  'print' '(' explist ')' ';' |
  'read' '(' lexplist ')' ';' |
 'null' ';' |
  'assert' expr ';' |
  'assume' expr ';' |
  'if' thenpart ifender |
  'for' iterator 'loop' block loopender |
  'use' idlist ';' |
  'var' varlist ';'|
  'procedure' id '(' { paralist } ')' ';' block  pender |
  'return' expr ';' |
  sexpr ';' |
  id ( '<' type | 
       - (lexpr ( ( ':=' | sbinop ':=' ) expr         |
                 ( 'frome' | 'fromb' | 'from' ) lexpr |
                 - id ( '(' { explist } ')' | - idlist ':' type  )
                ) |
          id '(' ')'
          ) 
     ) ';' |
   lexpr ':=' expr ';' ;
--
-- parts for conditional statement
--
elsepart =  'else' block  |  'elseif' thenpart ; 
thenpart =  expr 'then' block { elsepart } ;
ifender = 'end' 'if' ';';
--
-- parts for conditional statement
--
whenlist = ( whenstmt | whenstmt whenlist ) ^ ;
whenstmt = 'when' explist '=>' block ;
otherwise = 'otherwise' '=>' block ;
caseender = 'end' 'case' ';' ;
--
-- parts for procedure definitions
--
paralist = para { ',' paralist } ^ ;
para = { 'wr' } id ;
pender = 'end' { id } ';' ;
--
-- parts for loops
--
loopender = 'end' 'loop' ';' ;
--
-- parts for declarations
--
-- var statement
varlist =  varl { ':=' expr } {',' varlist } ^ ;
varl = id ! ;
-- type declaration
btype = ( 'int'      -- integer
       | 'bool'      -- boolean
  | '{' type '}'     -- set
  | '<' type '>'     -- multiset
  |        'str'     -- string
  | '(' typelist ')' -- record
  | '[' type ']'     -- tuple
  | ('record' | 'package' | 'class' )
   '(' declarelist ')' |  id {'-' ( 'sb' | 'wb') { 'hb' }} ) ! ; -- ! fix
type = ( '->' btype | btype { '->' {btype} }) !;
typelist = type {',' typelist } ^ ;
vdec = id ;
vlist = vdec ( ',' vdec ) * ^ ;
declare = vlist ':' type ';' ;
declarelist =  declare { declarelist } ;
--
-- parts for iterators
--
iters = iter ( ','iter)*;
iter = bexpr ('in' | 'subset') expr;
iterator = iters {'|' expr};
inside = '}'- | ']' - | expr ( ':' iterator {('minimizing' |
  'maximizing') expr} | '..' expr | ',' expr ((',' expr)* | '..' expr ) |
 '}' - | ']' - | - iterator  {('minimizing' | 'maximizing' ) expr} );
--
-- parts for bound variables
--
bexpr = '[' bexplist ']' | id ! ;
bexplist =  bexpr { ',' bexplist } ^ ;
--
-- parts for left-hand-sides of assignments
--
lexpr = '[' lexplist ']' |  '^' (id # expr) | id # expr { '(' explist ')' | 
        '{' explist '}' } ! ;
lexplist = lexpr { ',' lexplist } ^ ;
sbinop = ( '+'| '-'| '*'| '/'| '**'| 'max'| 'min'| '&'| 
           'and'| 'or' | '?'| 'impl'| 'with'|'less' | '\\' ) -
         (binop ! );
--
-- parts for object orientation
--
sexpr = sleft ('.' selector % ) + ! ;
sleft = '(' expr ')' | id { '(' {explist } ')' } ! ;
selector = id '(' ( ')' | explist ')');
--
-- parameter list
--
explist =  expr { ',' explist } ^ ;
idlist = id (',' id)* ^;
--
-- hook between operator prec. parser and top-down parser
--
fpargs = '(' expr ',' bexpr ')' ;
cfpargs = '(' expr ',' expr ',' bexpr ')' ;
--
-- hook between operator prec. parser and top-down parser
--
pexplist = ')' - | expr { ',' pexplist } ^ ;
end syntax;
