semantics srstlc;
  --
  --  This is the SETL to C translator reimplemented using
  --  inference instead of conditional rewriting.
  --
  --  Allen (Oct 30, 1994) 
  --
transcript setup();
       rel SpecialForm : [ string ];   -- special forms to be translated
       key SpecialForm: [1];

       language setl;
  --
  --  The following are special forms to be translated and should not
  --  be confused with functions applications or procedure calls.
  --

begin

      true
  ->  SpecialForm (getfirst)
  and SpecialForm (getnext)
  and SpecialForm (emptys)
  and SpecialForm (emptyw)
  and SpecialForm (emptysbtuple)
  and SpecialForm (is_emptys)
  and SpecialForm (is_emptyw)
  and SpecialForm (ismem)
  and SpecialForm (dels)
  and SpecialForm (del)
  and SpecialForm (adds)
  and SpecialForm (addub)
  and SpecialForm (addfs)
  and SpecialForm (getkeyimage)
  and SpecialForm (getmapval)
  and SpecialForm (getimage)
  and SpecialForm (getval)
  and SpecialForm (readwbset)
  and SpecialForm (readint);


end;

transcript SETL_to_C();
   comment 'Low-level SETL to C translation (Nov 14)';

   --
   --  During inference, the relation (actually a map) R is
   --  computed incrementally.  R is a mapping from
   --  SETL syntactic fragments to their C counterparts.
   --
   --  R is actually divided into the following relations:
   --

   rel Prog  : [ node, c ];  -- translation from SETL to C programs
       Block : [ node, c ];  -- translation from SETL to C blocks
       Stmt  : [ node, c ];  -- translation from SETL to C statements
       Expr  : [ node, c ];  -- translation from SETL to C expressions  
       Decl  : [ node, c ];  -- translation from SETL to C declarations 
       Type  : [ node, c ];  -- translation from SETL to C types 
       Version : [ string ];

       --
       -- Local relations for list traversal.
       --
       stmt_list      : [ node, node, c ];
       type_list      : [ node, node, c ];
       fun_arg_list   : [ node, node, c, c ];
       proc_arg_list  : [ node, node, c, c ];

   external SpecialForm : [string];

   prompt Prog     : [ 'Translated C program = ', 2 ];
          Block    : [ 'SETL block = ', 1, 'C block = ', 2 ]; 
          Stmt     : [ 'SETL statement = ', 1, 'C statement = ', 2 ]; 
          Expr     : [ 'SETL expression = ', 1, 'C expression = ', 2 ]; 
          Decl     : [ 'SETL declaration = ', 1, 'C declaration = ', 2 ]; 
          Type     : [ 'SETL type = ', 1, 'C type = ', 2 ];  

          stmt_list       : [ 'stmt list = ', 1, 2, 3];
          type_list       : [ 'type list = ', 1, 2, 3];
          fun_arg_list    : [ 'fun arg list = ', 1, 2, 3, 4];
          proc_arg_list   : [ 'proc arg list = ', 1, 2, 3, 4];

   language setl; 

   --
   --  List traversal is done by replacement so that incremental results
   --  are not saved.
   --
--   incremental stmt_list,proc_arg_list,fun_arg_list,type_list : replace;

   key Prog, Block, Stmt, Expr, Decl, Type : [1];
       stmt_list, type_list, fun_arg_list, proc_arg_list : [1,2];   

begin

  true -> Version (1);

  ---------------------------------------------------------------------------
  -- 
  --  Program level inference rules
  --
  ---------------------------------------------------------------------------
  --
  --  Translate top level program
  --
       match (%program, program .name ; .body end; %) 
  |    Block (.body, %statement, { .c_body } %)
  ->   Prog  (loc(), %program, main () { .c_body exit(0); } %);

       Prog  (.a,.b)
  ->   print ('The SETL program has been successfully translated into C.');

  ---------------------------------------------------------------------------
  --
  --  Block rules.
  --  These rules decompose a list of statements into their constitutents.
  --
  --  Traversal of the list of blocks is handled by the 3-ary relation
  --  `list'. 
  ---------------------------------------------------------------------------

  --
  --  Start traversing the list of statements
  --
      match (%block, .statements %)
  |   Stmt  (lchild(.statements), .c_statement)
  ->  stmt_list (loc(), lchild(.statements), %statement, { .c_statement } %);

  --
  --  Termination case: we have reached the end of the list.
  --  The second argument now contains the list of translated statements
  --
      stmt_list (.block, .statement, .c_block)
  and eq        (rsyb(.statement), nil)
  ->  Block     (.block, .c_block);

  --
  --  Inductive case:  translate one statement of the block;
  --  add it to the accumulator; move to the right of the list and continue.
  --
      stmt_list (.block, .statement, %statement, { .c_block } %)
  and neq       (rsyb(.statement), nil)
  and Stmt      (rsyb(.statement), .c_statement)
  ->  
  stmt_list(.block, rsyb(.statement), %statement, { .c_block .c_statement } %);

------------------
------------------
  ---------------------------------------------------------------------------
  --
  --  Statement level inference rules
  --
  ---------------------------------------------------------------------------
  --
  --  Translate null statements
  --
      match (%statement, null; %)
  ->  Stmt  (loc(), %statement, ; %);
   
  --
  --  Translate assignment statements
  --
      match (%statement, .x := .y; %)
  |   Expr  (.x, .a) and Expr (.y, .b)
  ->  Stmt  (loc(), %statement, .a = .b; %);

      match (%statement, .x - := .y; %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Stmt  (loc(), %statement, .a  -= .b; %);

      match (%statement, .x + := .y; %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Stmt  (loc(), %statement, .a  += .b; %);

  --
  --  Translate while loops
  --
      match (%statement, while .cond loop .body end loop; %)
  |   Expr  (.cond, .c_cond)
  and Block (.body, .c_body)
  ->  Stmt  (loc(), %statement, while (.c_cond) .c_body %);

  --
  --  Translate if/then/else statements
  --
      match (%statement, if .cond then .yes else .no end if; %)
  |   Expr  (.cond, .c_cond)
  and Block (.yes,  .c_yes)
  and Block (.no ,  .c_no)
  ->  Stmt  (loc(), %statement, if (.c_cond) .c_yes else .c_no %);

  --
  --  Translate if/then statements
  --
      match (%statement, if .cond then .yes end if; %)
  |   Expr  (.cond, .c_cond)
  and Block (.yes,  .c_yes)
  ->  Stmt  (loc(), %statement, if (.c_cond) .c_yes %);

  --
  --  Translate until loops
  --
      match (%statement, until .cond loop .body end loop; %)
  |   Expr  (.cond, .c_cond)
  and Block (.body, .c_body)
  ->  Stmt  (loc(), %statement, do .c_body while ( ! (.c_cond) ); %);

  --
  --  Translate iteration over a set.
  --  A hidden loop control variable .i is introduced at below
  --  so that the user provided loop variable .x can be overwritten 
  --  within the loop without affecting the semantics of the loop.  
  --  [Q]: Is this the correct semantics of the SETL loop?
  -- ???? remove bind, convert .i_ to .i to allow for string conversion
      match (%statement, for .x in .set loop .body end loop; %)
  |   Expr  (.set,  .c_set)  
  and Block (.body, .c_body)
  ->  genvar(.i_)  -- new index variable
--  and bind  (.i, %expr, .i_%)
  and Stmt  (loc(),
             %statement, 
                {  cell * .i_;
                   for (.i_ = .c_set -> next; .i_; .i_ = .i_ -> next ) {
                      .x = .i_;
                      .c_body
                   }
                }
             %);

  --
  --  Translate a procedure call with one argument
  --
      match  (%statement, .proc (.arg); %)
  |   not    (SpecialForm (.proc))
  and Expr   (.arg, .c_arg)
  and isleaf (.proc)
  ->  Stmt   (loc(), %statement, .proc(.c_arg); %);

  --
  --  Translate a procedure call with multiple arguments - initialization
  --
      match  (%statement, .proc (.args); %)
  |   not    (SpecialForm (.proc))
  and Expr   (lchild(.args), .c_arg)
  and isleaf (.proc)
  ->  proc_arg_list 
               (loc(), lchild(.args), %expr, .proc%, %explist, .c_arg %);
  
  --
  --  Translate a list of arguments - termination step
  -- 
      proc_arg_list (.proc_call, .arg, .c_proc, .c_args)
  and eq            (rsyb(.arg), nil)
  ->  Stmt          (.proc_call, %statement, .c_proc (.c_args); %);

--
-- inductive step
--

      proc_arg_list (.proc_call, .arg, .c_proc, .c_args)
  and neq           (rsyb(.arg), nil)
  and Expr          (rsyb(.arg), .c_arg)
  ->  proc_arg_list (.proc_call, rsyb(.arg), .c_proc,
                     %explist, .c_args , .c_arg %);

--------------
---------------
  ---------------------------------------------------------------------------
  -- 
  --  Type expression and type declaration inference rules
  --
  ---------------------------------------------------------------------------
  --
  --  Translate built-in types into C's equivalent.
  --  Notice that C doesn't have a standard boolean type.
  --
      match (%type, bool%)
  ->  Type (loc(), %type, int%);
      match (%type, int%)
  ->  Type (loc(), %type, int%);
      match (%type, cellp%)
  ->  Type (loc(), %type, cellp%);

  --
  --  Translate record type into C's struct's
  --
     match     (%type, record ( .type_decls ) %)
  |  Decl      (lchild(.type_decls), .c_type_decls)
  -> type_list (loc(), lchild(.type_decls), %tblock, .c_type_decls %);

  --
  --  Translate a list of type declarations (within a record type)
  --  into the struct body in C;  termination step
  --
      type_list (.t, .type_decl, .c_type_decls)
  and eq        (rsyb(.type_decl), nil)
  ->  Type      (.t, %type, struct { .c_type_decls }%);

--
-- inductive step
--

      type_list (.t, .type_decl, %tblock, .c_type_decls %)
  and neq       (rsyb(.type_decl), nil)
  and Decl      (rsyb(.type_decl), .c_type_decl)
  ->  type_list (.t, rsyb(.type_decl), % tblock, .c_type_decls .c_type_decl %); 

  --
  --  Translate set type into C's cell pointer
  --
      match (%type, { .type } %)
  ->  Type  (loc(), %type, cellp %);

  --
  --  Translate type declarations into C
  --
      match (%declare, .var : .type; %)
  |   Type  (.type, .c_type)
  ->  Decl  (loc(), %tstatement, .c_type .var; %);

  --
  --  Translate type declarations into C
  -- ???? examine translation of .var from node to c
      match (%declare, .var : < .type >; %)
  |   Type  (.type, .c_type)
  ->  Decl  (loc(), %tstatement, .c_type * .var; %);

  --
  --  Translate type declarations into C
  -- ??? translation of .var
      match (%statement, .var : .type; %)
  |   Type  (.type, .c_type)
  ->  Stmt  (loc(), %tstatement, .c_type .var; %);

  --
  --  Translate type declarations into C
  --??? translation of .var
      match (%statement, .var : < .type >; %)
  |   Type  (.type, .c_type)
  ->  Stmt  (loc(), %tstatement, .c_type * .var; %);

  --
  --  Translate array declaration into C
  --
      match (%statement, array(.var, .type, .size); %)
  |   Expr  (.var,  .c_var)
  and Type  (.type, .c_type)
  and Expr  (.size, .c_size)
  ->  Stmt  (loc(), %tstatement, .c_type .c_var [.c_size]; %);


  ---------------------------------------------------------------------------
  -- 
  --  Generic expression inference rules
  --
  ---------------------------------------------------------------------------
  --
  --  Translate the left hand side of an assignment expression
  --??? translate .x
      match (%lexpr, .x %)
  ->  Expr  (loc(), %expr, .x%);

  --
  --  Translate a function call with one argument
  --
      match  (%expr, .f (.arg) %)
  |   not    (SpecialForm (.f))
  and Expr   (.arg, .c_arg)
  and isleaf (.f)
  ->  Expr   (loc(), %expr, .f (.c_arg) %);


  --
  --  Translate a function application of several arguments
  --
      match        (%expr, .f (.args) %)
  |   not          (SpecialForm (.f))
  and Expr         (lchild(.args), .c_arg)
  and isleaf (.f)
  ->  fun_arg_list (loc(), lchild(.args), %expr,.f%, %explist, .c_arg %);
  
  --
  --  Translate a list of arguments; termination step
  -- 
      fun_arg_list (.fun_call, .arg, .c_f, .c_args)
  and eq           (rsyb(.arg), nil)
  ->  Expr         (.fun_call, %expr, .c_f (.c_args) %);

--
-- inductive step
--

      fun_arg_list (.fun_call, .arg, .c_f, .c_args)
  and neq          (rsyb(.arg), nil)
  and Expr         (rsyb(.arg), .c_arg)
  ->  fun_arg_list (.fun_call, rsyb(.arg), .c_f, %explist, .c_args , .c_arg %);

  --
  --  Translate equality tests into C
  --  
      match (%expr, .x = .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a == .b %);

  --
  --  Translate inequality tests into C
  --
      match (%expr, .x /= .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a != .b %);

  --
  --  Translate comparisons
  --
      match (%expr, .x > .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a > .b %);
  
      match (%expr, .x < .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a < .b %);
  
      match (%expr, .x >= .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a >= .b %);
  
      match (%expr, .x <= .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a <= .b %);
  

  --
  --  Translate conjunctive tests into C
  --
      match (%expr, .x and .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a && .b %);

  --
  --  Translate disjunctive tests into C
  --
      match (%expr, .x or .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a || .b %);

  --
  --  Translate negations into C
  --
      match (%expr, not .x %)
  |   Expr  (.x, .a)
  ->  Expr  (loc(), %expr, ! .a %);

  --
  --  Translate addition into C
  --
      match (%expr, .x + .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a + .b %);

  --
  --  Translate subtraction into C
  --
      match (%expr, .x - .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a - .b %);

  --
  --  Translate multiplication into C
  --
      match (%expr, .x * .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a * .b %);

  --
  --  Translate division into C
  --
      match (%expr, .x / .y %)
  |   Expr  (.x, .a) and Expr  (.y, .b)
  ->  Expr  (loc(), %expr, .a / .b %);

  --
  --  Translate negation into C
  --
      match (%expr, - .x %)
  |   Expr  (.x, .a)
  ->  Expr  (loc(), %expr, - .a %);

  --
  --  Translate SETL variables or constants into C.
  --  The naming is preserved.
  -- ???translate .var_or_constant
      match (%expr, .var_or_constant %) 
  |   isleaf(.var_or_constant)
  ->  Expr  (loc(), %expr, .var_or_constant %);


  --------------------------------------------------------------------------
  --
  --  Inference rules for input:
  --     (i)  input from a set,
  --     (ii) input from an integer variable
  --
  --------------------------------------------------------------------------
  --
  --  Translate read into a set variable.
  --  A C macro `readwbset' is generated, which will be expanded into
  --  code that actually performs the reading.
  --??? translate .base
      match (%statement, readwbset ( .base ); %)  
  ->  Stmt  (loc(), %statement, readwbset ( & .base ); %);
             
  --
  --  Translate read into an integer variable.
  --  Similarly, a C macro `readint' is generated.
  --??? translate .int_var
      match (%statement, readint ( .int_var ); %)  
  ->  Stmt  (loc(), %statement, readint ( & .int_var ); %);

  ---------------------------------------------------------------------------
  --
  --  Based sets inference rules.
  --  The translation from high level SETL to low level SETL introduces
  --  the following primitive functions, which are to be translated into
  --  C code: 
  --
  --  addub(...)        --
  --  addfs(...)        --
  --  del(...)          --
  --  dels(...)         --
  --  getkeyimage (...) --
  --  getimage(...)     --
  --  getval(...)       --
  --  emptysbtuple(...) --
  --  emptys(...)       --
  --  emptyw(...)       --
  --  ismem(...)
  --  is_emptys(...)    --
  --  is_emptyw(...)    --
  --
  --
  ---------------------------------------------------------------------------
  --
  --  Translate `ismem', which tests whether an element(i.e. member) is
  --  in a based set.
  --
      match (%expr, ismem( .element, .set, .base ) %)
  |   Expr  (.element, .c_element)
  and Expr  (.set,     .c_set)
  and Expr  (.base,    .c_base)
  ->  Expr  (loc(), %expr, .c_base . recs[ .c_element ] . .c_set . mem %);
   
  --
  --  Translate `getfirst', which locates the first element
  --  of a base set.
  --
      match (%expr, getfirst( .set, .base ) %)
  |   Expr  (.set,  .c_set)
  and Expr  (.base, .c_base) 
  ->  Expr  (loc(), %expr, .c_base . firsts . .c_set %);

  --
  --  Translate `getnext'
  --
      match (%expr, getnext( .set, .base, .element ) %)
  |   Expr  (.set,     .c_set)
  and Expr  (.base,    .c_base)
  and Expr  (.element, .c_element)
  ->  Expr  (loc(), %expr, .c_base . recs [ .c_element ] . .c_set . next %);

  --
  --  Translate `getimage'
  --
      match (%expr, getimage (.element, .set, .base) %)
  |   Expr  (.element, .c_element)
  and Expr  (.set,     .c_set)
  and Expr  (.base,    .c_base)
  ->  Expr  (loc(), %expr, .c_base . recs [ .c_element ] . .c_set . image %);

  --
  --  Translate `getkeyimage'
  --
      match (%expr, getkeyimage (.element, .base) %)
  |   Expr  (.element, .c_element)
  and Expr  (.base,    .c_base)
  ->  Expr  (loc(), %expr, .c_base . recs [ .c_element ] . key %);

  --
  --  Translate `is_emptys', which tests whether a base set is
  --  empty.
  --
      match (%expr, is_emptys( .base, .set ) %)
  |   Expr  (.base, .c_base)
  and Expr  (.set,  .c_set)
  ->  Expr  (loc(), %expr, .c_base . firsts . .c_set == 0 %);

  --
  --  Translate `is_emptyw'
  --
      match (%expr, is_emptyw( .set ) %)
  |   Expr  (.set,  .c_set)
  ->  Expr  (loc(), %expr, .c_set -> next == NULL %);

  --
  --  Translate `emptys', which clears a strongly based set.
  --
      match (%statement, emptys(.set, .base); %)
  |   Expr  (.set,  .c_set)
  and Expr  (.base, .c_base)
  ->  Stmt  (loc(), %statement, .c_base . firsts . .c_set = 0; %);

  --
  --  Translate `emptysbtuple', which clears a strongly based tuple.
  --
      match (%statement, emptysbtuple(.tuple, .base); %)
  |   Expr  (.tuple, .c_tuple)
  and Expr  (.base,  .c_base)
  ->  Stmt  (loc(), %statement, .c_tuple = alloc_tuple(.c_base . size); %);

  --
  --  Translate `emptyw(set, base)'
  --
      match (%statement, emptyw(.set, .base);%)
  |   Expr  (.set, .c_set)
  ->  Stmt  (loc(), %statement, .c_set = alloccell; %);

  --
  --  Translate `set := [];'
  --
      match (%statement, .set := [];%)
  |   Expr  (.set, .c_set)
  ->  Stmt  (loc(), %statement, .c_set = alloccell; %);

  --
  --  Translate `getval(...)'
  --
      match (%expr, getval (.element) %)
  |   Expr  (.element, .c_element)
  ->  Stmt  (loc(), %expr, .c_element -> data . val %);

  --
  --  Translate `getmapval(...)'
  --
      match (%expr, getmapval (.element, .map, .base) %)
  |   Expr  (.element, .c_element)
  and Expr  (.map,     .c_map)
  and Expr  (.base,    .c_base)
  ->  Expr  (loc(), %expr, .c_base . recs [ .c_element ] . .c_map . image %);

  --
  --  Translate `exists element in set'
  -- 
      match (%expr, exists .element in .set %)
  |   Expr  (.element, .c_element)
  and Expr  (.set,     .c_set)
  ->  Expr  (loc(), %expr, exists (& .c_element, .c_set) != NULL %);

  -- 
  --  Translate adds(...), which adds an element to a strongly
  --  based set.
  --??? shouldnl't need bind statements
      match (%statement, adds (.element, .set, .base); %)
  |   Expr  (.element, .c_element)
  and Expr  (.set,     .c_set)
  and Expr  (.base,    .c_base)
  ->  genvar(.old_first_)
  and genvar(.elm_)
  and bind  (.old_first, %expr, .old_first_ %)
  and bind  (.elm,       %expr, .elm_ %)
  and Stmt  (loc(),
             %statement,
             {  int .old_first, .elm;
                .elm       = .c_element;
                .old_first = .c_base . firsts . .c_set;
                if ( .c_base . recs [ .elm ] . .c_set . mem == false ) 
                { .c_base . recs [ .elm ] . .c_set . mem  = true;
                  .c_base . recs [ .elm ] . .c_set . prev = 0;
                  .c_base . recs [ .elm ] . .c_set . next = .old_first;
                  .c_base . firsts . .c_set = .elm;
                  if ( .old_first != 0 )
                    .c_base . recs [ .old_first ] . .c_set . prev = .elm;
                  else
                    .c_base . lasts . .c_set = .elm;
                }
             }
             %
             );

  -- 
  --  Translate addfs(...), which adds an element to a strongly
  --  based map.
  --??? shouldn't need bind statements
      match (%statement, addfs(.x, .s, .b, .y, .t); %)
  |   Expr  (.x, .c_x)
  and Expr  (.s, .c_s)
  and Expr  (.b, .c_b)
  and Expr  (.y, .c_y)
  and Expr  (.t, .c_t)
  ->  genvar(.old_first_)
  and genvar(.elm_)
  and bind  (.old_first, %expr, .old_first_ %)
  and bind  (.elm      , %expr, .elm_ %)
  and Stmt  (loc(),
         %statement,
         {  int .old_first, .elm ;
            cell * tmp;
            .elm = .c_x;
            .old_first = .c_b . firsts . .c_s ;
            if ( .c_b . recs [ .elm ] . .c_s . mem == false ) {
              tmp = alloccell;
              .c_b . recs [ .elm ] . .c_s . mem   = true;
              .c_b . recs [ .elm ] . .c_s . prev  = 0;
              .c_b . recs [ .elm ] . .c_s . next  = .old_first;
              .c_b . recs [ .elm ] . .c_s . image = tmp;
              .c_b . firsts . .c_s = .elm;
              if ( .old_first != 0 )
                .c_b . recs [ .old_first ] . .c_s . prev = .elm;
              else
                .c_b . lasts . .c_s = .elm;
            }
            get_funcv(.c_b . recs [ .elm ] . .c_s . image) 
                -> data . .c_t = .c_y;
        } 
        %);

  --
  --  Translate `set with := element;' for weakly and unbased sets
  --  The 'with :=' statement will be translated into the 
  --  'addub(...)' procedure call. 
  --  Weakly based sets are implemented as doubly-linked lists; so the
  --  the code generated is simply a linked element removal.  
  -- ???shouldn't need bind statements
      match (%statement, addub (.element, .set, .t); %)
  |   Expr  (.element, .c_element)
  and Expr  (.set,     .c_set)
  and Expr  (.t, .c_t)
  ->  genvar(.old_prev)  -- new variable to for pointer to previous link
  and genvar(.old_first)  -- new variable to for pointer to first link
  and Stmt  (loc(),
             %statement,
                 {  cell * .old_prev; cell * .old_first;
		    if (.c_set == NULL)
                        .c_set = alloccell ; 
		   .old_prev = alloccell;               		   
		   .old_first = .c_set -> next ; 
	           .old_prev -> next = .old_first ; 
	           .old_prev -> data . .c_t = .c_element ;
                   if (.old_first != NULL)
                      .old_first -> prev = .old_prev;
                   else
                      .c_set -> prev = .old_prev;
 	           .c_set -> next = .old_prev ;
                 }
             %
            );

  --
  --  Translate `set less := element;' for weakly and unbased sets
  --  The 'less :=' statement will be translated into the 
  --  'del(...)' procedure call. 
  --  Weakly based sets are implemented as doubly-linked lists; so the
  --  the code generated is simply a linked element removal.  
  -- ???shouldn't need bind statements
      match (%statement, del (.element, .set); %)
  |   Expr  (.element, .c_element)
  and Expr  (.set,     .c_set)
  ->  genvar(.old_prev_)  -- new variable to for pointer to previous link
  and genvar(.old_next_)  -- new variable to for pointer to next link
  and bind  (.old_prev, %expr, .old_prev_ %)
  and bind  (.old_next, %expr, .old_next_ %)
  and Stmt  (loc(),
             %statement,
                 {  cell * .old_prev; cell * .old_next;
                   .old_prev = .c_element -> prev;
                   .old_next = .c_element -> next;
                    free( .c_element );
                    if (.old_prev != NULL)
                      .old_prev -> next = .old_next;
                    else
                      .c_set -> next = .old_next;
                    if ( .old_next != 0 )
                      .old_next -> prev = .old_prev;
                    else
                      .c_set -> prev = .old_prev;
                 }
             %
            );

  --
  --  Translate `dels(...)', which deletes an element from a strongly
  --  based set.
  -- ???shouldn't need bind statements
      match (% statement, dels ( .element , .set , .base ); %)
  |   Expr  (.element, .c_element)
  and Expr  (.set,     .c_set)
  and Expr  (.base,    .c_base)
  ->  genvar (.old_first_)
  and genvar (.elm_)
  and genvar (.prev_)
  and genvar (.next_)
  and genvar (.last_)
  and bind   (.old_first, %expr, .old_first_ %)
  and bind   (.elm,  %expr, .elm_ %)
  and bind   (.prev, %expr, .prev_ %)
  and bind   (.next, %expr, .next_ %)
  and bind   (.last, %expr, .last_ %)
  and Stmt   (loc(),
              % statement,
                 {  int .old_first , .last , .elm , .prev , .next;
                    .elm = .c_element;
                    .old_first = .c_base . firsts . .c_set;
                    .last = .c_base . lasts . .c_set;
                    .c_base . recs [ .elm ] . .c_set . mem = false;
                    .prev = .c_base . recs [ .elm ] . .c_set . prev;
                    .next = .c_base . recs [ .elm ] . .c_set . next;
                    .c_base . recs [ .prev ] . .c_set . next = .next;
                    .c_base . recs [ .next ] . .c_set . prev = .prev;
                    if ( .old_first == .elm )
                       .c_base . firsts . .c_set = .next;
                    if ( .last == .elm )
                       .c_base . lasts . .c_set = .prev;
                  }
              %);


  

end;
end semantics;
