-- Module used for type checking programmer declarations
--
   transcript translate () ; 
      comment 'translating SETL types to tlisp types' ; 

--database relations defined in rwub:

--type_assign(v,type) if v: type, mostly defined in rwub - only used when
--  types are explicitly assigned by programmer (not used for sq2x)
--empty_set(x) - defined in rwub - system identifiers that replace {}
--empty_tuple(x) - defined in rwub - system identifiers that replace []
--new_val(x) - defined in rwub - system identifers that replace newval function
--stl_subtype0(b,t) - defined in rwub - if b < t is in program
--based0(b) - defined in rwub - if b-sb is a type
--
--is_record0(v) if type var b represents the type of v, where v:t is a decl,
--  and b is an immediate subtype of a record type
--is_map0(x) if prog. var. x is a map (ismap is defined in type and copied to
--   database
--is_array0(x) if prog var x is an array
--is_map defined in database
--translate(b,t) if b uniquely represents subterm t of prog. decl. b1<t or b1:t
--trans_reclist(b,i,t) if translate(b,(q)) and t is the ith suffix of t
--translated(t,b) inverse of translate + translated(t,t) where 
--  t is a variable and (translate(_,t) or translate(_t-sb) )
--sb(b1,b) if type var b1 represents something strongly based on b
--field_indx(b,n,b1) if b represents type (q) and b1 is the translated form
--   of the nth suffix of q
--array_type0(b,t1) if type var b represents a set type interpreted
-- as an array with element type t1
--sub_type0(b,t) if type var b represents translated type t
--stl_subtype1(b1,b2) if b1 < t is prog decl and t is represented by b2

--sb_dom(b,e) prog var e is a set of records with 2 fields, the first of
--  which is strongly based on b
--sb_set(b,v) set valued prog var v is strongly based on b
--sb_array(b1,x) declared prog. var. x strongly based on b1
--btype0(v,t) if prog decl v:q, type var b represents q, and t is the
--  translated form of b
--base_link0(v,b) if prog decl. is v:t and type var. b represents t
--rec_list(x,[b1 []]) if trans_reclist(b,n,x) and x is translated as b1
--rec_list("x,y",[b1,b2]) and rec_list(y,b2) if trans_reclist(b,n,"x,y") and
--  x is translated as b1
      rel translate: [string, stree];
          trans_reclist: [string, string, stree];
          translated: [stree, string];
          empty_set: [string]; 
          sb: [string, typexpr];
          field_indx: [string, string, typexpr];
          array_type0, sub_type0: [typexpr, typexpr];
          stl_subtype0: [string, stree];
          stl_subtype1: [string, string];
          type_assign: [stree, stree];
          based0: [typexpr];
          is_record0, is_map0, is_array0: [string];
          sb_dom, sb_set, sb_array: [typexpr, stree];
          btype0, base_link0: [stree, typexpr];
          new_val, empty_tuple: [string];
          rec_list: [stree, typexpr];
      database ismap: [tree];
      prompt base_link0: ['variable ',1, ' is linked to type ', 2];
             translate: ['type ', 1, ' is linked to translation of ', 2];
             sub_type0:  ['type ', 1, ' is a subtype of type ', 2];
      incremental btype0, base_link0, sub_type0, rec_list: unify;
      language setl ; 
      key base_link0,sub_type0, empty_tuple, empty_set, new_val, array_type0,
          based0, translate,type_assign, stl_subtype0, btype0, rec_list,
	  is_map0: [1];
         sb_array: [2];
         trans_reclist: [3];
         field_indx: [1,2];
      begin 

       match(%statement, .x := .y;%)
       | empty_set(.y)
       -> bind(.b, newatom(b)) and
          base_link0(.x, .b) and
          sub_type0(.b, [set, newatom(b)]);

       match(%statement, .v : ( .b ); %)
       -> type_assign(.v, %type, (.b)%);

--translate types from SETL2 to tb_lisp

       stl_subtype0(.b, .t)
       -> translate(newatom(b), .t);

       type_assign(.v,.t)
       -> translate(newatom(b), .t);

       translate(.b, %type,{.t}%)
       ->   bind(.n,newatom(b)) and
            translate(.n,.t);

       translate(.b, %type, [.t]%)
       ->   translate(newatom(b),.t);

       translate(.b, %type, (.t)%)
       -> trans_reclist(.b, 1, .t);

       trans_reclist(.b, .n, %type, .x%)
       -> translate(newatom(b), .x);

       trans_reclist(.b, .n, %typelist, .x, .y%)
       ->   translate(newatom(b), .x) and
            trans_reclist(.b, add(.n, 1), .y);

--gather up tb-lisp-translated types

       translate(.b,.t) and
       isleaf(.t)
       -> translated(.t, .t);

       translate(.b,.t) and
       not isleaf(.t)
       -> translated(.t, .b);

       trans_reclist(.b, .n, %type, .x%) and
       translated(.x, .b1)
       -> rec_list(.x, [.b1, []]) and
          field_indx(.b, .n, .b1);

       trans_reclist(.b, .n, %typelist, .x, .y%) and
       translated(.x, .b1)
       ->   field_indx(.b, .n, .b1) and
            bind(.l, newatom(t)) and
            rec_list(%typelist, .x, .y%,  [.b1, .l]) and
            rec_list(.y, .l);

-- subtypes in terms of tb_lisp

       translate(.b1, %type, .b - sb%)
       -> translated(.b, .b) and based0(.b) and
          sb(.b1, .b);

       translate(.b, %type, [.t]%) and
       translated(.t, .t1)
       ->   sub_type0(.b, [set, .t1]) and 
            array_type0(.b, .t1);

       translate(.b, %type,{.t}%) and
       translated(.t, .t1)
       ->   sub_type0(.b, [set, .t1]);

       stl_subtype0(.b, .t) and
       translated(.t, .b1)
       -> stl_subtype1(.b, .b1);

       stl_subtype1(.b, .b1) and
       sub_type0(.b1, .b2)
       -> sub_type0(.b, .b2);

       stl_subtype0(.b, .t) and
       translated(.t, .b1) and
       isleaf(.t)
       -> sub_type0(.b, .b1);

       translate(.b, %type, (.t)%) and
       trans_reclist(.b, .n, %type,.x%) and
       rec_list(%typelist,.t%, .p)
       -> sub_type0(.b, [record, [.n, .p]]);

--type assignments in terms of tb_lisp

       type_assign(.v,.t) and
       translated(.t, .b)
       -> base_link0(.v, .b);



       base_link0(.x, .y) and sub_type0(.y, .z)
       -> btype0(.x, .z);

       base_link0(.x, .b) and
       sub_type0(.b, [set, .t1]) and
       array_type0(.b, .t1) and
       sb(.t1, .b1)
       -> sb_array(.b1, .x);

       btype0(.x, [set,.t1]) and
       sb(.t1, .b1)
       -> sb_set(.b1, .x);

       ismap(.x) -> is_map0(.x);

       btype0(.x, [set, .t2]) and
       sub_type0(.t2, [record, [2, [.t1, .t]]])
       -> is_map0(.x);

       btype0(.x, [set, .t2]) and
       sub_type0(.t2, [record, [2, [.t1, .t]]]) and
       sb(.t1, .b1)
       -> sb_dom(.b1, .x);

--final type termination

       base_link0(.x, .b) and
       sub_type0(.b, [record, .b1])
       -> is_record0(.x);

       base_link0(.v, .b) and array_type0(.b, .t)
       -> is_array0(.v);

 end ;
