transcript wbase();
  comment    'weakly based variables';
--ubset(b,x) is exactly the same as ubset0
--wbset(b,x) is exactly the same as wbset0
--wbdom(b,f) if domain of f is based on b but not strongly based
--ubset0 (b,x) if set x is not based on b
--wbset0(b,x) if set x is based on b, but not strongly based on b
--wbdom0 is undefined
--decl used to model physical structure
--decl_array is undefined
--data_type(e,t) if t models physical structure for e
--cdata_type(t1,t2) models physical structure
--in_cell is defined in rwub
--wbelem(z) if z will store a value retrieved from a weakly based map or set
--sbelemv(z) same as sbelem
--wbelemv(z) same as wbelem
--wbelemof(z,f,b) if z will store a value retrieved from a weakly based map
--  or set f (where b is the base)
  rel ubset, wbset, wbdom: [typexpr, string];
      ubset0, wbset0, wbdom0: [typexpr, tree];
      decl: [string, string];
      decl_array: [string, typexpr];
      data_type: [tree, typexpr];
      cdata_type: [typexpr, typexpr];
      in_cell: [tree, tree];
      wbelem: [tree];
      sbelemv, wbelemv: [string];
      wbelemof: [string, string, typexpr];
  external sbset: [ typexpr, string];
           sbsetv, sb_struct, sb_array: [ typexpr, stree];
           based : [typexpr];
           is_array : [tree];
           array_type : [ typexpr, typexpr];
           not_map, not_variable, base_elem, sbelem: [tree];
           created: [tree, typexpr];
           retrieve: [tree, tree, node];
           sub_type: [typexpr, typexpr];
           btype, base_link, range_link, domain_link: [tree, typexpr];
  key  ubset, wbset, wbdom: [2];
       cdata_type, data_type, decl, wbelem, 
       decl_array, wbelemv, sbelemv, in_cell, wbelemof: [1];
  incremental wbelemof: replace;
begin
   wbset0(.x, .y)
   -> wbset(.x, .y);

   match(%expr, domain .f%)
   | wbset0(.b, %expr, domain .f%)
   -> wbdom(.b, .f);

   match(%expr, domain .x%)
   |  retrieve(.z, %expr, domain .x%, .t) and wbdom(.b, .x)
   -> wbelem(.z) and wbelemof(.z, .x, .b);

   retrieve(.z, .e, .t) and wbset0(.b, .e)
   -> wbelem(.z) and wbelemof(.z, .e, .b);

   wbelem( .v) and not base_elem(.v)
   -> data_type(.v, [pointer, cell]);

   base_elem( .v)
   -> data_type(.v, int);

   base_link(.x, .b) and sub_type(.b, [set, .b1]) and based(.b1) and
   not sbsetv(.b1, .x) and not sb_array(.b1, .x)
   -> wbset0(.b1, .x);

   base_link(.x, .b) and sub_type(.b, [set, .b1]) and not based(.b1)
   and null(z, domain_link(.x, z))
   -> ubset0(.b1, .x) and ubset(.b1, .x);

   ubset0(.b1, .x)
   -> data_type(.x, [pointer, cell]);

   wbset0(.b1, .x) and not base_elem(.x)
   -> data_type(.x, [pointer, cell]);

   btype(.x, [tuple, .b])
   -> data_type(.x, [pointer, cell]);

   btype(.x, [set, .b]) and null(z, sb_array(z, .x)) and is_array(.x)
   -> data_type(.x, [pointer, cell]);

   sb_array(.b, .x)
   -> data_type(.x, [pointer, elem]);

   base_link(.x, int)
   -> data_type(.x, int);

   base_link(.x, str)
   -> data_type(.x, str);

   base_link(.x, .b) and sub_type(.b, int) and not sb_struct(.b, .x)
   -> data_type(.x, int);

   base_link(.x, .b) and sub_type(.b, str) and not based(.b)
   -> data_type(.x, [pointer, char]);

   base_link(.x, .b) and sub_type(.b, bool)
   -> data_type(.x, int);

   base_link(.x, .b) and sub_type(.b, [pointer, file])
   -> data_type(.x, [pointer, file]);

   data_type(.x, int) and isavar(.x) and not not_variable(.x)
   -> decl(.x, int);

   data_type(.x, [pointer, int]) and isavar(.x) and not not_variable(.x)
   -> decl(.x, intp);

   data_type(.x, [pointer, cell]) and isavar(.x) and not not_variable(.x)
   -> decl(.x, cellp);

   data_type(.x, [pointer, polycell]) and isavar(.x) and not not_variable(.x)
   -> decl(.x, polycellp);

   data_type(.x, [pointer, char]) and isavar(.x) and not not_variable(.x)
   -> decl(.x, charp);

   data_type(.x, [pointer, file]) and isavar(.x) and not not_variable(.x)
   -> decl(.x, filep);

   wbelem(.x) -> wbelemv(.x);

   sbelem(.x) -> sbelemv(.x);

   base_link(.x, .b) and sub_type(.b, [record, [.n, .p]])
   -> data_type(.x, [pointer, elem]);

   data_type(.x, [pointer, elem ]) and isavar(.x) and not not_variable(.x)
   -> decl(.x, elemp);

   true -> cdata_type(int, intv) and
           cdata_type(str, strv) and
           cdata_type(cellp, cellpv) and
           cdata_type(elemp, elempv) and
           cdata_type([pointer, int], intpv) and
           cdata_type([pointer, cell], cellpv) and
           cdata_type([pointer, file], filepv) and
           cdata_type([pointer, char], strv) and
           cdata_type([pointer, elem], elempv);
    
    based(.b) ->  cdata_type(.b, intv);

    sub_type(.b, int) ->  cdata_type(.b, intv);

    sub_type(.b, str) and not based(.b) ->  cdata_type(.b, strv);

    base_link(.x, .b) and
    sub_type(.b, [set, .b1]) and 
    not based(.b) and
    not not_map(.x)
    ->  cdata_type(.b, cellpv);

    sub_type(.b, [record, .b1]) ->  cdata_type(.b, elempv);

    array_type(.b, .b1) ->  cdata_type(.b, elempv);



end;
