semantics;
--
-- declare exclusive database relations
--
transcript db_rels();
       rel processed: [string];
           acyclic: [string,string];
       key acyclic, processed: [1];
begin
  true -> acyclic(1,yes);  -- call graph is acyclic unless proven otherwise
end;
-- compute call graph in a SETL2 program with no nested procedures
-- and no recursion
--
transcript find_procs();
  comment 'collecting procedure names';
--proc_here(x,y) if x is a procedure name; y is the procedure node
  rel proc_here: [string,node];
  key proc_here: [1];
  language setl;
begin
-- compute proc_here
  match(%statement,procedure .name (); .b end;%) -> proc_here(.name,loc());
  match(%statement,procedure .name(.p); .b end;%) -> proc_here(.name,loc());  
  match(%program,.x%) -> proc_here(main,loc());
end;

transcript call();
  comment 'calculate initial call_graph';
-- call_graph(p,x,y) iff procedure x may call procedure y at point p
  database proc_here: [string,node];
  language setl;
  rel call: [node,string];
      current_proc: [string];
      call_graph: [node,string,string];
  key call:[1];
      call_graph: [1];
  incremental call_graph: replace;
begin
--compute initial call graph
--function calls
  match(%expr,.f()%)   ->  call(loc(),.f);
  match(%expr,.f(.y)%) ->  call(loc(),.f);
--procedure calls
  match(%statement,.f();%)    ->  call(loc(),.f);
  match(%statement,.f(.y);%)  ->  call(loc(),.f);
-- complete call graph
  proc_here(.proc,root()) -> current_proc(.proc);
  current_proc(.caller) and call(.place,.called) -> 
      call_graph(.place,.caller,.called);
end;
--
-- Recursiveness <-> exists(z,proc_here(z,.x),not marked(.z))
--
transcript nonrecursive();
  comment 'calculate final call graph';
 rel cgraph : [string,string];
 database call_graph: [node,string,string];
 key cgraph: [1,2];
begin
 call_graph(.n,.caller,.called) -> cgraph(.caller,.called);
end;
end semantics;

commands;
 procedure compute_cg();
   analyze proc_here;  -- proc_here(x:string,y:node) <-> proc x is defined at y
   analyze processed;  -- initialize dbrelations acyclic, processed
   database proc_here,processed,acyclic;
   initsm;
   usedb;             -- call_graph(x:node,y:string,z:string) if y calls z at x
--first process main
 if proc_here(main,.point) then
     analyze call_graph;
     database call_graph;
     initsm;
     dparse processed(main);
   end if;
   while exists([.proc,.point],proc_here(.proc,.point),not processed(.proc)) loop
     locate top;
     locate .point;
     analyze call_graph;   -- compute call graph for procedure .proc
     database call_graph;  -- augment global call graph
     initsm;
     dparse processed(.proc);
   end loop;
   analyze cgraph;
   database cgraph;
   initsm;
-- decide if cgraph is acyclic
   initdb processed;  -- use processed for marking procedure names
   pause 'call graph computed';
   while exists([.called,.point],proc_here(.called,.point),
     (not processed(.called)) and
     not exists(.z, cgraph(.z,.called), not processed(.z)) ) loop
     dparse processed(.called);
   end loop;
   if exists([.proc,.point],proc_here(.proc,.point),not processed(.proc)) then
     dparse acyclic(1,no);
     print 'cycle detected in call graph - abnormal termination';
     print 'relations cgraph and processed printed below';
     help cgraph;
     help processed;
   end if;
   if acyclic(1,yes) then
     print 'acyclic graph found; begin procedure integration';
-- procedure integration
   end if;
 end procedure;
end commands;

