/* bitblt routines */
#include "jerq.h"

void
bitblt (sb, r, db, p, f)
Bitmap *sb, *db;
Rectangle r;	/* in source bitmap */
Point p;	/* in dest bitmap */
Code f;
{
	int wd = r.corner.x - r.origin.x;
	int ht = r.corner.y - r.origin.y;

	if(sb->flag & BI_OFFSCREEN)
		r.origin = sub(r.origin, sb->rect.origin);
	if(db->flag & BI_OFFSCREEN)
		p = sub(p, db->rect.origin);
#ifdef X11
	_XSetFunction(dpy, gc, f);
	XCopyArea(dpy, sb->dr, db->dr, gc, r.origin.x, r.origin.y,
		wd, ht, p.x, p.y);
#endif /* X11 */
}

void
point (b, p, f)
Bitmap *b;
Point p;
Code f;
{
	int i;

	if(b->flag & BI_OFFSCREEN)
		p = sub(p, b->rect.origin);
#ifdef X11
	_XSetFunction(dpy, gc, f);
	XDrawPoint(dpy, b->dr, gc, p.x, p.y);
#endif /* X11 */
}

void
rectf (b, r, f)
Bitmap *b;
Rectangle r;
Code f;
{
	Point diff;

	diff = sub(r.corner, r.origin);
	if(b->flag & BI_OFFSCREEN)
		r.origin = sub(r.origin, b->rect.origin);
#ifdef X11
	_XSetFunction(dpy, gc, f);
	XFillRectangle(dpy, b->dr, gc,r.origin.x,r.origin.y,diff.x,diff.y);
#endif /* X11 */
}

screenswap (bp, rect, screenrect)
register Bitmap *bp;
Rectangle rect;
Rectangle screenrect;
{
	bitblt(&display, screenrect, bp, rect.origin, F_XOR);
	bitblt(bp, rect, &display, screenrect.origin, F_XOR);
	bitblt(&display, screenrect, bp, rect.origin, F_XOR);
}

void
segment (b, p, q, f)
Bitmap *b;
Point p, q;
Code f;
{
	int i;

	if(b->flag & BI_OFFSCREEN){
		p = sub(p, b->rect.origin);
		q = sub(q, b->rect.origin);
	}
#ifdef X11
	_XSetFunction(dpy, gc, f);
	XDrawLine(dpy, b->dr, gc, p.x, p.y, q.x, q.y);
#endif /* X11 */
}

void
texture (b, r, tile, f)
Bitmap *b;
Rectangle r;
Texture *tile;
Code f;
{
#ifdef SUNTOOLS
	extern struct pixrectops mem_ops;
	static struct mpr_data d = 
		{mpr_linebytes(16,1), (short *)0, {0, 0}, 0, 0};
	static struct pixrect textrect = {&mem_ops, 16, 16, 1, (caddr_t)&d};
#endif /* SUNTOOLS */
	Point diff;

	diff = sub(r.cor, r.org);
	if (b->flag & BI_OFFSCREEN)
		r.org = sub(r.org, b->rect.org);
#ifdef X11
	_XSetFunction(dpy, gc, f);
	XSetFillStyle(dpy, gc, FillTiled);
	XSetTile(dpy, gc, *tile);
	XFillRectangle(dpy, b->dr, gc, r.org.x, r.org.y, diff.x, diff.y);
	XSetFillStyle(dpy, gc, FillSolid);
#endif /* X11 */
#ifdef SUNTOOLS
	d.md_image = *tile;
	if(b->flag & BI_OFFSCREEN)
		pr_replrop((Pixrect *)b->dr, r.origin.x, r.origin.y,
			diff.x, diff.y, f, &textrect, r.origin.x, r.origin.y);
	else
		pw_replrop((Pixwin *)b->dr, r.origin.x, r.origin.y,
			diff.x, diff.y, f, &textrect, r.origin.x, r.origin.y);
#endif /* SUNTOOLS */
}

void
texture32 (b, r, tile, c)
Bitmap *b;
Rectangle r;
Texture32 *tile;
Code c;
{
#ifdef SUNTOOLS
	extern struct pixrectops mem_ops;
	static struct mpr_data d = 
		{mpr_linebytes(32,1), (short *)0, {0, 0}, 0, 0};
	static struct pixrect textrect32 =
		{&mem_ops, 32, 32, 1, (caddr_t)&d};
#endif /* SUNTOOLS */
	Point diff;

	diff = sub(r.cor, r.org);
	if (b->flag & BI_OFFSCREEN)
		r.org = sub(r.org, b->rect.org);
#ifdef X11
	_XSetFunction(dpy, gc, c);
	XSetFillStyle(dpy, gc, FillTiled);
	XSetTile(dpy, gc, *tile);
	XFillRectangle(dpy, b->dr, gc, r.org.x, r.org.y, diff.x, diff.y);
	XSetFillStyle(dpy, gc, FillSolid);
#endif /* X11 */
#ifdef SUNTOOLS
	d.md_image = (short *)*tile;
	if(b->flag & BI_OFFSCREEN)
		pr_replrop((Pixrect *)b->dr, r.origin.x, r.origin.y,
		   diff.x, diff.y, c, &textrect32, r.origin.x, r.origin.y);
	else
		pw_replrop((Pixwin *)b->dr, r.origin.x, r.origin.y,
		   diff.x, diff.y, c, &textrect32, r.origin.x, r.origin.y);
#endif /* SUNTOOLS */
}

_XSetFunction(_dpy, _gc, _f)
Display *_dpy;
GC _gc;
Code _f;
{
	if (_f == F_XOR) {
		XSetForeground(dpy, _gc, 0xFFFFFFFF);
		XSetBackground(dpy, _gc, 0);
		XSetPlaneMask(dpy, _gc, fgpix ^ bgpix);
		XSetFunction(dpy, _gc, GXxor);
	}
	else if (_f == F_CLR) {
		XSetForeground(dpy, _gc, bgpix);
		XSetBackground(dpy, _gc, bgpix);
		XSetPlaneMask(dpy, _gc, AllPlanes);
		XSetFunction(dpy, _gc, GXcopy);
	}
	else /* if (_f == F_OR) */ {
		XSetForeground(dpy, _gc, fgpix);
		XSetBackground(dpy, _gc, bgpix);
		XSetPlaneMask(dpy, _gc, AllPlanes);
		XSetFunction(dpy, _gc, GXcopy);
	}
#if 0
	else
		XSetForeground(_dpy, _gc, fgpix);
	XSetFunction(_dpy, _gc, _f);
#endif
}

/*
 * The X color model defect rears its head again.  How the hell am I
 * supposed to get around this?
 */
#if 0

_XSetFunction(_dpy, _gc, _f)
Display *_dpy;
GC _gc;
Code _f;
{
	if (_f == F_XOR)
		XSetForeground(_dpy, _gc, AllPlanes);
	else if (_f == F_CLR) {
		XSetForeground(_dpy, _gc, bgpix);
		_f = F_STORE;
	}
	else if (_f == F_OR) {
		XSetForeground(_dpy, _gc, fgpix);
		_f = F_STORE;
	}
	else
		XSetForeground(_dpy, _gc, fgpix);
	XSetFunction(_dpy, _gc, _f);
}

#endif

#if 0
_XSetFunction(_dpy, _gc, _f)
Display *_dpy;
GC _gc;
Code _f;
{
	static int ok = 0;

	if (ok == 0) {		/* we don't know yet */
		if (fgpix == 0)
			ok = -1;
		else
			ok = 1;
	}

	if (ok == 1) {
chomp:
		XSetFunction(_dpy, _gc, _f);
		return;
	}
	
	if (_f == F_XOR || _f == F_OR) {
		XSetForeground(_dpy, _gc, bgpix);
		XSetBackground(_dpy, _gc, fgpix);
	}
	else {
		XSetForeground(_dpy, _gc, fgpix);
		XSetBackground(_dpy, _gc, bgpix);
	}
	goto chomp;
}
#endif
