#include "jerq.h"

#if defined(BSD) || defined(mips) || defined(SVR4)
#include <fcntl.h>
#else	/* V9 */
#include <sys/filio.h>
#endif /* BSD */

#define	XBUG

Rectangle	Drect;
Bitmap		display, Jfscreen;
Point		Joffset;
struct Mouse	mouse;
static struct	JProc sP;
struct JProc	*P;
Font		defont;
int		mouse_alive = 0;
int		jerqrcvmask = 1;
int		displayfd;
Cursor		normalcursor;
static int	hintwidth, hintheight, hintflags;
static		Jlocklevel;
void		handleinput();

#define	DEF_WIDTH	80
#define	DEF_HEIGHT	24

GC		gc;
Display		*dpy;
int		fgpix, bgpix;
Colormap	colormap;
XColor		fgcolor, bgcolor;
static unsigned long inputmask = 
	ButtonPressMask|ButtonReleaseMask|ButtonMotionMask
	|StructureNotifyMask|ExposureMask|KeyPressMask
	|PointerMotionHintMask;
static unsigned long pointermask = 
	ButtonPressMask|ButtonReleaseMask|ButtonMotionMask
	|PointerMotionHintMask;

Cursor _ToCursor();

#define arrow_width 16
#define arrow_height 16
#define arrow_x_hot 0
#define arrow_y_hot 0
#if SVR4
static unsigned char arrow_bits[] = {
#else
static char arrow_bits[] = {
#endif
	0xff,0x01,0x7f,0x00,0x1f,0x00,0x3f,0x00,
	0x7f,0x00,0xfb,0x00,0xf3,0x01,0xe1,0x03,
	0xc1,0x07,0x80,0x0f,0x00,0x1f,0x00,0x3e,
	0x00,0x7c,0x00,0xf8,0x00,0x70,0x00,0x20
};

#define Arrow_f_width 18
#define Arrow_f_height 18
#define Arrow_f_x_hot 1
#define Arrow_f_y_hot 1
#if SVR4
static unsigned char Arrow_f_bits[] = {
#else
static char Arrow_f_bits[] = {
#endif
   0x00, 0x00, 0x00, 0xfe, 0x03, 0x00, 0xfe, 0x00, 0x00, 0x3e, 0x00, 0x00,
   0x7e, 0x00, 0x00, 0xfe, 0x00, 0x00, 0xf6, 0x01, 0x00, 0xe6, 0x03, 0x00,
   0xc2, 0x07, 0x00, 0x82, 0x0f, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x3e, 0x00,
   0x00, 0x7c, 0x00, 0x00, 0xf8, 0x00, 0x00, 0xf0, 0x01, 0x00, 0xe0, 0x00,
   0x00, 0x40, 0x00, 0x00, 0x00, 0x00};

#define Arrow_m_width 18
#define Arrow_m_height 18
#define Arrow_m_x_hot 1
#define Arrow_m_y_hot 1
#if SVR4
static unsigned char Arrow_m_bits[] = {
#else
static char Arrow_m_bits[] = {
#endif
   0xff, 0x0f, 0x00, 0xff, 0x07, 0x00, 0xff, 0x03, 0x00, 0xff, 0x00, 0x00,
   0xff, 0x00, 0x00, 0xff, 0x01, 0x00, 0xff, 0x03, 0x00, 0xff, 0x07, 0x00,
   0xe7, 0x0f, 0x00, 0xc7, 0x1f, 0x00, 0x87, 0x3f, 0x00, 0x03, 0x7f, 0x00,
   0x01, 0xfe, 0x00, 0x00, 0xfc, 0x01, 0x00, 0xf8, 0x03, 0x00, 0xf0, 0x01,
   0x00, 0xe0, 0x00, 0x00, 0x40, 0x00};

/* This must be called before initdisplay */
mousemotion ()
{
	mouse_alive = 1;
#ifdef X11
	inputmask |= PointerMotionMask;
#endif /* X11 */
}

#ifdef X11
initdisplay(argc, argv)
	int argc;
	char *argv[];
{
	int	i, rv = 0;
	char	*font, *geom = 0;
	int	flags = 0;
	int	width = DEF_WIDTH;
	int	height = DEF_HEIGHT;
	int	x, y;
	char	**ap;
	char	*dname;
	XSizeHints		sizehints;
	XSetWindowAttributes	xswa;
	XWindowAttributes	xwa;

	ap = argv;
	i = argc;
	dname = "";
	while(i-- > 0) {
		if(!strcmp("-display", ap[0])){
			dname = ap[1];
			i--; ap++;
		}
		ap++;
	}
	if(!(dpy= XOpenDisplay(dname))){
		perror("Cannot open display\n");
		exit(-1);
	}
	displayfd = ConnectionNumber(dpy);

	if (jerqrcvmask)
#ifdef	BSD
		fcntl(1, F_SETFL, FNDELAY);;
#else
#if defined(mips) && !defined(sony) || defined(SVR4)
		fcntl(1, F_SETFL, O_NDELAY);;
#else
		ioctl(1, FIOWNBLK, 0);
#endif
#endif
	font = XGetDefault(dpy, argv[0], "JerqFont");
	if(font == NULL)
		font = "fixed";
#if SVR4
	memset(&sizehints, 0, sizeof(sizehints));
#else
	bzero(&sizehints, sizeof(sizehints));
#endif
	ap = argv;
	i = argc;
	while(i-- > 0){
		if(!strcmp("-i", ap[0]))
			rv++;
		else if(!strcmp("-fn", ap[0])){
			font = ap[1];
			i--; ap++;
		} else if(!strcmp("-font", ap[0])){
			font = ap[1];
			i--; ap++;
		} else if(ap[0][0] == '=' || strcmp(ap[0], "-geometry") == 0) {
			if (ap[0][0] == '=')
				geom = ap[0];
			else {
				i--; ap++;
				geom = ap[0];
			}	
			flags = XParseGeometry(ap[0],&x,&y,(unsigned int*)&width,(unsigned int*)&height);
			if(WidthValue & flags)
				sizehints.flags |= USSize;
			if(HeightValue & flags)
	    			sizehints.flags |= USSize;
			if(XValue & flags){
				if(XNegative & flags)
				  x=DisplayWidth(dpy,DefaultScreen(dpy))+x 
					- sizehints.width;
				sizehints.flags |= USPosition;
				sizehints.x = x;
			}
			if(YValue & flags){
				if(YNegative & flags)
				  y=DisplayHeight(dpy,DefaultScreen(dpy))+y
					-sizehints.height;
				sizehints.flags |= USPosition;
				sizehints.y = y;
			}
		}
		ap++;
	}
	defont = getfont(font);
	P = &sP;
#ifdef NODEFONT
	sizehints.width_inc = sizehints.height_inc = 1;
#else
	sizehints.width_inc = defont.max_bounds.width;
	sizehints.height_inc = (defont.max_bounds.ascent +
				defont.max_bounds.descent);
#endif
	sizehints.min_width = sizehints.min_height = 20;
	sizehints.flags |= PResizeInc|PMinSize;
	if (!geom || ((flags & (HeightValue|WidthValue)) == 0)) {
		sizehints.width = defont.max_bounds.width * DEF_WIDTH;
		sizehints.height = (defont.max_bounds.ascent +
				defont.max_bounds.descent) * DEF_HEIGHT;
		sizehints.flags |= PSize;
		jerqsizehints();
		if (hintwidth)
			sizehints.width = hintwidth;
		if (hintheight)
			sizehints.height = hintheight;
		if (hintflags) {
			sizehints.min_width = hintwidth;
			sizehints.min_height = hintheight;
		}
	} else {
		sizehints.width = defont.max_bounds.width * width;
		sizehints.height = (defont.max_bounds.ascent +
				defont.max_bounds.descent) * height;
	}
	xswa.event_mask = 0;
	if (rv) {
		bgpix = xswa.background_pixel = BlackPixel(dpy, 0);
		fgpix = xswa.border_pixel = WhitePixel(dpy, 0);
	} else {
		bgpix = xswa.background_pixel = WhitePixel(dpy, 0);
		fgpix = xswa.border_pixel = BlackPixel(dpy, 0);
	}
	display.dr = XCreateWindow(dpy,
			RootWindow(dpy, DefaultScreen(dpy)),
			sizehints.x,sizehints.y, sizehints.width,
			sizehints.height, 2,0,InputOutput,
			DefaultVisual(dpy, DefaultScreen(dpy)),
			CWEventMask | CWBackPixel | CWBorderPixel, &xswa);
#if 0
	XSetStandardProperties(dpy, display.dr, argv[0], argv[0],
				None, argv, argc, &sizehints);
#else
	setAllHints(argc, argv, &sizehints);
#endif
	XMapWindow(dpy, display.dr);
	colormap = XDefaultColormap(dpy, 0);
	fgcolor.pixel = fgpix;
	bgcolor.pixel = bgpix;
	XQueryColor(dpy, colormap, &fgcolor);
	XQueryColor(dpy, colormap, &bgcolor);
	gc = XCreateGC(dpy, display.dr, 0, NULL);
	XSetForeground(dpy, gc, fgpix);
	XSetBackground(dpy, gc, bgpix);
	XSetFont(dpy, gc, defont.fid);
	XSetLineAttributes(dpy, gc, 0, LineSolid, CapNotLast, JoinMiter);
	Drect.origin.x = 0;
	Drect.origin.y = 0;
	Drect.corner.x = sizehints.width;
	Drect.corner.y = sizehints.height;
	display.rect = Drect;
#ifdef XBUG
	Jfscreen = display;
#else
	Jfscreen.dr = RootWindow(dpy, DefaultScreen(dpy));
	Jfscreen.rect.origin.x = 0;
	Jfscreen.rect.origin.y = 0;
	Jfscreen.rect.corner.x = DisplayWidth(dpy, DefaultScreen(dpy));
	Jfscreen.rect.corner.y = DisplayHeight(dpy, DefaultScreen(dpy));
#endif /* XBUG */
	if (cursorSizeOKWithServer(Arrow_f_width, Arrow_f_height)) {
		normalcursor = _ToCursor(Arrow_f_bits, Arrow_m_bits, Arrow_f_width,
					 Arrow_f_height, Arrow_f_x_hot, Arrow_f_y_hot);
	}
	else {
		normalcursor = _ToCursor(arrow_bits, arrow_bits, arrow_width,
					 arrow_height, arrow_x_hot, arrow_y_hot);
	}
	cursswitch(&normalcursor);
	XSelectInput(dpy, display.dr, inputmask);
	for(;;) {
		if (sizehints.flags & USPosition) {
			XGetWindowAttributes(dpy, display.dr, &xwa);
			if (xwa.map_state != IsUnmapped) {
#ifndef XBUG
				Joffset.x = xwa.x;
				Joffset.y = xwa.y;
#endif /* XBUG */
				break;
			}
		} else if (P->state & RESHAPED)
			break;
		while (XPending(dpy))
			handleinput();
	}
}

Font
getfont(s)
char *s;
{
	static Font f;
	Font *fp;

	fp = XLoadQueryFont(dpy, s);
	return fp ? *fp : f;
}
#endif /* X11 */

request(what)
int what;
{
	if (!(what & RCV)) {
		jerqrcvmask = 0;
		close(0);
#ifdef	MINDFUCKER
		close(1);
#endif
	}
}

Bitmap *
balloc (r)
Rectangle r;
{
	Bitmap *b;

	b = (Bitmap *)malloc(sizeof (struct Bitmap));
#ifdef X11
	b->dr = XCreatePixmap(dpy, display.dr, r.cor.x-r.org.x,
		r.cor.y-r.org.y, DefaultDepth(dpy, 0));
#endif /* X11 */
	b->flag = BI_OFFSCREEN;
	b->rect=r;
	return b;
}

void
bfree(b)
Bitmap *b;
{
	if(b){
#ifdef X11
		XFreePixmap(dpy, b->dr);
#endif /* X11 */
		free((char *)b);
	}
}

Point
string (f, s, b, p, c)
Font *f;
char *s;
Bitmap *b;
Point p;
Code c;
{
	if(b->flag & BI_OFFSCREEN)
		p = sub(p, b->rect.origin);
#ifdef X11
	_XSetFunction(dpy, gc, c);
	XDrawString(dpy, b->dr, gc, p.x, p.y + f->max_bounds.ascent, s, strlen(s));
#endif /* X11 */
	return(add(p, Pt(strwidth(f,s),0)));
}

int
strwidth (f, s)
Font *f;
register char *s;
{
#ifdef X11
	return XTextWidth(f, s, strlen(s));
#endif /* X11 */
}

#ifdef	X11
/*
 * Convert a blit style texture to a pixmap which can be used in tiling
 * or cursor operations.
 */
Texture
ToTexture(bits)
short bits[];
{
	static XImage *im;
	Pixmap pm;

	if (!im)
		im = XCreateImage(dpy, XDefaultVisual(dpy, 0), 1,
				  XYBitmap, 0, (char *)bits, 16, 16, 8, 2);
	else
		im->data = (char *)bits;
	XSetForeground(dpy, gc, 0);		/* restore defaults */
	XSetBackground(dpy, gc, 1);
	XSetFunction(dpy, gc, GXcopy);
	pm = XCreatePixmap(dpy, display.dr, 16, 16, 1);
	XPutImage(dpy, pm, gc, im, 0, 0, 0, 0, 16, 16);
	return pm;
}

Pixmap
ToPixmap(bits, wid, ht)
char  *bits;
int	wid, ht;
{
	Pixmap	pm;

	pm = XCreatePixmapFromBitmapData(dpy, display.dr, bits, wid, ht, bgpix,
		fgpix, DefaultDepth(dpy, 0));
	return pm;
}

Cursor
ToCursor (source, mask, hotx, hoty)
short source[], mask[];
{
	Texture sp, mp;
	Cursor c;

	sp = ToTexture(source);
	mp = ToTexture(mask);
	c = XCreatePixmapCursor(dpy, sp,mp, &fgcolor,&bgcolor, hotx,hoty);
	XFreePixmap(dpy, sp);
	XFreePixmap(dpy, mp);
	return(c);
}

Pixmap _ToBitmap(bits, wid, ht)
char *bits;
unsigned int wid, ht;
{
	Pixmap pm;

	pm = XCreateBitmapFromData(dpy, display.dr, bits, wid, ht);
	return pm;
}

Cursor _ToCursor(source, mask, wid, ht, hotx, hoty)
char *source, *mask;
unsigned int wid, ht, hotx, hoty;
{
	Pixmap sp, mp;
	Cursor c;

	sp = _ToBitmap(source, wid, ht);
	mp = _ToBitmap(mask, wid, ht);
	c = XCreatePixmapCursor(dpy, sp, mp, &fgcolor, &bgcolor, hotx, hoty);
	XFreePixmap(dpy, sp);
	XFreePixmap(dpy, mp);
	return(c);
}

int
cursorSizeOKWithServer(wid, ht)
unsigned int wid, ht;
{
	unsigned int rw, rh;

	if (XQueryBestCursor(dpy, display.dr, wid, ht, &rw, &rh) != (Status)1)
		return (False);

	return (rw >= wid && rh >= ht);
}

#endif /* X11 */

char *
gcalloc (nbytes, where)
unsigned long nbytes;
char **where;
{
	*where=(char *)alloc(nbytes);
	return *where;
}

void
gcfree (s)
char *s;
{
	free(s);
}

#undef button
void
handleinput ()
{
	XEvent ev;
	KeySym key;
	unsigned char s[16], *cp;
	int n;
	Window rw, cw;
	int xr, yr, xw, yw;
	unsigned bstate;

	for(;;){
		XNextEvent(dpy, &ev);
		switch (ev.type) {
		case ButtonPress:
			mouse.buttons |= (8 >> ev.xbutton.button);
			mouse.xy.x = ev.xbutton.x;
			mouse.xy.y = ev.xbutton.y;
			mouse.time = ev.xbutton.time;
			break;
		case ButtonRelease:
			mouse.buttons &= ~(8 >> ev.xbutton.button);
			mouse.xy.x = ev.xbutton.x;
			mouse.xy.y = ev.xbutton.y;
			mouse.time = ev.xbutton.time;
			break;
		case MotionNotify:
			XQueryPointer(dpy, display.dr,
				&rw, &cw, &xr, &yr, &xw, &yw, &bstate);
			if(button123() && bstate==0)
				continue;
			mouse.xy.x = xw;
			mouse.xy.y = yw;
			break;
		case MapNotify:
		case NoExpose:
			break;
		case ConfigureNotify:
#ifndef XBUG
			Joffset.x = ev.xconfigure.x;
			Joffset.y = ev.xconfigure.y;
#endif /* XBUG */
			if (display.rect.corner.x != ev.xconfigure.width ||
			    display.rect.corner.y != ev.xconfigure.height) {
				display.rect.corner.x = ev.xconfigure.width;
				display.rect.corner.y = ev.xconfigure.height;
				Drect = display.rect;
#ifdef XBUG
				Jfscreen = display;
#endif
			}
			break;
		case Expose:
			if (ev.xexpose.count == 0) {
				rectf(&display, Drect, F_CLR);
				P->state |= RESHAPED;
			}
			break;
		case KeyPress:
			mouse.xy.x = ev.xkey.x;
			mouse.xy.y = ev.xkey.y;
			mouse.time = ev.xkey.time;
			n = XLookupString((XKeyEvent *)&ev, (char *)s, sizeof(s), NULL, NULL);
			if(n > 0){
				cp = s;
				P->state |= KBD;
				do{
					kbdread(cp);
				} while (--n);
			}
			break;
		default:
			break;
		}
		return;
	}
}

Jscreengrab()
{
	if (!Jlocklevel) {
		while (XGrabPointer(dpy, display.dr, False,
                        pointermask, GrabModeAsync, GrabModeAsync,
			None, *P->cursor, CurrentTime) != GrabSuccess)
				sleep(6);
		XSetSubwindowMode(dpy, gc, IncludeInferiors);
	}
	Jlocklevel++;
}

Jscreenrelease()
{
	if (--Jlocklevel <= 0) {
		Jlocklevel = 0;
		XUngrabPointer(dpy, CurrentTime);
		XSetSubwindowMode(dpy, gc, ClipByChildren);
	}
}

/* Compatability functions */

ringbell ()
{
	XBell(dpy, 0);
}

cursinhibit ()
{
}

cursallow ()
{
}

/* misc functions	*/
border (b,r,i,f)
Bitmap *b;
Rectangle r;
int i;
Code f;
{
	rectf(b, Rect(r.origin.x, r.origin.y, r.corner.x, r.origin.y+i), f);
	rectf(b, Rect(r.origin.x, r.corner.y-i, r.corner.x, r.corner.y), f);
	rectf(b, Rect(r.origin.x, r.origin.y+i, r.origin.x+i, r.corner.y-i), f);
	rectf(b, Rect(r.corner.x-i, r.origin.y+i, r.corner.x, r.corner.y-i), f);
}

setsizehints (width, height, flags)
{
	hintwidth = width;
	hintheight = height;
	hintflags = flags;
}

Point
Pt(x, y)
	short x, y;
{
	Point p;
	p.x = x;
	p.y = y;
	return p;
}
Rectangle
SRect(x1, y1, x2, y2)
	short x1, y1, x2, y2;
{
	Rectangle r;
	r.origin.x = x1;
	r.origin.y = y1;
	r.corner.x = x2;
	r.corner.y = y2;
	return r;
}
Rectangle
Rpt(p1, p2)
	Point p1, p2;
{
	Rectangle r;
	r.origin = p1;
	r.corner = p2;
	return r;
}

#ifdef	X11

#include <X11/Xatom.h>

/*
 * Set up stuff the window manager will want to know.  Must be done
 * before mapping window, but after creating it.
 */

char *MyClass = "Jerq";
char *	MyIconPixmapBits = (char *)None;
int	MyIconPixmapWidth;
int	MyIconPixmapHeight;

#define	HOSTNLEN	40

setAllHints(argc, argv, sizehints)
int				argc;
char **				argv;
XSizeHints *			sizehints;
{
	XClassHint		xch;
	XWMHints		xwmh;
	char *			host[HOSTNLEN];
	Pixmap			ip;

	xch.res_name = argv[0];
	xch.res_class = MyClass;
	XSetClassHint(dpy, display.dr, &xch);
	XStoreName(dpy, display.dr, argv[0]);

	XSetCommand(dpy, display.dr, argv, argc);

	XSetIconName(dpy, display.dr, argv[0]);

	XSetNormalHints(dpy, display.dr, sizehints);

	xwmh.flags = InputHint | StateHint;
	xwmh.input = True;
	xwmh.initial_state = NormalState;
	if (MyIconPixmapBits != (char *)None) {
		ip = _ToBitmap(MyIconPixmapBits, MyIconPixmapWidth, MyIconPixmapHeight);
		xwmh.icon_pixmap = ip;
		xwmh.flags |= IconPixmapHint;
	}
	XSetWMHints(dpy, display.dr, &xwmh);
	if (gethostname(host, sizeof host) >= 0)
		XChangeProperty(dpy, display.dr, XA_WM_CLIENT_MACHINE, XA_STRING, 
			8, PropModeReplace, (unsigned char *)host, strlen(host));
}
#endif /* X11 */
