#include "jerq.h"
#include <errno.h>

sendchar(c)
char c;
{
	sendnchars(1, &c);
}

sendnchars (n, p)
char *p;
int n;
{
	int i;
	int maxfd;
#ifdef SVR4
	fd_set rmask, wmask;
#else
	int rmask, wmask;
#endif

#ifdef SVR4
	FD_ZERO(&rmask);
	FD_ZERO(&wmask);
#endif
	maxfd = displayfd + 1;
	while(n){
		i = write(1, p, n);
		if(i > 0){
			n -= i;
			p += i;
			continue;
		}
#if defined(BSD) || defined(SVR4)
		if(i < 0 && errno == EWOULDBLOCK){
#else	/* V9 */
		if(i < 0 && errno == EBUSY){
#endif
			do{
				while (XPending(dpy))
					handleinput();
#ifdef SVR4
				FD_SET(displayfd, &rmask);
				if (jerqrcvmask)
					FD_SET(1, &rmask);
				FD_SET(2, &wmask);
#else
				rmask = (1 << displayfd) | jerqrcvmask;
				wmask = 2;
#endif
#if defined(BSD) || defined(SVR4)
				select(maxfd, &rmask, &wmask, 0, 0);
#else
				select(maxfd, &rmask, &wmask, 0x6fffffff);
#endif
#ifdef SVR4
				if (jerqrcvmask && FD_ISSET(jerqrcvmask, &rmask))
					rcvfill();
				if (FD_ISSET(displayfd, &rmask))
					handleinput();
			} while(!FD_ISSET(2, &wmask));
#else
				if (rmask & jerqrcvmask)
					rcvfill();
				if (rmask & (1 << displayfd))
					handleinput();
			} while(!wmask);
#endif
		} else
			exit(1);
	}
}
