#include "master.pri"
#include "process.pri"
#include "rt.h"
#include "rtraw.h"
#include "rtnrtx.h"
SRCFILE("rt.c")

#define	K	DB_KERNELID

RtConnections::RtConnections()
{
	Menu m;
	char conn[128], *c;
	int i;
	char *getenv(char*);

	pad = new Pad( (PadRcv*) this );
	pad->options(TRUNCATE|SORTED);
	pad->name( "RtConnections" );
	pad->banner( "RtConnections:" );
	m.last("quit?", (Action)&::exit, 0);
	pad->menu(m);
	if( c = getenv("RTCONNECTIONS") ) {
		while(*c) {
			while (*c == ' ')
				c++;
			for (i = 0; *c && *c != ' '; i++, c++)
				conn[i] = *c;
			conn[i] = 0;
			if (i)
				kbd(conn);
		}
	}
	pad->makecurrent();
}

char *RtConnections::help()
{
	return "internetname {attach to internetname}";
}

char *RtConnections::kbd(char *s)
{
	RtNode *n = search(s);
	if (n)
		pad->insert((long)n, SELECTLINE, (PadRcv*)n, n->carte(),
			    n->name());
	else
		insert(new RtNode(this, sf("%s", s)));
	return 0;
}

RtNode *RtConnections::search(char *inetname)
{
	for (RtNode *n = child; n; n = n->sibling)
		if (eqstr(inetname, n->name()))
			break;
	return n;
}

void RtConnections::insert(RtNode *n)
{
	if (!child)
		child = n;
	else {
		n->sibling = child;
		child = n;
	}
	pad->insert((long)n, SELECTLINE, (PadRcv*)n, n->carte(), n->name());
}

RtNode::RtNode(RtConnections *c, char *s)
{
	parent = c;
	fd = -1;
	inetname = s;
}

char *RtNode::name()		{ return inetname; }

Index RtNode::carte()
{
	Menu m;
	m.last("open connection", (Action)&RtNode::open);
	return m.index();
}

void RtNode::open()
{
	if (fd != -1)
		goto out;
	if ((fd = ::dbopen(name())) == -1 || ::dbrequest(fd, 0, K,
	     DBR_GETNPROC, (int)&nboards, 0, sizeof(nboards)) == -1) {
		if (fd != -1) {
			::dbclose(fd);
			fd = -1;
		}
		parent->pad->insert(1, SELECTLINE, "Can't open %s", name());
		return;
	}
	if (nboards > 1) {
		pad = new Pad((PadRcv*) this );
		pad->options(TRUNCATE|SORTED);
		pad->name(name());
		pad->banner("%s:", name());
	}
	bmaster = new RtbMaster *[nboards];
	register RtbMaster *m;
	int i;
	DebugAttrib dba;
	for(i = 0; i < nboards; i++) {
		::dbrequest(fd, i, K, DBR_GETATTRIB,(int)&dba, 0, sizeof(dba));
		if (dba.os == DBOS_NRTX)
			m = (RtbMaster *)new RtNrtxMaster(fd, i, this);
		else
			m = (RtbMaster *)new RtRawMaster(fd, i, this);
		bmaster[i] = m;
		if (pad)
			pad->insert((long)m, DONT_CUT, (PadRcv*)m, m->carte(),
				m->name());
	}
out:
	if (pad)
		pad->makecurrent();
	else
		bmaster[0]->open();
}

RtbMaster::RtbMaster(int f,int b, RtNode *n)
{
	fd = f;
	boardid = b;
	parent = n;
	char s[128];
	::dbrequest(f, b, K, DBR_GETBNAME, (int)s, 0, sizeof(s));
	bname = sf("%s", s);
}

Index RtbMaster::carte()
{
	Menu m;
	m.last("open board", (Action)&RtbMaster::open);
	return m.index();
}

void RtbMaster::open()		{ }
char *RtbMaster::name()		{ return bname; }
