#include "core.pri"
#include "m68kcore.h"
#define proc nrtxproc
#include "/usr/dak/nrtx/src/sys/h/nrtxdb.h"
#include "/usr/dak/nrtx/src/sys/h/proc.h"

class RtNrtxSigMask;

class RtNrtxMaster : public RtbMaster {
	RtRawMaster *kernel;
	Process	*domakeproc(char*, char*, char*);
	char	*kbd(char*);
	char	*help();
	void	refresh(int);
	void	kpi();
public:
	void	open();
	RtNrtxMaster(int f,int i,RtNode* n): (f, i, n) {}
	Index	carte();
};

class RtNrtxProcess : public Process {
	friend RtNrtxCore;
	int	fd;
	int	boardid;
	int	procid;
	RtNrtxSigMask	*sigmsk;
	int	accept(Action);
	Index	carte();
	void	destroy();
	void	hang();
	void	hangopen();
	void	hangtakeover();
	void	opensigmask();
	void	substitute(RtNrtxProcess*);
	void	takeover();
	void	userclose();
public:
		RtNrtxProcess(int,int,Process*,char*,char*,char*);
	void	open();
};

class RtNrtxCore : public M68kCore {
	friend RtNrtxProcess;
	friend RtNrtxSigMask;
	int		commfd;
	int		boardid;
	int		procid;
	proc		pr;
	DebugKstate	kstate;
	char	*dostep(long,long,int);
	char	*readwrite(long,char*,int,int);
	int	instack(long,long);
	int	fpvalid(long);
	long	regaddr();
	Behavs	behavetype();
	long	scratchaddr();
	char	*dbreq(int, char* =0, int =0, int =0);
	char	*clrcurrsig();
	char	*signalmask(long);
	char	*exechang(long);
	char	*sendsig(long);
public:
		RtNrtxCore(int,int,int,Process*, Master*);
	Behavs	behavs();
	char	*eventname();
	char	*destroy();
	char	*laybpt(Trap*);
	char	*open();
	char	*problem();
	char	*readcontrol();
	char	*reopen(char*,char*);
	char	*run();
	char	*stop();
};

class RtNrtxSigMask : public PadRcv {
	friend RtNrtxSigBit;
	friend RtNrtxProcess;
	RtNrtxCore	*core;
	long	mask;
	Pad	*pad;
	long	exechang;
	long	bit(long s)		{ return 1<<(s-1); }
	void	signalmask(long);
	void	setsig(long);
	void	clrsig(long);
	void	clrcurrsig(long);
	void	sendsig(long);
	void	open();
	void	execline(long);
	void	updatecore(char* =0);
public:
		RtNrtxSigMask(RtNrtxCore*);
	void	linereq(long,Attrib=0);
	void	hostclose();
	void	banner();
};

class RtNrtxSigBit : public PadRcv {
	friend	RtNrtxSigMask;
	int	bit;
	void	set(RtNrtxSigMask*);
	void	clr(RtNrtxSigMask*);
	void	send(RtNrtxSigMask*);
		RtNrtxSigBit() {}
};
