
#include "gram.h"
#include "expr.pub"
#include "bpts.pub"
#include <ctype.h>
int LexIndex;
int LexGoal;
struct Expr *CurrentExpr;
char *LexString;
char *yyerr;		/* yacc doesn't use this */
long yyres;
char Token[128];
int DotDot;
Expr *E_IConst(long), *E_DConst(double);

typedef union
#ifdef __cplusplus
	YYSTYPE
#endif
 {
	char		cc;
	long		ll;
	char		ss[32];
	struct Expr	*ee;
	double		dd;
} YYSTYPE;
# define G_EXPR 257
# define G_DOTEQ_CONEX 258
# define G_DOLEQ_CONEX 259
# define G_CONEX 260
# define G_DOTDOT 261
# define ICONST 262
# define ID 263
# define PCENT 264
# define EQUAL 265
# define SLASH 266
# define DOLLAR 267
# define SIZEOF 268
# define TYPEOF 269
# define QMARK 270
# define SEMI 271
# define UNOP 272
# define STAR 273
# define PLUS 274
# define MINUS 275
# define AMPER 276
# define ARROW 277
# define DOT 278
# define LB 279
# define LP 280
# define COMMA 281
# define ERROR 282
# define RB 283
# define RP 284
# define PLUSPLUS 285
# define MINUSMINUS 286
# define EQUALEQUAL 287
# define GREATER 288
# define LESS 289
# define BAR 290
# define BARBAR 291
# define AMPERAMPER 292
# define HAT 293
# define TILDE 294
# define GREATEREQUAL 295
# define LESSEQUAL 296
# define FABS 297
# define GREATERGREATER 298
# define LESSLESS 299
# define BANG 300
# define BANGEQUAL 301
# define DCONST 302
# define LC 303
# define RC 304
# define DOTDOT 305

#ifdef __STDC__
#include <stdlib.h>
#include <string.h>
#else
#include <malloc.h>
#include <memory.h>
#endif

#include <values.h>

#ifdef __cplusplus

#ifndef yyerror
	void yyerror(const char *);
#endif

#ifndef yylex
#ifdef __EXTERN_C__
	extern "C" { int yylex(void); }
#else
	int yylex(void);
#endif
#endif
	int yyparse(void);

#endif
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
YYSTYPE yylval;
YYSTYPE yyval;
typedef int yytabelem;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#if YYMAXDEPTH > 0
int yy_yys[YYMAXDEPTH], *yys = yy_yys;
YYSTYPE yy_yyv[YYMAXDEPTH], *yyv = yy_yyv;
#else	/* user does initial allocation */
int *yys;
YYSTYPE *yyv;
#endif
static int yymaxdepth = YYMAXDEPTH;
# define YYERRCODE 256



#define LOOK (LexString[LexIndex ])
#define TAKE (AddToken(), LexString[LexIndex++])
#define MORE (LexString[LexIndex+1])
#define yc (yylval.cc)
#define yd (yylval.dd)
#define yl (yylval.ll)
#define ys (yylval.ss)
#define ishex(x) (isdigit(x) || (x>='a'&&x<='f') || (x>='A'&&x<='F'))
#define isoct(x) ( x>='0' && x<='7' )
int doyylex();
int yyerror(char*);

yylex()
{
	int token = doyylex();

	return token;
}

void AddToken()
{
	int l = strlen(Token);

	if( l < 64 ){
		Token[l] = LOOK;
		Token[l+1] = '\0';
	}
}

doyylex()
{
	if( LexIndex < 0 ){
		LexIndex = 0;
		return LexGoal;
	}
	while( isspace(LOOK) ) TAKE;
	Token[0] = '\0';
	if( isalpha(LOOK) || LOOK=='_' || LOOK=='$' ){
		TAKE;
		while( isalnum(LOOK) || LOOK=='_' ) TAKE;
		strcpy( ys, Token );
		if( !strcmp(ys,"sizeof") ) return SIZEOF;
		if( !strcmp(ys,"typeof") ) return TYPEOF;
		if( !strcmp(ys,"fabs") ) return FABS;
		if( !strcmp(ys,"$") ) return DOLLAR;
		return ID;
	}
	if( LOOK == '\'' ){
		TAKE;
		if( LOOK == '\\' ){
			TAKE;
			if( MORE != '\'' ) return 0;
			char *trans = "bnftv", *late = "\b\n\f\t\v";
			yl = LOOK;
			for( int i = 0; trans[i]; ++i )
				if( LOOK == trans[i] ) yl = late[i];
			TAKE; TAKE; return ICONST;
		}
		if( MORE != '\'' ) return 0;
		yl = TAKE;
		TAKE;
		return ICONST;
	}
	if( LOOK=='0' && (MORE=='x' || MORE=='X') ){
		TAKE; TAKE;
		if( !ishex(LOOK) ) return 0;
		for( yl = 0; ishex(LOOK); TAKE )
		    yl = (yl<<4) + (isalpha(LOOK) ? (LOOK|' ')+10-'a' : LOOK-'0');
		return ICONST;
	}
	if( LOOK=='0' ){
		for( TAKE, yl = 0; isoct(LOOK); TAKE ) yl = (yl<<3) + LOOK - '0';
		goto IorD;
	}
	if( isdigit(LOOK) ){
		for( yl = 0; isdigit(LOOK); TAKE ) yl = yl*10 + LOOK - '0';
		goto IorD;
	}
	if( LOOK == '.' && isdigit(MORE) ) goto Point;
#define EAT2(x) {TAKE; TAKE; return x;}
	if( LOOK=='.' && MORE=='.' ) EAT2(DOTDOT)
	if( LOOK=='-' && MORE=='>' ) EAT2(ARROW)
	if( LOOK=='-' && MORE=='-' ) EAT2(MINUSMINUS)
	if( LOOK=='+' && MORE=='+' ) EAT2(PLUSPLUS)
	if( LOOK=='=' && MORE=='=' ) EAT2(EQUALEQUAL)
	if( LOOK=='!' && MORE=='=' ) EAT2(BANGEQUAL)
	if( LOOK==':' && MORE=='=' ) EAT2(EQUAL)
	if( LOOK=='>' && MORE=='=' ) EAT2(GREATEREQUAL)
	if( LOOK=='<' && MORE=='=' ) EAT2(LESSEQUAL)
	if( LOOK=='&' && MORE=='&' ) EAT2(AMPERAMPER)
	if( LOOK=='|' && MORE=='|' ) EAT2(BARBAR)
	if( LOOK=='>' && MORE=='>' ) EAT2(GREATERGREATER)
	if( LOOK=='<' && MORE=='<' ) EAT2(LESSLESS)
	switch( TAKE ){
		case '>' : return GREATER;
		case '<' : return LESS;
		case '/' : return SLASH;
		case '*' : return STAR;
		case '+' : return PLUS;
		case '-' : return MINUS;
		case '.' : return DOT;
		case '(' : return LP;
		case ')' : return RP;
		case '[' : return LB;
		case ']' : return RB;
		case '&' : return AMPER;
		case ',' : return COMMA;
		case '%' : return PCENT;
		case '=' : return EQUAL;
		case ';' : return SEMI;
		case '|' : return BAR;
		case '^' : return HAT;
		case '~' : return TILDE;
		case '!' : return BANG;
		case '{' : return LC;
		case '}' : return RC;
		default  : return 0;
	}
IorD:
	if( LOOK=='l' || LOOK=='L' ) return TAKE, ICONST;
	if( LOOK=='.' && MORE=='.' ) return ICONST;
	if( LOOK=='.' ) goto Point;
	if( LOOK=='e' || LOOK=='E' ) goto Exp;
	return ICONST;
Point:
	for( TAKE; isdigit(LOOK); TAKE) {}
	if( LOOK!='e' && LOOK!='E' ) goto Double;
Exp:
	TAKE;
	if( LOOK=='+' || LOOK=='-' ) TAKE;
	if( !isdigit(LOOK) ) return 0;
	while( isdigit(LOOK) ) TAKE;
Double:
	yd = atof(Token);
	return DCONST;	

}
yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 62
# define YYLAST 800
yytabelem yyact[]={

    66,    50,    68,   128,    81,    72,   127,    42,     9,    67,
    69,    64,    54,    65,    48,    70,    10,    49,    35,    34,
   129,   126,   110,    56,    59,    58,    53,    51,    52,    55,
    93,    61,    60,     8,    62,    63,     7,    57,    66,    50,
    68,    47,    65,    48,    70,     1,   117,    67,    69,    64,
    54,    65,    48,    70,     0,    49,     0,   125,     0,     0,
     0,    56,    59,    58,    53,    51,    52,    55,     0,    61,
    60,     0,    62,    63,     0,    57,    66,    50,    68,    47,
     2,     4,     5,     6,     3,    67,    69,    64,    54,    65,
    48,    70,     0,    49,     0,     0,   120,     0,     0,    56,
    59,    58,    53,    51,    52,    55,     0,    61,    60,     0,
    62,    63,     0,    57,    66,    50,    68,    47,     0,     0,
     0,     0,     0,    67,    69,    64,    54,    65,    48,    70,
     0,    49,     0,     0,     0,     0,     0,    56,    59,    58,
    53,    51,    52,    55,     0,    61,    60,     0,    62,    63,
     0,    57,     0,     0,   116,    47,    66,    50,    68,     0,
     0,     0,     0,    82,     0,    67,    69,    64,    54,    65,
    48,    70,     0,    49,     0,     0,     0,     0,     0,    56,
    59,    58,    53,    51,    52,    55,     0,    61,    60,     0,
    62,    63,     0,    57,    66,    50,    68,    47,     0,     0,
     0,    46,     0,    67,    69,    64,    54,    65,    48,    70,
     0,    49,     0,     0,     0,     0,     0,    56,    59,    58,
    53,    51,    52,    55,     0,    61,    60,     0,    62,    63,
     0,    57,    66,    50,    68,    47,     0,     0,     0,     0,
     0,    67,    69,    64,    54,    65,    48,    70,     0,     0,
     0,     0,     0,     0,     0,    56,    59,    58,    53,    51,
    52,    55,     0,    61,    60,     0,    62,    63,     0,    57,
    66,    50,    68,    47,     0,     0,     0,     0,     0,    67,
    69,    64,    54,    65,    48,    70,     0,    49,     0,     0,
     0,     0,     0,    56,    59,    58,    53,    51,    52,    55,
     0,    61,    60,     0,    62,    63,     0,    57,    66,    50,
    68,    14,    13,     0,     0,     0,    12,    67,    69,    64,
    54,    65,    48,    70,    16,    15,     0,     0,     0,    17,
     0,    56,    59,    58,    53,    51,    52,    55,     0,    61,
    60,     0,    62,    63,    66,    57,    68,     0,     0,     0,
     0,     0,     0,    67,    69,    64,    54,    65,    48,    70,
     0,     0,    38,     0,    40,     0,     0,    56,    59,    58,
    53,    39,    52,    55,     0,    61,    60,    42,    62,    63,
    66,    57,    68,     0,     0,     0,     0,     0,     0,    67,
    69,    64,    54,    65,    48,    70,     0,     0,     0,     0,
     0,     0,     0,    56,    59,    58,    53,     0,     0,    55,
     0,    61,    60,     0,    62,    63,    66,    57,    68,     0,
     0,     0,     0,     0,     0,    67,    69,    64,    54,    65,
    48,    70,     0,     0,     0,     0,     0,     0,     0,    56,
    59,    58,     0,     0,     0,    55,     0,    61,    60,     0,
    62,    63,    66,    57,    68,     0,     0,     0,     0,     0,
     0,    67,    69,    64,    54,    65,    48,    70,     0,     0,
     0,     0,     0,     0,     0,    56,    59,    58,     0,    66,
     0,    68,     0,    61,    60,     0,    62,    63,    67,    57,
    23,    21,    65,    48,    70,    19,    26,    27,     0,     0,
    66,    24,    68,    29,    25,     0,     0,     0,    31,    67,
    69,    64,   118,    65,    48,    70,     0,     0,     0,     0,
     0,     0,    30,     0,     0,    32,     0,     0,    28,     0,
    22,    20,    23,    21,    62,    63,     0,    19,    26,    27,
     0,     0,    38,    24,    40,    29,    25,     0,     0,     0,
    31,    39,    41,    37,     0,     0,     0,    42,     0,     0,
     0,     0,    91,     0,    30,     0,    66,    32,    68,     0,
    28,     0,    22,    20,     0,    67,    69,    64,     0,    65,
    48,    70,     0,     0,     0,     0,     0,     0,     0,    56,
    59,    58,     0,     0,     0,     0,     0,    61,    60,     0,
    62,    63,    66,    57,    68,     0,     0,     0,     0,     0,
     0,    67,    69,    64,     0,    65,    48,    70,     0,     0,
    38,     0,    40,     0,     0,     0,    59,    58,     0,    39,
    41,    37,     0,    61,    60,    42,    62,    63,    66,   124,
    68,     0,     0,     0,     0,     0,     0,    67,    69,    64,
     0,    65,    48,    70,    38,     0,    40,     0,     0,     0,
     0,   123,     0,    39,    41,    37,    38,     0,    40,    42,
    18,     0,     0,   122,     0,    39,    41,    37,    38,    33,
    40,    42,     0,     0,     0,    36,     0,    39,    41,    37,
     0,    71,     0,    42,     0,    73,    74,    75,    76,    77,
    78,    79,    80,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,    92,     0,
    94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
   104,   105,   106,   107,   108,   109,     0,   111,   112,   113,
   114,   115,    11,   119,     0,     0,     0,     0,     0,     0,
     0,     0,   121,     0,     0,     0,     0,     0,    43,    44,
    45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    83,    84,     0,
    85,    86,    87,    88,    89,    90,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,   130 };
yytabelem yypact[]={

  -177,-10000000,-10000000,-10000000,  -270,  -251,    49,   270,   270,  -246,
  -247,   414,-10000000,-10000000,-10000000,    49,    49,    49,   -70,-10000000,
   270,  -275,-10000000,-10000000,   270,   270,   270,   270,   270,   270,
   270,   270,  -276,  -108,    49,    49,-10000000,    49,    49,    49,
    49,    49,    49,  -272,  -272,   278,-10000000,   270,  -233,   270,
   270,   270,   270,   270,   270,   270,   270,   270,   270,   270,
   270,   270,   270,   270,   270,  -241,   270,   270,   270,   270,
   270,  -150,   228,  -235,   302,  -235,  -235,  -235,  -235,  -235,
  -188,   270,-10000000,   402,   390,    98,  -272,  -272,  -272,    98,
   356,-10000000,     6,-10000000,    44,    44,    80,   116,   152,   302,
   188,   338,   338,   236,   236,   236,   236,   374,   374,   215,
-10000000,  -235,  -235,  -235,   215,  -226,  -242,  -278,-10000000,   -32,
-10000000,  -264,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,   270,-10000000,
   -32 };
yytabelem yypgo[]={

     0,   670,    46,   742,    45,    36,    33 };
yytabelem yyr1[]={

     0,     5,     4,     6,     4,     4,     4,     4,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     2,     2 };
yytabelem yyr2[]={

     0,     1,     9,     1,     9,    11,    11,     7,     3,     9,
     3,     3,     3,     5,     5,     5,     5,     5,     5,     5,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     9,     9,     7,     7,     9,     3,     3,
     3,     5,     5,     7,     7,     7,     7,     7,     9,     7,
     3,     7 };
yytabelem yychk[]={

-10000000,    -4,   257,   261,   258,   259,   260,    -5,    -6,   278,
   267,    -3,   267,   263,   262,   276,   275,   280,    -1,   267,
   303,   263,   302,   262,   273,   276,   268,   269,   300,   275,
   294,   280,   297,    -1,   265,   265,   271,   275,   264,   273,
   266,   274,   279,    -3,    -3,    -3,   271,   305,   278,   281,
   265,   291,   292,   290,   276,   293,   287,   301,   289,   288,
   296,   295,   298,   299,   275,   277,   264,   273,   266,   274,
   279,    -1,   280,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   280,   271,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
    -3,   284,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
   263,    -1,    -1,    -1,    -1,    -1,   304,    -2,   284,    -1,
   284,    -1,   271,   271,   283,   283,   263,   284,   281,   284,
    -1 };
yytabelem yydef[]={

     0,    -2,     1,     3,     0,     0,     0,     0,     0,     0,
     0,     0,    48,    49,    50,     0,     0,     0,     0,     8,
     0,    10,    11,    12,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     7,     0,     0,     0,
     0,     0,     0,    51,    52,     0,     2,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,    13,    14,    15,    16,    17,    18,    19,
     0,     0,     4,     0,     0,    53,    54,    55,    56,    57,
     0,    59,    20,    21,    22,    23,    24,    25,    26,    27,
    28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
    38,    39,    40,    41,    42,     0,     0,     0,    45,    60,
    46,     0,     5,     6,    58,    43,     9,    44,     0,    47,
    61 };
typedef struct
#ifdef __cplusplus
	yytoktype
#endif
{ char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"G_EXPR",	257,
	"G_DOTEQ_CONEX",	258,
	"G_DOLEQ_CONEX",	259,
	"G_CONEX",	260,
	"G_DOTDOT",	261,
	"ICONST",	262,
	"ID",	263,
	"PCENT",	264,
	"EQUAL",	265,
	"SLASH",	266,
	"DOLLAR",	267,
	"SIZEOF",	268,
	"TYPEOF",	269,
	"QMARK",	270,
	"SEMI",	271,
	"UNOP",	272,
	"STAR",	273,
	"PLUS",	274,
	"MINUS",	275,
	"AMPER",	276,
	"ARROW",	277,
	"DOT",	278,
	"LB",	279,
	"LP",	280,
	"COMMA",	281,
	"ERROR",	282,
	"RB",	283,
	"RP",	284,
	"PLUSPLUS",	285,
	"MINUSMINUS",	286,
	"EQUALEQUAL",	287,
	"GREATER",	288,
	"LESS",	289,
	"BAR",	290,
	"BARBAR",	291,
	"AMPERAMPER",	292,
	"HAT",	293,
	"TILDE",	294,
	"GREATEREQUAL",	295,
	"LESSEQUAL",	296,
	"FABS",	297,
	"GREATERGREATER",	298,
	"LESSLESS",	299,
	"BANG",	300,
	"BANGEQUAL",	301,
	"DCONST",	302,
	"LC",	303,
	"RC",	304,
	"DOTDOT",	305,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"start : G_EXPR",
	"start : G_EXPR expr SEMI",
	"start : G_DOTDOT",
	"start : G_DOTDOT expr SEMI",
	"start : G_DOTEQ_CONEX DOT EQUAL conex SEMI",
	"start : G_DOLEQ_CONEX DOLLAR EQUAL conex SEMI",
	"start : G_CONEX conex SEMI",
	"expr : DOLLAR",
	"expr : LC expr RC ID",
	"expr : ID",
	"expr : DCONST",
	"expr : ICONST",
	"expr : STAR expr",
	"expr : AMPER expr",
	"expr : SIZEOF expr",
	"expr : TYPEOF expr",
	"expr : BANG expr",
	"expr : MINUS expr",
	"expr : TILDE expr",
	"expr : expr DOTDOT expr",
	"expr : expr DOT ID",
	"expr : expr COMMA expr",
	"expr : expr EQUAL expr",
	"expr : expr BARBAR expr",
	"expr : expr AMPERAMPER expr",
	"expr : expr BAR expr",
	"expr : expr AMPER expr",
	"expr : expr HAT expr",
	"expr : expr EQUALEQUAL expr",
	"expr : expr BANGEQUAL expr",
	"expr : expr LESS expr",
	"expr : expr GREATER expr",
	"expr : expr LESSEQUAL expr",
	"expr : expr GREATEREQUAL expr",
	"expr : expr GREATERGREATER expr",
	"expr : expr LESSLESS expr",
	"expr : expr MINUS expr",
	"expr : expr ARROW ID",
	"expr : expr PCENT expr",
	"expr : expr STAR expr",
	"expr : expr SLASH expr",
	"expr : expr PLUS expr",
	"expr : expr LB expr RB",
	"expr : ID LP list RP",
	"expr : ID LP RP",
	"expr : LP expr RP",
	"expr : FABS LP expr RP",
	"conex : DOLLAR",
	"conex : ID",
	"conex : ICONST",
	"conex : AMPER conex",
	"conex : MINUS conex",
	"conex : conex MINUS conex",
	"conex : conex PCENT conex",
	"conex : conex STAR conex",
	"conex : conex SLASH conex",
	"conex : conex PLUS conex",
	"conex : conex LB conex RB",
	"conex : LP conex RP",
	"list : expr",
	"list : list COMMA expr",
};
#endif /* YYDEBUG */
/*
 * Copyright (c) 1993 by Sun Microsystems, Inc.
 */

#pragma ident	"@(#)yaccpar	6.12	93/06/07 SMI"

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#define YYNEW(type)	malloc(sizeof(type) * yynewmax)
#define YYCOPY(to, from, type) \
	(type *) memcpy(to, (char *) from, yynewmax * sizeof(type))
#define YYENLARGE( from, type) \
	(type *) realloc((char *) from, yynewmax * sizeof(type))
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-10000000)

/*
** global variables used by the parser
*/
YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



#ifdef YYNMBCHARS
#define YYLEX()		yycvtok(yylex())
/*
** yycvtok - return a token if i is a wchar_t value that exceeds 255.
**	If i<255, i itself is the token.  If i>255 but the neither 
**	of the 30th or 31st bit is on, i is already a token.
*/
#if defined(__STDC__) || defined(__cplusplus)
int yycvtok(int i)
#else
int yycvtok(i) int i;
#endif
{
	int first = 0;
	int last = YYNMBCHARS - 1;
	int mid;
	wchar_t j;

	if(i&0x60000000){/*Must convert to a token. */
		if( yymbchars[last].character < i ){
			return i;/*Giving up*/
		}
		while ((last>=first)&&(first>=0)) {/*Binary search loop*/
			mid = (first+last)/2;
			j = yymbchars[mid].character;
			if( j==i ){/*Found*/ 
				return yymbchars[mid].tvalue;
			}else if( j<i ){
				first = mid + 1;
			}else{
				last = mid -1;
			}
		}
		/*No entry in the table.*/
		return i;/* Giving up.*/
	}else{/* i is already a token. */
		return i;
	}
}
#else/*!YYNMBCHARS*/
#define YYLEX()		yylex()
#endif/*!YYNMBCHARS*/

/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
#if defined(__STDC__) || defined(__cplusplus)
int yyparse(void)
#else
int yyparse()
#endif
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

#if defined(__cplusplus) || defined(lint)
/*
	hacks to please C++ and lint - goto's inside switch should never be
	executed; yypvt is set to 0 to avoid "used before set" warning.
*/
	static int __yaccpar_lint_hack__ = 0;
	switch (__yaccpar_lint_hack__)
	{
		case 1: goto yyerrlab;
		case 2: goto yynewstate;
	}
	yypvt = 0;
#endif

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

#if YYMAXDEPTH <= 0
	if (yymaxdepth <= 0)
	{
		if ((yymaxdepth = YYEXPAND(0)) <= 0)
		{
			yyerror("yacc initialization error");
			YYABORT;
		}
	}
#endif

	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */
	goto yystack;	/* moved from 6 lines above to here to please C++ */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			int yynewmax;
#ifdef YYEXPAND
			yynewmax = YYEXPAND(yymaxdepth);
#else
			yynewmax = 2 * yymaxdepth;	/* double table size */
			if (yymaxdepth == YYMAXDEPTH)	/* first time growth */
			{
				char *newyys = (char *)YYNEW(int);
				char *newyyv = (char *)YYNEW(YYSTYPE);
				if (newyys != 0 && newyyv != 0)
				{
					yys = YYCOPY(newyys, yys, int);
					yyv = YYCOPY(newyyv, yyv, YYSTYPE);
				}
				else
					yynewmax = 0;	/* failed */
			}
			else				/* not first time */
			{
				yys = YYENLARGE(yys, int);
				yyv = YYENLARGE(yyv, YYSTYPE);
				if (yys == 0 || yyv == 0)
					yynewmax = 0;	/* failed */
			}
#endif
			if (yynewmax <= yymaxdepth)	/* tables not expanded */
			{
				yyerror( "yacc stack overflow" );
				YYABORT;
			}
			yymaxdepth = yynewmax;

			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
			skip_init:
				yynerrs++;
				/* FALLTHRU */
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:
{ DotDot=0; } break;
case 2:
{ yyres = (long) yypvt[-1].ee;  } break;
case 3:
{ DotDot=1; } break;
case 4:
{ yyres = (long) yypvt[-1].ee;  } break;
case 5:
{ yyres = (long) yypvt[-1].ee; } break;
case 6:
{ yyres = (long) yypvt[-1].ee; } break;
case 7:
{ yyres = (long) yypvt[-1].ee; } break;
case 8:
{ if( !CurrentExpr){
					yyerror("$ cannot be used here");
					YYACCEPT;
				  }
				  yyval.ee = CurrentExpr;
				} break;
case 9:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_ENV, E_Id(yypvt[-0].ss) ); } break;
case 10:
{ yyval.ee = E_Id( yypvt[-0].ss ); } break;
case 11:
{ yyval.ee = E_DConst( yypvt[-0].dd ); } break;
case 12:
{ yyval.ee = E_IConst( yypvt[-0].ll ); } break;
case 13:
{ yyval.ee = E_Unary( O_DEREF, yypvt[-0].ee ); } break;
case 14:
{ yyval.ee = E_Unary( O_REF, yypvt[-0].ee ); } break;
case 15:
{ yyval.ee = E_Unary( O_SIZEOF, yypvt[-0].ee ); } break;
case 16:
{ yyval.ee = E_Unary( O_TYPEOF, yypvt[-0].ee ); } break;
case 17:
{ yyval.ee = E_Unary( O_LOGNOT, yypvt[-0].ee ); } break;
case 18:
{ yyval.ee = E_Unary( O_MINUS, yypvt[-0].ee ); } break;
case 19:
{ yyval.ee = E_Unary( O_1SCOMP, yypvt[-0].ee ); } break;
case 20:
{ if( !DotDot ){
					yyerror(".. cannot be used here");
					YYACCEPT;
				  }
				  yyval.ee = E_Binary( yypvt[-2].ee, O_RANGE, yypvt[-0].ee );} break;
case 21:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_DOT, E_Id(yypvt[-0].ss)); } break;
case 22:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_COMMA, yypvt[-0].ee ); } break;
case 23:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_ASSIGN, yypvt[-0].ee ); } break;
case 24:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_LOGOR, yypvt[-0].ee ); } break;
case 25:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_LOGAND, yypvt[-0].ee ); } break;
case 26:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_BITOR, yypvt[-0].ee ); } break;
case 27:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_BITAND, yypvt[-0].ee ); } break;
case 28:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_BITXOR, yypvt[-0].ee ); } break;
case 29:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_EQ, yypvt[-0].ee ); } break;
case 30:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_NE, yypvt[-0].ee ); } break;
case 31:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_LT, yypvt[-0].ee ); } break;
case 32:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_GT, yypvt[-0].ee ); } break;
case 33:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_LE, yypvt[-0].ee ); } break;
case 34:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_GE, yypvt[-0].ee ); } break;
case 35:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_RSHIFT, yypvt[-0].ee ); } break;
case 36:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_LSHIFT, yypvt[-0].ee ); } break;
case 37:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_MINUS, yypvt[-0].ee ); } break;
case 38:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_ARROW, E_Id(yypvt[-0].ss)); } break;
case 39:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_MOD, yypvt[-0].ee ); } break;
case 40:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_MULT, yypvt[-0].ee ); } break;
case 41:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_DIV, yypvt[-0].ee ); } break;
case 42:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_PLUS, yypvt[-0].ee ); } break;
case 43:
{ yyval.ee = E_Binary( yypvt[-3].ee, O_INDEX, yypvt[-1].ee );} break;
case 44:
{ yyval.ee = E_Binary( E_Id(yypvt[-3].ss), O_CALL, yypvt[-1].ee ); } break;
case 45:
{ yyval.ee = E_Binary( E_Id(yypvt[-2].ss), O_CALL, 0 ); } break;
case 46:
{ yyval.ee = yypvt[-1].ee; } break;
case 47:
{ yyval.ee = E_Unary( O_FABS, yypvt[-1].ee ); } break;
case 48:
{ if( !CurrentExpr){
					yyerror("no current expression for $");
					YYACCEPT;
				  }
				  yyval.ee = CurrentExpr;
				} break;
case 49:
{ yyval.ee = E_Id( yypvt[-0].ss ); } break;
case 50:
{ yyval.ee = E_IConst( yypvt[-0].ll ); } break;
case 51:
{ yyval.ee = E_Unary( O_REF, yypvt[-0].ee ); } break;
case 52:
{ yyval.ee = E_Unary( O_MINUS, yypvt[-0].ee ); } break;
case 53:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_MINUS, yypvt[-0].ee ); } break;
case 54:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_MOD, yypvt[-0].ee ); } break;
case 55:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_MULT, yypvt[-0].ee ); } break;
case 56:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_DIV, yypvt[-0].ee ); } break;
case 57:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_PLUS, yypvt[-0].ee ); } break;
case 58:
{ yyval.ee = E_Binary( yypvt[-3].ee, O_INDEX, yypvt[-1].ee );} break;
case 59:
{ yyval.ee = yypvt[-1].ee; } break;
case 60:
{ yyval.ee = yypvt[-0].ee; } break;
case 61:
{ yyval.ee = E_Binary( yypvt[-2].ee, O_COMMA, yypvt[-0].ee ); } break;
	}
	goto yystack;		/* reset registers in driver code */
}

