#include "core.pri"
#include "m68kcore.h"

class RtRawMaster : public RtbMaster {
	Process	*domakeproc(char*, char*, char*);
	char	*kbd(char*);
	char	*help();
	void	refresh();
public:
	void	clean(Process*);
	void	open();
	RtRawMaster(int f,int i,RtNode* n): (f, i, n) {}
	Index	carte();
};

class RtRawProcess : public Process {
	friend RtRawCore;
	int	fd;
	int	boardid;
	int	accept(Action);
	Index	carte();
	void	hang();
	void	hangopen();
	void	hangtakeover();
	void	substitute(RtRawProcess*);
	void	takeover();
	void	destroy();
public:
		RtRawProcess(int,int,Process*,char*,char*,char*);
	void	open();
};

class RtRawCore : public M68kCore {
	friend RtRawProcess;
	int		commfd;
	int		boardid;
	DebugAttrib	attrib;
	DebugKstate	state;
	char	*dostep(long,long,int);
	char	*readwrite(long,char*,int,int);
	int	instack(long,long);
	int	fpvalid(long);
	long	regaddr();
	Behavs	behavetype();
	long	scratchaddr();
	char	*dbreq(int, char* =0, int =0, int =0);
public:
		RtRawCore(int,int,Process*, Master*);
	Behavs	behavs();
	char	*eventname();
	char	*destroy();
	char	*laybpt(Trap*);
	char	*open();
	char	*readcontrol();
	char	*reopen(char*,char*);
	char	*run();
	char	*stop();
	int	nregs();
};
