;  BUFFER.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, TOOLS GROUP-DNK, 11/05/82
;  Contains buffer manipulation extensions in EMACS
;  Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; horiz_left            shifts the current window to the left    ^x}       ;;;
;;; horiz_right           shifts the current window to the right   ^x{       ;;;
;;; hscroll               takes the present column as the hcol     {esc}x... ;;;
;;;                       value                                              ;;;
;;; kill_rest_of_buffer   kills from point to end of buffer        {esc}^d   ;;;
;;; mark_bottom           puts a mark at bottom of buffer          ^x^z>     ;;;
;;; mark_top              puts a mark at top of buffer             ^x^z<     ;;;
;;; mod_one_window        same as one_window, except remembers     ^x1       ;;;
;;;                       what used to be in window                          ;;;
;;; mod_select_buf        same as select_buf but knows about file  ^xb       ;;;
;;;                       file hooks
;;; mod_split_window      same as split_window, except retains     ^x2       ;;;
;;;                       past buffer                                        ;;;
;;; mod_split_window_stay same as split_window_stay, except        ^x3       ;;;
;;;                       remembers what used to be in window                ;;;
;;; mod_write_file        same as write_file except asks if it               ;;;
;;;                       is alright to overwrite                  ^x^w      ;;;
;;; next_buf              cycles through all user buffers forward  {esc}n    ;;;
;;; prev_buf              cycles through all user buffers backward {esc}p    ;;;
;;; repaint               moves point to a line on the screen      {ctrl-x}r ;;;
;;; reset                 refreshes screen, puts in one window               ;;;
;;;                       mode, and resets hcol to 1                         ;;;
;;; save_all_files        saves all files, ignores  modified       {esc}x ...;;;
;;;                       buffers                                            ;;;
;;; scroll_other_backward scrolls the other window backward        ^xv       ;;;
;;; scroll_other_forward  scrolls the other window forward         {esc}^v   ;;;
;;; set_hscroll           prompts for hcol value                             ;;;
;;;                                                                          ;;;
;;; INSURE DEFINITIONS IS LOADED                                             ;;;
; 02/03/83 Zane       (if (null loaded$) (load))
;;; Global Variables:
; 02/03/83 Zane           (setq other_buffer$ ())


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; kill_rest_of_buffer                                                      ;;;
;;;     Command that kills from point to the end of the buffer.              ;;;
;;;     It is normally bound as {esc}^d.                                     ;;;
;;;                                                                          ;;;
;;;         (kill_rest_of_buffer)                                            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom kill_rest_of_buffer
     &doc "Kills from point to end of buffer"
     (mark)
     (move_bottom)
     (kill_region))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; mark_top                                                                 ;;;
;;;     Command that places a mark at the top of the buffer and leaves point ;;;
;;;     alone.  Bound as ^x^z<.                                              ;;;
;;;                                                                          ;;;
;;;         (mark_top)                                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom mark_top
    &doc "Places a mark at top of buffer"
    (save_position
        (move_top)
        (mark))
    (info_message "Top marked"))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; mark_bottom                                                              ;;;
;;;    Command that places a mark at the bottom of the buffer and leaves     ;;;
;;;    point alone.  Bound as ^x^z>.                                         ;;;
;;;                                                                          ;;;
;;;         (mark_bottom)                                                    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom mark_bottom
    &doc "Places a mark at bottom of buffer"
    (save_position
        (move_bottom)
        (mark))
    (info_message "Bottom marked"))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; save_all_files                                                           ;;;
;;;      Automatically saves all files that have been modified.  This        ;;;
;;;      command ignores buffers that have been modified.  This is           ;;;
;;;      invoked as an extended command; i.e., {esc}x save_all_files         ;;;
;;;                                                                          ;;;
;;;           (save_all_files)     or     (save_all_files$)                  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom save_all_files
    &doc "Saves all files, ignores modified buffers"
    (save_all_files$))
(defun save_all_files$ (&local (filename string)
                               (counter integer)
                        &returns integer)
    (setq counter 0)
    (save_position
      (with_no_redisplay               ; necessary so that files aren't shown
         (go_to_cursor (find_buffer ".buffers")) ; where list of files are
         (do_forever
              (if (forward_search " * ")
                                       ; search for modified flag
                  (setq filename (rest_of_line))
                  (if (^= filename "") ; if = null, then am looking at
                                       ; a buffer, not file
                      (find_file filename)
                      (save_file)
                      (setq counter (1+ counter))
                                       ; keep track of number saved
                      (select_buf ".buffers"))
               else
                   (stop_doing)))))
    (info_message (catenate (integer_to_string counter)
                            " file(s) saved "))
    (return counter))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; next_buf                                                                 ;;;
;;;      Command that cycles through all buffers.  This command goeslength (1+ (- (window_info bottom_line)   ; compute length
                                 (window_info top_line)))))  ; of window
          (if (> count window_length)                        ; make sure arg is
              (setq count window_length)                     ; in range
              (ring_the_bell)
              (info_message "Argument too big, it has been reset")))
     (begin_line)
     (if (> count 1)                  ; process argument
         (next_line (1- count))
      else
         (if (< count 1)
             (info_message "Negative arguments are not accepted")
             (ring_the_bell))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; scroll_other_forward                                                     ;;;
;;;     This command scrolls the window reached by other_window forward.     ;;;
;;;     It will accept both positive and negative arguments.  This command   ;;;
;;;     is bound as {esc}^v.                                                 ;;;
;;;                                                                          ;;;
;;;        (scroll_other_forward arg)                                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom scroll_other_forward
     &doc "Page the other window"
     &na (&pass count &default 1)
     (if (= (major_window_count) 1)
         (error_message "Only one window")
      else
         (other_window)
         (next_page count)
         (other_window)))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; scroll_other_backward                                                    ;;;
;;;     This command scrolls the window reached by other_window backward.    ;;;
;;;     It will accept both positive and negative arguments.  It is          ;;;
;;;     normally bound as ^xv.                                               ;;;
;;;                                                                          ;;;
;;;        (scroll_other_backward arg)                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom scroll_other_backward
     &doc "Page the other window backward"
     &na (&pass count &default 1)
     (scroll_other_forward (- count)))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; hscroll                                                                  ;;;
;;;    Extended command that uses the current column position to set         ;;;
;;;    hcol (horizontal scrolling).                                          ;;;
;;;                                                                          ;;;
;;;         (hscroll)                                                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom hscroll                        ; this is really pretty useless
     &doc "Sets horizontal column to current pos"
     (hcol (cur_hpos)))
(defun take_horiz ()
     (hscroll))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; set_hscroll                                                              ;;;
;;;     Extended comand that prompts for hcol value (horizontal              ;;;
;;;     scrolling).                                                          ;;;
;;;                                                                          ;;;
;;;         (set_hscroll)                                                    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom set_hscroll                    ; this is really pretty useless
     &doc "Lets you say where hcol position will be"
     (hcol (prompt_for_integer "What is the horizontal column" 1)))
(defun set_horiz ()
     (set_hscroll))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; horiz_left                                                               ;;;
;;;    Shifts the current window to the left by either an argument           ;;;
;;;    or by default.  This will not work in macros.                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom horiz_left
        &doc "Shift current window to the left"
        &numeric_arg (&pass offset &default 40)
        (hcol (- (window_info column_offset) offset)) )




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; horiz_right                                                              ;;;
;;;    Shifts the current window to the right by either an argument          ;;;
;;;    or by default.  This will not work in macros.                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom horiz_right
        &doc "Shift current window to the right"
        &numeric_arg (&pass offset &default 40)
        (hcol (+ (window_info column_offset) offset)) )




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; reset                                                                    ;;;
;;;     Extended command that puts you back in one window mode, sets         ;;;
;;;     hcol to 1, and refreshes the screen.                                 ;;;
;;;                                                                          ;;;
;;;         (reset)                                                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom reset
     &doc "Resets windows and columns"
     (hcol 1)
     (2doff)
     (#off)
     (set_mode "")
     (one_window)
     (refresh))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; mod_split_window                                                         ;;;
;;;   This is the same as the fundamental command split_window.  The         ;;;
;;;   difference is that it goes to the buffer that previously was           ;;;
;;;   there.                                                                 ;;;
;;;                                                                          ;;;
;;;        (mod_split_window optional-integer)                               ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom mod_split_window
    &doc "Split windows"
    &na (&pass count &default -99999)
    (if (= count -99999)
        (setq count (/ (1+ (- (window_info bottom_line)
                              (window_info top_line)))
                       2)))
    (split_window count)               ; same as split_window
    (if (not (null other_buffer$))      ; go to what was there previously
        