; COMPILE.EM, EMACS*>EXTENSIONS>SOURCE, ENVIRONMENTS, 03/05/84
; Compiles various languages and displays errors
; Copyright (c) 1983, Prime Computer, Inc., Natick, MA 01760
;                     All Rights Reserved

; Description:
;
; COMPILE.EM and the primitives necessary to run it
;
; Abnormal conditions:
;
; Implementation:
;
; Modifications:
;   Date   Programmer     Description of modification
; 02/01/84 Rand           Put in lm_init which initializes globals
; 08/26/83 Rand           Initial coding.

(defcom lm_init
   (setq languages$  '(spl plp pl1 pl1g modula2 cc pascal f77 ftn cobol cbl
                       rpg vrpg pma basicv scribe))
   (setq error_in_listing_file$ '("cobol" "pma"))
;
;  option abbreviation list
;
   (setq abbrevs$ '(  ("-ban" "-banner") ("-b" "-binary") ("-dc" "-dclvar")
      ("-deba" "-debase") ("-de" "-debug") ("-do" "-do1") ("-dy" "-dymn")
      ("-errl" "-errlist") ("-errt" "-errtty") ("-ex" "-explist")
      ("-i" "-input") ("-l" "-listing") ("-ma" "-map") ("-ne" "-nesting")
      ("-nob" "-nobig") ("-nodc" "-nodclvar") ("-node"    "-nodebug")
      ("-nodo" "-nodo1") ("-noerrl" "-noerrlist") ("-noerrt"  "-noerrtty")
      ("-noex" "-noexplist")  ("-nof" "-nofp") ("-noof"    "-nooffset")
      ("-noop" "-nooptimize") ("-nop" "-noproduction") ("-nor" "-norange")
      ("-nosi" "-nosilent")   ("-nost" "-nostatistics") ("-not" "-notrace")
      ("-nox" "-noxref") ("-nc" "-nocopy") ("-of" "-offset") ("-op" "-optimize")
      ("-pb" "-pbecb") ("-pro" "-protect") ("-r" "-range") ("-sa" "-save")
      ("-si" "-silent") ("-st" "-statistics") ("-stdo" "-stdopt")
      ("-unc" "-uncopt") ("-u" "-upcase") ("-x" "-xref")))

(if (null lm_list_path$) (setq lm_list_path$ ""))
(if (null lm_bin_path$) (setq lm_bin_path$  ""))
(if (null lm_max_num_errors$) (setq lm_max_num_errors$ 100))
(if (null lm_error_size$) (setq lm_max_error_size$ 10))
(if (null lm_forward_error_key$) (setq lm_forward_error_key$ "^xn"))
(if (null lm_prev_error_key$) (setq lm_prev_error_key$    "^xp"))
(setq lm_initialized$ true)
) ; end lm_init

(defun lm_display ((number integer))
   (lm_display_errors (nthcar lm_errors$ number))
)

(defun lm_display_errors ((slist list)
                          &local
                          (number_of_lines integer)
                          (string_list list)
                          (source_cursor cursor)
                          (total_lines integer)
                          (counter integer)
                         )
; slist has the form
; (cursor "text1" "text2" ..)
   (setq source_cursor (car slist))
   (setq string_list (cdr slist))
   (if (^= (typef source_cursor) 9)
      (info_message "No more errors to display")
      (return))
   (setq counter 1)
   (one_window)
   (with_no_redisplay
   (save_position
      (select_buf ".errors")
      (delete_buffer)
      (do_forever (if (null string_list) (stop_doing))
         (insert (catenate  (integer_to_string counter) ". "))
         (insert (car string_list))
         (cr)
         (setq string_list (cdr string_list))
         (setq counter (1+ counter))
      )
      (if (> (line_number current_cursor) lm_max_error_size$)
         (setq number_of_lines lm_max_error_size$)
       else
         (setq number_of_lines (line_number current_cursor))
      )
   )
   (setq total_lines (window_info bottom_line))
   (select_buf ".errors")
   (move_top)
   (split_window number_of_lines)
   (go_to_cursor source_cursor)
   )
(info_message (catenate "Error " (integer_to_string number) " of "
                 (integer_to_string (length lm_errors$))))
)

(defcom lm_next_error
   (setq lm_err#$ (1+ lm_err#$))
   (if (<= lm_err#$ (length lm_errors$))
      (lm_display lm_err#$)
    else
      (info_message "Beyond last error")
      (setq lm_err#$ (1+ (length lm_errors$)))
   )
)

(defcom lm_goto_error
   &args ((number &prompt "Error #" &default 1 &integer))
   (if (| (< number 1) (> number (length lm_errors$)))
      (info_message "Out of error range")
    else
      (setq lm_err#$ number)
      (lm_display number)
   )
)

(defcom lm_prev_error
   (setq lm_err#$ (1- lm_err#$))
   (if (> lm_err#$ 0)
      (lm_display lm_err#$)
    else
      (info_message "Before first error")
      (setq lm_err#$ 0)
   )
)

;
; Decodes abbreviations for command line options
;

(defun abbrev    ((token_string string)
                 &local (scar string)
                        (scdr string)
                 &returns string)
   (if (= token_string "") (return ""))
   (setq scar (before token_string " "))
   (setq scdr (after  token_string " "))
   (return (catenate (abbrev_f scar) " "
                     (abbrev   scdr))))

(defun abbrev_f  ((token string) &returns string)
   (if (^ (null (car (cdr (assoc token  abbrevs$)))))
   (return (car (cdr (assoc token abbrevs$))))
   else (return token))
)

;
; Returns the oposite of an option
;

(defun anti ((token string) &returns string)
   (if (= (substr token 2 2) "no")
      (return (catenate "-" (substr token 4)))
    else
      (return (catenate "-" "no" (substr token 2))))
)

;
; Remove redundant or contradictory options
;

(defun remove_extras ((token_string string)
       &returns string &local (sc string) (sd string))
   (if (= token_string "") (return ""))
   (setq sc (before token_string " "))
   (setq sd (after  token_string " "))
   (if (& (= (index sd sc) 0)
          (= (index sd (anti sc)) 0))
      (return (catenate sc " " (remove_extras sd)))
    else
      (return (remove_extras sd))
    )
)

;
; Returns global variable options for a language
; (if any)
;

(defun user_options ((cname string) &returns any &local (co atom))
  (setq co (eval (intern (catenate cname "_compile_options$"))))
  (if (null co) (return "") else (return co))
)

;
; Compile on a key
;
(defcom compile_key
  &doc "Function to invoke compile to bind to a key"
  (setq command_args_string$ "")
  (compile)
)

;
; Compile file in buffer
;

(defcom compile
  &doc "Compiles current buffer, scans for errors."
  (if (buffer_info modified) (save_file)rtstring string)
                    &returns string)
(if (^= (index options item) 0)
   (setq partstring (substr options (index options item)))
   (setq partstring (after  partstring " "))
   (if (| (= (substr partstring 1 1) "-")
          (= partstring ""))
    (return (catenate default entry_name$))
    else
    (return ""))
else
(return "")
)
)

(defun insert_in ((options string) (item string) (insert_string string)
                  &local (first_part string)
                         (last_part string)
                         (item_index integer)
                  &returns string)
(setq item_index (index options item))
(if (= item_index 0) (return options)
 else
 (setq first_part (substr options 1 (1- item_index)))
 (setq last_part (after  (substr options item_index) " "))
 (return
 (catenate first_part item " " insert_string " " last_part))
)
)

; Description:
;
; Gather takes any list of lists in the form ( (..) (..) ... (..) )
; and assumes that entries look like (key contents)
; it also assumes that the list is sorted.
; it produces a list with entries that look like (key contents1 contents2 ..)
; which can then be used as an associative list with that key.
;

(defun gather ((alist list)
              &local
              (rlist list)
              &returns list)
(setq rlist '())
   (do_forever (if (null alist) (stop_doing))
   (if (= (car (car rlist)) (car (car alist)))
   (setq rlist (cons
     (append (car rlist) (cdr (car alist)))
     (cdr rlist)))
    else
   (setq rlist (cons (car alist) rlist))
   )
   (setq alist (cdr alist))
   )
(return rlist)
)

; Description:
;
; MakCur takes a list of errors and makes cursors into the appropriate
; buffers, loading insert files where needed.  It takes a list of the
; form:
;
; ( ("#/filename" "et1" "et2" ...) ... ) most compilers
; or
; ( ("#.#..." "et1" "et2" ...) ... ) c
;
; also # is found by itself, indicating that the error is in the compiled
; routine.
;
; The result is:
;
; ( (c1 "et1" ...) (c2 "et1" ...)  ... )
;
; where c# indicates a cursor, et1,2 etc are error text associated with each
; cursor
;
(defun makcur ((error_list list)
               &local
               (current_list list)
               (return_list list)
               (line_number string)
               (number integer)
               &returns list)
(setq return_list '())
(do_forever (if (null error_list) (stop_doing)) ;do until out of errors
   (setq current_list (car error_list))
   (setq error_list (cdr error_list))
   (setq line_number (before (car current_list) "/"))
   (if (= compiler "cc")
      (setq return_list
         (cons (append (list (cc_getline line_number)) (cdr current_list))
             return_list))
    else
      (save_excursion
      (if (^= (after (car current_list) "/") "") ; no insert file
        (find_file (after (car current_list) "/") "yes") ; get the file
      )
      (setq return_list
         (cons (append (list (make_cursor (buffer_info name)
                   (string_to_integer line_number)
                   1
                   ))
                (cdr current_list))
           return_list
          )
      )
      )
   )
)
(return return_list)
)


;
; cc_getline,  with many thanks to DMM for supplying much of this code.
;
(defun cc_getline ((line_str string)
                   &local
                   (src_curs cursor)
                   (temp_str string)
                   (rt_delim string)
                   &returns cursor)

(save_excursion
;
; For each line (aaa, bbb, ccc... as above), dive as deep as
; necessary to get to the actual source that caused error.
; This may mean diving into included files, included include
; files, etc.  Uses src_curs to remember the outermost include
; (the line in the original source file) so we can get back to
; it if something fails in the diving process.
;
(do_forever
    ;
    ; Go to line in current buffer.
    ;
    (setq src_curs (make_cursor (buffer_info name)
                     (string_to_integer (before line_str ".")) 1 ))
    (go_to_cursor src_curs)
    (begin_line)
    ;
    ; Now check if add'l line numbers specified indicating
    ; we should probably dive into an included file.
    ; If not, simply stop the dive loop.
    ;
    (setq line_str (after line_str "."))
    (if (= line_str "") (stop_doing))
    ;
    ; Dive:  Obviously we can't if the line doesn't contain
    ; a #include, or that #include doesn't seem to contain
    ; a proper filename delimited by "" or <>.  If no dive
    ; possible, stop the loop which marks as deep as we got.
    ;
    (if (or (= (search (current_line) "#") 0)
            (= (index (downcase (current_line)) "include") 0))
        (stop_doing)
    )
    (if (^ (search_fd_in_line "<~""))
        (stop_doing)
    )
    ;
    ; There's a difference between an include file delimited
    ; by <> and "".  The "" is an absolute or relative Primos
    ; pathname.  The <> indicates a standard include file in
    ; the SYSCOM UFD.  At the moment, no search-rules are
    ; used for CC include files.
    ;
    (if_at "<"
        (setq temp_str "syscom>")
        (setq rt_delim ">")
     else
        (setq temp_str "")
        (setq rt_delim "~"")
    )
    (forward_char)
    (with_cursor here
        (search_fd_in_line rt_delim)
        (setq temp_str (catenate temp_str (point_cursor_to_string here)))
    )
    ;
    ; Dive into the included file.  Barf if cannot--return to
    ; original source and let user try his/her luck!
    ; The "yes" in find_file answers the proverbial question:
    ;   `File modified, reread?' if it comes up.
    ;
    (with_command_abort_handler
        (find_file temp_str "yes")
     command_abort_handler
        (go_to_cursor src_curs)
        (stop_doing)
    )
)
)
(return src_curs)
)


(defcom set_lm_list_path$
    &doc "Sets the listing path for COMPILE"
    (let ((path (prompt_for_string  "What is the listing path" "")))
         (if (= path "") (setq path () ))
         (setq lm_list_path$ path)))

(defcom set_lm_bin_path$
    &doc "Sets the binary path for COMPILE"
    (let ((path (prompt_for_string  "What is the binary path" "")))
         (if (= path "") (setq path () ))
         (setq lm_bin_path$ path)))

(defcom set_ftn_compile$
    &doc "Sets the compile options for FTN"
    (let ((options (prompt_for_string  "What are the FTN compile options" "")))
         (if (= options "") (setq options () ))
         (setq ftn_compile_options$ options)))

(defcom set_f77_compile$
    &doc "Sets the compile options for F77"
    (let ((options (prompt_for_string  "What are the F77 compile options" "")))
         (if (= options "") (setq options () ))
         (setq f77_compile_options$ options)))

(defcom set_rpg_compile$
    &doc "Sets the compile options for RPG"
    (let ((o